/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.security.Security;
import com.sap.security.um.SSOUser;
import com.sap.security.um.r3.ModifyTracker;
import com.sap.security.um.r3.R3UserAccount;
import com.sap.security.um.r3.R3UserFactory;
import com.sap.security.usermanagement.FeatureNotAvailableException;
import com.sap.security.usermanagement.IUserAccount;
import com.sap.security.usermanagement.IUserFactory;
import com.sap.security.usermanagement.IUserMaint;
import com.sap.security.usermanagement.UMException;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class R3User
extends SSOUser
implements IUserMaint,
Serializable {
    private static final String M1 = "getUserFactory()";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$um$r3$R3User == null ? (class$com$sap$security$um$r3$R3User = R3User.class$("com.sap.security.um.r3.R3User")) : class$com$sap$security$um$r3$R3User));
    static final String NAMESPACES = "m_namespaces";
    static final String COMPANYID = "m_companyid";
    static final String TITLE = "m_title";
    static final String SALUTATION = "m_salutation";
    static final String FIRSTNAME = "m_firstname";
    static final String LASTNAME = "m_lastname";
    static final String DEPARTMENT = "m_department";
    static final String JOBTITLE = "m_jobtitle";
    static final String EMAIL = "m_email";
    static final String TELEPHONE = "m_telephone";
    static final String FAX = "m_fax";
    static final String LOCALE = "m_locale";
    static final String TIMEZONE = "m_timezone";
    static final String UNIQUEID = "m_uniqueid";
    static final String NEWUSER = "m_newuser";
    static final String LASTMODIFIED = "m_lastmodified";
    static final String TICKET = "SAPLogonTicket";
    static final Date DATE_NOT_SUPPORTED = new Date(Long.MAX_VALUE);
    public static final String UM_READONLY = "UM_READONLY";
    public static final String EXTERNAL_ROLES_ATTRIBUTE = "EXTERNAL_ROLES";
    private final ModifyTracker m_companyid = new ModifyTracker(null, "");
    private final ModifyTracker m_title = new ModifyTracker(null, "");
    private final ModifyTracker m_salutation = new ModifyTracker(null, "");
    private final ModifyTracker m_firstname = new ModifyTracker(null, "");
    private final ModifyTracker m_lastname = new ModifyTracker(null, "");
    private final ModifyTracker m_department = new ModifyTracker(null, "");
    private final ModifyTracker m_jobtitle = new ModifyTracker(null, "");
    private final ModifyTracker m_email = new ModifyTracker(null, "");
    private final ModifyTracker m_telephone = new ModifyTracker(null, "");
    private final ModifyTracker m_fax = new ModifyTracker(null, "");
    private final ModifyTracker m_locale = new ModifyTracker(null, null);
    private final ModifyTracker m_timezone = new ModifyTracker(null, null);
    private String m_uniqueid;
    private Date m_lastmodified;
    private Date m_preparedate;
    private String[] m_roles = new String[0];
    private boolean m_newuser = false;
    private boolean m_prepared = false;
    private String m_ufkey;
    private transient R3UserFactory m_userfactory;
    private transient Map m_credentials;
    private R3UserAccount m_implicitAccount;
    private IUserAccount m_account;
    static /* synthetic */ Class class$com$sap$security$um$r3$R3User;
    static /* synthetic */ Class class$com$sap$security$um$r3$R3UserFactory;

    public R3User(R3UserFactory userFactory) {
        this.m_userfactory = userFactory;
        this.m_implicitAccount = new R3UserAccount(this);
    }

    public R3User(R3UserFactory userFactory, String userFactoryKey) {
        this.m_userfactory = userFactory;
        this.m_ufkey = userFactoryKey;
        this.m_implicitAccount = new R3UserAccount(this);
    }

    void checkPrepared() {
        if (!this.m_prepared) {
            throw new UMRuntimeException("Maintaing user data not allowed - call prepare() first");
        }
    }

    public boolean isModified() {
        if (this.m_prepared) {
            return this.m_newuser || this.m_companyid.isModified() || this.m_title.isModified() || this.m_salutation.isModified() || this.m_firstname.isModified() || this.m_lastname.isModified() || this.m_department.isModified() || this.m_jobtitle.isModified() || this.m_telephone.isModified() || this.m_fax.isModified() || this.m_email.isModified() || this.m_locale.isModified() || this.m_timezone.isModified();
        }
        return false;
    }

    boolean isModified(String fieldname) {
        try {
            Object o = this.getClass().getDeclaredField(fieldname).get(this);
            if (o instanceof ModifyTracker) {
                return ((ModifyTracker)o).isModified();
            }
            return false;
        }
        catch (Exception e) {
            throw new UMRuntimeException(e, "while trying to check if field \"" + fieldname + "\" is modified");
        }
    }

    public String[] getAttribute(String namespace, String name) {
        if (UM_READONLY.equals(namespace) && EXTERNAL_ROLES_ATTRIBUTE.equals(name)) {
            String[] roles = this.m_roles;
            String[] rolesCopy = new String[roles.length];
            System.arraycopy(roles, 0, rolesCopy, 0, roles.length);
            return rolesCopy;
        }
        return null;
    }

    public String[] getAttributeNamespaces() {
        return new String[]{UM_READONLY};
    }

    public String[] getAttributeNames(String namespace) {
        if (UM_READONLY.equals(namespace)) {
            return new String[]{EXTERNAL_ROLES_ATTRIBUTE};
        }
        return null;
    }

    public boolean setAttribute(String namespace, String name, String[] values) {
        throw new FeatureNotAvailableException("setAttribute(String, String, String[]) is not available in this implementation");
    }

    public String getName() {
        return this.m_uniqueid;
    }

    public String getUniqueID() {
        return this.m_uniqueid;
    }

    public String getUid() {
        return this.m_uniqueid;
    }

    public String getDisplayName() {
        return this.m_uniqueid;
    }

    public boolean setCompanyId(String companyId) {
        this.checkPrepared();
        if (companyId != null) {
            companyId = companyId.trim().toUpperCase();
        }
        return this.m_companyid.setValue(companyId);
    }

    public String getCompanyId() {
        return (String)this.m_companyid.getValue();
    }

    public boolean isCompanyUser() {
        String companyid = (String)this.m_companyid.getValue();
        return companyid != null && !companyid.equals("");
    }

    public boolean setDisplayName(String displayname) {
        throw new FeatureNotAvailableException("setDisplayName() is not available in this implementation");
    }

    public boolean setTitle(String title) {
        this.checkPrepared();
        return this.m_title.setValue(title);
    }

    public String getTitle() {
        return (String)this.m_title.getValue();
    }

    public boolean setSalutation(String salutation) {
        this.checkPrepared();
        return this.m_salutation.setValue(salutation);
    }

    public String getSalutation() {
        return (String)this.m_salutation.getValue();
    }

    public boolean setDepartment(String department) {
        this.checkPrepared();
        return this.m_department.setValue(department);
    }

    public String getDepartment() {
        return (String)this.m_department.getValue();
    }

    public boolean setFirstName(String firstname) {
        this.checkPrepared();
        return this.m_firstname.setValue(firstname);
    }

    public String getFirstName() {
        return (String)this.m_firstname.getValue();
    }

    public boolean setLastName(String lastname) {
        this.checkPrepared();
        return this.m_lastname.setValue(lastname);
    }

    public String getLastName() {
        return (String)this.m_lastname.getValue();
    }

    public boolean setJobTitle(String jobtitle) {
        this.checkPrepared();
        return this.m_jobtitle.setValue(jobtitle);
    }

    public String getJobTitle() {
        return (String)this.m_jobtitle.getValue();
    }

    public boolean setTimeZone(TimeZone timezone) {
        this.checkPrepared();
        return this.m_timezone.setValue(timezone);
    }

    public TimeZone getTimeZone() {
        return (TimeZone)this.m_timezone.getValue();
    }

    public boolean setLocale(Locale locale) {
        this.checkPrepared();
        return this.m_locale.setValue(locale);
    }

    public Locale getLocale() {
        return (Locale)this.m_locale.getValue();
    }

    public boolean setStreet(String street) {
        throw new FeatureNotAvailableException("setStreet() is not available in this implementation");
    }

    public String getStreet() {
        throw new FeatureNotAvailableException("getStreet() is not available in this implementation");
    }

    public boolean setCity(String city) {
        throw new FeatureNotAvailableException("setCity() is not available in this implementation");
    }

    public String getCity() {
        throw new FeatureNotAvailableException("getCity() is not available in this implementation");
    }

    public boolean setZip(String zip) {
        throw new FeatureNotAvailableException("setZip() is not available in this implementation");
    }

    public String getZip() {
        throw new FeatureNotAvailableException("getZip() is not available in this implementation");
    }

    public boolean setState(String state) {
        throw new FeatureNotAvailableException("setState() is not available in this implementation");
    }

    public String getState() {
        throw new FeatureNotAvailableException("getState() is not available in this implementation");
    }

    public boolean setCountry(String country) {
        throw new FeatureNotAvailableException("setCountry() is not available in this implementation");
    }

    public String getCountry() {
        throw new FeatureNotAvailableException("getCountry() is not available in this implementation");
    }

    public boolean setEmail(String email) {
        this.checkPrepared();
        return this.m_email.setValue(email);
    }

    public String getEmail() {
        return (String)this.m_email.getValue();
    }

    public boolean setFax(String fax) {
        this.checkPrepared();
        return this.m_fax.setValue(fax);
    }

    public String getFax() {
        return (String)this.m_fax.getValue();
    }

    public boolean setTelephone(String telephone) {
        this.checkPrepared();
        return this.m_telephone.setValue(telephone);
    }

    public String getTelephone() {
        return (String)this.m_telephone.getValue();
    }

    public String getCellPhone() {
        throw new FeatureNotAvailableException("getCellPhone() is not available in this implementation");
    }

    public boolean setCellPhone(String cellphone) {
        throw new FeatureNotAvailableException("setCellPhone() is not available in this implementation");
    }

    public boolean hasPermission(Permission permission) {
        throw new FeatureNotAvailableException("hasPermission() is not available in this implemenation");
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        throw new FeatureNotAvailableException("checkPermission() is not available in this implementation");
    }

    public Map getCredentials() {
        HashMap credentials = this.m_credentials;
        if (credentials == null) {
            this.m_credentials = credentials = new HashMap();
        }
        return credentials;
    }

    public IUserMaint prepare() {
        if (!this.m_prepared) {
            this.m_prepared = true;
            this.m_preparedate = new Date();
        }
        return this;
    }

    public boolean isPrepared() {
        return this.m_prepared;
    }

    Date getPrepareDate() {
        return this.m_preparedate;
    }

    boolean isNewUser() {
        return this.m_newuser;
    }

    public IUserFactory getUserFactory() {
        if (this.m_userfactory == null) {
            IUserFactory userFactory = Security.getUserFactory(this.m_ufkey);
            if (userFactory == null) {
                StringBuffer sb = new StringBuffer();
                sb.append("Cannot restore callback reference to user factory.\n");
                sb.append("No user factory is registered in the Security class ");
                sb.append("with key \"").append(this.m_ufkey).append("\"");
                LOCATION.errorT(M1, sb.toString());
            } else if (!(userFactory instanceof R3UserFactory)) {
                StringBuffer sb = new StringBuffer();
                sb.append("The user factory registered in the Security class ");
                sb.append("with key \"").append(this.m_ufkey);
                sb.append(" has an incorrect type.\nFound: ");
                sb.append(userFactory.getClass().getName()).append(" Required: ");
                sb.append((class$com$sap$security$um$r3$R3UserFactory == null ? (class$com$sap$security$um$r3$R3UserFactory = R3User.class$("com.sap.security.um.r3.R3UserFactory")) : class$com$sap$security$um$r3$R3UserFactory).getName());
                LOCATION.errorT(M1, sb.toString());
            } else {
                this.m_userfactory = (R3UserFactory)userFactory;
            }
        }
        return this.m_userfactory;
    }

    public void commit() throws UMException {
        this.checkPrepared();
        ((R3UserFactory)this.getUserFactory()).commitUser(this);
        this.m_prepared = false;
        this.m_preparedate = null;
        this.m_newuser = false;
    }

    public void rollback() {
        this.m_prepared = false;
        this.m_preparedate = null;
    }

    public String getCurrency() {
        throw new FeatureNotAvailableException("getCurrency() is not available in this implementation");
    }

    public boolean setCurrency(String value) {
        throw new FeatureNotAvailableException("setCurrency() is not available in this implementation");
    }

    public Date created() {
        throw new FeatureNotAvailableException("created() is not available in this implementation");
    }

    public Date lastModified() {
        if (DATE_NOT_SUPPORTED.equals(this.m_lastmodified)) {
            throw new FeatureNotAvailableException("lastModified() is not with this SAP release");
        }
        return this.m_lastmodified;
    }

    public IUserAccount getUserAccount() throws UMException {
        if (this.m_account != null) {
            return this.m_account;
        }
        return this.m_implicitAccount;
    }

    public void setUserAccount(IUserAccount userAccount) throws UMException {
        if (!this.m_newuser) {
            throw new UMException("setUserAccount() can only be called for new users");
        }
        if (!this.getDisplayName().equals(userAccount.getLogonUid())) {
            throw new UMException("The account's logon UID \"" + userAccount.getLogonUid() + "\" does not match this user's display name \"" + this.getDisplayName() + "\"");
        }
        this.m_account = userAccount;
    }

    public R3UserAccount getImplicitUserAccount() {
        return this.m_implicitAccount;
    }

    public String toString() {
        String strLastModified = null;
        strLastModified = DATE_NOT_SUPPORTED.equals(this.m_lastmodified) ? "feature not available (SAP release < 6.10)" : (this.m_newuser ? "not commited to store yet" : String.valueOf(this.m_lastmodified));
        String strPrepared = this.m_prepared ? "yes, on " + this.m_preparedate : "no";
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + ":\n");
        sb.append("   UniqueID:           \"" + this.m_uniqueid + "\"\n");
        sb.append("   Display Name:       \"" + this.m_uniqueid + "\"\n");
        sb.append("   Salutation:         \"" + this.m_salutation + "\"\n");
        sb.append("   Title:              \"" + this.m_title + "\"\n");
        sb.append("   First Name:         \"" + this.m_firstname + "\"\n");
        sb.append("   Last Name:          \"" + this.m_lastname + "\"\n");
        sb.append("   Email:              \"" + this.m_email + "\"\n");
        sb.append("   Phone:              \"" + this.m_telephone + "\"\n");
        sb.append("   Fax:                \"" + this.m_fax + "\"\n");
        sb.append("   Locale:             \"" + this.m_locale + "\"\n");
        sb.append("   Time Zone:          \"" + this.m_timezone + "\"\n");
        sb.append("   Company ID:         \"" + this.m_companyid + "\"\n");
        sb.append("   Job Title:          \"" + this.m_jobtitle + "\"\n");
        sb.append("   Department:         \"" + this.m_department + "\"\n");
        sb.append("   Prepared:           \"" + strPrepared + "\"\n");
        sb.append("   Currently Modified: \"" + this.isModified() + "\"\n");
        sb.append("   Last Modified:      \"" + strLastModified + "\"\n");
        return sb.toString();
    }

    void update(Map updatedValues) {
        if (updatedValues.containsKey(TICKET)) {
            this.getCredentials().put("com.sap.security.SAPLogonTicket", updatedValues.get(TICKET));
        }
        if (updatedValues.containsKey(COMPANYID)) {
            this.m_companyid.reset(updatedValues.get(COMPANYID));
        }
        if (updatedValues.containsKey(TITLE)) {
            this.m_title.reset(updatedValues.get(TITLE));
        }
        if (updatedValues.containsKey(SALUTATION)) {
            this.m_salutation.reset(updatedValues.get(SALUTATION));
        }
        if (updatedValues.containsKey(FIRSTNAME)) {
            this.m_firstname.reset(updatedValues.get(FIRSTNAME));
        }
        if (updatedValues.containsKey(LASTNAME)) {
            this.m_lastname.reset(updatedValues.get(LASTNAME));
        }
        if (updatedValues.containsKey(DEPARTMENT)) {
            this.m_department.reset(updatedValues.get(DEPARTMENT));
        }
        if (updatedValues.containsKey(JOBTITLE)) {
            this.m_jobtitle.reset(updatedValues.get(JOBTITLE));
        }
        if (updatedValues.containsKey(EMAIL)) {
            this.m_email.reset(updatedValues.get(EMAIL));
        }
        if (updatedValues.containsKey(TELEPHONE)) {
            this.m_telephone.reset(updatedValues.get(TELEPHONE));
        }
        if (updatedValues.containsKey(FAX)) {
            this.m_fax.reset(updatedValues.get(FAX));
        }
        if (updatedValues.containsKey(LOCALE)) {
            this.m_locale.reset(updatedValues.get(LOCALE));
        }
        if (updatedValues.containsKey(TIMEZONE)) {
            this.m_timezone.reset(updatedValues.get(TIMEZONE));
        }
        if (updatedValues.containsKey(UNIQUEID)) {
            this.m_uniqueid = (String)updatedValues.get(UNIQUEID);
        }
        if (updatedValues.containsKey(LASTMODIFIED)) {
            this.m_lastmodified = (Date)updatedValues.get(LASTMODIFIED);
        }
        if (updatedValues.containsKey(NEWUSER)) {
            this.m_newuser = (Boolean)updatedValues.get(NEWUSER);
        }
        if (updatedValues.containsKey(EXTERNAL_ROLES_ATTRIBUTE)) {
            this.m_roles = (String[])updatedValues.get(EXTERNAL_ROLES_ATTRIBUTE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

