/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.security.ticket.SimpleTicket;
import com.sap.security.ticket.TicketException;
import com.sap.security.toolkit.ds.MostRecentlyUsedCache;
import com.sap.security.um.SSOUser;
import com.sap.security.um.r3.CacheCheckFailedException;
import com.sap.security.um.r3.CacheCheckResult;
import com.sap.security.um.r3.Util;
import com.sap.security.usermanagement.IUser;
import com.sap.security.usermanagement.UMException;
import com.sap.security.usermanagement.UMNestedException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Map;

public class CacheCheck {
    private MostRecentlyUsedCache m_cache;
    private String m_cacheID;
    private int m_tolerance;
    private static final Location m_location = Location.getLocation((Class)(class$com$sap$security$um$r3$CacheCheck == null ? (class$com$sap$security$um$r3$CacheCheck = CacheCheck.class$("com.sap.security.um.r3.CacheCheck")) : class$com$sap$security$um$r3$CacheCheck));
    private static final Category m_category = Category.getCategory((String)"/Security/Authentication");
    static /* synthetic */ Class class$com$sap$security$um$r3$CacheCheck;

    public CacheCheck(MostRecentlyUsedCache cache, String cacheID, int tolerance) {
        this.m_cacheID = cacheID;
        this.m_cache = cache;
        this.m_tolerance = tolerance;
    }

    public CacheCheckResult checkCertKey(String certString) throws UMException {
        Map map;
        String method = "checkCertKey(java.lang.String)";
        m_location.entering(method);
        SimpleTicket ticket = null;
        String ticketString = null;
        String certKey = Util.getCacheKey(this.m_cacheID + certString);
        IUser user = (IUser)this.m_cache.get(certKey);
        if (user != null && user instanceof SSOUser && (ticketString = (String)(map = ((SSOUser)((Object)user)).getCredentials()).get("com.sap.security.SAPLogonTicket")) != null) {
            try {
                ticket = new SimpleTicket();
                ticket.setEnforceVerify(false);
                ticket.setTicket(ticketString);
            }
            catch (TicketException e) {
                throw new UMNestedException(e, "Cache check failed");
            }
            if (ticket.isValid(this.m_tolerance)) {
                ticketString = Util.replaceSpecialChar(ticketString);
                CacheCheckResult result = new CacheCheckResult(user, ticketString);
                m_location.exiting(method);
                return result;
            }
            this.m_cache.invalidate(certKey);
            throw new CacheCheckFailedException("SAP Logon Ticket is expired");
        }
        CacheCheckResult result = new CacheCheckResult(null, "");
        m_location.exiting(method);
        return result;
    }

    public CacheCheckResult checkTicketKey(String ticketString) throws UMException {
        String method = "checkTicketKey(java.lang.String)";
        m_location.entering(method);
        SimpleTicket ticket = null;
        String ticketKey = Util.getCacheKey(this.m_cacheID + ticketString);
        IUser user = (IUser)this.m_cache.get(ticketKey);
        try {
            ticket = new SimpleTicket();
            ticket.setEnforceVerify(false);
            ticket.setTicket(ticketString);
        }
        catch (TicketException e) {
            throw new UMNestedException(e, "Cache check failed.");
        }
        if (!ticket.isValid(this.m_tolerance)) {
            this.m_cache.invalidate(ticketKey);
            throw new CacheCheckFailedException("SAP Logon Ticket is expired.");
        }
        CacheCheckResult result = new CacheCheckResult(user, ticketString);
        m_location.exiting(method);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

