/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.um.r3.AbapProxyFactory;
import com.sap.security.um.r3.BAPIRETURN;
import com.sap.security.um.r3.BapiException;
import com.sap.security.um.r3.ISearch;
import com.sap.security.um.r3.ISearchHelp;
import com.sap.security.um.r3.R3User;
import com.sap.security.um.r3.R3UserFactory;
import com.sap.security.um.r3.SearchResult;
import com.sap.security.um.r3.UserAddrSearchHelp;
import com.sap.security.usermanagement.FeatureNotAvailableException;
import com.sap.security.usermanagement.ISearchResult;
import com.sap.security.usermanagement.UserAccountSearchFilter;
import com.sap.security.usermanagement.UserSearchFilter;
import com.sap.security.util.LogUtil;
import com.sap.security.util.SAPBasis;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Map;

class BapiHVGetSearch
implements ISearch {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$um$r3$BapiHVGetSearch == null ? (class$com$sap$security$um$r3$BapiHVGetSearch = BapiHVGetSearch.class$("com.sap.security.um.r3.BapiHVGetSearch")) : class$com$sap$security$um$r3$BapiHVGetSearch));
    private static final String RC_NO_USERS_FOUND = "S&013";
    private static final String M1 = "searchUsers(UserSearchFilter)";
    private static final String M2 = "execBapiHelpValuesGet(JCO.Client,ISearchHelp,UserSearchFilter)";
    private R3UserFactory m_userFactory;
    private JCO.PoolManager m_poolManager;
    private String m_poolID;
    private IRepository m_repository;
    private final ISearchHelp m_userAddrSearchHelp = new UserAddrSearchHelp();
    private LogUtil m_logUtil = new LogUtil(LOCATION, null);
    static /* synthetic */ Class class$com$sap$security$um$r3$BapiHVGetSearch;

    public BapiHVGetSearch(R3UserFactory userFactory, SAPBasis sapBasis) {
        this.m_userFactory = userFactory;
        this.m_poolManager = sapBasis.getPoolManager();
        this.m_poolID = sapBasis.getPoolID();
        this.m_repository = sapBasis.getRepository();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISearchResult searchUsers(UserSearchFilter filter) {
        ArrayList<R3User> users;
        block8: {
            if (LOCATION.bePath()) {
                LOCATION.entering(M1, new Object[]{filter});
            }
            JCO.Client client = null;
            users = null;
            try {
                try {
                    this.assertSearchCriteriaSupported(filter);
                    client = this.m_poolManager.getClient(this.m_poolID);
                    Map[] databags = this.execBapiHelpValuesGet(client, this.m_userAddrSearchHelp, filter);
                    users = new ArrayList<R3User>(databags.length);
                    int i = 0;
                    while (i < databags.length) {
                        R3User r3user = new R3User(this.m_userFactory);
                        r3user.update(databags[i]);
                        users.add(r3user);
                        ++i;
                    }
                }
                catch (RuntimeException e) {
                    throw (RuntimeException)this.m_logUtil.logException(e, M1);
                }
                Object var8_8 = null;
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (client != null) {
                    this.m_poolManager.releaseClient(client);
                }
                throw throwable;
            }
            this.m_poolManager.releaseClient(client);
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting(M1);
        }
        return new SearchResult(users);
    }

    public ISearchResult searchAccounts(UserAccountSearchFilter filter, int maxCount) {
        throw new FeatureNotAvailableException("search(UserAccountSearchFilter filter) is not available in this implementation");
    }

    private Map[] execBapiHelpValuesGet(JCO.Client client, ISearchHelp searchhelp, UserSearchFilter filter) {
        if (LOCATION.bePath()) {
            LOCATION.entering(M2, new Object[]{client, searchhelp, filter});
        }
        JCO.Function gethelpvalues = this.m_repository.getFunctionTemplate("BAPI_HELPVALUES_GET").getFunction();
        JCO.ParameterList imports = gethelpvalues.getImportParameterList();
        JCO.ParameterList tables = gethelpvalues.getTableParameterList();
        imports.setValue("USER", "OBJNAME");
        imports.setValue("GetDetail", "METHOD");
        imports.setValue("UserName", "PARAMETER");
        if (searchhelp.getName() != null) {
            imports.getStructure("EXPLICIT_SHLP").getField("SHLPNAME").setValue(searchhelp.getName());
            imports.getStructure("EXPLICIT_SHLP").setValue("SH", "SHLPTYPE");
        }
        searchhelp.fillSelectionFromFilter(tables.getTable("SELECTION_FOR_HELPVALUES"), filter);
        try {
            client.execute(gethelpvalues);
            Object var8_7 = null;
            this.m_logUtil.logFunction(gethelpvalues, M2);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_logUtil.logFunction(gethelpvalues, M2);
            throw throwable;
        }
        JCO.Structure structReturn = gethelpvalues.getExportParameterList().getStructure("RETURN");
        String msgtype = structReturn.getString("TYPE");
        if (msgtype.equals("E") || msgtype.equals("W") || msgtype.equals("A")) {
            if (RC_NO_USERS_FOUND.equals(structReturn.getString("CODE"))) {
                return new Map[0];
            }
            BAPIRETURN bapireturn = AbapProxyFactory.getBAPIRETURN((JCO.Record)structReturn);
            throw new BapiException("BAPI_HELPVALUES_GET", bapireturn);
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting(M2);
        }
        return searchhelp.getSearchResult(tables.getTable("HELPVALUES"), tables.getTable("DESCRIPTION_FOR_HELPVALUES"));
    }

    private void assertSearchCriteriaSupported(UserSearchFilter filter) {
        StringBuffer sb = new StringBuffer();
        if (filter.getDisplayName() != null) {
            sb.append("Searching for DISPLAYNAME not supported\n");
        }
        if (filter.getTitle() != null) {
            sb.append("Searching for TITLE not supported\n");
        }
        if (filter.getJobTitle() != null) {
            sb.append("Searching for JOBTITLE not supported\n");
        }
        if (filter.getStreet() != null) {
            sb.append("Searching for STREET not supported\n");
        }
        if (filter.getCity() != null) {
            sb.append("Searching for CITY not supported\n");
        }
        if (filter.getZip() != null) {
            sb.append("Searching for ZIP not supported\n");
        }
        if (filter.getState() != null) {
            sb.append("Searching for STATE not supported\n");
        }
        if (filter.getCountry() != null) {
            sb.append("Searching for COUNTRY not supported\n");
        }
        if (filter.getTelephone() != null) {
            sb.append("Searching for TELEPHONE not supported\n");
        }
        if (filter.getCellPhone() != null) {
            sb.append("Searching for CELLPHONE not supported\n");
        }
        if (filter.getFax() != null) {
            sb.append("Searching for FAX not supported\n");
        }
        if (filter.getEmail() != null) {
            sb.append("Searching for EMAIL not supported\n");
        }
        if (filter.getCurrency() != null) {
            sb.append("Searching for CURRENCY not supported\n");
        }
        if (filter.getZip() != null) {
            sb.append("Searching for ZIP not supported\n");
        }
        if (sb.length() > 0) {
            throw new RuntimeException(sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

