/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.mw.jco.JCO;

class AbstractSearchHelp {
    protected void appendRowsFromFilterValue(JCO.Table selection, String filterValue, String selectField) {
        if (filterValue != null) {
            BAPIF4B[] bapif4bs = this.convertFilterValueToBAPIF4Bs(filterValue);
            int i = 0;
            while (i < bapif4bs.length) {
                selection.appendRow();
                selection.setValue(selectField, "SELECT_FLD");
                selection.setValue(bapif4bs[i].getSIGN(), "SIGN");
                selection.setValue(bapif4bs[i].getOPTION(), "OPTION");
                selection.setValue(bapif4bs[i].getLOW(), "LOW");
                selection.setValue(bapif4bs[i].getHIGH(), "HIGH");
                ++i;
            }
        }
    }

    private BAPIF4B[] convertFilterValueToBAPIF4Bs(String filterValue) {
        BAPIF4B bapif4b = new BAPIF4B();
        bapif4b.setSIGN("I");
        if (this.containsWildCard(filterValue)) {
            bapif4b.setOPTION("CP");
        } else {
            bapif4b.setOPTION("EQ");
        }
        bapif4b.setLOW(filterValue);
        return new BAPIF4B[]{bapif4b};
    }

    private boolean containsWildCard(String filterValue) {
        return filterValue.indexOf("+") > -1 || filterValue.indexOf("*") > -1;
    }

    private static class BAPIF4B {
        private String SELECT_FLD;
        private String SIGN;
        private String OPTION;
        private String LOW;
        private String HIGH;

        public String getSELECT_FLD() {
            return this.SELECT_FLD;
        }

        public void setSELECT_FLD(String SELECT_FLD) {
            this.SELECT_FLD = SELECT_FLD;
        }

        public void setSIGN(String SIGN) {
            this.SIGN = SIGN;
        }

        public String getSIGN() {
            return this.SIGN;
        }

        public void setOPTION(String OPTION) {
            this.OPTION = OPTION;
        }

        public String getOPTION() {
            return this.OPTION;
        }

        public void setLOW(String LOW) {
            this.LOW = LOW;
        }

        public String getLOW() {
            return this.LOW;
        }

        public void setHIGH(String HIGH) {
            this.HIGH = HIGH;
        }

        public String getHIGH() {
            return this.HIGH;
        }
    }
}

