/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.tools;

import com.sap.security.tools.WizardModelDB;
import com.sap.security.tools.WizardModelXML;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.TraceFormatter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class UMConfiguratorLoad {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$tools$UMConfiguratorLoad == null ? (class$com$sap$security$tools$UMConfiguratorLoad = UMConfiguratorLoad.class$("com.sap.security.tools.UMConfiguratorLoad")) : class$com$sap$security$tools$UMConfiguratorLoad));
    private static final String LS = System.getProperty("line.separator");
    private static final String MSG_ENTERING = "Entering method";
    private static final String MSG_EXITING = "Exiting method";
    public static final int RC_OK = 0;
    public static final int RC_INVALID_ARGS = 1;
    public static final int RC_FILE_ERROR = 2;
    public static final int RC_UNKNOWN_ERROR = 99;
    private static String _action = "init";
    private static int _severity = 300;
    private static String _fileLocation = null;
    private static String[] _args = null;
    static /* synthetic */ Class class$com$sap$security$tools$UMConfiguratorLoad;

    private static void showUsage() {
        String method = "showUsage()";
        LOCATION.pathT("showUsage()", MSG_ENTERING);
        String USAGE = "Usage: java " + (class$com$sap$security$tools$UMConfiguratorLoad == null ? (class$com$sap$security$tools$UMConfiguratorLoad = UMConfiguratorLoad.class$("com.sap.security.tools.UMConfiguratorLoad")) : class$com$sap$security$tools$UMConfiguratorLoad).getName() + " OPTIONS..." + LS + "Generate UM configuration files" + LS + LS + "  -a ACTION          action to be performed (init|clean|setup)" + LS + "  -f CONFIG_FILE     location of config.properties file" + LS + "  -p PERSISTENCY     persistency option (db|abap|abap_db)(required)" + LS + "  -u KEY=VALUE       specifies a UM property             (required)" + LS + "  -c KEY=VALUE       specifies a connect property        (required)" + LS + "  -h                 display this help                   (optional)" + LS + LS + "Example UM Properties" + LS + "---------------------" + LS + "  ADMIN_USR          administrator user name" + LS + "  GUEST_USR          guest user name" + LS + "  ADMIN_PWD          administrator user password" + LS + "  GUEST_PWD          guest user password" + LS + "  ADMIN_GRP          administrator group name" + LS + "  GUEST_GRP          guest group name" + LS + "  ALL_GRP            name of group containing all users" + LS + LS + "Example Connect Properties" + LS + "--------------------------" + LS + "  CLIENT             three digit number of logical system" + LS + "  COM_USR            communication user ID" + LS + "  COM_PWD            communication user password" + LS + LS + " Dedicated Host Configuration" + LS + "  ASHOST             application server hostname" + LS + "  SYSNR              system number" + LS + LS + " Load Balancing Configuration" + LS + "  MSHOST             message server hostname" + LS + "  MSSERV             message server port number" + LS + "  GROUP              logon group (CASE SENSITIVE)" + LS + "  R3NAME             system id" + LS;
        System.out.println(USAGE);
        LOCATION.pathT("showUsage()", MSG_EXITING);
    }

    private static void configureLog() {
        int severity = 300;
        ConsoleLog log = new ConsoleLog((Formatter)new TraceFormatter("%m"));
        log.setEffectiveSeverity(0);
        LOCATION.setEffectiveSeverity(severity);
        LOCATION.addLog((Log)log);
        log = new FileLog("dev_umconfigurator", (Formatter)new TraceFormatter("%24d %-13l %s: %m"));
        log.setEffectiveSeverity(0);
        LOCATION.setEffectiveSeverity(severity);
        LOCATION.addLog((Log)log);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseArgs(String[] args) {
        String method = "parseArgs(String[] args)";
        LOCATION.pathT("parseArgs(String[] args)", MSG_ENTERING);
        int i = 0;
        while (i < args.length) {
            block10: {
                block13: {
                    block12: {
                        block11: {
                            if (!"-u".equals(args[i])) break block11;
                            ++i;
                            break block10;
                        }
                        if (!"-c".equals(args[i])) break block12;
                        ++i;
                        break block10;
                    }
                    if (!"-a".equals(args[i])) break block13;
                    if ((_action = args[++i]).equalsIgnoreCase("init")) {
                        LOCATION.infoT("Setting up initial configuration for mother system");
                        break block10;
                    } else if (_action.equalsIgnoreCase("clean")) {
                        LOCATION.infoT("Cleaning system for DB export");
                        break block10;
                    } else {
                        if (!_action.equalsIgnoreCase("setup")) {
                            LOCATION.errorT("Action " + _action + " is not supported");
                            throw new IllegalArgumentException("Action " + _action + " is not supported");
                        }
                        LOCATION.infoT("Configuring clean system after DB load installation");
                    }
                    break block10;
                }
                if ("-p".equals(args[i])) {
                    ++i;
                } else {
                    if ("-h".equals(args[i])) {
                        _action = "help";
                        LOCATION.infoT("parseArgs(String[] args)", "Help message will be written to stdout");
                        return;
                    }
                    if (!"-f".equals(args[i])) {
                        LOCATION.errorT("parseArgs(String[] args)", "Unexpected argument: " + args[i]);
                        throw new IllegalArgumentException("Unexpected argument: " + args[i]);
                    }
                    _fileLocation = args[++i];
                    LOCATION.infoT("parseArgs(String[] args)", "Config properties will be taken from: " + _fileLocation);
                }
            }
            ++i;
        }
        LOCATION.pathT("parseArgs(String[] args)", MSG_EXITING);
    }

    private static int doSetup() {
        String method = "main(String[] args)";
        int returnCode = 0;
        WizardModelXML modelArgs = new WizardModelXML(_args);
        WizardModelDB modelDB = new WizardModelDB(_fileLocation);
        modelDB.open();
        modelDB.addGroup(modelArgs.getPropertyUM("ADMIN_GRP"), new String[]{"Administrator"});
        modelDB.addGroup(modelArgs.getPropertyUM("GUEST_GRP"), new String[0]);
        modelDB.addUser(modelArgs.getPropertyUM("ADMIN_USR"), modelArgs.getPropertyUM("ADMIN_PWD"), new String[]{modelArgs.getPropertyUM("ADMIN_GRP")}, false, new String[0]);
        modelDB.addUser(modelArgs.getPropertyUM("GUEST_USR"), modelArgs.getPropertyUM("GUEST_PWD"), new String[]{modelArgs.getPropertyUM("GUEST_GRP")}, true, new String[0]);
        modelDB.setRoleReferences();
        modelDB.setAdminUser(modelArgs.getPropertyUM("ADMIN_USR"), modelArgs.getPropertyUM("ADMIN_PWD"));
        modelDB.setDefaultGroups(modelArgs.getPropertyUM("ADMIN_GRP"), modelArgs.getPropertyUM("GUEST_GRP"), modelArgs.getPropertyUM("ALL_GRP"));
        modelDB.setJMSUser(modelArgs.getPropertyUM("ADMIN_USR"));
        WizardModelDB.DatasourceConfiguration config = modelDB.getDatasourceConfiguration();
        modelDB.setGuestUser(modelArgs.getPropertyUM("GUEST_USR"));
        if (modelArgs.getPersistency().equalsIgnoreCase("db")) {
            config.setConfigurationXML("dataSourceConfiguration_database_only.xml");
        } else if (modelArgs.getPersistency().equalsIgnoreCase("abap") || modelArgs.getPersistency().equalsIgnoreCase("abap_db")) {
            if (modelArgs.getPersistency().equalsIgnoreCase("abap")) {
                config.setConfigurationXML("dataSourceConfiguration_r3_roles_db.xml");
            } else if (modelArgs.getPersistency().equalsIgnoreCase("abap_db")) {
                config.setConfigurationXML("dataSourceConfiguration_r3_rw.xml");
            }
            Object[] datasources = config.getDatasources();
            int i = 0;
            while (!(datasources[i] instanceof WizardModelDB.DatasourceABAP)) {
                ++i;
            }
            WizardModelDB.DatasourceABAP datasourceABAP = (WizardModelDB.DatasourceABAP)datasources[i];
            datasourceABAP.setClient(modelArgs.getPropertyConnect("CLIENT"));
            datasourceABAP.setUser(modelArgs.getPropertyConnect("COM_USR"), modelArgs.getPropertyConnect("COM_PWD"));
            if (modelArgs.getLoadBalacing()) {
                datasourceABAP.setHostLoadBalancing(modelArgs.getPropertyConnect("MSHOST"), modelArgs.getPropertyConnect("MSSERV"), modelArgs.getPropertyConnect("GROUP"), modelArgs.getPropertyConnect("R3NAME"));
            } else {
                datasourceABAP.setHostSingle(modelArgs.getPropertyConnect("ASHOST"), modelArgs.getPropertyConnect("SYSNR"));
            }
        }
        modelDB.commit();
        LOCATION.pathT("main(String[] args)", MSG_EXITING);
        return returnCode;
    }

    private static int doInit() {
        String method = "main(String[] args)";
        int returnCode = 0;
        try {
            WizardModelXML modelArgs = new WizardModelXML(_args);
            byte[] policyXML = modelArgs.generatePolicyXML();
            byte[] userstoreXML = modelArgs.generateUserstoreXML();
            Properties umeProps = modelArgs.generateUMEProps();
            WizardModelDB modelDB = new WizardModelDB(_fileLocation);
            modelDB.open();
            modelDB.setXMLFiles(new String(policyXML, "UTF-8"), new String(userstoreXML, "UTF-8"));
            Enumeration keys = ((Hashtable)umeProps).keys();
            String key = null;
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                modelDB.setUMEProperty(key, umeProps.getProperty(key));
            }
            modelDB.addGroup(modelArgs.getPropertyUM("ADMIN_GRP"), new String[]{"Administrator"});
            modelDB.addGroup(modelArgs.getPropertyUM("GUEST_GRP"), new String[0]);
            modelDB.addUser(modelArgs.getPropertyUM("ADMIN_USR"), modelArgs.getPropertyUM("ADMIN_PWD"), new String[]{modelArgs.getPropertyUM("ADMIN_GRP")}, false, new String[0]);
            modelDB.addUser(modelArgs.getPropertyUM("GUEST_USR"), modelArgs.getPropertyUM("GUEST_PWD"), new String[]{modelArgs.getPropertyUM("GUEST_GRP")}, true, new String[0]);
            modelDB.commit();
        }
        catch (IOException e) {
            LOCATION.errorT("main(String[] args)", e.getMessage());
            returnCode = 2;
        }
        LOCATION.pathT("main(String[] args)", MSG_EXITING);
        return returnCode;
    }

    private static int doClean() {
        String method = "main(String[] args)";
        int returnCode = 0;
        WizardModelDB modelDB = new WizardModelDB(_fileLocation);
        modelDB.open();
        modelDB.clearUsersAndGroups();
        modelDB.clearRoleAssignments();
        modelDB.clearUMETables();
        modelDB.clearServiceConfigs();
        modelDB.clearUMAPKey();
        modelDB.commit();
        LOCATION.pathT("main(String[] args)", MSG_EXITING);
        return returnCode;
    }

    public static void main(String[] args) {
        String method = "main(String[] args)";
        _args = args;
        int returnCode = 0;
        try {
            UMConfiguratorLoad.configureLog();
            UMConfiguratorLoad.parseArgs(args);
            if (_action.equals("help")) {
                UMConfiguratorLoad.showUsage();
            } else if (_action.equals("init")) {
                returnCode = UMConfiguratorLoad.doInit();
            } else if (_action.equals("clean")) {
                returnCode = UMConfiguratorLoad.doClean();
            } else if (_action.equals("setup")) {
                returnCode = UMConfiguratorLoad.doSetup();
            }
        }
        catch (IllegalArgumentException e) {
            LOCATION.errorT("main(String[] args)", e.getMessage());
            returnCode = 1;
        }
        LOCATION.infoT("main(String[] args)", "Leaving with return code " + returnCode);
        LOCATION.pathT("main(String[] args)", MSG_EXITING);
        System.exit(returnCode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

