/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.tools;

import com.sap.security.tools.WizardModelXML;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.TraceFormatter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class UMConfigurator {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$tools$UMConfigurator == null ? (class$com$sap$security$tools$UMConfigurator = UMConfigurator.class$("com.sap.security.tools.UMConfigurator")) : class$com$sap$security$tools$UMConfigurator));
    private static final String LS = System.getProperty("line.separator");
    private static final String MSG_ENTERING = "Entering method";
    private static final String MSG_EXITING = "Exiting method";
    public static final int RC_OK = 0;
    public static final int RC_INVALID_ARGS = 1;
    public static final int RC_FILE_ERROR = 2;
    public static final int RC_UNKNOWN_ERROR = 99;
    private static String _action = "init";
    private static int _severity = 300;
    private static String _fileLocation = null;
    private static String[] _args = null;
    static /* synthetic */ Class class$com$sap$security$tools$UMConfigurator;

    private static void showUsage() {
        String method = "showUsage()";
        LOCATION.pathT("showUsage()", MSG_ENTERING);
        String USAGE = "Usage: java " + (class$com$sap$security$tools$UMConfigurator == null ? (class$com$sap$security$tools$UMConfigurator = UMConfigurator.class$("com.sap.security.tools.UMConfigurator")) : class$com$sap$security$tools$UMConfigurator).getName() + " OPTIONS..." + LS + "Generate UM configuration files" + LS + LS + "  -a ACTION          action to be performed (init|clean|setup)" + LS + "  -f CONFIG_FILE     location of config.properties file" + LS + "  -p PERSISTENCY     persistency option (db|abap)        (required)" + LS + "  -u KEY=VALUE       specifies a UM property             (required)" + LS + "  -c KEY=VALUE       specifies a connect property        (required)" + LS + "  -h                 display this help                   (optional)" + LS + LS + "Example UM Properties" + LS + "---------------------" + LS + "  ADMIN_USR          administrator user name" + LS + "  GUEST_USR          guest user name" + LS + "  ADMIN_PWD          administrator user password" + LS + "  GUEST_PWD          guest user password" + LS + "  ADMIN_GRP          administrator group name" + LS + "  GUEST_GRP          guest group name" + LS + "  ALL_GRP            name of group containing all users" + LS + LS + "Example Connect Properties" + LS + "--------------------------" + LS + "  CLIENT             three digit number of logical system" + LS + "  COM_USR            communication user ID" + LS + "  COM_PWD            communication user password" + LS + LS + " Dedicated Host Configuration" + LS + "  ASHOST             application server hostname" + LS + "  SYSNR              system number" + LS + LS + " Load Balancing Configuration" + LS + "  MSHOST             message server hostname" + LS + "  MSSERV             message server port number" + LS + "  GROUP              logon group (CASE SENSITIVE)" + LS + "  R3NAME             system id" + LS;
        System.out.println(USAGE);
        LOCATION.pathT("showUsage()", MSG_EXITING);
    }

    private static void configureLog() {
        int severity = 300;
        String s = System.getProperty("UMConfigurator.debug");
        if (null != s) {
            try {
                severity = Severity.parse((String)s);
            }
            catch (IllegalArgumentException iae) {
                severity = 300;
            }
        }
        ConsoleLog log = new ConsoleLog((Formatter)new TraceFormatter("%m"));
        log.setEffectiveSeverity(0);
        LOCATION.setEffectiveSeverity(severity);
        LOCATION.addLog((Log)log);
        log = new FileLog("dev_umconfigurator", (Formatter)new TraceFormatter("%24d %-13l %s: %m"));
        log.setEffectiveSeverity(0);
        LOCATION.setEffectiveSeverity(severity);
        LOCATION.addLog((Log)log);
    }

    private static void parseArgs(String[] args) {
        String method = "parseArgs(String[] args)";
        LOCATION.pathT("parseArgs(String[] args)", MSG_ENTERING);
        int i = 0;
        while (i < args.length) {
            if ("-u".equals(args[i])) {
                ++i;
            } else if ("-c".equals(args[i])) {
                ++i;
            } else if ("-p".equals(args[i])) {
                ++i;
            } else {
                if ("-h".equals(args[i])) {
                    _action = "help";
                    LOCATION.infoT("parseArgs(String[] args)", "Help message will be written to stdout");
                    return;
                }
                if ("-f".equals(args[i])) {
                    _fileLocation = args[++i];
                    LOCATION.infoT("parseArgs(String[] args)", "Config properties will be taken from: " + _fileLocation);
                } else {
                    LOCATION.errorT("parseArgs(String[] args)", "Unexpected argument: " + args[i]);
                    throw new IllegalArgumentException("Unexpected argument: " + args[i]);
                }
            }
            ++i;
        }
        LOCATION.pathT("parseArgs(String[] args)", MSG_EXITING);
    }

    private static int doInit() {
        String method = "main(String[] args)";
        int returnCode = 0;
        try {
            WizardModelXML modelArgs = new WizardModelXML(_args);
            byte[] policyXML = modelArgs.generatePolicyXML();
            byte[] userstoreXML = modelArgs.generateUserstoreXML();
            Properties umeProps = modelArgs.generateUMEProps();
            FileOutputStream out = null;
            out = new FileOutputStream("policy.xml");
            ((OutputStream)out).write(policyXML);
            ((OutputStream)out).close();
            out = new FileOutputStream("userstore.xml");
            ((OutputStream)out).write(userstoreXML);
            ((OutputStream)out).close();
            out = new FileOutputStream("sapum.properties");
            umeProps.store(out, "");
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            LOCATION.errorT("main(String[] args)", e.getMessage());
            returnCode = 2;
        }
        LOCATION.pathT("main(String[] args)", MSG_EXITING);
        return returnCode;
    }

    public static void main(String[] args) {
        String method = "main(String[] args)";
        _args = args;
        int returnCode = 0;
        try {
            UMConfigurator.configureLog();
            UMConfigurator.parseArgs(args);
            if (_action.equals("help")) {
                UMConfigurator.showUsage();
            } else {
                returnCode = UMConfigurator.doInit();
            }
        }
        catch (IllegalArgumentException e) {
            LOCATION.errorT("main(String[] args)", e.getMessage());
            returnCode = 1;
        }
        LOCATION.infoT("main(String[] args)", "Leaving with return code " + returnCode);
        LOCATION.pathT("main(String[] args)", MSG_EXITING);
        System.exit(returnCode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

