/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.toolkit.ds;

import java.util.HashMap;
import java.util.TreeMap;

public class MostRecentlyUsedCache {
    private int mCapacity;
    private int mTime;
    private HashMap mIndexByCacheKey;
    private TreeMap mIndexByLastAccess;

    public MostRecentlyUsedCache(int capacity) {
        this.mCapacity = capacity;
        this.mTime = 0;
        this.mIndexByCacheKey = new HashMap();
        this.mIndexByLastAccess = new TreeMap();
    }

    public synchronized void put(Object key, Object entry) {
        if (key == null || entry == null) {
            return;
        }
        CacheRecord record = new CacheRecord();
        record.AccessTime = this.nextConsecutiveNumber();
        record.Value = entry;
        if (this.mIndexByCacheKey.containsKey(key)) {
            Integer lastAccess = ((CacheRecord)this.mIndexByCacheKey.get((Object)key)).AccessTime;
            this.mIndexByLastAccess.remove(lastAccess);
        } else if (this.mIndexByCacheKey.size() >= this.mCapacity) {
            Integer lruTime = (Integer)this.mIndexByLastAccess.firstKey();
            Object lruKey = this.mIndexByLastAccess.remove(lruTime);
            this.mIndexByCacheKey.remove(lruKey);
        }
        this.mIndexByCacheKey.put(key, record);
        this.mIndexByLastAccess.put(record.AccessTime, key);
    }

    public Object get(Object key) {
        if (this.mIndexByCacheKey.containsKey(key)) {
            Integer accessTime;
            CacheRecord record = (CacheRecord)this.mIndexByCacheKey.get(key);
            Integer lastAccess = record.AccessTime;
            record.AccessTime = accessTime = this.nextConsecutiveNumber();
            MostRecentlyUsedCache mostRecentlyUsedCache = this;
            synchronized (mostRecentlyUsedCache) {
                this.mIndexByLastAccess.remove(lastAccess);
                this.mIndexByLastAccess.put(accessTime, key);
            }
            return record.Value;
        }
        return null;
    }

    public boolean invalidate(Object key) {
        if (this.mIndexByCacheKey.containsKey(key)) {
            MostRecentlyUsedCache mostRecentlyUsedCache = this;
            synchronized (mostRecentlyUsedCache) {
                this.mIndexByLastAccess.remove(((CacheRecord)this.mIndexByCacheKey.remove((Object)key)).AccessTime);
            }
            return true;
        }
        return false;
    }

    private synchronized Integer nextConsecutiveNumber() {
        this.mTime = this.mTime < Integer.MAX_VALUE ? ++this.mTime : this.restartNumbering();
        return new Integer(this.mTime);
    }

    private int restartNumbering() {
        int counter = 0;
        Integer counterObj = null;
        Integer[] oldKeys = this.mIndexByLastAccess.keySet().toArray(new Integer[0]);
        int i = 0;
        while (i < oldKeys.length) {
            counterObj = new Integer(counter++);
            Object key = this.mIndexByLastAccess.remove(oldKeys[i]);
            this.mIndexByLastAccess.put(counterObj, key);
            ((CacheRecord)this.mIndexByCacheKey.get(key)).AccessTime = counterObj;
            ++i;
        }
        this.mTime = counter;
        return counter;
    }

    private class CacheRecord {
        Integer AccessTime;
        Object Value;

        private CacheRecord() {
        }
    }
}

