/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.ticket;

import com.sap.security.ticket.InfoUnit;
import com.sap.security.ticket.TicketException;
import com.sap.security.ticket.WrongTicketModeException;
import com.sap.security.util.Base64InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SimpleTimeZone;
import java.util.Vector;

public class SimpleTicket {
    public boolean debug = false;
    protected int version;
    protected String codepage = "";
    protected String encoding = null;
    protected String mTicket = null;
    protected int mMode;
    protected String user = "";
    protected String sysID = "";
    protected String sysClient = "";
    protected String createTime = "000000000000";
    protected int validTime = 0;
    protected int validTimeMin = 0;
    protected Calendar startTime;
    protected Calendar endTime;
    protected byte[] derSignature = null;
    protected byte[] tbsData = null;
    protected Vector infoUnits = new Vector();
    protected boolean enforceVerify = true;
    public static HashMap codepageEncoding;
    public static int MODE_UNDEFINED;
    public static int MODE_VERIFY;
    public static int MODE_CREATE;
    public static int MODE_CREATED;
    protected static final int STATE_START = 0;
    protected static final int STATE_INITIALIZED = 1;
    protected static final int STATE_VERIFIED = 2;
    protected int state = 0;

    public SimpleTicket() {
        this.mMode = MODE_UNDEFINED;
    }

    public void setMode(int mode) {
        this.mMode = mode;
    }

    public void setTicket(String base64string) throws TicketException {
        byte[] data = base64string.getBytes();
        this.mTicket = base64string;
        this.setTicket(new Base64InputStream(new ByteArrayInputStream(data)));
        this.mMode = MODE_VERIFY;
    }

    public void setTicket(byte[] ticket) throws TicketException {
        this.setTicket(new ByteArrayInputStream(ticket));
        this.mMode = MODE_VERIFY;
    }

    public void setTicket(InputStream in) throws TicketException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.version = in.read();
            out.write(this.version);
            byte[] rawCodePage = InfoUnit.readRaw(in, 4);
            this.codepage = InfoUnit.bytesToString(rawCodePage, null);
            out.write(rawCodePage);
            if (!codepageEncoding.containsKey(this.codepage)) {
                throw new TicketException("Unsupported codepage " + this.codepage + " in ticket.");
            }
            this.encoding = (String)codepageEncoding.get(this.codepage);
            InfoUnit unit = InfoUnit.readInfoUnit(in);
            while (unit != null) {
                if (unit.getID() == 255) {
                    this.derSignature = unit.getContent();
                    break;
                }
                unit.writeTo(out);
                switch (unit.getID()) {
                    case 1: {
                        this.user = unit.getString(this.encoding);
                        break;
                    }
                    case 3: {
                        this.sysID = unit.getString(this.encoding);
                        break;
                    }
                    case 2: {
                        this.sysClient = unit.getString(this.encoding);
                        break;
                    }
                    case 4: {
                        this.createTime = unit.getString(this.encoding);
                        break;
                    }
                    case 5: {
                        this.validTime = unit.getInt();
                        break;
                    }
                    case 7: {
                        this.validTimeMin = unit.getInt();
                        break;
                    }
                    default: {
                        this.infoUnits.addElement(unit);
                    }
                }
                unit = InfoUnit.readInfoUnit(in);
            }
            out.close();
            this.tbsData = out.toByteArray();
        }
        catch (Exception e) {
            throw new TicketException("" + e);
        }
        if (this.createTime.length() < 12) {
            throw new TicketException("Creation Time not set in Ticket (" + this.createTime + ")!");
        }
        int year = Integer.parseInt(this.createTime.substring(0, 4));
        int month = Integer.parseInt(this.createTime.substring(4, 6));
        int day = Integer.parseInt(this.createTime.substring(6, 8));
        int hour = Integer.parseInt(this.createTime.substring(8, 10));
        int min = Integer.parseInt(this.createTime.substring(10, 12));
        int sec = 0;
        this.startTime = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        this.startTime.set(year, month - 1, day, hour, min, sec);
        this.endTime = (Calendar)this.startTime.clone();
        this.endTime.add(10, this.validTime);
        this.endTime.add(12, this.validTimeMin);
        this.state = 1;
        this.mMode = MODE_VERIFY;
        if (this.debug) {
            System.out.println(this.toString());
        }
    }

    public void setEnforceVerify(boolean val) {
        this.enforceVerify = val;
    }

    public String getUser() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.enforceVerify && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.user;
    }

    /*
     * Unable to fully structure code
     */
    public String getUser(String application) throws TicketException, UnsupportedEncodingException {
        if (this.mMode != SimpleTicket.MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.enforceVerify && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        e = this.infoUnits.elements();
        iu = null;
        if (e != null) ** GOTO lbl15
        return null;
lbl-1000:
        // 1 sources

        {
            iu = (InfoUnit)e.nextElement();
            id = iu.getID();
            if (id < 32 || id >= 64 || !(s = iu.getString("UTF8")).startsWith(application + ":")) continue;
            return s.substring(s.indexOf(58) + 1);
lbl15:
            // 2 sources

            ** while (e.hasMoreElements())
        }
lbl16:
        // 1 sources

        return null;
    }

    public String getSystemID() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.enforceVerify && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.sysID;
    }

    public String getSystemClient() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.enforceVerify && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.sysClient;
    }

    public byte[] getInfoUnit(int id) throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.enforceVerify && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        Iterator i = ((AbstractList)this.infoUnits).iterator();
        while (i.hasNext()) {
            InfoUnit unit = (InfoUnit)i.next();
            if (unit.getID() != id) continue;
            return unit.getContent();
        }
        return null;
    }

    public Enumeration getInfoUnits() throws TicketException {
        if (this.mMode != MODE_VERIFY) {
            throw new WrongTicketModeException("This instance is not in verify mode.");
        }
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        if (this.enforceVerify && this.state != 2) {
            throw new TicketException("Ticket not verified.");
        }
        return this.infoUnits.elements();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Ticket ");
        if (this.state == 0) {
            s.append("[not initialized]\n");
        } else {
            if (this.state == 2) {
                s.append("[verified]\n");
            } else {
                s.append("[initialized]\n");
            }
            s.append("  Ticket Version  = " + this.version + "\n");
            s.append("  Ticket Codepage = " + this.codepage + " (Encoding=" + this.encoding + ")\n");
            s.append("  User = " + this.user + "\n");
            s.append("  Issuing System ID     = " + this.sysID + "\n");
            s.append("  Issuing System Client = " + this.sysClient + "\n");
            s.append("  Creation Time = " + this.createTime + "\n");
            s.append("  Valid Time    = " + this.validTime + " h " + this.validTimeMin + " min\n");
            s.append("  Valid from   " + this.startTime.getTime() + "   until   " + this.endTime.getTime() + "\n");
            s.append("  Signature (length=" + this.derSignature.length + " bytes)\n");
            Iterator i = ((AbstractList)this.infoUnits).iterator();
            while (i.hasNext()) {
                InfoUnit unit = (InfoUnit)i.next();
                s.append("  InfoUnit " + unit.getID() + ", length=" + unit.getContent().length + "\n");
            }
        }
        return s.toString();
    }

    public boolean isValid() {
        Calendar now = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        now.set(13, 1);
        return now.after(this.startTime) && now.before(this.endTime);
    }

    public boolean isValid(int tolerance) {
        Calendar now = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        now.set(13, 1);
        Calendar calcTime = (Calendar)now.clone();
        calcTime.add(12, tolerance);
        return calcTime.after(this.startTime) && now.before(this.endTime);
    }

    public String getTicket() throws TicketException {
        if (this.state == 0) {
            throw new TicketException("No Ticket set.");
        }
        return this.mTicket;
    }

    public Calendar getExpirationDate() {
        return this.endTime;
    }

    static {
        MODE_UNDEFINED = -1;
        MODE_VERIFY = 0;
        MODE_CREATE = 1;
        MODE_CREATED = 3;
        codepageEncoding = new HashMap();
        codepageEncoding.put("4110", "UTF8");
        codepageEncoding.put("1100", "ISO8859_1");
        codepageEncoding.put("1140", "ISO8859_1");
        codepageEncoding.put("1401", "ISO8859_2");
        codepageEncoding.put("1500", "ISO8859_5");
        codepageEncoding.put("1610", "ISO8859_9");
        codepageEncoding.put("1700", "ISO8859_7");
        codepageEncoding.put("1800", "ISO8859_8");
        codepageEncoding.put("1900", "ISO8859_4");
        codepageEncoding.put("8200", "ISO2022JP");
        codepageEncoding.put("8700", "ISO8859_4");
        codepageEncoding.put("0120", "Cp500");
        codepageEncoding.put("1103", "Cp850");
        codepageEncoding.put("1404", "Cp1250");
        codepageEncoding.put("1504", "Cp1251");
        codepageEncoding.put("1614", "Cp1254");
        codepageEncoding.put("1704", "Cp1253");
        codepageEncoding.put("1804", "Cp1255");
        codepageEncoding.put("1904", "Cp1257");
        codepageEncoding.put("8604", "Cp874");
        codepageEncoding.put("8704", "Cp1256");
        codepageEncoding.put("8000", "SJIS");
        codepageEncoding.put("8100", "EUC_JP");
        codepageEncoding.put("8300", "Big5");
        codepageEncoding.put("8600", "TIS620");
        codepageEncoding.put("8400", "ISO2022CN_GB");
        codepageEncoding.put("8500", "EUC_KR");
        codepageEncoding.put("4103", "UnicodeLittleUnmarked");
    }
}

