/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.tcs.servletapi;

import com.sap.cms.tcs.servletapi.DcInfo;
import com.sap.cms.tcs.servletapi.TCSConnectionException;
import com.sap.cms.tcs.servletapi.TCSDeployInfoIF;
import com.sap.cms.tcs.servletapi.TCSNoEntryFoundException;
import com.sap.cms.tcs.servletapi.TCSVersionConflictException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.entities.ByteArrayEntity;
import com.tssap.dtr.client.lib.protocol.requests.http.GetRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.PostRequest;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;

public class TCSDeployInfo
implements TCSDeployInfoIF {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$tcs$servletapi$TCSDeployInfo == null ? (class$com$sap$cms$tcs$servletapi$TCSDeployInfo = TCSDeployInfo.class$("com.sap.cms.tcs.servletapi.TCSDeployInfo")) : class$com$sap$cms$tcs$servletapi$TCSDeployInfo).getName());
    private String tcsServletHost = null;
    private String tcsServletPath = null;
    private Connection conn = null;
    private String user = "";
    private String password = "";
    private KeyStore truststore = null;
    private boolean isSecure = false;
    private boolean versionInitialized = false;
    private String versionRelease = "0.00";
    private String versionSP = "00";
    private String versionPatch = "00";
    static /* synthetic */ Class class$com$sap$cms$tcs$servletapi$TCSDeployInfo;

    public TCSDeployInfo(URL tcsServletURL) {
        this.tcsServletHost = tcsServletURL.getProtocol() + "://" + tcsServletURL.getHost() + ":" + tcsServletURL.getPort();
        this.tcsServletPath = tcsServletURL.getPath();
        if (null == this.tcsServletHost || null == this.tcsServletPath) {
            throw new IllegalArgumentException();
        }
    }

    TCSDeployInfo(URL tcsServletURL, String user, String password, KeyStore truststore) throws TCSConnectionException {
        log.entering("TCSDeployInfo");
        try {
            this.tcsServletHost = tcsServletURL.getProtocol() + "://" + tcsServletURL.getHost() + ":" + tcsServletURL.getPort();
            this.tcsServletPath = tcsServletURL.getPath();
            if (this.tcsServletHost == null || this.tcsServletPath == null) {
                throw new TCSConnectionException("Invalid URL");
            }
            this.user = user;
            this.password = password;
            this.truststore = truststore;
            this.isSecure = "https".equalsIgnoreCase(tcsServletURL.getProtocol());
            if (this.isSecure) {
                if (truststore == null) {
                    log.error("Impossible to use https without keystore");
                    throw new TCSConnectionException("No keystore provided, impossible to use HTTPS");
                }
                log.debug("Using secure connection");
            } else {
                log.warning("Using insecure connection");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            log.exiting("TCSDeployInfo");
            throw throwable;
        }
        log.exiting("TCSDeployInfo");
    }

    public String getDeploymentStatus(String buildSpaceName, String buildRequestId, String buildvariant) throws TCSConnectionException, TCSNoEntryFoundException {
        log.entering("getDeploymentStatus(" + buildSpaceName + ", " + buildRequestId + ", " + buildvariant + ")");
        IResponse response = null;
        boolean closeConn = false;
        String message = null;
        String result = null;
        PostRequest post = new PostRequest(this.tcsServletPath);
        post.addParameter("ACTION", "DEPLOYMENTSTATUS");
        post.addParameter("BSNAME", buildSpaceName);
        post.addParameter("REQID", buildRequestId);
        log.debug("params=" + buildSpaceName + "," + buildRequestId);
        try {
            try {
                if (this.conn == null) {
                    this.openConnection();
                    closeConn = true;
                }
                this.versionCheck("getDeploymentStatus", "0.00", "00", "00");
                response = post.perform((IConnection)this.conn);
                int status = response.getStatus();
                log.debug("response status: " + status);
                if (status == 200) {
                    message = ((ByteArrayEntity)response.getEntity()).getContent("UTF-8").toString();
                    String tag = "<deployment status=\"";
                    int begin = message.indexOf(tag) + tag.length();
                    int end = message.lastIndexOf("\"/>");
                    result = message.substring(begin, end);
                } else if (response != null && response.getStatus() != 200) {
                    String errorMessage = this.extractErrorMessage(response);
                    if (response.getStatus() == 400) {
                        log.info("Bad request: " + errorMessage);
                        throw new TCSNoEntryFoundException();
                    }
                    log.error("HTTP response status:" + response.getStatusDescription());
                    log.error("Error message from server:" + errorMessage);
                    if (errorMessage == null) {
                        throw new TCSConnectionException("CommunicationError: Servlet response: " + response.getStatusDescription());
                    }
                    throw new TCSConnectionException("Server error:\n" + errorMessage);
                }
                Object var14_16 = null;
                if (closeConn) {
                    this.closeConnection();
                }
            }
            catch (IOException e) {
                throw new TCSConnectionException(e);
            }
            catch (HTTPException e) {
                throw new TCSConnectionException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (closeConn) {
                this.closeConnection();
            }
            log.exiting("getDeploymentStatus:" + result);
            throw throwable;
        }
        log.exiting("getDeploymentStatus:" + result);
        return result;
    }

    public URL getDeploymentLog(String buildSpaceName, String buildRequestId, String buildvariant) throws TCSConnectionException, TCSNoEntryFoundException {
        log.entering("getDeploymentLog(" + buildSpaceName + ", " + buildRequestId + ", " + buildvariant + ")");
        URL result = null;
        IResponse response = null;
        boolean closeConn = false;
        String message = null;
        PostRequest post = new PostRequest(this.tcsServletPath);
        post.addParameter("ACTION", "DEPLOYMENTPROTOCOL");
        post.addParameter("BSNAME", buildSpaceName);
        post.addParameter("REQID", buildRequestId);
        log.debug("params=" + buildSpaceName + "," + buildRequestId);
        try {
            try {
                if (this.conn == null) {
                    this.openConnection();
                    closeConn = true;
                }
                this.versionCheck("getDeploymentLog", "0.00", "00", "00");
                response = post.perform((IConnection)this.conn);
                int status = response.getStatus();
                log.debug("response status: " + status);
                if (status == 200) {
                    message = ((ByteArrayEntity)response.getEntity()).getContent("UTF-8").toString();
                    String tag = "<deployment protocolurl=\"";
                    int begin = message.indexOf(tag) + tag.length();
                    int end = message.lastIndexOf("\"/>");
                    String url = URLDecoder.decode(message.substring(begin, end));
                    log.debug("Deployment protocol URL: '" + url + "'");
                    result = new URL(url);
                } else if (response != null && response.getStatus() != 200) {
                    String errorMessage = this.extractErrorMessage(response);
                    if (response.getStatus() == 400) {
                        log.info("Bad request: " + errorMessage);
                        throw new TCSNoEntryFoundException();
                    }
                    log.error("HTTP response status:" + response.getStatusDescription());
                    log.error("Error message from server:" + errorMessage);
                    if (errorMessage == null) {
                        throw new TCSConnectionException("CommunicationError: Servlet response: " + response.getStatusDescription());
                    }
                    throw new TCSConnectionException("Server error:\n" + errorMessage);
                }
                Object var15_17 = null;
                if (closeConn) {
                    this.closeConnection();
                }
            }
            catch (IOException e) {
                throw new TCSConnectionException(e);
            }
            catch (HTTPException e) {
                throw new TCSConnectionException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (closeConn) {
                this.closeConnection();
            }
            log.exiting("getDeploymentLog: " + result);
            throw throwable;
        }
        log.exiting("getDeploymentLog: " + result);
        return result;
    }

    public void openConnection() throws TCSConnectionException {
        log.entering("openConnection");
        IResponse response = null;
        try {
            try {
                if (null == this.conn) {
                    SessionContext ctx = new SessionContext(this.user, this.password);
                    ctx.setAuthenticator("basic");
                    if (this.isSecure) {
                        ctx.certificates().setAuthenticateThem(true);
                        ctx.certificates().setServerCertificates(this.truststore);
                    }
                    this.conn = new Connection(this.tcsServletHost, (ISessionContext)ctx);
                    GetRequest get = new GetRequest(this.tcsServletPath);
                    response = null;
                    response = get.perform((IConnection)this.conn);
                    if (response != null && response.getStatus() != 200) {
                        this.closeConnection();
                        throw new TCSConnectionException("Unable to open connection to server '" + this.tcsServletHost + "'");
                    }
                }
                Object var7_6 = null;
            }
            catch (IOException e) {
                this.closeConnection();
                throw new TCSConnectionException(e);
            }
            catch (HTTPException e) {
                this.closeConnection();
                throw new TCSConnectionException((Exception)((Object)e));
            }
            catch (KeyStoreException e) {
                throw new TCSConnectionException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TCSConnectionException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            log.exiting("openConnection");
            throw throwable;
        }
        log.exiting("openConnection");
    }

    public void closeConnection() {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public DcInfo getDeploymentInfo(String buildSpaceName, String dcName, String dcVendor, String buildvariant) throws TCSConnectionException, TCSNoEntryFoundException {
        log.entering("getDeploymentInfo(" + buildSpaceName + ", " + dcName + ", " + dcVendor + ", " + buildvariant + ")");
        DcInfo result = null;
        String logUrl = null;
        String deplStatus = null;
        IResponse response = null;
        boolean closeConn = false;
        String message = null;
        PostRequest post = new PostRequest(this.tcsServletPath);
        post.addParameter("ACTION", "DEPLOYMENTINFO");
        post.addParameter("BSNAME", buildSpaceName);
        post.addParameter("DCNAME", dcName);
        post.addParameter("DCVENDOR", dcVendor);
        post.addParameter("BUILDVARIANT", buildvariant);
        try {
            try {
                if (this.conn == null) {
                    this.openConnection();
                    closeConn = true;
                }
                this.versionCheck("getDeploymentInfo", "0.00", "00", "00");
                response = post.perform((IConnection)this.conn);
                int status = response.getStatus();
                log.debug("response status: " + status);
                if (status == 200) {
                    message = ((ByteArrayEntity)response.getEntity()).getContent("UTF-8").toString();
                    String tag = "<deployment status=\"";
                    int begin = message.indexOf(tag) + tag.length();
                    int end = message.indexOf("\"", begin);
                    deplStatus = message.substring(begin, end);
                    tag = "protocolurl=\"";
                    begin = message.indexOf(tag, end) + tag.length();
                    end = message.indexOf("\"/>", begin);
                    logUrl = URLDecoder.decode(message.substring(begin, end));
                    log.debug("Deployment protocol URL: '" + logUrl + "'");
                    result = new DcInfo(deplStatus, logUrl);
                } else if (response != null && response.getStatus() != 200) {
                    String errorMessage = this.extractErrorMessage(response);
                    if (response.getStatus() == 400) {
                        log.info("Bad request: " + errorMessage);
                        throw new TCSNoEntryFoundException();
                    }
                    log.error("HTTP response status:" + response.getStatusDescription());
                    log.error("Error message from server:" + errorMessage);
                    if (errorMessage == null) {
                        throw new TCSConnectionException("CommunicationError: Servlet response: " + response.getStatusDescription());
                    }
                    throw new TCSConnectionException("Server error:\n" + errorMessage);
                }
                Object var18_19 = null;
                if (closeConn) {
                    this.closeConnection();
                }
            }
            catch (IOException e) {
                throw new TCSConnectionException(e);
            }
            catch (HTTPException e) {
                throw new TCSConnectionException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            if (closeConn) {
                this.closeConnection();
            }
            throw throwable;
        }
        return result;
    }

    private String extractErrorMessage(IResponse response) {
        try {
            String message = ((ByteArrayEntity)response.getEntity()).getContent("UTF-8").toString();
            if ("text/xml".equalsIgnoreCase(response.getContentType())) {
                String tag = "<exception>";
                String tag2 = "</exception>";
                int begin = message.indexOf(tag);
                if (begin == -1) {
                    log.error("Message is no error message!");
                    return null;
                }
                int end = message.indexOf(tag2);
                if (end == -1) {
                    log.error("Message has no exception end tag!");
                    return null;
                }
                String exception = message.substring(begin + tag.length(), end);
                exception = URLDecoder.decode(exception);
                return exception;
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initServletVersion() {
        log.entering("initServletVersion");
        PostRequest post = new PostRequest(this.tcsServletPath);
        post.addParameter("ACTION", "VERSION");
        IResponse response = null;
        try {
            try {
                if (this.conn == null) {
                    this.openConnection();
                }
                response = post.perform((IConnection)this.conn);
                int status = response.getStatus();
                String message = ((ByteArrayEntity)response.getEntity()).getContent("UTF-8").toString();
                log.debug("Response status: " + status);
                log.debug("Response body: " + message);
                switch (status) {
                    case 200: {
                        String tag = "<version release=\"";
                        int begin = message.indexOf(tag) + tag.length();
                        int end = message.indexOf("\"", begin);
                        this.versionRelease = message.substring(begin, end);
                        tag = "sp=\"";
                        begin = message.indexOf(tag) + tag.length();
                        end = message.indexOf("\"", begin);
                        this.versionSP = message.substring(begin, end);
                        tag = "patch=\"";
                        begin = message.indexOf(tag) + tag.length();
                        end = message.indexOf("\"", begin);
                        this.versionPatch = message.substring(begin, end);
                        log.debug("Server version: " + this.versionRelease + "." + this.versionSP + "." + this.versionPatch);
                        break;
                    }
                    case 400: {
                        log.debug("Server has no versioning, setting version to Release 0.00 SP00 Patch lebel 00");
                        break;
                    }
                }
                this.versionInitialized = true;
            }
            catch (Exception e) {
                log.error("Read of servlet version failed", (Throwable)e);
                Object var9_10 = null;
                log.exiting("initServletVersion");
                return;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            log.exiting("initServletVersion");
            throw throwable;
        }
        log.exiting("initServletVersion");
    }

    private void versionCheck(String method, String minRelease, String minSP, String minPatch) throws TCSVersionConflictException {
        log.entering("versionCheck(" + method + ", " + minRelease + ", " + minSP + ", " + minPatch + ")");
        try {
            if (!this.versionInitialized) {
                this.initServletVersion();
            }
            if (minRelease.compareTo(this.versionRelease) > 0 || minRelease.equals(this.versionRelease) && minSP.compareTo(this.versionSP) > 0 || minRelease.equals(this.versionRelease) && minSP.equals(this.versionSP) && minPatch.compareTo(this.versionPatch) > 0) {
                if (this.versionRelease.equals("0.00") && this.versionPatch.equals("00") && this.versionSP.equals("00")) {
                    throw new TCSVersionConflictException(method, "Release 6.30 SP07 Patch level 00 or less", "Release " + minRelease + " SP" + minSP + " Patch level " + minPatch);
                }
                throw new TCSVersionConflictException(method, "Release " + this.versionRelease + " SP" + this.versionSP + " Patch level " + this.versionPatch, "Release " + minRelease + " SP" + minSP + " Patch level " + minPatch);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            log.exiting("versionCheck");
            throw throwable;
        }
        log.exiting("versionCheck");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

