/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.tcs.eclipse.deployview.provider.actions;

import com.sap.cms.tcs.servletapi.DcInfo;
import com.sap.cms.tcs.servletapi.TCSConnectionException;
import com.sap.cms.tcs.servletapi.TCSDeployInfoFact;
import com.sap.cms.tcs.servletapi.TCSDeployInfoIF;
import com.sap.cms.tcs.servletapi.TCSNoEntryFoundException;
import com.sap.cms.tcs.servletapi.TCSVersionConflictException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.Property;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import java.net.MalformedURLException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DeploymentProtocolAction
implements IElementMultiAction {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$tcs$eclipse$deployview$provider$actions$DeploymentProtocolAction == null ? (class$com$sap$cms$tcs$eclipse$deployview$provider$actions$DeploymentProtocolAction = DeploymentProtocolAction.class$("com.sap.cms.tcs.eclipse.deployview.provider.actions.DeploymentProtocolAction")) : class$com$sap$cms$tcs$eclipse$deployview$provider$actions$DeploymentProtocolAction).getName());
    private static final String LABEL_SHOW_DEPLOYMENT_PROTOCOL = "Central deployment log";
    static /* synthetic */ Class class$com$sap$cms$tcs$eclipse$deployview$provider$actions$DeploymentProtocolAction;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAvailable(Element[] elements) {
        boolean bl;
        boolean returnCode;
        block12: {
            boolean bl2;
            block11: {
                boolean bl3;
                block10: {
                    boolean bl4;
                    block9: {
                        boolean bl5;
                        block8: {
                            boolean bl6;
                            block7: {
                                log.entering("isAvailable", (Object[])elements);
                                returnCode = false;
                                try {
                                    if (elements == null || elements.length == 0) {
                                        log.error("nothing selected");
                                        bl6 = returnCode;
                                        Object var8_6 = null;
                                        break block7;
                                    }
                                    if (!ComponentUtil.isDCElement((Element)elements[0])) {
                                        log.debug("element not a DC");
                                        bl5 = returnCode;
                                        break block8;
                                    }
                                    Object obj = ObjectUtil.getComponentObject((Element)elements[0]);
                                    if (!(obj instanceof IDevelopmentComponentNode)) {
                                        log.debug("element not a DC node");
                                        bl4 = returnCode;
                                        break block9;
                                    }
                                    IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)obj;
                                    if (dcNode.IsInactive()) {
                                        log.debug("element is not active");
                                        bl3 = returnCode;
                                        break block10;
                                    }
                                    ISoftwareComponentNode scNode = ComponentUtil.getParentSCNode((Element)elements[0]);
                                    if (scNode == null) {
                                        log.debug("sc node is null");
                                        bl2 = returnCode;
                                        break block11;
                                    }
                                    returnCode = true;
                                    bl = true;
                                    break block12;
                                }
                                catch (Throwable throwable) {
                                    Object var8_12 = null;
                                    log.exiting("isAvailable", (Object)new Boolean(returnCode));
                                    throw throwable;
                                }
                            }
                            log.exiting("isAvailable", (Object)new Boolean(returnCode));
                            return bl6;
                        }
                        Object var8_7 = null;
                        log.exiting("isAvailable", (Object)new Boolean(returnCode));
                        return bl5;
                    }
                    Object var8_8 = null;
                    log.exiting("isAvailable", (Object)new Boolean(returnCode));
                    return bl4;
                }
                Object var8_9 = null;
                log.exiting("isAvailable", (Object)new Boolean(returnCode));
                return bl3;
            }
            Object var8_10 = null;
            log.exiting("isAvailable", (Object)new Boolean(returnCode));
            return bl2;
        }
        Object var8_11 = null;
        log.exiting("isAvailable", (Object)new Boolean(returnCode));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnabled(Element[] elements) {
        boolean bl;
        boolean returnCode;
        block14: {
            boolean bl2;
            block13: {
                boolean bl3;
                block12: {
                    boolean bl4;
                    block11: {
                        boolean bl5;
                        block10: {
                            boolean bl6;
                            block9: {
                                boolean bl7;
                                block8: {
                                    log.entering("isEnabled", (Object[])elements);
                                    returnCode = false;
                                    try {
                                        if (elements == null || elements.length == 0) {
                                            log.error("nothing selected");
                                            bl7 = returnCode;
                                            Object var8_6 = null;
                                            break block8;
                                        }
                                        if (elements.length != 1) {
                                            log.debug("action disabled for multiselection");
                                            bl6 = returnCode;
                                            break block9;
                                        }
                                        Object obj = ObjectUtil.getComponentObject((Element)elements[0]);
                                        if (!(obj instanceof IDevelopmentComponentNode)) {
                                            log.debug("element not a DC node");
                                            bl5 = returnCode;
                                            break block10;
                                        }
                                        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)obj;
                                        if (dcNode.isLocalOnly()) {
                                            log.debug("DC is local only");
                                            bl4 = returnCode;
                                            break block11;
                                        }
                                        if (!this.isDeployable(dcNode)) {
                                            log.debug("element contains no deployable parts");
                                            bl3 = returnCode;
                                            break block12;
                                        }
                                        String url = this.getTCSServletURL(dcNode);
                                        if (url == null) {
                                            log.debug("no runtime system defined");
                                            bl2 = returnCode;
                                            break block13;
                                        }
                                        returnCode = true;
                                        bl = true;
                                        break block14;
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_13 = null;
                                        log.exiting("isEnabled", (Object)new Boolean(returnCode));
                                        throw throwable;
                                    }
                                }
                                log.exiting("isEnabled", (Object)new Boolean(returnCode));
                                return bl7;
                            }
                            Object var8_7 = null;
                            log.exiting("isEnabled", (Object)new Boolean(returnCode));
                            return bl6;
                        }
                        Object var8_8 = null;
                        log.exiting("isEnabled", (Object)new Boolean(returnCode));
                        return bl5;
                    }
                    Object var8_9 = null;
                    log.exiting("isEnabled", (Object)new Boolean(returnCode));
                    return bl4;
                }
                Object var8_10 = null;
                log.exiting("isEnabled", (Object)new Boolean(returnCode));
                return bl3;
            }
            Object var8_11 = null;
            log.exiting("isEnabled", (Object)new Boolean(returnCode));
            return bl2;
        }
        Object var8_12 = null;
        log.exiting("isEnabled", (Object)new Boolean(returnCode));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Element[] elements) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        log.entering("run", (Object[])elements);
                        String deployServletString = null;
                        IDevelopmentComponentNode dcNode = null;
                        try {
                            try {
                                if (elements == null || elements.length == 0) {
                                    log.error("nothing selected");
                                    Object var10_4 = null;
                                    break block13;
                                }
                                Object obj = ObjectUtil.getComponentObject((Element)elements[0]);
                                if (!(obj instanceof IDevelopmentComponentNode)) {
                                    log.debug("element not a DC node");
                                    break block14;
                                }
                                dcNode = (IDevelopmentComponentNode)obj;
                                deployServletString = this.getTCSServletURL(dcNode);
                                if (deployServletString == null) {
                                    log.debug("TCS servlet URL property does not exist in Development Configuration");
                                    MessageDialog.openInformation((Shell)new Shell(), (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (String)"No deployment protocol available:\nThere is no runtime system defined in this development configuration.");
                                    break block15;
                                }
                                URL deployServletURL = new URL(deployServletString);
                                log.debug("Deploy servlet URL: '" + deployServletURL + "'");
                                log.debug("Buildspace: " + dcNode.getConfiguration().getBuildSpace().getName());
                                log.debug("DC name: " + dcNode.getName());
                                log.debug("DC vendor" + dcNode.getVendor());
                                log.debug("Build variant: default");
                                TCSDeployInfoIF tcsDeployInfo = TCSDeployInfoFact.getDeployInfo(deployServletURL, UserValidator.getDefaultServerData().getUser(), UserValidator.getDefaultServerData().getPassword(), UserValidator.getKeyStore());
                                DcInfo dcInfo = tcsDeployInfo.getDeploymentInfo(dcNode.getConfiguration().getBuildSpace().getName(), dcNode.getName(), dcNode.getVendor(), "default");
                                log.debug("Deployment protocol URL: " + dcInfo.getLogPath());
                                int returnCode = Platform.getPlatform().openWithDefaultApplication(dcInfo.getLogPath());
                                if (returnCode == -3) {
                                    log.error("openWithDefaultApplication returned error code -3");
                                    MessageDialog.openError((Shell)new Shell(), (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (String)"Unable to show deployment protocol:\nThe external browser call failed.");
                                }
                                break block16;
                            }
                            catch (MalformedURLException ex) {
                                log.error("Invalid TCS servlet URL " + deployServletString, (Throwable)ex);
                                MessageDialog.openError((Shell)new Shell(), (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (String)("Unable to show deployment protocol:\nInvalid TCS servlet URL '" + deployServletString + "'"));
                                Object var10_8 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (TCSNoEntryFoundException ex) {
                                log.info("No deployment information found for DC " + dcNode.getVendor() + "/" + dcNode.getName());
                                MessageDialog.openInformation((Shell)new Shell(), (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (String)("No deployment information available for DC " + dcNode.getVendor() + "/" + dcNode.getName()));
                                Object var10_9 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (TCSVersionConflictException ex) {
                                log.error("Version conflict", (Throwable)ex);
                                MessageDialog.openError((Shell)new Shell(), (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (String)ex.getMessage());
                                Object var10_10 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (TCSConnectionException ex) {
                                log.error("Error during retrieval of deploy info", (Throwable)ex);
                                MessageDialog.openError((Shell)new Shell(), (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (String)("Unable to show deployment protocol:\nError during retrieval of deployment information:\n" + ex.getMessage()));
                                Object var10_11 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (RuntimeException ex) {
                                log.error("RuntimeException during retrieval of deploy info");
                                MessageDialog.openError((Shell)new Shell(), (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (String)("Unable to show deployment protocol:\nError during retrieval of deployment information:\n" + ex.getMessage()));
                                Object var10_12 = null;
                                log.exiting("run");
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            log.exiting("run");
                            throw throwable;
                        }
                    }
                    log.exiting("run");
                    return;
                }
                Object var10_5 = null;
                log.exiting("run");
                return;
            }
            Object var10_6 = null;
            log.exiting("run");
            return;
        }
        Object var10_7 = null;
        log.exiting("run");
    }

    public ICategory getCategory() {
        return ComponentCategoryImage.getDispCat((ICategory)Category.DEFAULT, (String)LABEL_SHOW_DEPLOYMENT_PROTOCOL, (boolean)false, (int)5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDeployable(IDevelopmentComponentNode dcNode) {
        boolean returnCode;
        block18: {
            boolean bl;
            block17: {
                boolean bl2;
                block16: {
                    boolean bl3;
                    block15: {
                        boolean bl4;
                        block14: {
                            boolean bl5;
                            block13: {
                                boolean bl6;
                                block12: {
                                    log.entering("isDeployable", new Object[]{dcNode});
                                    returnCode = false;
                                    try {
                                        try {
                                            DevelopmentComponent devComp = dcNode.getDevelopmentComponent(false);
                                            ComponentType compType = devComp.getComponentType();
                                            String type = compType.getType();
                                            String subType = compType.getSubType();
                                            log.debug("Type: " + type + " Subtype: " + subType);
                                            if ("Java".equalsIgnoreCase(type)) {
                                                bl6 = returnCode;
                                                Object var9_15 = null;
                                                break block12;
                                            }
                                            if ("J2EE".equalsIgnoreCase(type) && ("EJB Module".equalsIgnoreCase(subType) || "Web Module".equalsIgnoreCase(subType))) {
                                                bl5 = returnCode;
                                                break block13;
                                            }
                                            if ("Web Services".equalsIgnoreCase(type) && "Standalone Proxy".equalsIgnoreCase(subType)) {
                                                bl4 = returnCode;
                                                break block14;
                                            }
                                            if ("Eclipse Plugin".equalsIgnoreCase(type)) {
                                                bl3 = returnCode;
                                                break block15;
                                            }
                                            if ("Build Infrastructure".equalsIgnoreCase(type)) {
                                                bl2 = returnCode;
                                                break block16;
                                            }
                                            if ("Build Plugin".equalsIgnoreCase(type)) {
                                                bl = returnCode;
                                                break block17;
                                            }
                                            returnCode = true;
                                            break block18;
                                        }
                                        catch (RepositoryAccessException e) {
                                            log.warning("Error accessing the .dcdef file");
                                            Object var9_22 = null;
                                            log.exiting("isDeployable", (Object)new Boolean(returnCode));
                                            return returnCode;
                                        }
                                        catch (InvalidDefinitionException e) {
                                            log.error("Error during getting the development component", (Throwable)e);
                                            Object var9_23 = null;
                                            log.exiting("isDeployable", (Object)new Boolean(returnCode));
                                            return returnCode;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_24 = null;
                                        log.exiting("isDeployable", (Object)new Boolean(returnCode));
                                        throw throwable;
                                    }
                                }
                                log.exiting("isDeployable", (Object)new Boolean(returnCode));
                                return bl6;
                            }
                            Object var9_16 = null;
                            log.exiting("isDeployable", (Object)new Boolean(returnCode));
                            return bl5;
                        }
                        Object var9_17 = null;
                        log.exiting("isDeployable", (Object)new Boolean(returnCode));
                        return bl4;
                    }
                    Object var9_18 = null;
                    log.exiting("isDeployable", (Object)new Boolean(returnCode));
                    return bl3;
                }
                Object var9_19 = null;
                log.exiting("isDeployable", (Object)new Boolean(returnCode));
                return bl2;
            }
            Object var9_20 = null;
            log.exiting("isDeployable", (Object)new Boolean(returnCode));
            return bl;
        }
        Object var9_21 = null;
        log.exiting("isDeployable", (Object)new Boolean(returnCode));
        return returnCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTCSServletURL(IDevelopmentComponentNode dcNode) {
        String string;
        String url;
        block8: {
            String string2;
            block7: {
                String string3;
                block6: {
                    String string4;
                    block5: {
                        log.entering("getTCSServletURL", new Object[]{dcNode});
                        url = null;
                        try {
                            IDevelopmentConfiguration conf = dcNode.getConfiguration();
                            if (conf == null) {
                                log.error("DC node configuration is null");
                                string4 = url;
                                Object var8_6 = null;
                                break block5;
                            }
                            DevelopmentConfiguration devConf = conf.getConfigurationData();
                            if (devConf == null) {
                                log.error("Development configuration data is null");
                                string3 = url;
                                break block6;
                            }
                            Property servletURLProp = devConf.getProperty("TCS_SERVLET", "http://xml.sap.com/2003/07/DevelopmentConfiguration/Transport-Controller");
                            if (servletURLProp == null) {
                                string2 = url;
                                break block7;
                            }
                            string = url = servletURLProp.getValue();
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            log.exiting("getTCSServletURL", url);
                            throw throwable;
                        }
                    }
                    log.exiting("getTCSServletURL", url);
                    return string4;
                }
                Object var8_7 = null;
                log.exiting("getTCSServletURL", url);
                return string3;
            }
            Object var8_8 = null;
            log.exiting("getTCSServletURL", url);
            return string2;
        }
        Object var8_9 = null;
        log.exiting("getTCSServletURL", url);
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

