/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.util.xml;

import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.dom.TextImpl;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLTool {
    public static StructureTree parseReader(Reader reader) throws IOException, XMLParseException {
        StructureTree result = null;
        try {
            DOMParser tmp2 = new DOMParser();
            InputSource source = new InputSource(reader);
            Document doc = tmp2.parse(source);
            Element tmp1 = doc.getDocumentElement();
            result = XMLTool.wrapDOM(tmp1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLParseException();
        }
        return result;
    }

    public static StructureTree wrapDOM(Element node) {
        if (node == null) {
            return null;
        }
        String tag = node.getNodeName();
        Header header = new Header(tag);
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            int i = 0;
            while (i < nnm.getLength()) {
                Node currentAttr = nnm.item(i);
                header.setParameter(currentAttr.getNodeName(), currentAttr.getNodeValue());
                ++i;
            }
        }
        StructureTree st = new StructureTree(header);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() == 1) {
                st.addNewChild(XMLTool.wrapDOM((Element)currentNode));
            } else if (currentNode.getNodeType() == 3 && i == 0) {
                st.setText(currentNode.getNodeValue());
            }
            ++i;
        }
        return st;
    }

    public static Document unWrapDOM(StructureTree st) {
        if (st == null) {
            return null;
        }
        DocumentImpl doc = new DocumentImpl();
        Element el = XMLTool.structureTree2Element(st, (Document)doc);
        doc.appendChild(el);
        return doc;
    }

    private static Element structureTree2Element(StructureTree st, Document doc) {
        Element el = doc.createElement(st.getTag());
        Properties params = st.getParameters();
        Enumeration keys = ((Hashtable)params).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            el.setAttribute(key, params.getProperty(key));
        }
        String text = st.getText();
        if (text != null) {
            TextImpl t = new TextImpl();
            t.setNodeValue(text);
            el.appendChild((Node)t);
        }
        StructureTree[] children = st.getChildren();
        int i = 0;
        while (i < children.length) {
            el.appendChild(XMLTool.structureTree2Element(children[i], doc));
            ++i;
        }
        return el;
    }

    public static void writeDocument(StructureTree[] trees, String outerTag, Writer writer) throws IOException {
        if (trees == null) {
            return;
        }
        StructureTree documentTree = new StructureTree(new Header(outerTag));
        int i = 0;
        while (i < trees.length) {
            documentTree.addChild(trees[i]);
            ++i;
        }
        XMLTool.writeDocument(documentTree, writer);
        writer.flush();
    }

    public static void writeDocument(StructureTree tree, Writer writer) throws IOException {
        if (tree == null) {
            return;
        }
        Document doc = XMLTool.unWrapDOM(tree);
        try {
            new DOMSerializer().write((Node)doc, writer);
        }
        catch (Exception e) {
            throw new IOException();
        }
        writer.flush();
    }

    public static String toString(StructureTree tree) {
        StringWriter sw = new StringWriter();
        BufferedWriter buf = new BufferedWriter(sw);
        Document doc = XMLTool.unWrapDOM(tree);
        try {
            new DOMSerializer().write((Node)doc, (Writer)buf);
            return sw.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

