/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.util.structures;

import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class StructureTree
implements Persistable {
    public static final String MACRO_DELIMITER = "@";
    private Header header;
    private StructureTree[] children;
    private StructureTree parent;
    private String text;

    public StructureTree(Header header) {
        this.header = header;
        this.children = new StructureTree[0];
        this.parent = null;
    }

    public Header getHeader() {
        return this.header;
    }

    public StructureTree getParent() {
        return this.parent;
    }

    public String getText() {
        if (this.text != null) {
            return this.text.trim();
        }
        return null;
    }

    public void setText(String text) {
        this.text = text;
    }

    public StructureTree addChild(Header header) {
        StructureTree tempTree = null;
        tempTree = this.findChild(header, null);
        if (tempTree == null) {
            tempTree = new StructureTree(header);
            this.addNewChild(tempTree);
        }
        return tempTree;
    }

    public StructureTree addNewChild(Header header) {
        StructureTree tempTree = new StructureTree(header);
        this.addNewChild(tempTree);
        return tempTree;
    }

    public StructureTree addChild(Header header, String t1) {
        StructureTree tempTree = null;
        tempTree = this.findChild(header, t1);
        if (tempTree == null) {
            tempTree = new StructureTree(header);
            tempTree.setText(t1);
            this.addNewChild(tempTree);
        }
        return tempTree;
    }

    public StructureTree addNewChild(Header header, String t1) {
        StructureTree tempTree = new StructureTree(header);
        tempTree.setText(t1);
        this.addNewChild(tempTree);
        return tempTree;
    }

    public StructureTree addChild(StructureTree tree) {
        if (tree == null) {
            return null;
        }
        StructureTree tempTree = null;
        tempTree = this.findChild(tree.getHeader(), tree.getText());
        if (tempTree == null) {
            this.addNewChild(tree);
            return tree;
        }
        int i = 0;
        while (i < tree.children.length) {
            tempTree.addChild(tree.children[i]);
            ++i;
        }
        return tempTree;
    }

    public StructureTree[] getChildren() {
        return this.children;
    }

    public StructureTree findChild(Header inHeader, String text) {
        if (inHeader == null) {
            return null;
        }
        int i = 0;
        while (i < this.children.length) {
            if (inHeader.eq(this.children[i].header) && (text == null && this.children[i].getText() == null || this.children[i].getText() != null && this.children[i].getText().equals(text))) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    public void removeChildren(Header inHeader) {
        if (inHeader == null) {
            return;
        }
        int i = 0;
        while (i < this.children.length) {
            if (inHeader.eq(this.children[i].header)) {
                StructureTree[] tempChildren = new StructureTree[this.children.length - 1];
                int j = 0;
                while (j < i) {
                    tempChildren[j] = this.children[j];
                    ++j;
                }
                int j2 = i + 1;
                while (j2 < this.children.length) {
                    tempChildren[j2 - 1] = this.children[j2];
                    ++j2;
                }
                this.children = tempChildren;
            }
            ++i;
        }
    }

    public void removeChildren(String tag) {
        if (tag == null) {
            return;
        }
        boolean[] remove = new boolean[this.children.length];
        int numberOfRemovals = 0;
        int i = 0;
        while (i < this.children.length) {
            if (tag.equals(this.children[i].getTag())) {
                remove[i] = true;
                ++numberOfRemovals;
            } else {
                remove[i] = false;
            }
            ++i;
        }
        StructureTree[] tempChildren = new StructureTree[this.children.length - numberOfRemovals];
        int currentIndex = 0;
        int i2 = 0;
        while (i2 < this.children.length) {
            if (!remove[i2]) {
                tempChildren[currentIndex] = this.children[i2];
                ++currentIndex;
            }
            ++i2;
        }
        this.children = tempChildren;
    }

    public StructureTree addNewChild(StructureTree tree) {
        StructureTree[] temp = new StructureTree[this.children.length + 1];
        int i = 0;
        while (i < this.children.length) {
            temp[i] = this.children[i];
            ++i;
        }
        temp[this.children.length] = tree;
        this.children = temp;
        tree.parent = this;
        return tree;
    }

    public StructureTree[] getChildren(String tag) {
        boolean[] good = new boolean[this.children.length];
        int found = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getTag().equals(tag)) {
                good[i] = true;
                ++found;
            } else {
                good[i] = false;
            }
            ++i;
        }
        StructureTree[] goodArray = new StructureTree[found];
        int currentIndex = 0;
        int i2 = 0;
        while (i2 < this.children.length) {
            if (good[i2]) {
                goodArray[currentIndex] = this.children[i2];
                ++currentIndex;
            }
            ++i2;
        }
        return goodArray;
    }

    public StructureTree getOnlyChild(String tag) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getTag().equals(tag)) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    public StructureTree toStructureTree() {
        return this;
    }

    public String getParameter(String name) {
        return this.header.getParameter(name);
    }

    public Properties getParameters() {
        return this.header.getParameters();
    }

    public String getTag() {
        return this.header.getTag();
    }

    private String resolveMacros(String string, Properties macros) {
        if (string == null) {
            return null;
        }
        Enumeration<?> enumeration = macros.propertyNames();
        if (!enumeration.hasMoreElements()) {
            return string;
        }
        StringTokenizer st = new StringTokenizer(string, MACRO_DELIMITER, true);
        if (st.countTokens() < 3) {
            return string;
        }
        String out = string;
        while (enumeration.hasMoreElements()) {
            String currentBare = (String)enumeration.nextElement();
            String currentPattern = MACRO_DELIMITER + currentBare + MACRO_DELIMITER;
            String currentValue = macros.getProperty(currentBare);
            if (out.length() < currentPattern.length()) continue;
            int i = 0;
            while (i <= out.length() - currentPattern.length()) {
                if (out.substring(i).startsWith(currentPattern)) {
                    out = out.substring(0, i) + currentValue + out.substring(i + currentPattern.length(), out.length());
                }
                ++i;
            }
        }
        return out;
    }

    public StructureTree resolveMacros(Properties macros) {
        this.setText(this.resolveMacros(this.getText(), macros));
        Properties pars = this.header.getParameters();
        Enumeration keys = ((Hashtable)pars).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = pars.getProperty(key);
            this.header.setParameter(key, this.resolveMacros(value, macros));
        }
        int i = 0;
        while (i < this.children.length) {
            this.children[i].resolveMacros(macros);
            ++i;
        }
        macros = new Properties();
        return this;
    }
}

