/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.ascii.StringBuf;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.io.Serializable;

public final class StringArrayParameter
implements ParameterInterface {
    private static final String PAR_TYPE_STRING_ARRAY_ITEM = "ITEM";
    protected final String name;
    private String[] value;
    private String type = "STRING[]";

    StringArrayParameter(String name, String[] value) {
        this.name = name;
        this.value = value;
    }

    StringArrayParameter(String name, String[] value, String type) {
        this.name = name;
        this.value = value;
        if (type == null || !type.equals("STRING[]") && !type.equals("FILE[]") && !type.equals("DIRECTORY[]")) {
            throw new IllegalArgumentException("type " + type + " is invalid");
        }
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String[] getValueTrue() {
        return this.value;
    }

    public String valueToString() {
        StringBuf buf = new StringBuf(200).append('{');
        if (null != this.value && 0 != this.value.length) {
            buf.append(this.value[0]);
            int i = 1;
            while (i < this.value.length) {
                buf.append(',');
                buf.append(this.value[i]);
                ++i;
            }
        }
        return buf.append('}').toString();
    }

    public String toString() {
        String valString = this.valueToString();
        StringBuf buf = new StringBuf(this.name.length() + valString.length() + 10);
        return buf.append(this.name).append(':').append(valString).toString();
    }

    public void setValue(Serializable newValue) {
        this.value = newValue == null ? null : (newValue instanceof String[] ? (String[])newValue : new String[]{newValue.toString()});
    }

    public StructureTree toStructureTree() {
        Header paramHeader = new Header("INPUT_PARAMETER");
        paramHeader.setParameter("NAME", this.name);
        paramHeader.setParameter("TYPE", this.type);
        StructureTree paramTree = new StructureTree(paramHeader);
        if (null != this.value && 0 != this.value.length) {
            Header contentHeader = new Header("VALUE");
            StructureTree contentTree = new StructureTree(contentHeader);
            paramTree.addNewChild(contentTree);
            int i = 0;
            while (i < this.value.length) {
                if (null != this.value[i]) {
                    StructureTree itemTree = new StructureTree(new Header(PAR_TYPE_STRING_ARRAY_ITEM));
                    itemTree.setText(this.value[i]);
                    contentTree.addChild(itemTree);
                }
                ++i;
            }
        }
        return paramTree;
    }

    static StringArrayParameter createFromStructureTree(String nameInfo, StructureTree treeInfo) throws BadTreeException {
        StructureTree[] contents = treeInfo.getChildren("VALUE");
        if (null == contents || 0 == contents.length) {
            return new StringArrayParameter(nameInfo, null, treeInfo.getParameter("TYPE"));
        }
        if (1 != contents.length) {
            throw new BadTreeException("illegal value content");
        }
        StructureTree[] items = contents[0].getChildren(PAR_TYPE_STRING_ARRAY_ITEM);
        if (null != items && 0 != items.length) {
            String[] values = new String[items.length];
            int i = 0;
            while (i < items.length) {
                values[i] = items[i].getText();
                if (null == values[i]) {
                    throw new BadTreeException("Empty StringArray Element");
                }
                ++i;
            }
            return new StringArrayParameter(nameInfo, values, treeInfo.getParameter("TYPE"));
        }
        return new StringArrayParameter(nameInfo, null, treeInfo.getParameter("TYPE"));
    }
}

