/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jtci.FilePosition;
import com.sap.tc.jtools.jtci.GenericPosition;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class PerformResponse {
    protected String name;
    protected String tool;
    private List results = new ArrayList();
    private Properties properties;

    public PerformResponse(String name) {
        this.name = name;
    }

    public PerformResponse(StructureTree tree) throws BadTreeException {
        this.name = tree.getParameter("NAME");
        this.properties = tree.getParameters();
        ((Hashtable)this.properties).remove("NAME");
        StructureTree[] sourceTrees = tree.getChildren("SOURCE");
        int i = 0;
        while (i < sourceTrees.length) {
            ResultInterface[] tempResults = PerformResponse.getResults(sourceTrees[i]);
            int ii = 0;
            while (ii < tempResults.length) {
                this.results.add(tempResults[ii]);
                ++ii;
            }
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTool() {
        return this.tool;
    }

    public void addResult(ResultInterface newResult) {
        this.results.add(newResult);
    }

    public void addResults(ResultInterface[] newResults) {
        this.results.addAll(Arrays.asList(newResults));
    }

    public ResultInterface[] getResults() {
        return this.results.toArray(new ResultInterface[this.results.size()]);
    }

    public ResultInterface[] getResults(String testObjectID) {
        Vector<ResultInterface> outVector = new Vector<ResultInterface>();
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            ResultInterface current = (ResultInterface)iterator.next();
            if (!current.getTestObjectID().equals(testObjectID)) continue;
            outVector.add(current);
        }
        return outVector.toArray(new ResultInterface[outVector.size()]);
    }

    public ResultInterface[] getResults(String testObjectID, String testName) {
        Vector<ResultInterface> outVector = new Vector<ResultInterface>();
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            ResultInterface current = (ResultInterface)iterator.next();
            if (!current.getTestObjectID().equals(testObjectID) || !current.getTestName().equals(testName)) continue;
            outVector.add(current);
        }
        return outVector.toArray(new ResultInterface[outVector.size()]);
    }

    public StructureTree toStructureTree() {
        Header rootHeader = new Header("RESPONSE");
        rootHeader.setParameter("NAME", this.name);
        if (this.properties != null) {
            Iterator iter = ((Hashtable)this.properties).keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                rootHeader.setParameter(key, this.properties.getProperty(key));
            }
        }
        StructureTree rootTree = new StructureTree(rootHeader);
        if (this.results.size() == 0) {
            return rootTree;
        }
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            StructureTree resultTree = ((ResultInterface)iterator.next()).toStructureTree();
            rootTree.addNewChild(resultTree);
        }
        return rootTree;
    }

    private static ResultInterface[] getResults(StructureTree resultTree) {
        String testObjectType = resultTree.getParameter("TYPE");
        String testObjectID = resultTree.getParameter("ID");
        Vector<Result> resultVector = new Vector<Result>();
        StructureTree[] testTrees = resultTree.getChildren("TEST");
        int i3 = 0;
        while (i3 < testTrees.length) {
            String testName = testTrees[i3].getParameter("NAME");
            StructureTree[] messageTrees = testTrees[i3].getChildren("MESSAGE");
            int i4 = 0;
            while (i4 < messageTrees.length) {
                int priority = Integer.parseInt(messageTrees[i4].getParameter("PR"));
                String errorMessage = messageTrees[i4].getText();
                Properties errorMessageParameters = messageTrees[i4].getParameters();
                TestObjectPosition position = null;
                StructureTree[] toPositionTrees = messageTrees[i4].getChildren();
                if (toPositionTrees.length == 1) {
                    String type = toPositionTrees[0].getTag();
                    try {
                        position = type.equals("FILE") ? new FilePosition(toPositionTrees[0]) : new GenericPosition(toPositionTrees[0]);
                    }
                    catch (Exception e) {
                        position = null;
                    }
                }
                resultVector.add(new Result(testName, testObjectType, testObjectID, position, priority, errorMessage, errorMessageParameters));
                ++i4;
            }
            ++i3;
        }
        return resultVector.toArray(new ResultInterface[resultVector.size()]);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

