/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class FilePosition
implements TestObjectPosition {
    private static final String TAG_FILE = "FILE";
    private static final String TAG_FILE_POSITION = "FILE_POSITION";
    private static final String PARAMETER_LINE = "LINE";
    private static final String PARAMETER_COLUMN = "COLUMN";
    private static final int DEFAULT_LINE = -1;
    private static final int DEFAULT_COLUMN = -1;
    private String file;
    public int line = -1;
    public int column = -1;

    public FilePosition(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public FilePosition(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public StructureTree toStructureTree() {
        Header fileHeader = new Header(TAG_FILE);
        fileHeader.setParameter("NAME", this.getFile());
        StructureTree fileTree = new StructureTree(fileHeader);
        int line = this.getLine();
        int column = this.getColumn();
        if (line != -1 || column != -1) {
            Header filePositionHeader = new Header(TAG_FILE_POSITION);
            if (line != -1) {
                filePositionHeader.setParameter(PARAMETER_LINE, Integer.toString(line));
            }
            if (column != -1) {
                filePositionHeader.setParameter(PARAMETER_COLUMN, Integer.toString(column));
            }
            StructureTree filePositionTree = new StructureTree(filePositionHeader);
            fileTree.addChild(filePositionTree);
        }
        return fileTree;
    }

    public FilePosition(StructureTree tree) throws BadTreeException {
        String tag = tree.getTag();
        if (!tag.equals(TAG_FILE)) {
            throw new BadTreeException();
        }
        this.file = tree.getParameter("NAME");
        StructureTree filePosition = tree.getOnlyChild(TAG_FILE_POSITION);
        if (filePosition != null) {
            String lineString = filePosition.getParameter(PARAMETER_LINE);
            String columnString = filePosition.getParameter(PARAMETER_COLUMN);
            this.line = lineString == null ? -1 : Integer.parseInt(lineString);
            this.column = columnString == null ? -1 : Integer.parseInt(columnString);
        }
    }
}

