/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunSummaryInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.ff.impl.RunSummary;
import com.sap.tc.jtools.jlint.report.html.RunReportConfiguration;
import com.sap.tc.jtools.jlint.report.html.RunReportPageManager;
import com.sap.tc.jtools.jlint.report.html.RunSummaryPage;
import com.sap.tc.jtools.jtci.TestSet;
import java.io.File;

public class RunReportManager {
    private RunReportConfiguration reportConfiguration;

    public RunReportManager(RunReportConfiguration reportConfiguration) {
        this.reportConfiguration = reportConfiguration;
    }

    public RunSummaryInterface createRunReport(RunInterface run, String outputDirectoryPath) {
        RunReportPageManager pageManager = new RunReportPageManager(this.reportConfiguration, outputDirectoryPath, false);
        TestDescriptionSet[] testDescriptionSets = run.getTestDescriptionSets();
        int j = 0;
        while (j < testDescriptionSets.length) {
            pageManager.createTestDescriptionPage(run.getRunID(), testDescriptionSets[j]);
            ++j;
        }
        RunSummaryPage runPage = pageManager.createRunSummary(run);
        ProjectRunInterface[] projectRuns = run.getProjectsRuns();
        int j2 = 0;
        while (j2 < projectRuns.length) {
            if (this.reportConfiguration.getProjectFilter().acceptProject(projectRuns[j2].getProjectId())) {
                TestSet testVariant = projectRuns[j2].getTestVariant();
                pageManager.createVariantPage(projectRuns[j2], testVariant);
                pageManager.createProjectRunPage(projectRuns[j2]);
                pageManager.saveAll();
            }
            ++j2;
        }
        pageManager.saveAll();
        return new RunSummary(new File(outputDirectoryPath, runPage.getAddress()).getParentFile());
    }
}

