/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.report.html.ProjectFilterInterface;
import com.sap.tc.jtools.jlint.report.html.TestFilterInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class RunReportConfiguration {
    private static final TestFilterInterface DEFAULT_TEST_FILTER = new TestFilterInterface(){

        public boolean acceptTest(String testId) {
            return true;
        }

        public boolean acceptMessage(String testId, String msgKey) {
            return true;
        }
    };
    private static final ProjectFilterInterface DEFAULT_PROJECT_FILTER = new ProjectFilterInterface(){

        public boolean acceptProject(String projectId) {
            return true;
        }
    };
    private ProjectFilterInterface projectFilter = DEFAULT_PROJECT_FILTER;
    private TestFilterInterface testFilter = DEFAULT_TEST_FILTER;
    private boolean displayIndividualMessages = true;
    private boolean displayMetricSummary = true;
    private boolean displayTestSummary = true;
    private boolean ignoreInfos = false;
    private boolean ignoreWarnings = false;

    public RunReportConfiguration() {
    }

    public RunReportConfiguration(StructureTree tree) {
        StructureTree testFilterTree;
        StructureTree projectFilterTree;
        if (tree.getParameter("DISPLAY_INDIVIDUAL_MESSAGES") != null) {
            this.displayIndividualMessages = new Boolean(tree.getParameter("DISPLAY_INDIVIDUAL_MESSAGES"));
        }
        if (tree.getParameter("DISPLAY_METRIC_SUMMARY") != null) {
            this.displayMetricSummary = new Boolean(tree.getParameter("DISPLAY_METRIC_SUMMARY"));
        }
        if (tree.getParameter("DISPLAY_TEST_SUMMARY") != null) {
            this.displayTestSummary = new Boolean(tree.getParameter("DISPLAY_TEST_SUMMARY"));
        }
        if (tree.getParameter("IGNORE_INFOS") != null) {
            this.ignoreInfos = new Boolean(tree.getParameter("IGNORE_INFOS"));
        }
        if (tree.getParameter("IGNORE_WARNINGS") != null) {
            this.ignoreWarnings = new Boolean(tree.getParameter("IGNORE_WARNINGS"));
        }
        if ((projectFilterTree = tree.getOnlyChild("PROJECT_FILTER")) != null) {
            StructureTree[] projectNameTrees = projectFilterTree.getChildren("PROJECT");
            final String[] projectNames = new String[projectNameTrees.length];
            int i = 0;
            while (i < projectNames.length) {
                projectNames[i] = projectNameTrees[i].getParameter("ID");
                ++i;
            }
            this.projectFilter = new ProjectFilterInterface(){

                public boolean acceptProject(String projectId) {
                    int i = 0;
                    while (i < projectNames.length) {
                        if (projectNames[i].equals(projectId)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            };
        }
        if ((testFilterTree = tree.getOnlyChild("TEST_FILTER")) != null) {
            StructureTree[] testNameTrees = testFilterTree.getChildren("TEST");
            final ArrayList<String> okTests = new ArrayList<String>();
            final HashMap<String, String[]> okMsgKeys = new HashMap<String, String[]>();
            int i = 0;
            while (i < testNameTrees.length) {
                String testName = testNameTrees[i].getParameter("ID");
                StructureTree[] okKeyTrees = testNameTrees[i].getChildren("KEY_MSG");
                if (okKeyTrees.length == 0) {
                    okTests.add(testName);
                } else {
                    String[] okKeys = new String[okKeyTrees.length];
                    int j = 0;
                    while (j < okKeys.length) {
                        okKeys[j] = okKeyTrees[j].getParameter("KEY");
                        ++j;
                    }
                    okMsgKeys.put(testName, okKeys);
                }
                ++i;
            }
            this.testFilter = new TestFilterInterface(){

                public boolean acceptTest(String testId) {
                    Iterator iter = okTests.iterator();
                    while (iter.hasNext()) {
                        String test = (String)iter.next();
                        if (!test.equals(testId)) continue;
                        return true;
                    }
                    Iterator iter2 = okMsgKeys.keySet().iterator();
                    while (iter2.hasNext()) {
                        String test = (String)iter2.next();
                        if (!test.equals(testId)) continue;
                        return true;
                    }
                    return false;
                }

                public boolean acceptMessage(String testId, String msgKey) {
                    Iterator iter = okTests.iterator();
                    while (iter.hasNext()) {
                        String test = (String)iter.next();
                        if (!test.equals(testId)) continue;
                        return true;
                    }
                    Iterator iter2 = okMsgKeys.keySet().iterator();
                    while (iter2.hasNext()) {
                        String test = (String)iter2.next();
                        if (!test.equals(testId)) continue;
                        String[] okKeys = (String[])okMsgKeys.get(test);
                        int i = 0;
                        while (i < okKeys.length) {
                            if (msgKey.equals(okKeys[i])) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                    return false;
                }
            };
        }
    }

    public boolean isDisplayIndividualMessages() {
        return this.displayIndividualMessages;
    }

    public boolean isDisplayMetricSummary() {
        return this.displayMetricSummary;
    }

    public boolean isDisplayTestSummary() {
        return this.displayTestSummary;
    }

    public ProjectFilterInterface getProjectFilter() {
        return this.projectFilter;
    }

    public TestFilterInterface getTestFilter() {
        return this.testFilter;
    }

    public void setDisplayIndividualMessages(boolean b) {
        this.displayIndividualMessages = b;
    }

    public void setDisplayMetricSummary(boolean b) {
        this.displayMetricSummary = b;
    }

    public void setDisplayTestSummary(boolean b) {
        this.displayTestSummary = b;
    }

    public void setProjectFilter(ProjectFilterInterface interface1) {
        this.projectFilter = interface1;
    }

    public void setTestFilter(TestFilterInterface interface1) {
        this.testFilter = interface1;
    }

    public boolean isIgnoreInfos() {
        return this.ignoreInfos;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreInfos(boolean b) {
        this.ignoreInfos = b;
    }

    public void setIgnoreWarnings(boolean b) {
        this.ignoreWarnings = b;
    }
}

