/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.report.html.Page;
import com.sap.tc.jtools.jlint.report.html.RunReportPageManager;
import com.sap.tc.jtools.jlint.statistics.MetricResult;
import com.sap.tc.jtools.jtci.FilePosition;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;

public class ResultFormatter {
    public static String getResultTable(String runId, ResultInterface[] results, RunReportPageManager pageManager, Page callingPage) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"1\">");
        sb.append("<th>Test</th>");
        sb.append("<th>Message</th>");
        sb.append("<th>File</th>");
        sb.append("<th>Line</th>");
        sb.append("<th>Column</th>");
        sb.append("<th>Priority</th>");
        int i = 0;
        while (i < results.length) {
            int prio = results[i].getPriority();
            if (!(prio > 3 || prio < 1 || prio == 3 && pageManager.getRunReportConfiguration().isIgnoreInfos() || prio == 2 && pageManager.getRunReportConfiguration().isIgnoreWarnings() || MetricResult.isGlobalMetricResult(results[i]))) {
                String msgKey;
                String testName = results[i].getTestName();
                if (pageManager.getRunReportConfiguration().getTestFilter().acceptTest(testName) && ((msgKey = results[i].getErrorParameters().getProperty("__MSG_KEY")) == null || pageManager.getRunReportConfiguration().getTestFilter().acceptMessage(testName, msgKey))) {
                    String message = results[i].getErrorText();
                    String link = results[i].getErrorParameters().getProperty("__LINK");
                    TestObjectPosition position = results[i].getResultPosition();
                    sb.append("<tr>");
                    sb.append("<td>");
                    if (pageManager.getLinkForTest(runId, testName, callingPage) != null) {
                        sb.append("<a href=\"" + pageManager.getLinkForTest(runId, testName, callingPage) + "\">" + testName + "</a>");
                    } else {
                        sb.append(testName);
                    }
                    sb.append("</td>");
                    sb.append("<td>");
                    if (link != null && !link.trim().equals("")) {
                        sb.append("<a href=\"" + link + "\">" + message + "</a>");
                    } else {
                        sb.append(message);
                    }
                    sb.append("</td>");
                    if (position instanceof FilePosition) {
                        FilePosition filePosition = (FilePosition)position;
                        sb.append("<td>");
                        sb.append(filePosition.getFile());
                        sb.append("</td>");
                        int line = filePosition.getLine();
                        int column = filePosition.getColumn();
                        if (line != -1) {
                            sb.append("<td>");
                            sb.append(line);
                            sb.append("</td>");
                        } else {
                            sb.append("<td>");
                            sb.append("");
                            sb.append("</td>");
                        }
                        if (column != -1) {
                            sb.append("<td>");
                            sb.append(column);
                            sb.append("</td>");
                        } else {
                            sb.append("<td>");
                            sb.append("");
                            sb.append("</td>");
                        }
                    } else {
                        sb.append("<td>");
                        sb.append("");
                        sb.append("</td>");
                        sb.append("<td>");
                        sb.append("");
                        sb.append("</td>");
                        sb.append("<td>");
                        sb.append("");
                        sb.append("</td>");
                    }
                    sb.append("<td>");
                    sb.append(prio);
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            }
            ++i;
        }
        sb.append("</table>");
        return sb.toString();
    }
}

