/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.html.Page;
import com.sap.tc.jtools.jlint.report.html.ResultFormatter;
import com.sap.tc.jtools.jlint.report.html.RunReportPageManager;
import com.sap.tc.jtools.jlint.report.html.StatisticsGenerator;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.PerformResponse;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class ProjectRunSummaryPage
extends Page {
    private ProjectRunInterface data;
    private String contents;
    private String runId;
    private ResultStatistics statistics;

    public ProjectRunSummaryPage(ProjectRunInterface data, String address, RunReportPageManager pageManager) {
        super(address, pageManager);
        this.data = data;
        this.runId = data.getRunId();
        this.statistics = data.getStatistics();
    }

    public ResultStatistics getStatistics() {
        return this.statistics;
    }

    public String getContents() {
        RunReportPageManager rrManager = (RunReportPageManager)this.pageManager;
        if (this.contents == null) {
            StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\"><html> <head> <META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><title>");
            sb.append("JLin run - Project " + this.data.getProjectId() + ", run " + this.runId);
            sb.append("</title></head>");
            sb.append("<body style=\"font-family: arial;\"><h2>");
            sb.append("JLin run - Project " + this.data.getProjectId() + ", run " + this.runId);
            sb.append("</h2>");
            sb.append("<p>");
            PerformResponse[] runIndex = this.data.getResults();
            if (runIndex != null && runIndex.length > 0) {
                sb.append("<p>NAME: " + runIndex[0].getName());
                Properties props = runIndex[0].getProperties();
                Iterator iter = ((Hashtable)props).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = props.getProperty(key);
                    sb.append("<p>" + key + ": " + value);
                }
            }
            sb.append("<hr><p>");
            if (rrManager.getLinkForVariant(this.data, this) != null) {
                sb.append("<p><a href=\"" + rrManager.getLinkForVariant(this.data, this) + "\">Executed tests</a>");
            }
            if (this.statistics != null) {
                sb.append(StatisticsGenerator.getSummary(this.runId, this.statistics, rrManager, this));
                sb.append("<p>");
                if (runIndex.length > 1) {
                    sb.append("<hr><p><b>Sub-runs</b><p>");
                    sb.append("<table border=\"0\" rules=\"groups\">");
                    sb.append(" <tbody>");
                    int i = 0;
                    while (i < runIndex.length) {
                        ResultStatistics rs = new ResultStatistics(runIndex[i].getResults());
                        sb.append("<tr>");
                        sb.append(" <td>");
                        sb.append(StatisticsGenerator.getSummary(this.runId, rs, rrManager, this));
                        sb.append("</td>");
                        sb.append("</tr>");
                        ++i;
                    }
                    sb.append("</tbody>");
                    sb.append("</table>");
                }
                if (rrManager.getRunReportConfiguration().isDisplayIndividualMessages()) {
                    sb.append("<h3>Details</h3>");
                    sb.append("<table border=\"0\" rules=\"groups\">");
                    sb.append(" <tbody>");
                    int i = 0;
                    while (i < runIndex.length) {
                        sb.append("<tr>");
                        sb.append(" <td>");
                        sb.append(ResultFormatter.getResultTable(this.runId, runIndex[i].getResults(), rrManager, this));
                        sb.append("</td>");
                        sb.append("</tr>");
                        ++i;
                    }
                    sb.append("</tbody>");
                    sb.append("</table>");
                }
            }
            sb.append("</body></html>");
            this.contents = sb.toString();
        }
        return this.contents;
    }
}

