/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunSummaryInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunSummaryInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.ff.impl.ProjectRunSummary;
import com.sap.tc.jtools.jlint.report.html.ProjectFilterInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class RunSummary
implements RunSummaryInterface {
    private File runDir;
    private ProjectRunSummaryInterface[] projects;
    private ResultStatistics globalResults;

    public RunSummary(File runDir) {
        this.runDir = runDir;
        File projectDir = new File(runDir, "projects");
        ArrayList projectList = new ArrayList();
        File[] projectDirectories = projectDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        this.projects = new ProjectRunSummaryInterface[projectDirectories.length];
        int i = 0;
        while (i < projectDirectories.length) {
            this.projects[i] = new ProjectRunSummary(projectDirectories[i].getName(), this.getRunID(), projectDirectories[i]);
            ++i;
        }
    }

    public String getRunID() {
        return this.runDir.getName();
    }

    public ResultStatistics getGlobalResults() {
        ArrayList<ResultStatistics> projectSummaryList = new ArrayList<ResultStatistics>();
        int i = 0;
        while (i < this.projects.length) {
            ResultStatistics rs = this.projects[i].getStatistics();
            if (rs != null) {
                projectSummaryList.add(rs);
            }
            ++i;
        }
        return ResultStatistics.merge(projectSummaryList.toArray(new ResultStatistics[0]));
    }

    public ProjectRunSummaryInterface[] getProjectSummaries() {
        return this.projects;
    }

    public String getRunRootDirectory() {
        return this.runDir.getAbsolutePath();
    }

    public ResultStatistics getGlobalResults(ProjectFilterInterface projectFilter) {
        ArrayList<ResultStatistics> projectSummaryList = new ArrayList<ResultStatistics>();
        int i = 0;
        while (i < this.projects.length) {
            ResultStatistics rs;
            if (projectFilter.acceptProject(this.projects[i].getProjectId()) && (rs = this.projects[i].getStatistics()) != null) {
                projectSummaryList.add(rs);
            }
            ++i;
        }
        return ResultStatistics.merge(projectSummaryList.toArray(new ResultStatistics[0]));
    }
}

