/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.extension;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassLoader
extends ClassLoader {
    private static final String JAR_SUFFIX = ".jar";
    private static final String ZIP_SUFFIX = ".zip";
    private static final String CLASS_SUFFIX = ".class";
    private static final String FILE_URL_PREFIX = "file:";
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_URL_SEPARATOR = "!/";
    private static final char SLASH = '/';
    private static final char DOT = '.';
    private static final int BUFFER_SIZE = 512;
    private List classDirs = new ArrayList();
    private List jarFiles = new ArrayList();
    private Map classes = new HashMap();
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(512);

    public JarClassLoader(ClassLoader parent, File[] libs) throws IOException {
        super(parent);
        int i = 0;
        while (i < libs.length) {
            String fileName;
            if (libs[i].isDirectory()) {
                this.classDirs.add(libs[i]);
            } else if (libs[i].isFile() && ((fileName = libs[i].getName().toLowerCase()).endsWith(JAR_SUFFIX) || fileName.endsWith(ZIP_SUFFIX))) {
                this.jarFiles.add(new ZipFile(libs[i]));
            }
            ++i;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.classes.get(name);
        if (c != null) {
            return c;
        }
        try {
            byte[] f = this.getBytes(name.replace('.', File.separatorChar).concat(CLASS_SUFFIX));
            c = this.defineClass(name, f, 0, f.length);
            this.classes.put(name, c);
        }
        catch (IOException ex) {
            c = super.findClass(name);
        }
        return c;
    }

    private byte[] getBytes(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        byte[] resultBytes = null;
        InputStream is = null;
        File file = null;
        File classDir = null;
        Iterator iter = this.classDirs.iterator();
        while (iter.hasNext()) {
            classDir = (File)iter.next();
            file = new File(classDir, fileName);
            if (!file.isFile()) continue;
            is = new FileInputStream(file);
            resultBytes = this.getEntryBytes(is);
            is.close();
            return resultBytes;
        }
        ZipFile zip = null;
        ZipEntry entry = null;
        Iterator iter2 = this.jarFiles.iterator();
        while (iter2.hasNext()) {
            zip = (ZipFile)iter2.next();
            entry = zip.getEntry(fileName.replace(File.separatorChar, '/'));
            if (entry == null) continue;
            is = zip.getInputStream(entry);
            resultBytes = this.getEntryBytes(is);
            is.close();
            return resultBytes;
        }
        throw new FileNotFoundException(fileName);
    }

    private byte[] getEntryBytes(InputStream in) throws IOException {
        byte[] buffer = new byte[512];
        this.baos.reset();
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            this.baos.write(buffer, 0, length);
        }
        return this.baos.toByteArray();
    }

    protected URL findResource(String name) {
        URL result = super.findResource(name);
        if (result != null) {
            return result;
        }
        try {
            File classDir = null;
            File file = null;
            Iterator iter = this.classDirs.iterator();
            while (iter.hasNext()) {
                classDir = (File)iter.next();
                file = new File(classDir, name);
                if (!file.exists()) continue;
                return new URL(FILE_URL_PREFIX + file.getCanonicalPath());
            }
            ZipFile zip = null;
            ZipEntry entry = null;
            Iterator iter2 = this.jarFiles.iterator();
            while (iter2.hasNext()) {
                zip = (ZipFile)iter2.next();
                entry = zip.getEntry(name.replace(File.separatorChar, '/'));
                if (entry == null) continue;
                return new URL(JAR_URL_PREFIX.concat(zip.getName()).concat(JAR_URL_SEPARATOR).concat(name));
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    protected Enumeration findResources(String name) throws IOException {
        URL url = this.findResource(name);
        if (url != null) {
            return new URLEnumeration(new URL[]{url});
        }
        return new URLEnumeration(new URL[0]);
    }

    private class URLEnumeration
    implements Enumeration {
        private Iterator iterator;

        public URLEnumeration(URL[] urls) {
            if (urls == null) {
                throw new IllegalArgumentException();
            }
            this.iterator = Arrays.asList(urls).iterator();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

