/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jlint.ProcessorInterface;
import com.sap.tc.jtools.jlint.ProcessorUnitFactory;
import com.sap.tc.jtools.jlint.Requirement;
import com.sap.tc.jtools.jlint.RequirementInterface;
import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.TestComponentInterface;
import com.sap.tc.jtools.jlint.TestDefinition;
import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.TestProcessorInterface;
import com.sap.tc.jtools.jlint.TestVariant;
import com.sap.tc.jtools.jlint.exceptions.ExecutionException;
import com.sap.tc.jtools.jlint.exceptions.InvalidDataProviderException;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.cache.CacheEntry;
import com.sap.tc.jtools.jtci.exceptions.CancelJobException;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestSpecificationException;
import com.sap.tc.jtools.jtci.exceptions.PerformException;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.JtciDataInterface;
import com.sap.tc.jtools.jtci.interfaces.Listener;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.cache.CacheDependency;
import com.sap.tc.jtools.util.cache.CacheInterface;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class TestManager {
    public static final String DEFAULT_CONFIG_FILE = "tool_descriptor.xml";
    private static TestDescriptionSet toolDescriptor;
    private TestVariant[] testVariants = new TestVariant[0];
    private DataEntryInterface[] data = new DataEntry[0];
    private ProcessorEntry[] processors = new ProcessorEntry[0];
    private Listener listener = null;
    private CacheInterface cache;

    public TestManager(TestDescriptionSet toolDescriptor, CacheInterface cache) {
        TestManager.toolDescriptor = toolDescriptor;
        this.cache = cache;
    }

    public TestDescriptionSet getTestDescriptionSet() {
        return toolDescriptor;
    }

    public int getVersion() {
        return toolDescriptor.getVersion();
    }

    public TestTree getAllTests() {
        return toolDescriptor.getTestTree();
    }

    public void reset() {
        this.testVariants = new TestVariant[0];
        this.data = new DataEntry[0];
        this.processors = new ProcessorEntry[0];
    }

    public void addTest(String test, ParameterInterface[] parameters, ITestMessageDescription[] messages, TestObject testObject) throws InvalidTestSpecificationException {
        TestVariant testVariant = null;
        TestDescriptionInterface[] tests = this.getAllTests().getAllLeaves();
        boolean done = false;
        int i = 0;
        while (i < tests.length && !done) {
            if (tests[i].getName().equals(test)) {
                try {
                    testVariant = new TestVariant((TestDefinition)tests[i], parameters, messages, testObject);
                }
                catch (Exception e) {
                    throw new InvalidTestSpecificationException(e);
                }
                done = true;
            }
            ++i;
        }
        TestVariant[] tempArray = new TestVariant[this.testVariants.length + 1];
        int i2 = 0;
        while (i2 < this.testVariants.length) {
            tempArray[i2] = this.testVariants[i2];
            ++i2;
        }
        try {
            tempArray[this.testVariants.length] = testVariant;
            TestComponentInterface processorUnit = ProcessorUnitFactory.createTestComponent(testVariant.getTestDefinition());
            processorUnit.setMessages(testVariant.getMessages());
            processorUnit.setParameters(testVariant.getParameters(), testVariant.getTestObject());
            ProcessorInterface newTestProcessor = null;
            RequirementInterface requiredProcessor = processorUnit.getProcessorDefinition();
            if (requiredProcessor == null) {
                newTestProcessor = (ProcessorInterface)((Object)processorUnit);
                this.addProcessor(newTestProcessor, newTestProcessor instanceof TestProcessorInterface);
            } else {
                RequirementInterface processorDefinition = processorUnit.getProcessorDefinition();
                this.addProcessor(processorDefinition).getProcessor().addProcessorUnit(processorUnit, processorUnit.getRole());
            }
        }
        catch (InvalidDataProviderException e) {
            throw new InvalidTestSpecificationException(e);
        }
        this.testVariants = tempArray;
    }

    public void addExternalData(JtciDataInterface[] externalData) {
        Vector<DataEntryInterface> totalData = new Vector<DataEntryInterface>();
        int i = 0;
        while (i < externalData.length) {
            totalData.add(new ExternalDataEntry(externalData[i].getName(), externalData[i].getParameters(), externalData[i].getData()));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.data.length) {
            boolean found = false;
            int j = 0;
            while (j < externalData.length && !found) {
                if (this.data[i2].getName().equals(externalData[j].getName()) && ParameterTool.eq(this.data[i2].getParameters(), externalData[j].getParameters())) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                totalData.add(this.data[i2]);
            }
            ++i2;
        }
        this.data = totalData.toArray(new DataEntryInterface[totalData.size()]);
    }

    public Result[] performTests() throws PerformException {
        Object[] values;
        RequirementInterface[] requirements;
        boolean somethingWasDone = true;
        while (somethingWasDone) {
            somethingWasDone = false;
            int i = 0;
            while (i < this.data.length) {
                if (this.listener != null && this.listener.isCanceled()) {
                    return new Result[0];
                }
                if (this.data[i].getStatus() != 3) {
                    Object cachedEntry;
                    if (this.cache != null && (cachedEntry = this.cache.getEntryValue(this.computeKey(this.data[i]))) != null) {
                        this.data[i] = new CachedDataEntry(this.data[i].getName(), this.data[i].getParameters(), cachedEntry);
                    } else {
                        DataEntry dataEntry = (DataEntry)this.data[i];
                        ProcessorInterface currentProcessor = dataEntry.getProcessor();
                        if (this.readyToStart(currentProcessor)) {
                            requirements = dataEntry.getRequirements();
                            values = new Object[requirements.length];
                            int j = 0;
                            while (j < values.length) {
                                if (!this.isExternalFile(requirements[j])) {
                                    if (this.listener != null && this.listener.isCanceled()) {
                                        return new Result[0];
                                    }
                                    values[j] = this.getDataEntry(requirements[j]).getData();
                                }
                                ++j;
                            }
                            currentProcessor.setPrerequisites(values);
                            try {
                                currentProcessor.execute();
                                dataEntry.setStatus(3);
                                if (this.cache != null) {
                                    ArrayList<CacheDependency> dependencies = new ArrayList<CacheDependency>();
                                    int j2 = 0;
                                    while (j2 < requirements.length) {
                                        boolean isFile = this.isExternalFile(requirements[j2]);
                                        String key = isFile ? requirements[j2].getParameters()[0].valueToString() : this.computeKey(requirements[j2]);
                                        dependencies.add(new CacheDependency(key, isFile));
                                        ++j2;
                                    }
                                    CacheEntry newEntry = new CacheEntry(this.computeKey(this.data[i]), this.data[i].getData(), dependencies.toArray(new CacheDependency[dependencies.size()]), System.currentTimeMillis());
                                    this.cache.addEntry(newEntry);
                                }
                                somethingWasDone = true;
                            }
                            catch (CancelJobException cje) {
                                return new Result[0];
                            }
                            catch (Exception e) {
                                ((DataEntry)this.data[i]).setStatus(4);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        ArrayList<ResultInterface> jobResult = new ArrayList<ResultInterface>();
        int i = 0;
        while (i < this.processors.length) {
            if (this.processors[i].isTest()) {
                TestProcessorInterface processor = (TestProcessorInterface)this.processors[i].getProcessor();
                processor.setListener(this.listener);
                requirements = processor.getRequirements();
                values = new Object[requirements.length];
                boolean missingData = false;
                RequirementInterface missingReqirement = null;
                int j = 0;
                while (j < values.length && !missingData) {
                    if (!requirements[j].getClassName().equals("External file")) {
                        values[j] = this.getDataEntry(requirements[j]).getData();
                    }
                    if (values[j] == null) {
                        missingData = true;
                    }
                    missingReqirement = requirements[j];
                    ++j;
                }
                if (missingData) {
                    TestObject testObject = processor.getTestObject();
                    Properties p = new Properties();
                    p.setProperty("__MSG_KEY", "Missing_data");
                    if (missingReqirement != null) {
                        p.setProperty("REQUIRED_CLASSNAME", missingReqirement.getClassName());
                        p.setProperty("PROCESSOR_NAME", missingReqirement.getProcessor().getName());
                        ParameterInterface[] params = missingReqirement.getParameters();
                        int j3 = 0;
                        while (j3 < params.length) {
                            p.setProperty("PARAMETER_" + j3, params[j3].toString());
                            ++j3;
                        }
                    }
                    jobResult.add(new Result(this.processors[i].getName(), testObject.getType(), testObject.getID(), null, 0, "Missing_data", p));
                } else {
                    processor.setPrerequisites(values);
                    try {
                        processor.execute();
                    }
                    catch (CancelJobException cje) {
                        TestObject testObject = processor.getTestObject();
                        jobResult.add(new Result(this.processors[i].getName(), testObject.getType(), testObject.getID(), null, 0, "job_canceled", null));
                        break;
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        Properties parameters = new Properties();
                        parameters.setProperty("EXCEPTION", sw.toString());
                        parameters.setProperty("__MSG_KEY", "Couldnt_perform");
                        TestObject testObject = processor.getTestObject();
                        jobResult.add(new Result(this.processors[i].getName(), testObject.getType(), testObject.getID(), null, 0, "Couldnt_perform", parameters));
                    }
                    ResultInterface[] results = processor.getErrors();
                    int k = 0;
                    while (k < results.length) {
                        jobResult.add(results[k]);
                        ++k;
                    }
                }
            }
            ++i;
        }
        this.testVariants = new TestVariant[0];
        return jobResult.toArray(new Result[jobResult.size()]);
    }

    private String computeKey(RequirementInterface data) {
        String key = data.getClassName() + "@";
        ParameterInterface[] params = data.getParameters();
        int i = 0;
        while (i < params.length) {
            key = key + params[i].valueToString().hashCode() + ";";
            ++i;
        }
        return key;
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    private boolean readyToStart(Requirement req) {
        DataEntryInterface dataEntry = this.getDataEntry(req);
        if (dataEntry == null || dataEntry.getStatus() != 0) {
            return false;
        }
        RequirementInterface[] reqs = ((DataEntry)dataEntry).getRequirements();
        int i = 0;
        while (i < reqs.length) {
            if (!reqs[i].getClassName().equals("External file") && !this.getDataEntry(reqs[i]).isCompleted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean readyToStart(String name, ParameterInterface[] parameters) {
        DataEntryInterface dataEntry = this.getDataEntry(name, parameters);
        if (dataEntry == null || dataEntry.getStatus() != 0) {
            return false;
        }
        RequirementInterface[] reqs = ((DataEntry)dataEntry).getRequirements();
        int i = 0;
        while (i < reqs.length) {
            if (!reqs[i].getClassName().equals("External file") && !this.getDataEntry(reqs[i]).isCompleted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean readyToStart(ProcessorInterface processor) {
        RequirementInterface[] reqs = processor.getRequirements();
        int i = 0;
        while (i < reqs.length) {
            if (!reqs[i].getClassName().equals("External file") && !this.getDataEntry(reqs[i]).isCompleted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private DataEntryInterface getDataEntry(RequirementInterface req) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i].getName().equals(req.getClassName()) && ParameterTool.eq(this.data[i].getParameters(), req.getParameters())) {
                return this.data[i];
            }
            ++i;
        }
        return null;
    }

    private DataEntryInterface getDataEntry(String name, ParameterInterface[] parameters) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i].getName().equals(name) && ParameterTool.eq(parameters, this.data[i].getParameters())) {
                return this.data[i];
            }
            ++i;
        }
        return null;
    }

    private ProcessorEntry getTestProcessor(RequirementInterface processor) {
        int i = 0;
        while (i < this.processors.length) {
            if (processor.getClassName().equals(this.processors[i].getName()) && ParameterTool.eq(processor.getParameters(), this.processors[i].getProcessor().getParameters())) {
                return this.processors[i];
            }
            ++i;
        }
        return null;
    }

    private ProcessorEntry addProcessor(ProcessorInterface newProcessor, boolean isTest) throws InvalidDataProviderException {
        int i = 0;
        while (i < this.processors.length) {
            if (newProcessor.getName().equals(this.processors[i].getName()) && newProcessor.getParameters().length == this.processors[i].getProcessor().getParameters().length) {
                boolean sameParameters = true;
                int j = 0;
                while (j < newProcessor.getParameters().length && sameParameters) {
                    ParameterInterface par1 = newProcessor.getParameters()[j];
                    ParameterInterface par2 = this.processors[i].getProcessor().getParameters()[j];
                    if (!par1.getName().equals(par2.getName()) || !par1.getValue().equals(par2.getValue())) {
                        sameParameters = false;
                    }
                    ++j;
                }
                if (sameParameters) {
                    if (isTest) {
                        this.processors[i].setIsTest(true);
                    }
                    return this.processors[i];
                }
            }
            ++i;
        }
        ProcessorEntry newEntry = new ProcessorEntry(newProcessor);
        if (isTest) {
            newEntry.setIsTest(true);
        }
        ProcessorEntry[] tempArray = new ProcessorEntry[this.processors.length + 1];
        int i2 = 0;
        while (i2 < this.processors.length) {
            tempArray[i2] = this.processors[i2];
            ++i2;
        }
        tempArray[this.processors.length] = newEntry;
        this.processors = tempArray;
        RequirementInterface[] reqs = newEntry.getProcessor().getRequirements();
        int j = 0;
        while (j < reqs.length) {
            if (!reqs[j].getClassName().equals("External file")) {
                try {
                    this.addData(reqs[j]);
                }
                catch (Exception e) {
                    throw new InvalidDataProviderException(e);
                }
            }
            ++j;
        }
        return newEntry;
    }

    private ProcessorEntry addProcessor(RequirementInterface processorDefinition) throws InvalidDataProviderException {
        int i = 0;
        while (i < this.processors.length) {
            if (processorDefinition.getClassName().equals(this.processors[i].getName()) && processorDefinition.getParameters().length == this.processors[i].getProcessor().getParameters().length) {
                boolean sameParameters = true;
                int j = 0;
                while (j < processorDefinition.getParameters().length && sameParameters) {
                    ParameterInterface par1 = processorDefinition.getParameters()[j];
                    ParameterInterface par2 = this.processors[i].getProcessor().getParameters()[j];
                    if (!par1.getName().equals(par2.getName()) || !par1.getValue().equals(par2.getValue())) {
                        sameParameters = false;
                    }
                    ++j;
                }
                if (sameParameters) {
                    return this.processors[i];
                }
            }
            ++i;
        }
        ProcessorEntry newEntry = new ProcessorEntry(processorDefinition.getProcessor());
        if (processorDefinition.getProcessor() instanceof TestProcessorInterface) {
            newEntry.setIsTest(true);
        }
        ProcessorEntry[] tempArray = new ProcessorEntry[this.processors.length + 1];
        int i2 = 0;
        while (i2 < this.processors.length) {
            tempArray[i2] = this.processors[i2];
            ++i2;
        }
        tempArray[this.processors.length] = newEntry;
        this.processors = tempArray;
        RequirementInterface[] reqs = newEntry.getProcessor().getRequirements();
        int j = 0;
        while (j < reqs.length) {
            if (!reqs[j].getClassName().equals("External file")) {
                try {
                    this.addData(reqs[j]);
                }
                catch (Exception e) {
                    throw new InvalidDataProviderException(e);
                }
            }
            ++j;
        }
        return newEntry;
    }

    private void addData(RequirementInterface newData) throws InvalidDataProviderException {
        int i = 0;
        while (i < this.data.length) {
            if (newData.getClassName().equals(this.data[i].getName()) && ParameterTool.eq(this.data[i].getParameters(), newData.getParameters())) {
                return;
            }
            ++i;
        }
        DataEntryInterface[] tempArray = new DataEntryInterface[this.data.length + 1];
        int i2 = 0;
        while (i2 < this.data.length) {
            tempArray[i2] = this.data[i2];
            ++i2;
        }
        try {
            this.data = tempArray;
            DataEntry newEntry = new DataEntry(newData);
            this.data[this.data.length - 1] = newEntry;
            ProcessorInterface nextProcessor = newEntry.getProcessor();
            if (nextProcessor != null) {
                this.addProcessor(nextProcessor, false);
            }
            return;
        }
        catch (Exception e) {
            throw new InvalidDataProviderException(e);
        }
    }

    private String computeKey(DataEntryInterface data) {
        String key = data.getName() + "@";
        ParameterInterface[] params = data.getParameters();
        int i = 0;
        while (i < params.length) {
            key = key + params[i].valueToString().hashCode() + ";";
            ++i;
        }
        return key;
    }

    private boolean isExternalFile(RequirementInterface req) {
        return req.getClassName().equals("External file");
    }

    private class ProcessorEntry {
        private ProcessorInterface processor;
        private boolean isTestProcessor = false;

        public ProcessorEntry(ProcessorInterface processor) {
            this.processor = processor;
        }

        public ProcessorInterface getProcessor() {
            return this.processor;
        }

        public String getName() {
            return this.processor.getName();
        }

        public void execute() throws ExecutionException {
            this.processor.execute();
        }

        public void setIsTest(boolean isTest) {
            this.isTestProcessor = isTest;
        }

        public boolean isTest() {
            return this.isTestProcessor;
        }
    }

    private class DataEntry
    implements DataEntryInterface {
        private RequirementInterface data;
        private int status = 0;

        public DataEntry(RequirementInterface req) {
            this.data = req;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public ProcessorInterface getProcessor() {
            return this.data.getProcessor();
        }

        public boolean isCompleted() {
            return this.status == 3;
        }

        public RequirementInterface[] getRequirements() {
            RequirementInterface[] reqs = this.data.getProcessor().getRequirements();
            if (reqs.length == 0) {
                return new Requirement[0];
            }
            return reqs;
        }

        public ResultInterface[] getResults() {
            if (this.status == 3) {
                return (ResultInterface[])this.data.getProcessor().getData();
            }
            return null;
        }

        public String getName() {
            return this.data.getClassName();
        }

        public ParameterInterface[] getParameters() {
            return this.data.getParameters();
        }

        public Object getData() {
            return this.data.getProcessor().getData();
        }
    }

    private class CachedDataEntry
    implements DataEntryInterface {
        private String name;
        private ParameterInterface[] parameters;
        private Object value;

        public CachedDataEntry(String name, ParameterInterface[] parameters, Object value) {
            this.name = name;
            this.parameters = parameters;
            this.value = value;
        }

        public int getStatus() {
            return 3;
        }

        public String getName() {
            return this.name;
        }

        public ParameterInterface[] getParameters() {
            return this.parameters;
        }

        public boolean isCompleted() {
            return true;
        }

        public Object getData() {
            return this.value;
        }
    }

    private class ExternalDataEntry
    implements DataEntryInterface {
        private String name;
        private ParameterInterface[] parameters;
        private Object value;

        public ExternalDataEntry(String name, ParameterInterface[] parameters, Object value) {
            this.name = name;
            this.parameters = parameters;
            this.value = value;
        }

        public int getStatus() {
            return 3;
        }

        public String getName() {
            return this.name;
        }

        public ParameterInterface[] getParameters() {
            return this.parameters;
        }

        public boolean isCompleted() {
            return true;
        }

        public Object getData() {
            return this.value;
        }
    }

    private static interface DataEntryInterface
    extends JtciDataInterface {
        public static final int INITIAL = 0;
        public static final int READY = 1;
        public static final int STARTED = 2;
        public static final int COMPLETED = 3;
        public static final int PROBLEM = 4;

        public int getStatus();

        public boolean isCompleted();
    }
}

