/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.binary.BinaryXmlWriter;
import com.sap.engine.lib.xml.parser.binary.exceptions.XmlBinaryException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import java.io.IOException;
import java.io.OutputStream;

public class XMLBinaryWriter
implements XMLTokenWriter {
    protected BinaryXmlWriter writer;

    public XMLBinaryWriter() {
        this.writer = null;
    }

    public XMLBinaryWriter(OutputStream output) {
        this.writer = new BinaryXmlWriter(output);
        this.writer.init();
    }

    public void init(OutputStream output) {
        if (this.writer == null) {
            this.writer = new BinaryXmlWriter(output);
            this.writer.init();
        } else {
            this.writer.reuse(output);
        }
    }

    public void init(OutputStream output, String encoding) throws Exception {
        this.init(output);
        if (!encoding.toLowerCase().equals("utf-8")) {
            throw new Exception("Not supported encoding! Binary writer supports only UTF-8 for now.");
        }
    }

    public void writeInitial() throws IOException {
    }

    public void enter(String namespace, String localName) throws IOException {
        try {
            this.writer.writeStartElement(localName, namespace);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void leave() throws IOException, IllegalStateException {
        try {
            this.writer.writeEndElement();
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        return this.writer.lookupNamespace(namespace);
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        this.writer.addNamespaceMapping(prefix, namespace);
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        try {
            this.writer.writeAttribute(name, namespace, value);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void writeContent(String content) throws IOException {
        try {
            this.writer.writeString(content);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void writeContentCData(char[] chars) throws IOException {
        this.writeContentCData(chars, 0, chars.length);
    }

    public void writeContentCData(char[] chars, int offset, int count) throws IOException {
        try {
            this.writer.writeString(chars, offset, count);
        }
        catch (XmlBinaryException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void writeContentCDataDirect(char[] chars) throws IOException {
        this.writeContentCDataDirect(chars, 0, chars.length);
    }

    public void writeContentCDataDirect(char[] chars, int offset, int count) throws IOException {
        try {
            this.writer.writeString(chars, offset, count);
        }
        catch (XmlBinaryException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void writeComment(String comment) throws IOException {
        try {
            this.writer.writeComment(comment);
        }
        catch (XmlBinaryException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
        try {
            this.writer.writeAttribute(name, value);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

