/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import com.sap.engine.lib.schema.util.Duration;
import com.sap.engine.lib.schema.util.LexicalCharsTokenizer;
import com.sap.engine.lib.schema.util.LexicalTokenizer;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class LexicalParser {
    public static String parseURIReference(String value) {
        if (value == null) {
            return null;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, new String[]{"//"});
        if (!LexicalParser.parseURIReference(tokenizer) || tokenizer.peek() != null) {
            return null;
        }
        return value;
    }

    public static GregorianCalendar parseDateTimeZone(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"-", "Z", "z", "+", "-"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseDateTimeZone(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static GregorianCalendar parseDateTime(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"-", "T", "t", "+", "-", ":", "Z", "z"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseDateTime(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static Duration parseDuration(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"-", "P", "T", "Y", "M", "D", "H", "M", "S", "p", "t", "y", "m", "d", "h", "m", "s"});
        Duration duration = new Duration();
        if (!LexicalParser.parseDuration(tokenizer, duration) || tokenizer.peek() != null) {
            return null;
        }
        return duration;
    }

    public static GregorianCalendar parseDayTimeZone(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"-", "Z", "z", "-", "+"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseDayTimeZone(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static GregorianCalendar parseMonthTimeZone(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"-", "Z", "z", "-", "+"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseMonthTimeZone(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static GregorianCalendar parseMonthDayTimeZone(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"-", "Z", "z", "+", "-"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseMonthDayTimeZone(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static GregorianCalendar parseYearTimeZone(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"Z", "z", "+", "-"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseYearTimeZone(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static GregorianCalendar parseYearMonthTimeZone(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{"-", "Z", "z", "+", "-"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseYearMonthTimeZone(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static GregorianCalendar parseTime(String value) {
        if (value == null) {
            return null;
        }
        LexicalTokenizer tokenizer = new LexicalTokenizer(value, new String[]{":", "Z", "z", "+", "-"});
        GregorianCalendar calendar = LexicalParser.createEmptyCalendar();
        if (!LexicalParser.parseTime(tokenizer, calendar) || tokenizer.peek() != null) {
            return null;
        }
        return calendar;
    }

    public static byte[] parseBase64Binary(String value) {
        if (value == null) {
            return null;
        }
        return BASE64Decoder.decode(value.getBytes());
    }

    public static Boolean parseBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.toLowerCase().equals("true") || value.equals("1")) {
            return new Boolean("true");
        }
        if (value.toLowerCase().equals("false") || value.equals("0")) {
            return new Boolean("false");
        }
        return null;
    }

    public static BigDecimal parseDecimal(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException numberFormExc) {
            return null;
        }
    }

    public static BigDecimal parseDouble(String value) {
        if (value == null) {
            return null;
        }
        try {
            Double doubleValue = new Double(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseFloat(String value) {
        if (value == null) {
            return null;
        }
        try {
            Float doubleValue = new Float(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static String parseQName(String value) {
        if (value == null) {
            return null;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, null);
        if (!LexicalParser.parseQName(tokenizer) || tokenizer.peek() != null) {
            return null;
        }
        return value;
    }

    public static String parseNormalizedString(String value) {
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == '\n' || ch == '\t' || ch == '\r') {
                return null;
            }
            ++i;
        }
        return value;
    }

    public static BigDecimal parseInteger(String value) {
        if (value == null) {
            return null;
        }
        try {
            new BigInteger(value);
        }
        catch (NumberFormatException numberFormExc) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static String parseToken(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("")) {
            return value;
        }
        if (value.charAt(0) == ' ') {
            return null;
        }
        if (value.length() > 1 && value.charAt(value.length() - 1) == ' ') {
            return null;
        }
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == ' ' ? i - 1 >= 0 && value.charAt(i - 1) == ' ' : ch == '\t' || ch == '\n') {
                return null;
            }
            ++i;
        }
        return value;
    }

    public static BigDecimal parseNonPositiveInteger(String value) {
        if (LexicalParser.parseLimitedInt_UpperLimit(value, "0") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseNonNegativeInteger(String value) {
        if (LexicalParser.parseLimitedInt_LowerLimit(value, "0") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseLong(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "-9223372036854775808", "9223372036854775807") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static String parseLanguage(String value) {
        if (value == null) {
            return null;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, null);
        if (!LexicalParser.parseLanguage(tokenizer) && tokenizer.peek() != null) {
            return null;
        }
        return value;
    }

    public static String parseName(String value) {
        if (value == null) {
            return null;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, null);
        if (!LexicalParser.parseName(tokenizer) && tokenizer.peek() != null) {
            return null;
        }
        return value;
    }

    public static String parseNmtoken(String value) {
        if (value == null) {
            return null;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, null);
        if (!LexicalParser.parseNmtoken(tokenizer) && tokenizer.peek() != null) {
            return null;
        }
        return value;
    }

    public static BigDecimal parseNegativeInteger(String value) {
        if (LexicalParser.parseLimitedInt_UpperLimit(value, "-1") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseInt(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "-2147483648", "2147483647") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseUnsignedLong(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "0", "18446744073709551615") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parsePositiveInteger(String value) {
        if (LexicalParser.parseLimitedInt_LowerLimit(value, "1") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static String parseNCName(String value) {
        if (value == null) {
            return null;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, null);
        if (!LexicalParser.parseNCName(tokenizer) || tokenizer.peek() != null) {
            return null;
        }
        return value;
    }

    public static BigDecimal parseShort(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "-32768", "32767") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseUnsignedInt(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "0", "4294967295") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseByte(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "-128", "127") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseUnsignedShort(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "0", "65535") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal parseUnsignedByte(String value) {
        if (LexicalParser.parseLimitedInt_LowerAndUpperLimit(value, "0", "255") == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static byte[] parseHexBinary(String value) {
        byte[] result = null;
        if (value != null) {
            if (value.length() == 0) {
                result = new byte[]{};
            }
            int size = value.length() / 2;
            result = new byte[size];
            int pos = 0;
            int i = 0;
            while (i < size) {
                char highbit = value.charAt(pos);
                char lowbit = value.charAt(pos + 1);
                byte highbits = 0;
                byte lowbits = 0;
                if (highbit >= '0' && highbit <= '9') {
                    highbits = (byte)(9 - (57 - highbit));
                }
                if (highbit >= 'a' && highbit <= 'f') {
                    highbits = (byte)(15 - (102 - highbit));
                }
                if (highbit >= 'A' && highbit <= 'F') {
                    highbits = (byte)(15 - (70 - highbit));
                }
                if (lowbit >= '0' && lowbit <= '9') {
                    lowbits = (byte)(9 - (57 - lowbit));
                }
                if (lowbit >= 'a' && lowbit <= 'f') {
                    lowbits = (byte)(15 - (102 - lowbit));
                }
                if (lowbit >= 'A' && lowbit <= 'F') {
                    lowbits = (byte)(15 - (70 - lowbit));
                }
                result[i] = (byte)(highbits << 4 | lowbits);
                pos += 2;
                ++i;
            }
        }
        return result;
    }

    public static boolean parseXPathSelector(String value) {
        if (value == null) {
            return false;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, new String[]{".//", "/", ".", "*", ":", "|"});
        return LexicalParser.parseXPathSelector(tokenizer) && tokenizer.peek() == null;
    }

    public static boolean parseXPathField(String value) {
        if (value == null) {
            return false;
        }
        LexicalCharsTokenizer tokenizer = new LexicalCharsTokenizer(value, new String[]{".//", "/", "@"});
        return LexicalParser.parseXPathField(tokenizer) && tokenizer.peek() == null;
    }

    private static boolean parseXPathField(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        String token = tokenizer.next();
        if (token == null || !token.equals(".//")) {
            tokenizer.setIndex(index);
        }
        while (tokenizer.peek() != null) {
            index = tokenizer.getIndex();
            boolean result = LexicalParser.parseXPathStep(tokenizer);
            if (result) {
                token = tokenizer.next();
                boolean bl = result = token != null && token.equals("/");
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        index = tokenizer.getIndex();
        if (!LexicalParser.parseXPathStep(tokenizer)) {
            tokenizer.setIndex(index);
            token = tokenizer.next();
            if (token == null || !token.equals("@")) {
                return false;
            }
            if (!LexicalParser.parseXPathNameTest(tokenizer)) {
                return false;
            }
        }
        return true;
    }

    private static boolean parseXPathSelector(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseXPathSelectorPath(tokenizer)) {
            return false;
        }
        while (tokenizer.peek() != null) {
            boolean result;
            int index = tokenizer.getIndex();
            String token = tokenizer.next();
            boolean bl = result = token != null && token.equals("|");
            if (result) {
                result = LexicalParser.parseXPathSelectorPath(tokenizer);
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseXPathSelectorPath(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        String token = tokenizer.next();
        if (token == null || !token.equals(".//")) {
            tokenizer.setIndex(index);
        }
        if (!LexicalParser.parseXPathStep(tokenizer)) {
            return false;
        }
        while (tokenizer.peek() != null) {
            boolean result;
            index = tokenizer.getIndex();
            token = tokenizer.next();
            boolean bl = result = token != null && token.equals("/");
            if (result) {
                result = LexicalParser.parseXPathStep(tokenizer);
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseXPathStep(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        String token = tokenizer.next();
        if (token != null && token.equals(".")) {
            return true;
        }
        tokenizer.setIndex(index);
        return LexicalParser.parseXPathNameTest(tokenizer);
    }

    private static boolean parseXPathNameTest(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseQName(tokenizer)) {
            tokenizer.setIndex(index);
            String token = tokenizer.next();
            if (token == null) {
                return false;
            }
            if (!token.equals("*")) {
                tokenizer.setIndex(index);
                if (!LexicalParser.parseNCName(tokenizer)) {
                    return false;
                }
                token = tokenizer.next();
                if (token == null || !token.equals(":")) {
                    return false;
                }
                token = tokenizer.next();
                if (token == null || !token.equals("*")) {
                    return false;
                }
            }
        }
        return true;
    }

    private static BigInteger parseLimitedInt_LowerAndUpperLimit(String value, String lowerLimit, String upperLimit) {
        BigInteger result = null;
        try {
            result = new BigInteger(value);
        }
        catch (NumberFormatException numberFormExc) {
            return null;
        }
        if (result.compareTo(new BigInteger(lowerLimit)) < 0 || result.compareTo(new BigInteger(upperLimit)) > 0) {
            return null;
        }
        return result;
    }

    private static BigInteger parseLimitedInt_UpperLimit(String value, String upperLimit) {
        BigInteger result = null;
        try {
            result = new BigInteger(value);
        }
        catch (NumberFormatException numberFormExc) {
            return null;
        }
        if (result.compareTo(new BigInteger(upperLimit)) > 0) {
            return null;
        }
        return result;
    }

    private static BigInteger parseLimitedInt_LowerLimit(String value, String lowerLimit) {
        BigInteger result = null;
        try {
            result = new BigInteger(value);
        }
        catch (NumberFormatException numberFormExc) {
            return null;
        }
        if (result.compareTo(new BigInteger(lowerLimit)) < 0) {
            return null;
        }
        return result;
    }

    private static BigDecimal parseLimitedDecimal(String value, String lowerLimit, String upperLimit) {
        BigDecimal result = LexicalParser.parseDecimal(value);
        if (result == null) {
            return null;
        }
        if (result.compareTo(new BigDecimal(lowerLimit)) <= 0 || result.compareTo(new BigDecimal(upperLimit)) >= 0) {
            return null;
        }
        return result;
    }

    private static boolean parseYearMonthTimeZone(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (!LexicalParser.parseYearMonth(tokenizer, calendar)) {
            return false;
        }
        return LexicalParser.parseTimeZone(tokenizer, calendar) && tokenizer.peek() == null;
    }

    private static boolean parseYearTimeZone(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (!LexicalParser.parseYear(tokenizer, calendar)) {
            return false;
        }
        return LexicalParser.parseTimeZone(tokenizer, calendar) && tokenizer.peek() == null;
    }

    private static boolean parseMonthDayTimeZone(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        String token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        if (!LexicalParser.parseMonth(tokenizer, calendar)) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        if (!LexicalParser.parseDay(tokenizer, calendar)) {
            return false;
        }
        return LexicalParser.parseTimeZone(tokenizer, calendar) && tokenizer.peek() == null;
    }

    private static boolean parseMonthTimeZone(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        String token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        if (!LexicalParser.parseMonth(tokenizer, calendar)) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        return LexicalParser.parseTimeZone(tokenizer, calendar) && tokenizer.peek() == null;
    }

    private static boolean parseDayTimeZone(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        String token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        if (!LexicalParser.parseDay(tokenizer, calendar)) {
            return false;
        }
        return LexicalParser.parseTimeZone(tokenizer, calendar) && tokenizer.peek() == null;
    }

    private static boolean parseDateTime(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (!LexicalParser.parseDate(tokenizer, calendar)) {
            return false;
        }
        String token = tokenizer.next();
        if (token == null || !token.toLowerCase().equals("t")) {
            return false;
        }
        return LexicalParser.parseTime(tokenizer, calendar) && tokenizer.peek() == null;
    }

    private static boolean parseDateTimeZone(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (!LexicalParser.parseDate(tokenizer, calendar)) {
            return false;
        }
        return LexicalParser.parseTimeZone(tokenizer, calendar) && tokenizer.peek() == null;
    }

    private static int parseNumber(LexicalTokenizer tokenizer, int filedLength) {
        String token = tokenizer.next();
        if (token == null) {
            return -1;
        }
        if (token.length() != filedLength) {
            return -1;
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException numberFormExc) {
            return -1;
        }
    }

    private static boolean parseYear(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        String token = tokenizer.next();
        if (token == null) {
            return false;
        }
        if (token.length() < 4) {
            return false;
        }
        if (token.equals("0000")) {
            return false;
        }
        try {
            int year = Integer.parseInt(token);
            calendar.set(1, year);
        }
        catch (NumberFormatException numberFormExc) {
            return false;
        }
        return true;
    }

    private static boolean parseMonth(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        int month = LexicalParser.parseNumber(tokenizer, 2);
        if (month == -1 || month == 0 || month > 12) {
            return false;
        }
        calendar.set(2, month);
        return true;
    }

    private static boolean parseDay(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        int day = LexicalParser.parseNumber(tokenizer, 2);
        if (day == -1 || day == 0 || day > 31) {
            return false;
        }
        calendar.set(5, day);
        return true;
    }

    private static boolean parseHour(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        int hour = LexicalParser.parseNumber(tokenizer, 2);
        if (hour == -1 || hour > 24) {
            return false;
        }
        calendar.set(11, hour);
        return true;
    }

    private static boolean parseMinute(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        int minute = LexicalParser.parseNumber(tokenizer, 2);
        if (minute == -1 || minute > 59) {
            return false;
        }
        calendar.set(12, minute);
        return true;
    }

    private static boolean parseSeconds(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        int second = LexicalParser.parseNumber(tokenizer, 2);
        if (second == -1 || second > 59) {
            return false;
        }
        calendar.set(13, second);
        return true;
    }

    private static boolean parseTimeZone(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            String token = tokenizer.next();
            if (token.toLowerCase().equals("z")) {
                ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            } else {
                tokenizer.setIndex(index);
                String sign = tokenizer.next();
                if (sign == null) {
                    return false;
                }
                if (!sign.equals("-") && !sign.equals("+")) {
                    return false;
                }
                int hour = LexicalParser.parseNumber(tokenizer, 2);
                if (hour == -1) {
                    return false;
                }
                token = tokenizer.next();
                if (token == null || !token.equals(":")) {
                    return false;
                }
                int minute = LexicalParser.parseNumber(tokenizer, 2);
                ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("GMT" + sign + hour + ":" + minute));
                return true;
            }
        }
        return true;
    }

    private static boolean parseYearMonth(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (!LexicalParser.parseYear(tokenizer, calendar)) {
            return false;
        }
        String token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        return LexicalParser.parseMonth(tokenizer, calendar);
    }

    private static boolean parseDate(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (!LexicalParser.parseYearMonth(tokenizer, calendar)) {
            return false;
        }
        String token = tokenizer.next();
        if (token == null || !token.equals("-")) {
            return false;
        }
        return LexicalParser.parseDay(tokenizer, calendar);
    }

    private static boolean parseTime(LexicalTokenizer tokenizer, GregorianCalendar calendar) {
        if (!LexicalParser.parseHour(tokenizer, calendar)) {
            return false;
        }
        String token = tokenizer.next();
        if (token == null || !token.equals(":")) {
            return false;
        }
        if (!LexicalParser.parseMinute(tokenizer, calendar)) {
            return false;
        }
        token = tokenizer.next();
        if (token == null || !token.equals(":")) {
            return false;
        }
        if (!LexicalParser.parseSeconds(tokenizer, calendar)) {
            return false;
        }
        return LexicalParser.parseTimeZone(tokenizer, calendar);
    }

    private static boolean parseURIReference(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseAbsoluteURI(tokenizer);
        if (!result) {
            tokenizer.setIndex(index);
            result = LexicalParser.parseRelativeURI(tokenizer);
        }
        if (!result) {
            tokenizer.setIndex(index);
        }
        index = tokenizer.getIndex();
        String token = tokenizer.next();
        boolean bl = result = token != null && token.equals("#");
        if (result) {
            result = LexicalParser.parseFragment(tokenizer);
        }
        if (!result) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseAbsoluteURI(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseSchema(tokenizer)) {
            return false;
        }
        String token = tokenizer.next();
        if (token == null || !token.equals(":")) {
            return false;
        }
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseHierPart(tokenizer);
        if (!result) {
            tokenizer.setIndex(index);
            return LexicalParser.parseOpaquePart(tokenizer);
        }
        return true;
    }

    private static boolean parseRelativeURI(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseNetPath(tokenizer);
        if (!result) {
            tokenizer.setIndex(index);
            result = LexicalParser.parseAbsPath(tokenizer);
            if (!result) {
                tokenizer.setIndex(index);
                if (!LexicalParser.parseRelPath(tokenizer)) {
                    return false;
                }
            }
        }
        index = tokenizer.getIndex();
        String token = tokenizer.next();
        boolean bl = result = token != null && token.equals("?");
        if (result) {
            result = LexicalParser.parseQuery(tokenizer);
        }
        if (!result) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseHierPart(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseNetPath(tokenizer);
        if (!result) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseAbsPath(tokenizer)) {
                return false;
            }
        }
        index = tokenizer.getIndex();
        String token = tokenizer.next();
        boolean bl = result = token != null && token.equals("?");
        if (result) {
            result = LexicalParser.parseQuery(tokenizer);
        }
        if (!result) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseOpaquePart(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseURIcNoSlash(tokenizer)) {
            return false;
        }
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            if (LexicalParser.parseURIC(tokenizer)) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseURIcNoSlash(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseUnreserved(tokenizer);
        if (!result) {
            tokenizer.setIndex(index);
            result = LexicalParser.parseEscaped(tokenizer);
            if (!result) {
                tokenizer.setIndex(index);
                String token = tokenizer.next();
                if (!(token != null && (token.equals(";") || token.equals("?") || token.equals(":") || token.equals("@") || token.equals("&") || token.equals("=") || token.equals("+") || token.equals("$") || token.equals(",")))) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean parseNetPath(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null || !token.equals("//")) {
            return false;
        }
        if (!LexicalParser.parseAuthority(tokenizer)) {
            return false;
        }
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseAbsPath(tokenizer)) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseAbsPath(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null || !token.equals("/")) {
            return false;
        }
        return LexicalParser.parsePathSegments(tokenizer);
    }

    private static boolean parseRelPath(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseRelSegment(tokenizer)) {
            return false;
        }
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseAbsPath(tokenizer)) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseRelSegment(LexicalCharsTokenizer tokenizer) {
        boolean result = false;
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            boolean parseResult = LexicalParser.parseUnreserved(tokenizer);
            if (!parseResult) {
                tokenizer.setIndex(index);
                parseResult = LexicalParser.parseEscaped(tokenizer);
                if (!parseResult) {
                    tokenizer.setIndex(index);
                    String token = tokenizer.next();
                    boolean bl = parseResult = token != null && (token.equals(";") || token.equals("@") || token.equals("&") || token.equals("=") || token.equals("+") || token.equals("$") || token.equals(","));
                }
            }
            if (parseResult) {
                result = true;
                continue;
            }
            tokenizer.setIndex(index);
            break;
        }
        return result;
    }

    private static boolean parseSchema(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseAlpha(tokenizer)) {
            return false;
        }
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            boolean result = LexicalParser.parseAlpha(tokenizer);
            if (!result) {
                tokenizer.setIndex(index);
                result = LexicalParser.parseDigit(tokenizer);
                if (!result) {
                    tokenizer.setIndex(index);
                    String token = tokenizer.next();
                    boolean bl = result = token != null && (token.equals("+") || token.equals("-") || token.equals("."));
                }
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseAuthority(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseServer(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseRegName(tokenizer)) {
                return false;
            }
        }
        return true;
    }

    private static boolean parseRegName(LexicalCharsTokenizer tokenizer) {
        boolean result = false;
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            boolean parseResult = LexicalParser.parseUnreserved(tokenizer);
            if (!parseResult) {
                tokenizer.setIndex(index);
                parseResult = LexicalParser.parseEscaped(tokenizer);
                if (!parseResult) {
                    tokenizer.setIndex(index);
                    String token = tokenizer.next();
                    boolean bl = parseResult = token != null && (token.equals("$") || token.equals(",") || token.equals(";") || token.equals(":") || token.equals("@") || token.equals("&") || token.equals("=") || token.equals("+"));
                }
            }
            if (parseResult) {
                result = true;
                continue;
            }
            tokenizer.setIndex(index);
            break;
        }
        return result;
    }

    private static boolean parseServer(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseUserInfo(tokenizer);
        if (result) {
            String token = tokenizer.next();
            boolean bl = result = token != null && token.equals("@");
        }
        if (!result) {
            tokenizer.setIndex(index);
        }
        index = tokenizer.getIndex();
        if (!LexicalParser.parseHostPort(tokenizer)) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseUserInfo(LexicalCharsTokenizer tokenizer) {
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            boolean parseResult = LexicalParser.parseUnreserved(tokenizer);
            if (!parseResult) {
                tokenizer.setIndex(index);
                parseResult = LexicalParser.parseEscaped(tokenizer);
                if (!parseResult) {
                    tokenizer.setIndex(index);
                    String token = tokenizer.next();
                    boolean bl = parseResult = token != null && (token.equals(";") || token.equals(":") || token.equals("&") || token.equals("=") || token.equals("+") || token.equals("$") || token.equals(","));
                }
            }
            if (parseResult) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseHostPort(LexicalCharsTokenizer tokenizer) {
        boolean result;
        if (!LexicalParser.parseHost(tokenizer)) {
            return false;
        }
        int index = tokenizer.getIndex();
        String token = tokenizer.next();
        boolean bl = result = token != null && token.equals(":");
        if (result) {
            result = LexicalParser.parsePort(tokenizer);
        }
        if (!result) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseHost(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseHostName(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseIPv4Address(tokenizer)) {
                tokenizer.setIndex(index);
                if (!LexicalParser.parseIPv6Reference(tokenizer)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean parseHostName(LexicalCharsTokenizer tokenizer) {
        int index;
        while (tokenizer.peek() != null) {
            index = tokenizer.getIndex();
            boolean result = LexicalParser.parseDomainLabel(tokenizer);
            if (result) {
                String token = tokenizer.next();
                boolean bl = result = token != null && token.equals(".");
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        if (!LexicalParser.parseTopLabel(tokenizer)) {
            return false;
        }
        index = tokenizer.getIndex();
        String token = tokenizer.next();
        if (token == null || !token.equals(".")) {
            tokenizer.setIndex(index);
        }
        return true;
    }

    private static boolean parseDomainLabel(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseAlphaNum(tokenizer)) {
            return false;
        }
        boolean result = false;
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            result = LexicalParser.parseAlphaNum(tokenizer);
            if (!result) {
                tokenizer.setIndex(index);
                String token = tokenizer.next();
                boolean bl = result = token != null && token.equals("-");
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseTopLabel(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseAlpha(tokenizer)) {
            return false;
        }
        boolean result = false;
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            result = LexicalParser.parseAlphaNum(tokenizer);
            if (!result) {
                tokenizer.setIndex(index);
                String token = tokenizer.next();
                boolean bl = result = token != null && token.equals("-");
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseIPv4Address(LexicalCharsTokenizer tokenizer) {
        int i = 0;
        while (i < 4) {
            String token;
            boolean hasDigit = false;
            while (tokenizer.peek() != null) {
                int index = tokenizer.getIndex();
                if (LexicalParser.parseDigit(tokenizer)) {
                    hasDigit = true;
                    continue;
                }
                tokenizer.setIndex(index);
                break;
            }
            if (!hasDigit) {
                return false;
            }
            if (!(i >= 3 || (token = tokenizer.next()) != null && token.equals("."))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean parsePort(LexicalCharsTokenizer tokenizer) {
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            if (LexicalParser.parseDigit(tokenizer)) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parsePath(LexicalCharsTokenizer tokenizer) {
        if (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            if (!LexicalParser.parseAbsPath(tokenizer)) {
                tokenizer.setIndex(index);
                if (!LexicalParser.parseOpaquePart(tokenizer)) {
                    tokenizer.setIndex(index);
                }
            }
        }
        return true;
    }

    private static boolean parsePathSegments(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parseSegment(tokenizer)) {
            return false;
        }
        while (tokenizer.peek() != null) {
            boolean result;
            int index = tokenizer.getIndex();
            String token = tokenizer.next();
            boolean bl = result = token != null && token.equals("/");
            if (result) {
                result = LexicalParser.parseSegment(tokenizer);
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseSegment(LexicalCharsTokenizer tokenizer) {
        int index;
        while (tokenizer.peek() != null) {
            index = tokenizer.getIndex();
            if (LexicalParser.parsePChar(tokenizer)) continue;
            tokenizer.setIndex(index);
            break;
        }
        while (tokenizer.peek() != null) {
            boolean result;
            index = tokenizer.getIndex();
            String token = tokenizer.next();
            boolean bl = result = token != null && token.equals(";");
            if (result) {
                result = LexicalParser.parseParam(tokenizer);
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseParam(LexicalCharsTokenizer tokenizer) {
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            if (LexicalParser.parsePChar(tokenizer)) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parsePChar(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseUnreserved(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseEscaped(tokenizer)) {
                tokenizer.setIndex(index);
                String token = tokenizer.next();
                if (!(token != null && (token.equals(":") || token.equals("@") || token.equals("&") || token.equals("=") || token.equals("+") || token.equals("$") || token.equals(",")))) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean parseQuery(LexicalCharsTokenizer tokenizer) {
        int index;
        do {
            index = tokenizer.getIndex();
        } while (LexicalParser.parseURIC(tokenizer));
        tokenizer.setIndex(index);
        return true;
    }

    private static boolean parseFragment(LexicalCharsTokenizer tokenizer) {
        int index;
        do {
            index = tokenizer.getIndex();
        } while (LexicalParser.parseURIC(tokenizer));
        tokenizer.setIndex(index);
        return true;
    }

    private static boolean parseURIC(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseReserved(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseUnreserved(tokenizer)) {
                tokenizer.setIndex(index);
                if (!LexicalParser.parseEscaped(tokenizer)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean parseReserved(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        return token != null && (token.equals(";") || token.equals("/") || token.equals("?") || token.equals(":") || token.equals("@") || token.equals("&") || token.equals("=") || token.equals("+") || token.equals("$") || token.equals(",") || token.equals("[") || token.equals("]"));
    }

    private static boolean parseUnreserved(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseAlphaNum(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseMark(tokenizer)) {
                return false;
            }
        }
        return true;
    }

    private static boolean parseMark(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        return token != null && (token.equals("-") || token.equals("_") || token.equals(".") || token.equals("!") || token.equals("~") || token.equals("*") || token.equals("'") || token.equals("(") || token.equals(")"));
    }

    private static boolean parseEscaped(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null || !token.equals("%")) {
            return false;
        }
        if (!LexicalParser.parseHex(tokenizer)) {
            return false;
        }
        return LexicalParser.parseHex(tokenizer);
    }

    private static boolean parseHex(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseDigit(tokenizer)) {
            tokenizer.setIndex(index);
            String token = tokenizer.next();
            if (!(token != null && (token.equals("A") || token.equals("B") || token.equals("C") || token.equals("D") || token.equals("E") || token.equals("F") || token.equals("a") || token.equals("b") || token.equals("c") || token.equals("d") || token.equals("e") || token.equals("f")))) {
                return false;
            }
        }
        return true;
    }

    private static boolean parseAlphaNum(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseAlpha(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseDigit(tokenizer)) {
                return false;
            }
        }
        return true;
    }

    private static boolean parseAlpha(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseLowAlpha(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseUpAlpha(tokenizer)) {
                return false;
            }
        }
        return true;
    }

    private static boolean parseLowAlpha(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null || token.length() != 1) {
            return false;
        }
        char ch = token.charAt(0);
        return Character.getType(ch) == 2;
    }

    private static boolean parseUpAlpha(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null || token.length() != 1) {
            return false;
        }
        char ch = token.charAt(0);
        return Character.getType(ch) == 1;
    }

    private static boolean parseDigit(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null || token.length() != 1) {
            return false;
        }
        char ch = token.charAt(0);
        return Character.getType(ch) == 9;
    }

    private static boolean parseIPv6Reference(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null || !token.equals("[")) {
            return false;
        }
        if (!LexicalParser.parseIPv4Address(tokenizer)) {
            return false;
        }
        token = tokenizer.next();
        return token != null && token.equals("]");
    }

    private static boolean parseDuration(LexicalTokenizer tokenizer, Duration duration) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseNegativeDuration(tokenizer, duration);
        if (!result) {
            tokenizer.setIndex(index);
            result = LexicalParser.parsePositiveDuration(tokenizer, duration);
        }
        return result;
    }

    private static boolean parseNegativeDuration(LexicalTokenizer tokenizer, Duration duration) {
        String token = tokenizer.next();
        if (token == null) {
            return false;
        }
        if (token.equals("-")) {
            duration.setPositiveDuration(false);
            return LexicalParser.parseValueDuration(tokenizer, duration);
        }
        return false;
    }

    private static boolean parsePositiveDuration(LexicalTokenizer tokenizer, Duration duration) {
        duration.setPositiveDuration(true);
        return LexicalParser.parseValueDuration(tokenizer, duration);
    }

    private static boolean parseValueDuration(LexicalTokenizer tokenizer, Duration duration) {
        String token = tokenizer.next();
        int index = tokenizer.getIndex();
        if (token == null) {
            return false;
        }
        if (!token.toLowerCase().equals("p")) {
            return false;
        }
        index = tokenizer.getIndex();
        boolean result = LexicalParser.parseYearsDuration(tokenizer, duration);
        if (!result) {
            tokenizer.setIndex(index);
        }
        if (tokenizer.peek() != null) {
            index = tokenizer.getIndex();
            result = LexicalParser.parseMonthsDuration(tokenizer, duration);
            if (!result) {
                tokenizer.setIndex(index);
            }
            if (tokenizer.peek() != null) {
                index = tokenizer.getIndex();
                result = LexicalParser.parseDaysDuration(tokenizer, duration);
                if (!result) {
                    tokenizer.setIndex(index);
                }
                if (tokenizer.peek() != null) {
                    result = LexicalParser.parseTimeDuration(tokenizer, duration);
                }
            }
        }
        return result && tokenizer.peek() == null;
    }

    private static boolean parseYearsDuration(LexicalTokenizer tokenizer, Duration duration) {
        int yearDuration = (int)LexicalParser.parseDuration(tokenizer, "y");
        if (yearDuration != -1) {
            duration.setYearsDuration(yearDuration);
            return true;
        }
        return false;
    }

    private static boolean parseMonthsDuration(LexicalTokenizer tokenizer, Duration duration) {
        int yearDuration = (int)LexicalParser.parseDuration(tokenizer, "m");
        if (yearDuration != -1) {
            duration.setMonthsDuration(yearDuration);
            return true;
        }
        return false;
    }

    private static boolean parseDaysDuration(LexicalTokenizer tokenizer, Duration duration) {
        int yearDuration = (int)LexicalParser.parseDuration(tokenizer, "d");
        if (yearDuration != -1) {
            duration.setDaysDuration(yearDuration);
            return true;
        }
        return false;
    }

    private static boolean parseTimeDuration(LexicalTokenizer tokenizer, Duration duration) {
        String token = tokenizer.next();
        if (token == null) {
            return false;
        }
        if (!token.toLowerCase().equals("t")) {
            return false;
        }
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseHoursDuration(tokenizer, duration);
        if (!result) {
            tokenizer.setIndex(index);
        }
        if (tokenizer.peek() != null) {
            index = tokenizer.getIndex();
            result = LexicalParser.parseMinutesDuration(tokenizer, duration);
            if (!result) {
                tokenizer.setIndex(index);
            }
            if (tokenizer.peek() != null) {
                result = LexicalParser.parseSecondsDuration(tokenizer, duration);
            }
        }
        return result;
    }

    private static boolean parseHoursDuration(LexicalTokenizer tokenizer, Duration duration) {
        int hoursDuration = (int)LexicalParser.parseDuration(tokenizer, "h");
        if (hoursDuration != -1) {
            duration.setHoursDuration(hoursDuration);
            return true;
        }
        return false;
    }

    private static boolean parseMinutesDuration(LexicalTokenizer tokenizer, Duration duration) {
        int minutesDuration = (int)LexicalParser.parseDuration(tokenizer, "m");
        if (minutesDuration != -1) {
            duration.setMinutesDuration(minutesDuration);
            return true;
        }
        return false;
    }

    private static boolean parseSecondsDuration(LexicalTokenizer tokenizer, Duration duration) {
        double secondsDuration = LexicalParser.parseDuration(tokenizer, "s");
        if (secondsDuration != -1.0) {
            duration.setSecondsDuration(secondsDuration);
            return true;
        }
        return false;
    }

    private static double parseDuration(LexicalTokenizer tokenizer, String designateIdetifier) {
        String duration = tokenizer.next();
        double durationValue = -1.0;
        if (duration == null) {
            return -1.0;
        }
        try {
            durationValue = Double.parseDouble(duration);
            String designator = tokenizer.next();
            if (designator == null) {
                return -1.0;
            }
            if (!designator.toLowerCase().equals(designateIdetifier)) {
                return -1.0;
            }
        }
        catch (NumberFormatException nimberFormExc) {
            return -1.0;
        }
        return durationValue;
    }

    private static boolean parseQName(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parsePrefix(tokenizer);
        if (result) {
            String token = tokenizer.next();
            boolean bl = result = token != null && token.equals(":");
        }
        if (!result) {
            tokenizer.setIndex(index);
        }
        return LexicalParser.parseLocalPart(tokenizer);
    }

    private static boolean parsePrefix(LexicalCharsTokenizer tokenizer) {
        return LexicalParser.parseNCName(tokenizer);
    }

    private static boolean parseLocalPart(LexicalCharsTokenizer tokenizer) {
        return LexicalParser.parseNCName(tokenizer);
    }

    private static boolean parseNCName(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        boolean result = LexicalParser.parseLetter(tokenizer);
        if (!result) {
            tokenizer.setIndex(index);
            String token = tokenizer.next();
            if (token == null || !token.equals("_")) {
                return false;
            }
        }
        while (tokenizer.peek() != null) {
            index = tokenizer.getIndex();
            if (LexicalParser.parseNCNameChar(tokenizer)) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseNCNameChar(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseLetter(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseDigit(tokenizer)) {
                tokenizer.setIndex(index);
                if (!LexicalParser.parseCombinigChar(tokenizer)) {
                    tokenizer.setIndex(index);
                    if (!LexicalParser.parseExtender(tokenizer)) {
                        tokenizer.setIndex(index);
                        String token = tokenizer.next();
                        return token != null && (token.equals(".") || token.equals("-") || token.equals("_"));
                    }
                }
            }
        }
        return true;
    }

    private static boolean parseLetter(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseBaseChar(tokenizer)) {
            tokenizer.setIndex(index);
            return LexicalParser.parseIdeographic(tokenizer);
        }
        return true;
    }

    private static boolean parseBaseChar(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null) {
            return false;
        }
        return Symbols.isBaseChar(token.charAt(0));
    }

    private static boolean parseIdeographic(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null) {
            return false;
        }
        return Symbols.isIdeographic(token.charAt(0));
    }

    private static boolean parseCombinigChar(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null) {
            return false;
        }
        return Symbols.isCombiningChar(token.charAt(0));
    }

    private static boolean parseExtender(LexicalCharsTokenizer tokenizer) {
        String token = tokenizer.next();
        if (token == null) {
            return false;
        }
        return Symbols.isExtender(token.charAt(0));
    }

    private static boolean parseLanguage(LexicalCharsTokenizer tokenizer) {
        if (!LexicalParser.parsePrimaryTag(tokenizer)) {
            return false;
        }
        while (tokenizer.peek() != null) {
            boolean result;
            int index = tokenizer.getIndex();
            String token = tokenizer.next();
            boolean bl = result = token != null && token.equals("-");
            if (result) {
                result = LexicalParser.parseSubtag(tokenizer);
            }
            if (result) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parsePrimaryTag(LexicalCharsTokenizer tokenizer) {
        return LexicalParser.parseAlphas(tokenizer);
    }

    private static boolean parseSubtag(LexicalCharsTokenizer tokenizer) {
        return LexicalParser.parseAlphas(tokenizer);
    }

    private static boolean parseAlphas(LexicalCharsTokenizer tokenizer) {
        boolean hasAlpha = false;
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            if (!LexicalParser.parseAlpha(tokenizer)) {
                tokenizer.setIndex(index);
                break;
            }
            hasAlpha = true;
        }
        return hasAlpha;
    }

    private static boolean parseName(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseLetter(tokenizer)) {
            tokenizer.setIndex(index);
            String token = tokenizer.next();
            if (token == null || !token.equals("_") && !token.equals(":")) {
                return false;
            }
        }
        while (tokenizer.peek() != null) {
            index = tokenizer.getIndex();
            if (LexicalParser.parseNameChar(tokenizer)) continue;
            tokenizer.setIndex(index);
            break;
        }
        return true;
    }

    private static boolean parseNameChar(LexicalCharsTokenizer tokenizer) {
        int index = tokenizer.getIndex();
        if (!LexicalParser.parseLetter(tokenizer)) {
            tokenizer.setIndex(index);
            if (!LexicalParser.parseDigit(tokenizer)) {
                tokenizer.setIndex(index);
                if (!LexicalParser.parseCombinigChar(tokenizer)) {
                    tokenizer.setIndex(index);
                    if (!LexicalParser.parseExtender(tokenizer)) {
                        tokenizer.setIndex(index);
                        String token = tokenizer.next();
                        if (token == null || !token.equals(".") && !token.equals("-") && !token.equals("_") && !token.equals(":")) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private static boolean parseNmtoken(LexicalCharsTokenizer tokenizer) {
        boolean hasNameChar = false;
        while (tokenizer.peek() != null) {
            int index = tokenizer.getIndex();
            if (!LexicalParser.parseNameChar(tokenizer)) {
                tokenizer.setIndex(index);
                break;
            }
            hasNameChar = true;
        }
        return hasNameChar;
    }

    private static GregorianCalendar createEmptyCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        return calendar;
    }
}

