/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WildcardImpl
extends BaseImpl
implements Wildcard {
    protected static final int SKIP = 0;
    protected static final int LAX = 1;
    protected static final int STRICT = 2;
    protected int processContents;
    protected boolean nsAny;
    protected String negated;
    protected Vector nsMemebers = new Vector();
    protected boolean isAttribWildcard;
    private int targetNsPosition = -1;
    private boolean hasOther;

    public WildcardImpl() {
        this(null);
    }

    public WildcardImpl(BaseInfo baseInfo) {
        this(null, baseInfo);
    }

    public WildcardImpl(Node associatedNode, BaseInfo baseInfo) {
        super(associatedNode, baseInfo);
    }

    public int getTypeOfComponent() {
        return 10;
    }

    public boolean isProcessContentsSkip() {
        return this.processContents == 0;
    }

    public boolean isProcessContentsLax() {
        return this.processContents == 1;
    }

    public boolean isProcessContentsStrict() {
        return this.processContents == 2;
    }

    public boolean isNamespaceConstraintAny() {
        return this.nsAny;
    }

    public String getNamespaceConstraintNegated() {
        return this.negated;
    }

    public boolean isAttribWildcard() {
        return this.isAttribWildcard;
    }

    public String[] getNamespaceConstraintMembersAsArray() {
        Object[] result = new String[this.nsMemebers.size()];
        this.nsMemebers.copyInto(result);
        return result;
    }

    public void getNamespaceConstraintMembers(Vector collector) {
        Tools.removeFromVectorToVector(this.nsMemebers, collector);
    }

    public boolean match(Base wildcard) {
        if (!super.match(wildcard)) {
            return false;
        }
        WildcardImpl targetWildcard = (WildcardImpl)wildcard;
        boolean result = this.processContents == targetWildcard.processContents && this.equalNamespaceConstraint(targetWildcard);
        return result;
    }

    private boolean equalNamespaceConstraint(WildcardImpl wildcard) {
        if (this.nsAny != wildcard.nsAny) {
            return false;
        }
        if (!Tools.compareStringProps(this.negated, wildcard.negated)) {
            return false;
        }
        return Tools.compareUnorderedSetsOfStrings(this.nsMemebers, wildcard.nsMemebers);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            String namespaceAttribValue = this.loadAttribsCollector.getProperty("namespace");
            if (namespaceAttribValue != null) {
                if (namespaceAttribValue.equals("##any")) {
                    this.nsAny = true;
                } else if (namespaceAttribValue.equals("##other")) {
                    this.negated = this.baseInfo.getTargetNamespace();
                    this.hasOther = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(namespaceAttribValue);
                    while (tokenizer.hasMoreElements()) {
                        String token = tokenizer.nextToken();
                        String nsMember = null;
                        if (token.equals("##targetNamespace")) {
                            nsMember = this.baseInfo.getTargetNamespace();
                            this.targetNsPosition = this.nsMemebers.size();
                        } else if (token.equals("##local")) {
                            nsMember = "";
                        } else if (token.equals("not")) {
                            this.negated = "";
                            while (tokenizer.hasMoreElements()) {
                                this.negated = this.negated + tokenizer.nextToken();
                            }
                        } else {
                            nsMember = token;
                        }
                        if (nsMember == null) continue;
                        this.nsMemebers.add(nsMember);
                    }
                }
            } else {
                this.nsAny = true;
            }
            String processContentsAttribValue = this.loadAttribsCollector.getProperty("processContents");
            if (processContentsAttribValue != null) {
                if (processContentsAttribValue.equals("lax")) {
                    this.processContents = 1;
                } else if (processContentsAttribValue.equals("skip")) {
                    this.processContents = 0;
                } else if (processContentsAttribValue.equals("strict")) {
                    this.processContents = 2;
                }
            } else {
                this.processContents = 2;
            }
            this.isAttribWildcard = this.associatedNode.getLocalName().equals("anyAttribute");
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeLocalName;
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema") && (nodeLocalName = node.getLocalName()).equals("annotation")) {
                    this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                    SchemaStructuresFactory.loadBase(this.annotation);
                }
                ++i;
            }
        }
    }

    protected void intersect(WildcardImpl srcWildcard) throws SchemaComponentException {
        if (this.negated != null && srcWildcard.negated != null && !this.negated.equals(srcWildcard.negated)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : The intersection of wildcard " + DOM.toXPath(this.associatedNode) + " with widcard " + DOM.toXPath(srcWildcard.associatedNode) + " isnot expressible.");
        }
        if (srcWildcard.nsMemebers.size() != 0 && this.nsAny) {
            this.nsAny = false;
            this.nsMemebers.addAll(srcWildcard.nsMemebers);
            return;
        }
        if (srcWildcard.nsMemebers.size() != 0 && this.negated != null) {
            int i = 0;
            while (i < srcWildcard.nsMemebers.size()) {
                String ns = (String)srcWildcard.nsMemebers.get(i);
                if (!ns.equals(this.negated)) {
                    this.nsMemebers.add(ns);
                }
                ++i;
            }
            this.negated = null;
            return;
        }
        if (srcWildcard.negated != null && this.nsMemebers.size() != 0) {
            this.nsMemebers.remove(srcWildcard.negated);
            return;
        }
        if (srcWildcard.nsMemebers.size() != 0 && this.nsMemebers.size() != 0) {
            int index = 0;
            while (index != this.nsMemebers.size()) {
                String ns = (String)this.nsMemebers.get(index);
                if (!srcWildcard.nsMemebers.contains(ns)) {
                    this.nsMemebers.remove(ns);
                    continue;
                }
                ++index;
            }
        }
    }

    protected void unite(WildcardImpl wildcard) throws SchemaComponentException {
        if (this.negated != null && wildcard.negated != null && !this.negated.equals(wildcard.negated)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : The unification of wildcard " + DOM.toXPath(this.associatedNode) + " with wildcard " + DOM.toXPath(wildcard.associatedNode) + " is not expressible.");
        }
        if (this.nsMemebers.size() != 0 && wildcard.nsMemebers.size() != 0) {
            int i = 0;
            while (i < wildcard.nsMemebers.size()) {
                String ns = (String)wildcard.nsMemebers.get(i);
                if (!this.nsMemebers.contains(ns)) {
                    this.nsMemebers.add(ns);
                }
                ++i;
            }
            return;
        }
        if (this.negated != null && wildcard.nsMemebers.size() != 0) {
            if (wildcard.nsMemebers.contains(this.negated)) {
                this.nsMemebers.removeAllElements();
                this.negated = null;
                this.nsAny = true;
            }
            return;
        }
        if (this.nsMemebers.size() != 0 && wildcard.negated != null) {
            if (this.nsMemebers.contains(wildcard.negated)) {
                this.nsMemebers.removeAllElements();
                this.negated = null;
                this.nsAny = true;
            } else {
                this.nsMemebers.removeAllElements();
                this.negated = wildcard.negated;
            }
            return;
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        WildcardImpl result = (WildcardImpl)super.initializeBase(base, clonedCollector);
        result.processContents = this.processContents;
        result.nsAny = this.nsAny;
        result.isAttribWildcard = this.isAttribWildcard;
        result.targetNsPosition = this.targetNsPosition;
        result.hasOther = this.hasOther;
        result.nsMemebers.addAll(this.nsMemebers);
        result.negated = this.negated;
        return result;
    }
}

