/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.AnnotationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeUseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.FacetImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupImpl;
import com.sap.engine.lib.schema.components.impl.structures.ParticleImpl;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.WildcardImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ComplexTypeDefinitionImpl
extends TypeDefinitionBaseImpl
implements ComplexTypeDefinition {
    protected boolean isDerivationMethodExtension;
    protected boolean isDerivationMethodRestriction;
    protected boolean isProhibitedSubstitutionExtension;
    protected boolean isProhibitedSubstitutionRestriction;
    protected boolean isAbstract;
    protected WildcardImpl attributeWildcard;
    protected Vector attribUsesCollector = new Vector();
    protected SimpleTypeDefinitionImpl contentTypeSimpleTypeDefinition;
    protected ParticleImpl contentTypeContentModel;
    protected boolean isMixed;
    protected Vector annotationsCollector = new Vector();

    public ComplexTypeDefinitionImpl() {
        this(null, null);
    }

    public ComplexTypeDefinitionImpl(Node associatedNode, BaseInfo baseInfo) {
        this(associatedNode, baseInfo, false);
    }

    public ComplexTypeDefinitionImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo, isTopLevel);
    }

    public boolean isDerivationMethodExtension() {
        return this.isDerivationMethodExtension;
    }

    public boolean isDerivationMethodRestriction() {
        return this.isDerivationMethodRestriction;
    }

    public boolean isProhibitedSubstitutionExtension() {
        return this.isProhibitedSubstitutionExtension;
    }

    public boolean isProhibitedSubstitutionRestriction() {
        return this.isProhibitedSubstitutionRestriction;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Wildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    public void getAttributeUses(Vector collector) {
        Tools.removeFromVectorToVector(this.attribUsesCollector, collector);
    }

    public AttributeUse[] getAttributeUsesArray() {
        Object[] result = new AttributeUse[this.attribUsesCollector.size()];
        this.attribUsesCollector.copyInto(result);
        return result;
    }

    public SimpleTypeDefinition getContentTypeSimpleTypeDefinition() {
        return this.contentTypeSimpleTypeDefinition;
    }

    public Particle getContentTypeContentModel() {
        return this.contentTypeContentModel;
    }

    public boolean isContentTypeEmpty() {
        return this.contentTypeContentModel == null && this.contentTypeSimpleTypeDefinition == null;
    }

    public boolean isMixed() {
        return this.isMixed;
    }

    public int getTypeOfComponent() {
        return 1;
    }

    public boolean match(Base complexTypeDef) {
        if (!super.match(complexTypeDef)) {
            return false;
        }
        ComplexTypeDefinitionImpl targetComplTypeDef = (ComplexTypeDefinitionImpl)complexTypeDef;
        return this.isDerivationMethodExtension == targetComplTypeDef.isDerivationMethodExtension && this.isFinalExtension == targetComplTypeDef.isFinalExtension && this.isFinalRestriction == targetComplTypeDef.isFinalRestriction && this.isProhibitedSubstitutionExtension == targetComplTypeDef.isProhibitedSubstitutionExtension && this.isProhibitedSubstitutionRestriction == targetComplTypeDef.isProhibitedSubstitutionRestriction && this.isAbstract == targetComplTypeDef.isAbstract && this.isMixed == targetComplTypeDef.isMixed && Tools.compareUnorderdSetsOfBases(this.attribUsesCollector, targetComplTypeDef.attribUsesCollector) && Tools.compareBases(this.attributeWildcard, targetComplTypeDef.attributeWildcard) && Tools.compareBases(this.contentTypeContentModel, targetComplTypeDef.contentTypeContentModel) && Tools.compareBases(this.contentTypeSimpleTypeDefinition, targetComplTypeDef.contentTypeSimpleTypeDefinition);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            WildcardImpl baseWildcard;
            String blockAttribValue;
            this.id = this.loadAttribsCollector.getProperty("id");
            Hashtable baseAttribUsesCollector = new Hashtable();
            Hashtable declaredAttribUsesCollector = new Hashtable();
            String abstractAttribValue = this.loadAttribsCollector.getProperty("abstract");
            if (abstractAttribValue != null) {
                this.isAbstract = abstractAttribValue.equals("true");
            }
            if ((blockAttribValue = this.loadAttribsCollector.getProperty("block")) != null) {
                if (blockAttribValue.equals("#all")) {
                    this.isProhibitedSubstitutionExtension = true;
                    this.isProhibitedSubstitutionRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(blockAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("extension")) {
                            this.isProhibitedSubstitutionExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isProhibitedSubstitutionRestriction = true;
                    }
                }
            } else {
                this.isProhibitedSubstitutionExtension = this.baseInfo.isProhibitedExtension();
                this.isProhibitedSubstitutionRestriction = this.baseInfo.isProhibitedRestriction();
            }
            String finalAttribValue = this.loadAttribsCollector.getProperty("final");
            if (finalAttribValue != null) {
                if (finalAttribValue.equals("#all")) {
                    this.isFinalExtension = true;
                    this.isFinalRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(finalAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("extension")) {
                            this.isFinalExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isFinalRestriction = true;
                    }
                }
            } else {
                this.isFinalExtension = this.baseInfo.isFinalExtension();
                this.isFinalRestriction = this.baseInfo.isFinalRestriction();
            }
            String mixedAttribValue = this.loadAttribsCollector.getProperty("mixed");
            if (mixedAttribValue != null) {
                this.isMixed = mixedAttribValue.equals("true");
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("group") || nodeLocalName.equals("all") || nodeLocalName.equals("choice") || nodeLocalName.equals("sequence")) {
                        this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
                        this.contentTypeContentModel = SchemaStructuresFactory.createParticle(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.contentTypeContentModel);
                    } else if (nodeLocalName.equals("anyAttribute")) {
                        WildcardImpl wildcard = this.createWildcard(node);
                        if (this.attributeWildcard != null) {
                            this.attributeWildcard.intersect(wildcard);
                        } else {
                            this.attributeWildcard = wildcard;
                        }
                    } else if (nodeLocalName.equals("simpleContent")) {
                        this.processSimpleContent(node, baseAttribUsesCollector, declaredAttribUsesCollector);
                    } else if (nodeLocalName.equals("complexContent")) {
                        this.processComplexContent(node, baseAttribUsesCollector, declaredAttribUsesCollector);
                    } else if (nodeLocalName.equals("attribute")) {
                        this.addAttribUse(this.createAttribUse(node), declaredAttribUsesCollector);
                    } else if (nodeLocalName.equals("attributeGroup")) {
                        AttributeGroupDefinitionImpl attribGroup = SchemaStructuresFactory.createAttributeGroupDefinition(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(attribGroup);
                        int j = 0;
                        while (j < attribGroup.attribUsesCollector.size()) {
                            AttributeUseImpl attribUse = (AttributeUseImpl)attribGroup.attribUsesCollector.get(j);
                            this.addAttribUse(attribUse, declaredAttribUsesCollector);
                            ++j;
                        }
                        this.processWildcard(attribGroup.attributeWildcard);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            if (this.isDerivationMethodExtension && this.baseTypeDefinition != null && this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl && (baseWildcard = ((ComplexTypeDefinitionImpl)this.baseTypeDefinition).attributeWildcard) != null) {
                if (this.attributeWildcard == null) {
                    this.attributeWildcard = baseWildcard;
                } else {
                    this.attributeWildcard.unite(baseWildcard);
                }
            }
            this.collectAttribUses(baseAttribUsesCollector, declaredAttribUsesCollector);
            if (this.baseTypeDefinition != null) {
                if (this.isDerivationMethodExtension) {
                    if (this.baseTypeDefinition.isFinalExtension) {
                        throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the {derivation method} is extension The {final} of the {base type definition} must not contain extension.");
                    }
                } else if (this.isDerivationMethodRestriction && this.baseTypeDefinition.isFinalRestriction) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the {derivation method} is restriction The {final} of the {base type definition} must not contain restriction.");
                }
            } else {
                this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
            }
            this.baseInfo.getSchema().allComponentsCollector.add(this);
        }
    }

    private void processSimpleContent(Node node, Hashtable baseAttribUsesCollector, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (elemName.equals("annotation")) {
                        AnnotationImpl annotation = SchemaStructuresFactory.createAnnotation(childNode, this.baseInfo);
                        SchemaStructuresFactory.loadBase(annotation);
                        this.annotationsCollector.add(annotation);
                    } else if (elemName.equals("restriction")) {
                        this.processSimpleContentRestriction(childNode, baseAttribUsesCollector, declaredAttribUsesCollector);
                    } else if (elemName.equals("extension")) {
                        this.processSimpleContentExtension(childNode, declaredAttribUsesCollector);
                    }
                }
            }
            ++j;
        }
    }

    private void processSimpleContentRestriction(Node node, Hashtable baseAttribUsesCollector, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        NamedNodeMap attribsMap = node.getAttributes();
        int i = 0;
        while (i < attribsMap.getLength()) {
            Node attrib = attribsMap.item(i);
            String attribName = attrib.getLocalName();
            String uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("base")) {
                this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.getTopLevelBase(node, value, 16);
                SchemaStructuresFactory.loadBase(this.baseTypeDefinition);
                if (!(this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl) || ((ComplexTypeDefinitionImpl)this.baseTypeDefinition).contentTypeSimpleTypeDefinition == null) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <simpleContent> alternative is chosen, the type definition ?resolved to by the ?actual value of the base [attribute] must be a complex type definition whose {base type definition} is a simple type definition.");
                }
                this.collectBaseAttribUses(baseAttribUsesCollector);
                ComplexTypeDefinitionImpl complBaseTypeDef = (ComplexTypeDefinitionImpl)this.baseTypeDefinition;
                this.contentTypeSimpleTypeDefinition = (SimpleTypeDefinitionImpl)complBaseTypeDef.contentTypeSimpleTypeDefinition.clone(new Hashtable());
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node childNode = childNodes.item(i2);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") && !elemName.equals("annotation")) {
                    if (elemName.equals("simpleType")) {
                        this.contentTypeSimpleTypeDefinition = SchemaStructuresFactory.createSimpleTypeDefinition(childNode, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.contentTypeSimpleTypeDefinition);
                    } else if (elemName.equals("minExclusive") || elemName.equals("minInclusive") || elemName.equals("maxExclusive") || elemName.equals("minInclusive") || elemName.equals("totalDigits") || elemName.equals("fractionDigits") || elemName.equals("length") || elemName.equals("minLength") || elemName.equals("maxLength") || elemName.equals("enumeration") || elemName.equals("whiteSpace") || elemName.equals("pattern")) {
                        FacetImpl restrictedFacet = SchemaStructuresFactory.createFacet(childNode, this.baseInfo);
                        SchemaStructuresFactory.loadBase(restrictedFacet);
                        this.contentTypeSimpleTypeDefinition.addRestrictedFacet(restrictedFacet);
                    } else if (elemName.equals("attribute")) {
                        this.restriction_ProcessAttribUse(childNode, baseAttribUsesCollector, declaredAttribUsesCollector);
                    } else if (elemName.equals("attributeGroup")) {
                        this.restriction_ProcessAttribGroup(childNode, baseAttribUsesCollector, declaredAttribUsesCollector);
                    } else if (elemName.equals("anyAttribute")) {
                        this.processWildcard(this.createWildcard(childNode));
                    }
                }
            }
            ++i2;
        }
        this.isDerivationMethodRestriction = true;
    }

    private void processSimpleContentExtension(Node node, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        NamedNodeMap attribsMap = node.getAttributes();
        int i = 0;
        while (i < attribsMap.getLength()) {
            Node attrib = attribsMap.item(i);
            String attribName = attrib.getLocalName();
            String uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("base")) {
                this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.getTopLevelBase(node, value, 16);
                SchemaStructuresFactory.loadBase(this.baseTypeDefinition);
                if (this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl) {
                    ComplexTypeDefinitionImpl complBaseTypeDef = (ComplexTypeDefinitionImpl)this.baseTypeDefinition;
                    if (complBaseTypeDef.contentTypeSimpleTypeDefinition == null) {
                        throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <simpleContent> alternative is chosen, the type definition ?resolved to by the ?actual value of the base [attribute] must be either a complex type definition whose {base type definition} is a simple type definition or, only if the <extension> alternative is also chosen, a simple type definition.");
                    }
                    this.collectBaseAttribUses(declaredAttribUsesCollector);
                    this.contentTypeSimpleTypeDefinition = complBaseTypeDef.contentTypeSimpleTypeDefinition;
                    this.contentTypeContentModel = complBaseTypeDef.contentTypeContentModel;
                } else {
                    this.contentTypeSimpleTypeDefinition = (SimpleTypeDefinitionImpl)this.baseTypeDefinition;
                }
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node childNode = childNodes.item(i2);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") && !elemName.equals("annotation")) {
                    if (elemName.equals("attribute")) {
                        this.extension_ProcessAttribUse(childNode, declaredAttribUsesCollector);
                    } else if (elemName.equals("attributeGroup")) {
                        this.extension_ProcessAttribGroup(childNode, declaredAttribUsesCollector);
                    } else if (elemName.equals("anyAttribute")) {
                        this.processWildcard(this.createWildcard(childNode));
                    }
                }
            }
            ++i2;
        }
        this.isDerivationMethodExtension = true;
    }

    private void processComplexContent(Node node, Hashtable baseAttribUsesCollector, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String uri = attrib.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                String attribName = attrib.getLocalName();
                String value = attrib.getNodeValue();
                if (attribName.equals("mixed")) {
                    if (value.equals("true")) {
                        this.isMixed = true;
                    } else if (value.equals("false")) {
                        this.isMixed = false;
                    }
                }
            }
            ++i;
        }
        NodeList nodeList = node.getChildNodes();
        int i2 = 0;
        while (i2 < nodeList.getLength()) {
            String uri;
            Node childNode = nodeList.item(i2);
            if (childNode.getNodeType() == 1 && (uri = childNode.getNamespaceURI()).equals("http://www.w3.org/2001/XMLSchema")) {
                String elemName = childNode.getLocalName();
                if (elemName.equals("restriction")) {
                    this.processComplexContentRestriction(childNode, baseAttribUsesCollector, declaredAttribUsesCollector);
                } else if (elemName.equals("extension")) {
                    this.processComplexContentExtension(childNode, declaredAttribUsesCollector);
                }
            }
            ++i2;
        }
    }

    private void processComplexContentRestriction(Node node, Hashtable baseAttribUsesCollector, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String uri = attrib.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                String attribName = attrib.getLocalName();
                String value = attrib.getNodeValue();
                if (attribName.equals("base")) {
                    this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.getTopLevelBase(node, value, 16);
                    SchemaStructuresFactory.loadBase(this.baseTypeDefinition);
                    if (!(this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl)) {
                        throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <complexContent> alternative is chosen, the type definition resolved to by the actual value of the base [attribute] must be either a complex type definition.");
                    }
                    this.collectBaseAttribUses(baseAttribUsesCollector);
                }
            }
            ++i;
        }
        NodeList nodeList = node.getChildNodes();
        int i2 = 0;
        while (i2 < nodeList.getLength()) {
            String uri;
            Node childNode = nodeList.item(i2);
            if (childNode.getNodeType() == 1 && (uri = childNode.getNamespaceURI()).equals("http://www.w3.org/2001/XMLSchema")) {
                String elemName = childNode.getLocalName();
                if (elemName.equals("attribute")) {
                    this.restriction_ProcessAttribUse(childNode, baseAttribUsesCollector, declaredAttribUsesCollector);
                } else if (elemName.equals("attributeGroup")) {
                    this.restriction_ProcessAttribGroup(childNode, baseAttribUsesCollector, declaredAttribUsesCollector);
                } else if (elemName.equals("anyAttribute")) {
                    this.processWildcard(this.createWildcard(childNode));
                } else if (elemName.equals("group") || elemName.equals("all") || elemName.equals("choice") || elemName.equals("sequence")) {
                    this.contentTypeContentModel = SchemaStructuresFactory.createParticle(childNode, this.baseInfo);
                    SchemaStructuresFactory.loadBase(this.contentTypeContentModel);
                }
            }
            ++i2;
        }
        this.isDerivationMethodRestriction = true;
    }

    private void processComplexContentExtension(Node node, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String uri = attrib.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                String attribName = attrib.getLocalName();
                String value = attrib.getNodeValue();
                if (attribName.equals("base")) {
                    this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.getTopLevelBase(node, value, 16);
                    SchemaStructuresFactory.loadBase(this.baseTypeDefinition);
                    if (!(this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl)) {
                        throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <complexContent> alternative is chosen, the type definition resolved to by the actual value of the base [attribute] must be either a complex type definition.");
                    }
                    ComplexTypeDefinitionImpl complBaseTypeDef = (ComplexTypeDefinitionImpl)this.baseTypeDefinition;
                    this.collectBaseAttribUses(declaredAttribUsesCollector);
                    this.contentTypeContentModel = complBaseTypeDef.contentTypeContentModel;
                }
            }
            ++i;
        }
        NodeList nodeList = node.getChildNodes();
        int i2 = 0;
        while (i2 < nodeList.getLength()) {
            String uri;
            Node childNode = nodeList.item(i2);
            if (childNode.getNodeType() == 1 && (uri = childNode.getNamespaceURI()).equals("http://www.w3.org/2001/XMLSchema")) {
                String elemName = childNode.getLocalName();
                if (elemName.equals("attribute")) {
                    this.extension_ProcessAttribUse(childNode, declaredAttribUsesCollector);
                } else if (elemName.equals("attributeGroup")) {
                    this.extension_ProcessAttribGroup(childNode, declaredAttribUsesCollector);
                } else if (elemName.equals("anyAttribute")) {
                    this.processWildcard(this.createWildcard(childNode));
                } else if (elemName.equals("group") || elemName.equals("all") || elemName.equals("choice") || elemName.equals("sequence")) {
                    ParticleImpl explicitContent = SchemaStructuresFactory.createParticle(childNode, this.baseInfo);
                    SchemaStructuresFactory.loadBase(explicitContent);
                    if (this.contentTypeContentModel != null) {
                        ParticleImpl baseContentTypeContentModel = this.contentTypeContentModel;
                        this.contentTypeContentModel = new ParticleImpl(this.baseInfo);
                        this.contentTypeContentModel.minOccurs = 1;
                        this.contentTypeContentModel.maxOccurs = 1;
                        ModelGroupImpl modelGroup = new ModelGroupImpl(this.baseInfo);
                        modelGroup.compositor = 3;
                        modelGroup.particlesCollector.add(baseContentTypeContentModel);
                        modelGroup.particlesCollector.add(explicitContent);
                        this.contentTypeContentModel.term = modelGroup;
                    } else {
                        this.contentTypeContentModel = explicitContent;
                    }
                }
            }
            ++i2;
        }
        this.isDerivationMethodExtension = true;
    }

    private void restriction_ProcessAttribUse(Node node, Hashtable baseAttribUsesCollector, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        Element element = (Element)node;
        String useValue = element.getAttribute("use");
        if (useValue.equals("prohibited")) {
            String formValue = element.getAttribute("form");
            boolean isFormQualified = formValue.equals("") || formValue.equals("qualified");
            String uri = this.baseInfo.attribsFormDefaultIsQualified() && isFormQualified ? this.baseInfo.getTargetNamespace() : "";
            String attribName = element.getAttribute("name");
            baseAttribUsesCollector.remove(Tools.generateKey(uri, attribName));
        } else {
            AttributeUseImpl attribUse = this.createAttribUse(node);
            baseAttribUsesCollector.remove(attribUse.attribDeclr.qualifiedKey);
            this.addAttribUse(attribUse, declaredAttribUsesCollector);
        }
    }

    private void extension_ProcessAttribUse(Node node, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        this.addAttribUse(this.createAttribUse(node), declaredAttribUsesCollector);
    }

    private void restriction_ProcessAttribGroup(Node node, Hashtable baseAttribUsesCollector, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        AttributeGroupDefinitionImpl attribGroup = SchemaStructuresFactory.createAttributeGroupDefinition(node, this.baseInfo);
        SchemaStructuresFactory.loadBase(attribGroup);
        int i = 0;
        while (i < attribGroup.attribUsesCollector.size()) {
            AttributeUseImpl attribUse = (AttributeUseImpl)attribGroup.attribUsesCollector.get(i);
            baseAttribUsesCollector.remove(attribUse.attribDeclr.qualifiedKey);
            this.addAttribUse(attribUse, declaredAttribUsesCollector);
            ++i;
        }
        this.processWildcard(attribGroup.attributeWildcard);
    }

    private void extension_ProcessAttribGroup(Node node, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        AttributeGroupDefinitionImpl attribGroup = SchemaStructuresFactory.createAttributeGroupDefinition(node, this.baseInfo);
        SchemaStructuresFactory.loadBase(attribGroup);
        int i = 0;
        while (i < attribGroup.attribUsesCollector.size()) {
            AttributeUseImpl attribUse = (AttributeUseImpl)attribGroup.attribUsesCollector.get(i);
            this.addAttribUse(attribUse, declaredAttribUsesCollector);
            ++i;
        }
        this.processWildcard(attribGroup.attributeWildcard);
    }

    private void processWildcard(WildcardImpl wildcard) throws SchemaComponentException {
        if (wildcard != null) {
            if (this.attributeWildcard == null) {
                this.attributeWildcard = (WildcardImpl)wildcard.clone(new Hashtable());
                this.attributeWildcard.annotation = null;
            } else {
                this.attributeWildcard.intersect(wildcard);
            }
        }
    }

    private void collectAttribUses(Hashtable baseAttribUsesCollector, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        SimpleTypeDefinitionImpl idTypeDef = (SimpleTypeDefinitionImpl)this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID");
        boolean[] hlpArray = new boolean[]{false};
        this.collectAttribUsesFromHashtable(baseAttribUsesCollector, hlpArray, idTypeDef);
        this.collectAttribUsesFromHashtable(declaredAttribUsesCollector, hlpArray, idTypeDef);
    }

    private void collectAttribUsesFromHashtable(Hashtable collector, boolean[] hlpArray, SimpleTypeDefinitionImpl idTypeDef) throws SchemaComponentException {
        if (collector != null) {
            Enumeration enumeration = collector.elements();
            while (enumeration.hasMoreElements()) {
                AttributeUseImpl attribUse = (AttributeUseImpl)enumeration.nextElement();
                if (attribUse.attribDeclr.typeDefinition.isDerivedFrom(idTypeDef, false, false)) {
                    if (hlpArray[0]) {
                        throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. Two distinct members of the {attribute uses} must not have {type definition}s which are or are derived from ID.");
                    }
                    hlpArray[0] = true;
                }
                this.attribUsesCollector.add(attribUse);
            }
        }
    }

    private WildcardImpl createWildcard(Node node) throws SchemaComponentException {
        WildcardImpl result = SchemaStructuresFactory.createWildcard(node, this.baseInfo);
        SchemaStructuresFactory.loadBase(result);
        return result;
    }

    private AttributeUseImpl createAttribUse(Node node) throws SchemaComponentException {
        AttributeUseImpl result = SchemaStructuresFactory.createAttributeUse(node, this.baseInfo);
        SchemaStructuresFactory.loadBase(result);
        return result;
    }

    private void addAttribUse(AttributeUseImpl attribUse, Hashtable declaredAttribUsesCollector) throws SchemaComponentException {
        AttributeDeclarationImpl attribDeclr = attribUse.attribDeclr;
        if (declaredAttribUsesCollector.containsKey(attribDeclr.qualifiedKey)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. No two attribute declarations in the {attribute uses} may have identical {name}s and {target namespace}s.");
        }
        declaredAttribUsesCollector.put(attribDeclr.qualifiedKey, attribUse);
    }

    private void collectBaseAttribUses(Hashtable collector) {
        ComplexTypeDefinitionImpl baseComplTypeDef = (ComplexTypeDefinitionImpl)this.baseTypeDefinition;
        int i = 0;
        while (i < baseComplTypeDef.attribUsesCollector.size()) {
            AttributeUseImpl attribUse = (AttributeUseImpl)baseComplTypeDef.attribUsesCollector.get(i);
            collector.put(attribUse.attribDeclr.qualifiedKey, attribUse);
            ++i;
        }
    }

    public boolean isDerivedFrom(TypeDefinitionBase typeDefinition, boolean disallowedRestriction, boolean disallowedExtension) {
        TypeDefinitionBaseImpl typeDefBase = (TypeDefinitionBaseImpl)typeDefinition;
        if (typeDefBase == null) {
            return false;
        }
        if (typeDefBase.isUrType && typeDefBase.name.equals("anyType")) {
            return true;
        }
        if (this.isUrType && this.name.equals("anyType")) {
            return false;
        }
        if (this.isDerivationMethodExtension && disallowedExtension || this.isDerivationMethodRestriction && disallowedRestriction) {
            return false;
        }
        if (this == typeDefBase) {
            return true;
        }
        if (!this.baseTypeDefinition.isUrType) {
            return this.baseTypeDefinition.isDerivedFrom(typeDefinition, disallowedRestriction, disallowedExtension);
        }
        return false;
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ComplexTypeDefinitionImpl result = (ComplexTypeDefinitionImpl)super.initializeBase(base, clonedCollector);
        result.isDerivationMethodExtension = this.isDerivationMethodExtension;
        result.isDerivationMethodRestriction = this.isDerivationMethodRestriction;
        result.isProhibitedSubstitutionExtension = this.isProhibitedSubstitutionExtension;
        result.isProhibitedSubstitutionRestriction = this.isProhibitedSubstitutionRestriction;
        result.isAbstract = this.isAbstract;
        if (this.attributeWildcard != null) {
            result.attributeWildcard = (WildcardImpl)this.attributeWildcard.clone(clonedCollector);
        }
        Tools.cloneVectorWithBases(this.attribUsesCollector, result.attribUsesCollector, clonedCollector);
        if (this.contentTypeSimpleTypeDefinition != null) {
            result.contentTypeSimpleTypeDefinition = (SimpleTypeDefinitionImpl)this.contentTypeSimpleTypeDefinition.clone(clonedCollector);
        }
        if (this.contentTypeContentModel != null) {
            result.contentTypeContentModel = (ParticleImpl)this.contentTypeContentModel.clone(clonedCollector);
        }
        result.isMixed = this.isMixed;
        Tools.cloneVectorWithBases(this.annotationsCollector, result.annotationsCollector, clonedCollector);
        return result;
    }
}

