/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Annotation;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AnnotationImpl
extends BaseImpl
implements Annotation {
    protected Vector attribsCollector = new Vector();
    protected Vector appInfosCollector = new Vector();
    protected Vector usrInfosCollector = new Vector();

    public AnnotationImpl() {
        this(null, null);
    }

    public AnnotationImpl(Node associatedNode, BaseInfo baseInfo) {
        super(associatedNode, baseInfo);
    }

    public int getTypeOfComponent() {
        return 15;
    }

    public void getAttributes(Vector collector) {
        Tools.removeFromVectorToVector(this.attribsCollector, collector);
    }

    public void getAppInformations(Vector collector) {
        Tools.removeFromVectorToVector(this.appInfosCollector, collector);
    }

    public void getUserInformations(Vector collector) {
        Tools.removeFromVectorToVector(this.usrInfosCollector, collector);
    }

    public Node[] getAttributesArray() {
        return this.createArray(this.attribsCollector);
    }

    public Node[] getAppInformationsArray() {
        return this.createArray(this.appInfosCollector);
    }

    public Node[] getUserInformationsArray() {
        return this.createArray(this.usrInfosCollector);
    }

    private Node[] createArray(Vector collector) {
        Object[] result = new Node[collector.size()];
        collector.copyInto(result);
        return result;
    }

    public boolean match(Base annotation) {
        if (!super.match(annotation)) {
            return false;
        }
        AnnotationImpl annotImpl = (AnnotationImpl)annotation;
        Vector attribsOfTheTargetAnnot = annotImpl.attribsCollector;
        if (this.attribsCollector.size() != attribsOfTheTargetAnnot.size()) {
            return false;
        }
        boolean[] checked = new boolean[attribsOfTheTargetAnnot.size()];
        int i = 0;
        while (i < this.attribsCollector.size()) {
            Attr attr = (Attr)this.attribsCollector.get(i);
            boolean found = false;
            int j = 0;
            while (j < attribsOfTheTargetAnnot.size()) {
                Attr targetAttr;
                if (!checked[j] && DOM.areEquivalent(attr, targetAttr = (Attr)attribsOfTheTargetAnnot.get(i))) {
                    checked[j] = true;
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            NamedNodeMap namedNodeMap = this.associatedNode.getAttributes();
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String attribUri = attr.getNamespaceURI();
                if (attribUri != null && !attribUri.equals("") || !attr.getLocalName().equals("id")) {
                    this.attribsCollector.add(attr);
                }
                ++i;
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i2 = 0;
            while (i2 < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i2);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("appinfo")) {
                        this.appInfosCollector.add(node);
                    } else if (nodeLocalName.equals("documentation")) {
                        this.usrInfosCollector.add(node);
                    }
                }
                ++i2;
            }
        }
    }

    public BaseImpl clone(Hashtable typesCollector) {
        return this;
    }
}

