/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl;

import com.sap.engine.lib.jaxp.MultiSource;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerImpl;
import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Loader;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaForSchemaEntityResolver;
import com.sap.engine.lib.schema.components.impl.SchemaInfo;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.DOMParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LoaderImpl
implements Loader,
Constants {
    private EntityResolver entityResolver;
    private URIResolver uriResolver;
    private Vector schemaInfosCollector_Location;
    private Hashtable schemaInfosCollector_Namespace;
    private DOMParser parser;
    private TransformerImpl transformer;
    private SchemaImpl schema;
    private boolean validateSchemaDOM;
    private SchemaImpl schemaForSchema;

    public void setValidateSchemaDOM(boolean validateSchemaDOM) {
        this.validateSchemaDOM = validateSchemaDOM;
    }

    public boolean getValidateSchemaDOM() {
        return this.validateSchemaDOM;
    }

    public Schema load(String location) throws SchemaComponentException {
        try {
            this.init();
            this.resolveSchemaInfos(null, location, null, null, null);
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var4_3 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(String namespace, String location) throws SchemaComponentException {
        try {
            this.init();
            this.resolveSchemaInfos(null, location, null, null, namespace);
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var5_4 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(String[] locations) throws SchemaComponentException {
        try {
            this.init();
            int i = 0;
            while (i < locations.length) {
                this.resolveSchemaInfos(null, locations[i], null, null, null);
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var5_4 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(String[] namespaces, String[] locations) throws SchemaComponentException {
        if (namespaces.length != locations.length) {
            throw new SchemaComponentException("ERROR : The count of namespaces has to be equal to the count of locations.");
        }
        try {
            this.init();
            int i = 0;
            while (i < locations.length) {
                this.resolveSchemaInfos(null, locations[i], null, null, namespaces[i]);
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var6_5 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(Node node) throws SchemaComponentException {
        try {
            this.init();
            this.resolveSchemaInfo(node, null, null, null, null);
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var4_3 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(Node[] nodes) throws SchemaComponentException {
        try {
            this.init();
            int i = 0;
            while (i < nodes.length) {
                this.resolveSchemaInfo(nodes[i], null, null, null, null);
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var5_4 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(Source source) throws SchemaComponentException {
        try {
            this.init();
            this.resolveSchemaInfos(source, null, null, null);
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var4_3 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(Source[] sources) throws SchemaComponentException {
        try {
            this.init();
            int i = 0;
            while (i < sources.length) {
                this.resolveSchemaInfos(sources[i], null, null, null);
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var5_4 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(InputStream inputStream) throws SchemaComponentException {
        try {
            this.init();
            this.resolveSchemaInfo(new InputSource(inputStream), null, null, null);
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var4_3 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(InputStream[] inputStreams) throws SchemaComponentException {
        try {
            this.init();
            int i = 0;
            while (i < inputStreams.length) {
                this.resolveSchemaInfo(new InputSource(inputStreams[i]), null, null, null);
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var5_4 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(InputSource inputSource) throws SchemaComponentException {
        try {
            this.init();
            this.resolveSchemaInfo(inputSource, null, null, null);
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var4_3 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(InputSource[] inputSources) throws SchemaComponentException {
        try {
            this.init();
            int i = 0;
            while (i < inputSources.length) {
                this.resolveSchemaInfo(inputSources[i], null, null, null);
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var5_4 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(File file) throws SchemaComponentException {
        try {
            this.init();
            this.resolveSchemaInfos(null, this.retriveSchemaLocation(file), null, null, null);
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var4_3 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finish();
            throw throwable;
        }
    }

    public Schema load(File[] files) throws SchemaComponentException {
        try {
            this.init();
            int i = 0;
            while (i < files.length) {
                this.resolveSchemaInfos(null, this.retriveSchemaLocation(files[i]), null, null, null);
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var5_4 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finish();
            throw throwable;
        }
    }

    public void importSchemaInfo(String parentLocation, String location, String namespace) throws SchemaComponentException {
        this.resolveSchemaInfos(parentLocation, location, namespace, null, namespace);
    }

    public void includeSchemaInfo(String parentLocation, String location, String parentNamespace) throws SchemaComponentException {
        this.resolveSchemaInfos(parentLocation, location, parentNamespace, parentNamespace, null);
    }

    public void redefineSchemaInfo(String parentLocation, String location, String parentNamespace) throws SchemaComponentException {
        this.includeSchemaInfo(parentLocation, location, parentNamespace);
    }

    public void resolveQualifiedBase(String namespace, String name, int type) throws SchemaComponentException {
        try {
            Vector<SchemaInfo> schemaInfosCollector = (Vector<SchemaInfo>)this.schemaInfosCollector_Namespace.get(namespace);
            if (schemaInfosCollector != null) {
                int i = 0;
                while (i < schemaInfosCollector.size()) {
                    SchemaInfo schemaInfo = (SchemaInfo)schemaInfosCollector.get(i);
                    schemaInfo.transfer(namespace, name, type);
                    ++i;
                }
            } else if (this.uriResolver != null) {
                schemaInfosCollector = new Vector<SchemaInfo>();
                this.schemaInfosCollector_Namespace.put(namespace, schemaInfosCollector);
                Source source = this.uriResolver.resolve(namespace, "xsd://");
                if (source == null) {
                    throw new SchemaComponentException("ERROR : Trying to resolve qualified base {" + namespace + "} : " + name + ", but the uri resolver is not able to resolve the relevant namespace.");
                }
                Source[] sources = null;
                if (source instanceof MultiSource) {
                    MultiSource multiSource = (MultiSource)source;
                    sources = multiSource.getSources();
                } else {
                    sources = new Source[]{source};
                }
                DOMResult domResult = new DOMResult();
                TransformerImpl transformer = this.determineTransformer();
                int i = 0;
                while (i < sources.length) {
                    String location = sources[i].getSystemId();
                    String canonicalizedLocation = this.canonicalizeLocation(location);
                    domResult.setNode(null);
                    transformer.transform(sources[i], domResult);
                    SchemaInfo schemaInfo = new SchemaInfo(this.retriveElement(domResult.getNode()), this.schema, this, canonicalizedLocation, location, true);
                    schemaInfo.resolve();
                    schemaInfo.transfer(namespace, name, type);
                    schemaInfosCollector.add(schemaInfo);
                    ++i;
                }
            }
        }
        catch (Throwable tr) {
            if (tr instanceof SchemaComponentException) {
                throw (SchemaComponentException)tr;
            }
            throw new SchemaComponentException(tr);
        }
    }

    public Schema load(Object schemaObj) throws SchemaComponentException {
        Schema result = null;
        if (schemaObj instanceof String) {
            result = this.load((String)schemaObj);
        } else if (schemaObj instanceof String[]) {
            result = this.load((String[])schemaObj);
        } else if (schemaObj instanceof Node) {
            result = this.load((Node)schemaObj);
        } else if (schemaObj instanceof Node[]) {
            result = this.load((Node[])schemaObj);
        } else if (schemaObj instanceof InputStream) {
            result = this.load((InputStream)schemaObj);
        } else if (schemaObj instanceof InputStream[]) {
            result = this.load((InputStream[])schemaObj);
        } else if (schemaObj instanceof InputSource) {
            result = this.load((InputSource)schemaObj);
        } else if (schemaObj instanceof InputSource[]) {
            result = this.load((InputSource[])schemaObj);
        } else if (schemaObj instanceof File) {
            result = this.load((File)schemaObj);
        } else if (schemaObj instanceof File[]) {
            result = this.load((File[])schemaObj);
        } else if (schemaObj instanceof Source) {
            result = this.load((Source)schemaObj);
        } else if (schemaObj instanceof Source[]) {
            result = this.load((Source[])schemaObj);
        } else if (schemaObj instanceof String[][]) {
            String[][] namespacesAndLocations = (String[][])schemaObj;
            result = this.load(namespacesAndLocations[0], namespacesAndLocations[1]);
        } else if (schemaObj instanceof Object[]) {
            result = this.load((Object[])schemaObj);
        } else {
            throw new SchemaComponentException("Unable to load schema. Schema source object with class : " + schemaObj.getClass().getName() + " is not supported.");
        }
        return result;
    }

    public Schema load(Object[] schemaSources) throws SchemaComponentException {
        try {
            this.init();
            int i = 0;
            while (i < schemaSources.length) {
                int j;
                Object[] schemaSources1;
                Object schemaSource = schemaSources[i];
                if (schemaSource instanceof String) {
                    this.resolveSchemaInfos(null, (String)schemaSource, null, null, null);
                } else if (schemaSource instanceof String[]) {
                    schemaSources1 = (String[])schemaSource;
                    j = 0;
                    while (j < schemaSources1.length) {
                        this.resolveSchemaInfos(null, (String)schemaSources1[i], null, null, null);
                        ++j;
                    }
                } else if (schemaSource instanceof Node) {
                    this.resolveSchemaInfo((Node)schemaSource, null, null, null, null);
                } else if (schemaSource instanceof Node[]) {
                    schemaSources1 = (Node[])schemaSource;
                    j = 0;
                    while (j < schemaSources1.length) {
                        this.resolveSchemaInfo((Node)schemaSources1[j], null, null, null, null);
                        ++j;
                    }
                } else if (schemaSource instanceof Source) {
                    this.resolveSchemaInfos((Source)schemaSource, null, null, null);
                } else if (schemaSource instanceof Source[]) {
                    schemaSources1 = (Source[])schemaSource;
                    j = 0;
                    while (j < schemaSources1.length) {
                        this.resolveSchemaInfos((Source)schemaSources1[j], null, null, null);
                        ++j;
                    }
                } else if (schemaSource instanceof InputStream) {
                    this.resolveSchemaInfo(new InputSource((InputStream)schemaSource), null, null, null);
                } else if (schemaSource instanceof InputStream[]) {
                    schemaSources1 = (InputStream[])schemaSource;
                    j = 0;
                    while (j < schemaSources1.length) {
                        this.resolveSchemaInfo(new InputSource((InputStream)schemaSources1[j]), null, null, null);
                        ++j;
                    }
                } else if (schemaSource instanceof InputSource) {
                    this.resolveSchemaInfo((InputSource)schemaSource, null, null, null);
                } else if (schemaSource instanceof InputSource[]) {
                    schemaSources1 = (InputSource[])schemaSource;
                    j = 0;
                    while (j < schemaSources1.length) {
                        this.resolveSchemaInfo((InputSource)schemaSources1[j], null, null, null);
                        ++j;
                    }
                } else if (schemaSource instanceof File) {
                    this.resolveSchemaInfos(null, this.retriveSchemaLocation((File)schemaSource), null, null, null);
                } else if (schemaSource instanceof File[]) {
                    schemaSources1 = (File[])schemaSource;
                    j = 0;
                    while (j < schemaSources1.length) {
                        this.resolveSchemaInfos(null, this.retriveSchemaLocation((File)schemaSources1[j]), null, null, null);
                        ++j;
                    }
                } else {
                    throw new SchemaComponentException("Unable to load schema. Schema source object with class : " + schemaSource.getClass().getName() + " is not supported.");
                }
                ++i;
            }
            this.schema.load();
            SchemaImpl schemaImpl = this.schema;
            Object var7_6 = null;
            this.finish();
            return schemaImpl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.finish();
            throw throwable;
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    private void init() {
        this.schemaInfosCollector_Location = new Vector();
        this.schemaInfosCollector_Namespace = new Hashtable();
        this.schema = new SchemaImpl();
    }

    private void finish() {
        this.schemaInfosCollector_Location = null;
        this.schemaInfosCollector_Namespace = null;
        this.schema = null;
    }

    private void resolveSchemaInfo(SchemaInfo schemaInfo) throws SchemaComponentException {
        String location;
        BaseInfo baseInfo = schemaInfo.getBaseInfo();
        String namespace = baseInfo.getTargetNamespace();
        String registrationKey = this.createSchemaInfoRegistrationKey(namespace, location = baseInfo.getLocation());
        if (registrationKey != null) {
            this.schemaInfosCollector_Location.add(registrationKey);
        }
        schemaInfo.resolve();
    }

    private String createSchemaInfoRegistrationKey(String namespace, String location) {
        return location == null || namespace == null ? null : "<" + namespace + "> : " + location;
    }

    private String canonicalizeLocation(String location) {
        String result = null;
        if (location != null) {
            if (location.startsWith("http:")) {
                int index = "http:".length();
                while (location.charAt(index++) == '/' && index < location.length()) {
                }
                result = "http://" + location.substring(index - 1);
            } else if (location.startsWith("file:")) {
                int index = "file:".length();
                while (location.charAt(index++) == '/' && index < location.length()) {
                }
                result = "file://" + location.substring(index - 1);
            } else {
                result = "file://" + location;
            }
            result = result.replace('\\', '/');
        }
        return result;
    }

    private String retriveSchemaLocation(File file) throws SchemaComponentException {
        String schemaLocation = null;
        try {
            schemaLocation = file.getCanonicalPath();
        }
        catch (IOException ioExc) {
            throw new SchemaComponentException("ERROR : An error occured while tring to retrieve schema location. Error message is : " + ioExc.getMessage());
        }
        return schemaLocation;
    }

    private TransformerImpl determineTransformer() throws SchemaComponentException {
        if (this.transformer == null) {
            TransformerFactoryImpl tf = new TransformerFactoryImpl();
            try {
                this.transformer = (TransformerImpl)((TransformerFactory)tf).newTransformer();
            }
            catch (TransformerConfigurationException transformernConfigExc) {
                throw new SchemaComponentException(transformernConfigExc);
            }
        }
        return this.transformer;
    }

    private void resolveSchemaInfo(Node node, String canonicalizedLocation, String location, String namespaceToSet, String namespaceToResolve) throws SchemaComponentException {
        try {
            String nodeLocation;
            String schemaInfoLocation = location;
            String schemaInfoCanonicalizedLocation = canonicalizedLocation;
            URL nodeURL = DOM.getLocation(node);
            String string = nodeLocation = nodeURL == null ? null : nodeURL.toExternalForm();
            if (schemaInfoLocation == null) {
                schemaInfoLocation = nodeLocation;
            }
            if (schemaInfoCanonicalizedLocation == null) {
                schemaInfoCanonicalizedLocation = this.canonicalizeLocation(nodeLocation);
            }
            SchemaInfo schemaInfo = this.createSchemaInfo(this.retriveElement(node), schemaInfoCanonicalizedLocation, schemaInfoLocation, namespaceToSet, namespaceToResolve);
            this.resolveSchemaInfo(schemaInfo);
        }
        catch (Throwable tr) {
            if (tr instanceof SchemaComponentException) {
                throw (SchemaComponentException)tr;
            }
            throw new SchemaComponentException(tr);
        }
    }

    private void resolveSchemaInfo(InputSource inputSource, String namespaceToImport, String namespaceToSet, String namespaceToResolve) throws SchemaComponentException {
        try {
            String location = inputSource.getSystemId();
            String canonicalizedLocation = this.canonicalizeLocation(location);
            String schemaInfoRegistrationKey = this.createSchemaInfoRegistrationKey(namespaceToImport, canonicalizedLocation);
            if (canonicalizedLocation == null || schemaInfoRegistrationKey == null || !this.schemaInfosCollector_Location.contains(schemaInfoRegistrationKey)) {
                Element schemaElement = this.retriveElement(inputSource);
                SchemaInfo schemaInfo = this.createSchemaInfo(schemaElement, canonicalizedLocation, location, namespaceToSet, namespaceToResolve);
                this.resolveSchemaInfo(schemaInfo);
            }
        }
        catch (Throwable tr) {
            if (tr instanceof SchemaComponentException) {
                throw (SchemaComponentException)tr;
            }
            throw new SchemaComponentException(tr);
        }
    }

    private void resolveSchemaInfos(String parentLocation, String location, String namespaceToImport, String namespaceToSet, String namespaceToResolve) throws SchemaComponentException {
        try {
            if (this.uriResolver != null) {
                String base = parentLocation == null ? "xsd://" : parentLocation;
                Source source = this.uriResolver.resolve(location, base);
                if (source == null) {
                    throw new SchemaComponentException("ERROR : The uri resolver is not able to resolve a source from location " + location + " and base " + base + ".");
                }
                this.resolveSchemaInfos(source, namespaceToImport, namespaceToSet, namespaceToResolve);
            } else {
                InputSource inputSource = this.retriveInputSource(parentLocation, location);
                this.resolveSchemaInfo(inputSource, namespaceToImport, namespaceToSet, namespaceToResolve);
            }
        }
        catch (Throwable tr) {
            if (tr instanceof SchemaComponentException) {
                throw (SchemaComponentException)tr;
            }
            throw new SchemaComponentException(tr);
        }
    }

    private void resolveSchemaInfos(Source source, String namespaceToImport, String namespaceToSet, String namespaceToResolve) throws SchemaComponentException {
        Source[] sources = null;
        if (source instanceof MultiSource) {
            MultiSource multiSource = (MultiSource)source;
            sources = multiSource.getSources();
        } else {
            sources = new Source[]{source};
        }
        DOMResult domResult = new DOMResult();
        int i = 0;
        while (i < sources.length) {
            Source schemaSource = sources[i];
            String location = schemaSource.getSystemId();
            String canonicalizedLocation = this.canonicalizeLocation(location);
            String schemaInfoRegistrationKey = this.createSchemaInfoRegistrationKey(namespaceToImport, canonicalizedLocation);
            domResult.setNode(null);
            if (canonicalizedLocation == null || schemaInfoRegistrationKey == null || !this.schemaInfosCollector_Location.contains(schemaInfoRegistrationKey)) {
                Node node = null;
                if (schemaSource instanceof DOMSource) {
                    node = ((DOMSource)schemaSource).getNode();
                } else {
                    try {
                        this.determineTransformer().transform(schemaSource, domResult);
                    }
                    catch (TransformerException transformerExc) {
                        throw new SchemaComponentException("[location : '" + canonicalizedLocation + "'] ERROR : " + transformerExc.getMessage());
                    }
                    node = domResult.getNode();
                }
                this.resolveSchemaInfo(node, canonicalizedLocation, location, namespaceToSet, namespaceToResolve);
            }
            ++i;
        }
    }

    private SchemaInfo createSchemaInfo(Element schemaElement, String canonicalizedLocation, String location, String namespaceToSet, String namespaceToResolve) throws SchemaComponentException {
        SchemaInfo schemaInfo = new SchemaInfo(schemaElement, this.schema, this, canonicalizedLocation, location, false);
        if (namespaceToSet != null) {
            schemaInfo.setTargetNamespace(namespaceToSet);
        } else if (namespaceToResolve != null && !schemaInfo.getBaseInfo().getTargetNamespace().equals(namespaceToResolve)) {
            throw new SchemaComponentException("[location : '" + schemaInfo.getBaseInfo().getLocation() + "'] ERROR : Target namespace is not equal to namespace '" + namespaceToResolve + "'.");
        }
        return schemaInfo;
    }

    private InputSource retriveInputSource(String parentLocation, String location) throws SchemaComponentException {
        return Tools.retrieveInputSource(this.entityResolver, parentLocation, location);
    }

    private DOMParser determineParser() throws SchemaComponentException {
        if (this.parser == null) {
            try {
                this.parser = new DOMParser();
                this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception exc) {
                throw new SchemaComponentException(exc);
            }
        }
        return this.parser;
    }

    private SchemaImpl determineSchemaForSchema() throws SchemaComponentException {
        if (this.schemaForSchema == null) {
            LoaderImpl loader = new LoaderImpl();
            loader.setEntityResolver(new SchemaForSchemaEntityResolver());
            this.schemaForSchema = (SchemaImpl)loader.load("XMLSchema.xsd");
        }
        return this.schemaForSchema;
    }

    private Element retriveElement(InputSource inputSource) throws SchemaComponentException {
        try {
            DOMParser parser = this.determineParser();
            parser.setFeature("http://xml.org/sax/features/validation", this.validateSchemaDOM);
            if (this.validateSchemaDOM) {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.setProperty("http://apache.org/xml/properties/schema/schemaObject", this.determineSchemaForSchema());
            }
            return parser.parse(inputSource).getDocumentElement();
        }
        catch (Throwable tr) {
            if (tr instanceof SchemaComponentException) {
                throw (SchemaComponentException)tr;
            }
            throw new SchemaComponentException(tr);
        }
    }

    private Element retriveElement(Node node) {
        Element result = null;
        if (node instanceof Element) {
            result = (Element)node;
        } else if (node instanceof Document) {
            Document doc = (Document)node;
            result = doc.getDocumentElement();
        }
        return result;
    }
}

