/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jaxp;

import com.sap.engine.lib.jaxp.DTMSource;
import com.sap.engine.lib.jaxp.DocHandlerResult;
import com.sap.engine.lib.jaxp.EmptyErrorListener;
import com.sap.engine.lib.jaxp.InstanceManager;
import com.sap.engine.lib.jaxp.MultiSource;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.SchemaComponentResult;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.DOMDocHandler1;
import com.sap.engine.lib.xml.dom.DOMImplementationImpl;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.SAXParser;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.handlers.SAXDocHandler;
import com.sap.engine.lib.xml.util.DOMToDocHandler;
import com.sap.engine.lib.xml.util.DTMToDocHandler;
import com.sap.engine.lib.xml.util.NamespaceAppender;
import com.sap.engine.lib.xml.util.SAXToDocHandler;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import com.sap.engine.lib.xsl.xslt.output.DocHandlerSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public final class TransformerImpl
extends Transformer {
    private static final boolean ALLOW_RESTRICTED_XPATH_EXPRESSION_IN_THE_END_OF_URLS = true;
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.engine.lib.jaxp.Res", new Locale("", ""));
    public static final Properties DEFAULT_OUTPUT_PROPERTIES = new Properties();
    public static final String TARGET_NS_ATTRIB_NAME = "targetNamespace";
    private Properties outputProperties = new Properties(DEFAULT_OUTPUT_PROPERTIES);
    private Properties explProperties = new Properties();
    private Properties templProperties = new Properties();
    private ErrorListener errorListener = new EmptyErrorListener();
    private Hashtable parameters = new Hashtable();
    private URIResolver uriResolver = null;
    private XSLStylesheet sheet;
    private XMLParser xmlParser;
    private DOMParser domParser;
    private SAXParser saxParser;
    private DocHandlerSerializer serializer = InstanceManager.getDocHandlerSerializer();
    private DocHandler nsa = new NamespaceAppender(this.serializer);
    private DOMToDocHandler domToDocHandler = new DOMToDocHandler();
    private DOMImplementation domImplementation = null;
    private InputSource inputSource = new InputSource();
    private String lastSystemIdProcessed = null;
    private boolean inUse = false;
    private Stack tStack;

    protected XMLParser getXMLParser() throws Exception {
        if (this.xmlParser == null) {
            try {
                this.xmlParser = new XMLParser();
                this.xmlParser.setFeature("http://xml.org/sax/features/namespaces", true);
                this.xmlParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this.domParser = new DOMParser(this.xmlParser);
                this.saxParser = new SAXParser(this.xmlParser);
            }
            catch (Exception e) {
                throw new TransformerConfigurationException(e);
            }
        }
        return this.xmlParser;
    }

    private Properties mergeProperties() {
        Object next;
        Properties p = (Properties)((Hashtable)DEFAULT_OUTPUT_PROPERTIES).clone();
        Enumeration e = ((Hashtable)this.templProperties).keys();
        while (e.hasMoreElements()) {
            next = e.nextElement();
            p.setProperty((String)next, this.templProperties.getProperty((String)next));
        }
        e = ((Hashtable)this.explProperties).keys();
        while (e.hasMoreElements()) {
            next = e.nextElement();
            p.setProperty((String)next, this.explProperties.getProperty((String)next));
        }
        return p;
    }

    protected TransformerImpl(XSLStylesheet sheet, Properties outputProperties, URIResolver uriResolver) throws TransformerConfigurationException {
        if (sheet == null) {
            return;
        }
        this.sheet = sheet;
        this.templProperties = (Properties)((Hashtable)outputProperties).clone();
        this.outputProperties = this.mergeProperties();
        this.setURIResolver(uriResolver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source source, Result result) throws TransformerException {
        block13: {
            if (this.tStack != null) {
                if (this.inUse) {
                    throw new TransformerException("Transformer is inUse. You have probbably selected 'http://sap.com/java/xslt/transformer-reuse' option, and the transformer has still not finished computation");
                }
                this.inUse = true;
            }
            try {
                if (source == null) {
                    throw new IllegalArgumentException(res.getString("XML_Source_is_null_"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(res.getString("Result_is_null_"));
                }
                if (result instanceof SchemaComponentResult) {
                    SchemaComponentResult schemaCompResult = (SchemaComponentResult)result;
                    try {
                        result.setSystemId(source.getSystemId());
                        Source[] sources = null;
                        sources = source instanceof MultiSource ? ((MultiSource)source).getSources() : new Source[]{source};
                        LoaderImpl loader = new LoaderImpl();
                        loader.setUriResolver(this.uriResolver);
                        Schema schema = loader.load(sources);
                        schemaCompResult.setSchema(schema);
                        schemaCompResult.setSystemId(source.getSystemId());
                        Object var8_10 = null;
                        if (this.tStack == null) return;
                        this.inUse = false;
                        this.tStack.push(this);
                        return;
                    }
                    catch (Exception sce) {
                        throw new TransformerException(sce);
                    }
                }
                try {
                    if (this.sheet == null) {
                        this.transformSimple(source, result);
                        break block13;
                    }
                    this.transformWithStylesheet(source, result);
                }
                catch (TransformerException e) {
                    this.errorListener.fatalError(e);
                }
                catch (Exception e) {
                    this.errorListener.fatalError(new TransformerException(e));
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (this.tStack == null) throw throwable;
                this.inUse = false;
                this.tStack.push(this);
                throw throwable;
            }
        }
        Object var8_11 = null;
        if (this.tStack == null) return;
        this.inUse = false;
        this.tStack.push(this);
    }

    private void transformSimple(Source source, Result result) throws Exception {
        DocHandler handler = this.getDocHandlerFor(result);
        this.invokeDocHandlerMethodsFor(source, handler);
        this.considerXPointer(source, result);
    }

    private void considerXPointer(Source source, Result result) {
        String s = source.getSystemId();
        if (s == null) {
            return;
        }
        int indexOfSharp = s.indexOf(35);
        if (indexOfSharp == -1) {
            return;
        }
        if (!(result instanceof DOMResult)) {
            return;
        }
        DOMResult domResult = (DOMResult)result;
        Node node = domResult.getNode();
        if (node == null) {
            return;
        }
        if ((s = s.substring(indexOfSharp + 1)).startsWith("xpointer(") && s.endsWith(")")) {
            s = s.substring("xpointer(".length(), s.length() - 1);
        }
        if ((node = DOM.toNode(s, node)) == null) {
            return;
        }
        domResult.setNode(node);
    }

    private void transformWithStylesheet(Source source, Result result) throws Exception {
        DocHandler inputHandler;
        if (source.getSystemId() != null) {
            this.sheet.setSourceBaseURI(source.getSystemId());
        }
        if (source instanceof StreamSource) {
            StreamSource s = (StreamSource)source;
            String systemId = s.getSystemId();
            InputStream inputStream = s.getInputStream();
            Reader reader = s.getReader();
            if (inputStream != null) {
                this.inputSource.setByteStream(inputStream);
            } else if (reader != null) {
                this.inputSource.setCharacterStream(reader);
            } else if (systemId != null) {
                this.inputSource.setSystemId(systemId);
            } else {
                throw new TransformerException("Could not load StreamSource: InputStream, Reader and SystemId are null");
            }
            if (this.inputSource.getSystemId() != null && !systemId.equals(this.lastSystemIdProcessed)) {
                this.getXMLParser().parse(systemId, this.sheet.getInputHandler(systemId));
                this.lastSystemIdProcessed = systemId;
            } else if (this.inputSource.getSystemId() != null && systemId.equals(this.lastSystemIdProcessed)) {
                this.sheet.reuseLastSource();
            } else {
                DocHandler inputHandler2 = this.sheet.getInputHandler();
                try {
                    this.getXMLParser().parse(this.inputSource, inputHandler2);
                }
                catch (IOException ioe) {
                    this.errorListener.error(new TransformerException("IOException occurred while parsing stream. An empty document will be used!", ioe));
                    inputHandler2.startDocument();
                    inputHandler2.endDocument();
                }
            }
        } else if (source instanceof DOMSource) {
            inputHandler = this.sheet.getInputHandler();
            Node node = ((DOMSource)source).getNode();
            if (node == null) {
                throw new TransformerException(res.getString("DOMSource_whose_Node"));
            }
            this.domToDocHandler.process(node, inputHandler);
        } else if (source instanceof SAXSource) {
            InputSource inputSource;
            inputHandler = this.sheet.getInputHandler();
            SAXSource s = (SAXSource)source;
            XMLReader xmlReader = s.getXMLReader();
            if (xmlReader == null) {
                this.getXMLParser();
                xmlReader = this.saxParser;
            }
            if ((inputSource = s.getInputSource()) == null) {
                throw new TransformerException(res.getString("SAXSource_whose"));
            }
            SAXToDocHandler saxToDocHandler = new SAXToDocHandler(inputHandler);
            xmlReader.setContentHandler(saxToDocHandler);
            xmlReader.setDTDHandler(saxToDocHandler);
            xmlReader.setErrorHandler(saxToDocHandler);
            xmlReader.parse(inputSource);
        } else {
            throw new TransformerException(res.getString("Only_input_from"));
        }
        DocHandler handler = this.getDocHandlerFor(result);
        if (handler == null) {
            throw new TransformerException(res.getString("Unable_to_create_SAX"));
        }
        this.sheet.process(handler);
    }

    public void setOutputProperty(String s, String s1) throws IllegalArgumentException {
        if (s == null || s1 == null || !((Hashtable)DEFAULT_OUTPUT_PROPERTIES).containsKey(s)) {
            throw new IllegalArgumentException();
        }
        this.explProperties.setProperty(s, s1);
        this.outputProperties = this.mergeProperties();
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.outputProperties).clone();
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
        if (this.sheet != null) {
            this.sheet.setURIResolver(uriResolver == null ? this.sheet.getDefaultResolver() : uriResolver);
        }
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            ((Hashtable)this.explProperties).clear();
            this.mergeProperties();
            return;
        }
        Enumeration e = ((Hashtable)properties).keys();
        while (e.hasMoreElements()) {
            String a = "";
            try {
                a = (String)e.nextElement();
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("ClassCast exception:" + ex);
            }
            if (((Hashtable)DEFAULT_OUTPUT_PROPERTIES).containsKey(a)) continue;
            throw new IllegalArgumentException();
        }
        ((Hashtable)this.outputProperties).putAll(properties);
    }

    public void clearParameters() {
        this.parameters.clear();
        if (this.sheet != null) {
            this.sheet.clearParameters();
        }
    }

    public Object getParameter(String s) {
        return this.parameters.get(s);
    }

    public void setParameter(String s, Object obj) {
        this.parameters.put(s, obj);
        if (this.sheet != null) {
            this.sheet.setParameters(this.parameters);
        }
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException();
        }
        this.errorListener = errorListener;
        if (this.sheet != null) {
            this.sheet.setErrorListener(errorListener);
        }
    }

    public String getOutputProperty(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        String r = this.outputProperties.getProperty(s);
        if (r == null) {
            throw new IllegalArgumentException();
        }
        return r;
    }

    private DocHandler getDocHandlerFor(Result result) throws Exception {
        DocHandler handler = null;
        if (result instanceof StreamResult) {
            StreamResult r = (StreamResult)result;
            this.serializer.setOutputProperties(this.outputProperties);
            if (r.getOutputStream() != null) {
                this.serializer.setOutputStream(r.getOutputStream());
                this.serializer.setCloseOnEnd(false);
            } else if (r.getWriter() != null) {
                this.serializer.setWriter(r.getWriter());
                this.serializer.setCloseOnEnd(false);
            } else if (r.getSystemId() != null) {
                File dir;
                String systemId = r.getSystemId();
                if (systemId.startsWith("file:")) {
                    int slashCount = 0;
                    int protocolLength = "file:".length();
                    int len = systemId.length();
                    while (systemId.charAt(protocolLength + slashCount) == '/') {
                        if (protocolLength + ++slashCount < len) continue;
                        throw new TransformerException("Cannot create file: " + systemId);
                    }
                    systemId = systemId.substring(protocolLength + slashCount);
                    if (slashCount % 2 == 0) {
                        systemId = "\\\\" + systemId;
                    } else if (systemId.charAt(1) != ':') {
                        systemId = "/" + systemId;
                    }
                }
                if ((dir = new File(systemId).getParentFile()) != null) {
                    dir.mkdirs();
                }
                FileOutputStream out = new FileOutputStream(systemId);
                this.serializer.setOutputStream(out);
                this.serializer.setCloseOnEnd(true);
            } else {
                throw new TransformerException(res.getString("StreamResult_whose"));
            }
            handler = this.nsa;
        } else if (result instanceof SAXResult) {
            SAXResult r = (SAXResult)result;
            ContentHandler contentHandler = r.getHandler();
            LexicalHandler lexicalHandler = r.getLexicalHandler();
            SAXDocHandler sdh = new SAXDocHandler();
            if (contentHandler != null) {
                sdh.setContentHandler(contentHandler);
            }
            if (lexicalHandler != null) {
                sdh.setLexicalHandler(lexicalHandler);
            }
            handler = sdh;
        } else if (result instanceof DOMResult) {
            DOMDocHandler1 ddh;
            DOMResult dr = (DOMResult)result;
            if (dr.getNode() == null) {
                this.ensureDOMImplementation();
                dr.setNode(this.domImplementation.createDocument(null, null, null));
            }
            handler = ddh = new DOMDocHandler1(dr.getNode());
        } else {
            if (result instanceof DocHandlerResult) {
                return ((DocHandlerResult)result).getDocHandler();
            }
            throw new TransformerException(res.getString("Only_output_to"));
        }
        return handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeDocHandlerMethodsFor(Source source, DocHandler handler) throws Exception {
        if (source instanceof StreamSource) {
            StreamSource s = (StreamSource)source;
            String systemId = s.getSystemId();
            if (systemId != null) {
                this.getXMLParser().parse(systemId, handler);
                return;
            } else {
                InputStream inputStream = s.getInputStream();
                if (inputStream != null) {
                    this.getXMLParser().parse(inputStream, handler);
                    return;
                } else {
                    Reader reader = s.getReader();
                    if (reader == null) throw new TransformerException(res.getString("StreamSource_whose"));
                    this.getXMLParser().parse(reader, handler);
                }
            }
            return;
        } else if (source instanceof SAXSource) {
            InputSource inputSource;
            SAXSource s = (SAXSource)source;
            XMLReader xmlReader = s.getXMLReader();
            if (xmlReader == null) {
                this.getXMLParser();
                xmlReader = this.saxParser;
            }
            if ((inputSource = s.getInputSource()) == null) {
                throw new TransformerException(res.getString("SAXSource_whose"));
            }
            this.setHandlerOnXMLReader(new SAXToDocHandler(handler), xmlReader);
            xmlReader.parse(inputSource);
            return;
        } else if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            if (node == null) {
                throw new TransformerException(res.getString("DOMSource_whose_Node"));
            }
            this.domToDocHandler.process(node, handler);
            return;
        } else {
            if (!(source instanceof DTMSource)) throw new TransformerException(res.getString("Only_input_from"));
            new DTMToDocHandler().process(((DTMSource)source).getDTM(), handler);
        }
    }

    private void setHandlerOnXMLReader(Object handler, XMLReader xmlReader) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (handler instanceof ContentHandler) {
            xmlReader.setContentHandler((ContentHandler)handler);
        }
        if (handler instanceof DTDHandler) {
            xmlReader.setDTDHandler((DTDHandler)handler);
        }
        if (handler instanceof DeclHandler) {
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
        }
        if (handler instanceof LexicalHandler) {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
    }

    private void ensureDOMImplementation() {
        if (this.domImplementation == null) {
            this.domImplementation = new DOMImplementationImpl();
        }
    }

    public void setPool(Stack p) {
        this.tStack = p;
    }

    static {
        DEFAULT_OUTPUT_PROPERTIES.setProperty("method", "");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("version", "1.0");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("encoding", "UTF-8");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "no");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("standalone", "yes");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("doctype-public", "");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("doctype-system", "");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("cdata-section-elements", "");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("indent", "no");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("media-type", "text/xml");
    }
}

