/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xpath;

import com.inqmy.lib.xsl.xpath.IntSetIterator;
import com.inqmy.lib.xsl.xpath.SegmentedIntSetIterator;

public final class SegmentedIntSet {
    private static final int initialCapacity = 16;
    private static final int resizeStep = 32;
    protected int size = 0;
    protected int[] ab = new int[32];

    public void clear() {
        this.size = 0;
    }

    public void add(int x) {
        if (this.size == 0 || x > this.ab[1 + 2 * (this.size - 1)] + 1) {
            this.ensureCapacity(this.size + 1);
            int n = x;
            this.ab[1 + 2 * this.size] = n;
            this.ab[2 * this.size] = n;
            ++this.size;
            return;
        }
        if (x == this.ab[1 + 2 * (this.size - 1)] + 1) {
            int n = 1 + 2 * (this.size - 1);
            this.ab[n] = this.ab[n] + 1;
            return;
        }
        this.addInterval(x, x);
    }

    public boolean contains(int x) {
        int i = 0;
        while (i < this.size) {
            if (this.ab[2 * i] <= x && x <= this.ab[1 + 2 * i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addInterval(int a, int b) {
        int r;
        if (this.size == 0) {
            this.ab[0] = a;
            this.ab[1] = b;
            this.size = 1;
            return;
        }
        int indexA = this.size;
        int indexB = -1;
        int i = 0;
        while (i < this.size) {
            if (a <= this.ab[1 + 2 * i] + 1) {
                indexA = i;
                break;
            }
            ++i;
        }
        int i2 = this.size - 1;
        while (i2 >= 0) {
            if (this.ab[2 * i2] - 1 <= b) {
                indexB = i2;
                break;
            }
            --i2;
        }
        int l = indexA < this.size ? Math.min(a, this.ab[2 * indexA]) : a;
        int n = r = indexB > -1 ? Math.max(b, this.ab[1 + 2 * indexB]) : b;
        if (indexA > indexB) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            int i3 = this.size - 1;
            while (i3 > indexA) {
                this.ab[2 * i3] = this.ab[2 * (i3 - 1)];
                this.ab[1 + 2 * i3] = this.ab[1 + 2 * (i3 - 1)];
                --i3;
            }
        } else if (indexA < indexB) {
            int i4 = 0;
            while (indexB + i4 < this.size) {
                this.ab[2 * (indexA + i4)] = this.ab[2 * (indexB + i4)];
                this.ab[1 + 2 * (indexA + i4)] = this.ab[1 + 2 * (indexB + i4)];
                ++i4;
            }
            this.size -= indexB - indexA;
        }
        this.ab[2 * indexA] = l;
        this.ab[1 + 2 * indexA] = r;
    }

    public void remove(int x) {
        this.removeInterval(x, x);
        if (this.size == 0 || x < this.ab[0] || x > this.ab[3]) {
            return;
        }
        int i = 0;
        while (i < this.size) {
            if (this.ab[2 * i] <= x && x <= this.ab[1 + 2 * i]) {
                if (this.ab[2 * i] == this.ab[1 + 2 * i]) {
                    this.deleteAt(i);
                    return;
                }
                if (this.ab[2 * i] == x) {
                    int n = 2 * i;
                    this.ab[n] = this.ab[n] + 1;
                } else if (this.ab[1 + 2 * i] == x) {
                    int n = 1 + 2 * i;
                    this.ab[n] = this.ab[n] - 1;
                } else {
                    this.insertAt(i);
                    this.ab[2 * i] = this.ab[2 * (i + 1)];
                    this.ab[1 + 2 * i] = x - 1;
                    this.ab[2 * (i + 1)] = x + 1;
                }
                return;
            }
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int count() {
        int r = 0;
        int i = 0;
        while (i < this.size) {
            r += this.ab[1 + 2 * i] - this.ab[2 * i];
            ++i;
        }
        return r += this.size;
    }

    public void removeInterval(int a, int b) {
        if (this.size == 0 || a > this.ab[1 + 2 * (this.size - 1)] || b < this.ab[0]) {
            return;
        }
        int index0 = 0;
        while (index0 < this.size && this.ab[2 * index0] < a) {
            ++index0;
        }
        int index1 = this.size - 1;
        while (index1 > -1 && b < this.ab[1 + 2 * index1]) {
            --index1;
        }
        if (index0 - index1 == 2) {
            int alphaOld = this.ab[2 * (index0 - 1)];
            int betaOld = this.ab[1 + 2 * (index0 - 1)];
            this.insertAt(index0 - 1);
            this.ab[2 * (index0 - 1)] = alphaOld;
            this.ab[1 + 2 * (index0 - 1)] = a - 1;
            this.ab[2 * index0] = b + 1;
            this.ab[1 + 2 * index0] = betaOld;
            return;
        }
        if (index0 > 0 && a <= this.ab[1 + 2 * (index0 - 1)]) {
            this.ab[1 + 2 * (index0 - 1)] = a - 1;
        }
        if (index1 < this.size - 1 && this.ab[2 * (index1 + 1)] <= b) {
            this.ab[2 * (index1 + 1)] = b + 1;
        }
        if (index0 <= index1) {
            this.deleteRange(index0, index1);
        }
    }

    private void ensureCapacity(int c) {
        if (c > this.ab.length / 2) {
            int[] temp = new int[(c + 32) * 2];
            System.arraycopy(this.ab, 0, temp, 0, this.size);
            this.ab = temp;
        }
    }

    private void insertAt(int p) {
        this.ensureCapacity(this.size + 1);
        ++this.size;
        int i = this.size - 1;
        while (i > p) {
            this.ab[2 * i] = this.ab[2 * (i - 1)];
            this.ab[1 + 2 * i] = this.ab[1 + 2 * (i - 1)];
            --i;
        }
    }

    private void deleteAt(int p) {
        --this.size;
        int i = p;
        while (i < this.size) {
            this.ab[2 * i] = this.ab[2 * (i + 1)];
            this.ab[1 + 2 * i] = this.ab[1 + 2 * (i + 1)];
            ++i;
        }
    }

    private void deleteRange(int p, int q) {
        int d = q - p + 1;
        this.size -= d;
        int i = p;
        while (i < this.size) {
            this.ab[2 * i] = this.ab[2 * (i + d)];
            this.ab[1 + 2 * i] = this.ab[1 + 2 * (i + d)];
            ++i;
        }
    }

    private void collapse(int p, int q) {
        int i = 0;
        while (q + i < this.size) {
            this.ab[2 * (p + i)] = this.ab[2 * (q + i)];
            this.ab[1 + 2 * (p + i)] = this.ab[1 + 2 * (q + i)];
            ++i;
        }
        this.size -= q - p;
    }

    public IntSetIterator iterator() {
        return SegmentedIntSetIterator.getIterator(this);
    }

    public IntSetIterator backIterator() {
        return new SegmentedIntSetBackIterator(this);
    }

    public boolean equals(Object x0) {
        if (!(x0 instanceof SegmentedIntSet)) {
            return false;
        }
        SegmentedIntSet x = (SegmentedIntSet)x0;
        if (this.size != x.size) {
            return false;
        }
        int i = 0;
        while (i < this.size) {
            if (this.ab[2 * i] != x.ab[2 * i] || this.ab[1 + 2 * i] != x.ab[1 + 2 * i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void appendSegment(StringBuffer b, int index) {
        if (this.ab[2 * index] == this.ab[1 + 2 * index]) {
            b.append(this.ab[2 * index]);
        } else {
            b.append(this.ab[2 * index]).append("..").append(this.ab[1 + 2 * index]);
        }
    }

    public int getKth(int k) {
        int i = 0;
        while (i < this.size) {
            int segmentLength = this.ab[1 + 2 * i] - this.ab[2 * i] + 1;
            if (segmentLength < k) {
                k -= segmentLength;
            } else {
                return this.ab[2 * i] + k - 1;
            }
            ++i;
        }
        return -1;
    }

    public int getFirst() {
        return this.ab[0];
    }

    public int getLast() {
        return this.ab[1 + 2 * (this.size - 1)];
    }

    public class SegmentedIntSetBackIterator
    implements IntSetIterator {
        private int index;
        private int current;
        private boolean hn;
        private SegmentedIntSet set;

        SegmentedIntSetBackIterator(SegmentedIntSet set0) {
            this.set = set0;
            if (this.set.size == 0) {
                this.hn = false;
                return;
            }
            this.hn = true;
            this.index = this.set.size - 1;
            this.current = SegmentedIntSet.this.ab[1 + 2 * this.index];
        }

        public boolean hasNext() {
            return this.hn;
        }

        public int next() {
            int r = this.current--;
            if (this.current < this.set.ab[2 * this.index]) {
                --this.index;
                if (this.index < 0) {
                    this.hn = false;
                    return r;
                }
                this.current = this.set.ab[1 + 2 * this.index];
            }
            return r;
        }

        public void close() {
        }
    }
}

