/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xpath;

import com.inqmy.lib.xml.SystemProperties;
import com.inqmy.lib.xsl.xpath.XPathMatcher;
import com.inqmy.lib.xsl.xpath.xobjects.XObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public final class CommandLine {
    private static void usage() {
        System.out.println("InQMy XPath query evaluator, nick_nickolov@yahoo.com");
        System.out.println("Allows you to evaluate from the console multiple XPath expressions");
        System.out.println("with respect to a single XML file.");
        System.out.println();
        System.out.println("Usage: xpath filename.xml");
    }

    public static void main(String[] args) throws Exception {
        SystemProperties.setProperty("javax.xml.parsers.SAXParserFactory", "com.inqmy.lib.jaxp.SAXParserFactoryImpl");
        SystemProperties.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.inqmy.lib.jaxp.DocumentBuilderFactoryImpl");
        SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "com.inqmy.lib.jaxp.TransformerFactoryImpl");
        if (args.length != 1) {
            CommandLine.usage();
            return;
        }
        XPathMatcher matcher = new XPathMatcher(args[0]);
        System.out.println("Type your queries, empty string to exit.");
        System.out.println("If the query starts with 'debug', the expression tree is printed.");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.println();
            System.out.print("QUERY: ");
            String s = in.readLine();
            if (s == null || s.length() == 0) break;
            boolean debugMode = false;
            if (s.startsWith("debug")) {
                debugMode = true;
                s = s.substring(5);
            }
            try {
                XObject xo = matcher.process(s);
                System.out.println(xo.toXString());
            }
            catch (Exception e) {
                CommandLine.printException(e);
            }
            if (!debugMode) continue;
            try {
                matcher.printET(s);
            }
            catch (Exception e) {}
        }
    }

    private static void printException(Exception e) {
        String a = e.getClass().getName();
        int p = a.lastIndexOf(46);
        a = p == -1 ? a : a.substring(p + 1);
        String m = e.getMessage();
        if (m != null) {
            a = a + ": " + m;
        }
        System.out.println(a);
    }
}

