/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml;

import java.util.Properties;

public class SystemProperties {
    private static Properties props = new Properties();

    public static Properties getProperties() {
        Properties result = null;
        try {
            result = System.getProperties();
        }
        catch (SecurityException e) {
            result = props;
        }
        return result;
    }

    public static String getProperty(String key) {
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException e) {
            if (key == null) {
                throw new NullPointerException("key can't be null");
            }
            if (key.equals("")) {
                throw new IllegalArgumentException("key can't be empty");
            }
            result = props.getProperty(key);
        }
        return result;
    }

    public static String getProperty(String key, String def) {
        String result = null;
        try {
            result = System.getProperty(key, def);
        }
        catch (SecurityException e) {
            if (key == null) {
                throw new NullPointerException("key can't be null");
            }
            if (key.equals("")) {
                throw new IllegalArgumentException("key can't be empty");
            }
            result = props.getProperty(key, def);
        }
        return result;
    }

    public static void setProperties(Properties p) {
        try {
            System.setProperties(p);
        }
        catch (SecurityException e) {
            if (p == null) {
                p = new Properties();
            }
            props = p;
        }
    }

    public static String setProperty(String key, String value) {
        String result = null;
        try {
            result = System.setProperty(key, value);
        }
        catch (SecurityException e) {
            if (key == null) {
                throw new NullPointerException("key can't be null");
            }
            if (key.equals("")) {
                throw new IllegalArgumentException("key can't be empty");
            }
            result = (String)props.setProperty(key, value);
        }
        return result;
    }

    public static boolean getBoolean(String name) {
        boolean result = false;
        try {
            result = Boolean.getBoolean(name);
        }
        catch (SecurityException e) {
            try {
                result = SystemProperties.toBoolean(props.getProperty(name));
            }
            catch (IllegalArgumentException ie) {
            }
            catch (NullPointerException ne) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }
}

