/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.java.javacomment.internal.test;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

public class AbstractTest
extends TestCase {
    private IJavaProject myProject;

    public AbstractTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project" + Math.random());
        project.create(null);
        project.open(null);
        this.myProject = JavaCore.create((IProject)project);
        AbstractTest.appendRTJar(this.myProject);
        IPackageFragment iPackageFragment = this.myProject.getPackageFragmentRoots()[0].createPackageFragment("cz.blajer", true, null);
    }

    protected void tearDown() throws Exception {
        this.myProject.getProject().delete(true, null);
    }

    private static void appendRTJar(IJavaProject javaProject) throws Exception {
        IClasspathEntry rtJarEntry;
        File javaHome = new File(System.getProperty("java.home"));
        File rtJar = new File(javaHome, "jre" + File.separator + "lib" + File.separator + "rt.jar");
        if (!rtJar.exists()) {
            rtJar = new File(javaHome, "lib" + File.separator + "rt.jar");
        }
        IClasspathEntry[] oldClasspath = javaProject.getRawClasspath();
        IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length + 1];
        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
        newClasspath[oldClasspath.length] = rtJarEntry = JavaCore.newLibraryEntry((IPath)new Path(rtJar.getAbsolutePath()), null, null);
        javaProject.setRawClasspath(newClasspath, null);
    }
}

