/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.java.javacomment.internal;

import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ISynchronizer;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.java.javacomment.internal.TagImpl;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

class JavaCommentsImpl
implements IJavaComment {
    private ISynchronizer mySynchronizer;
    private String myContent;
    private String myUnchangedContent;
    private String myCommentBody;
    private List myTags = new ArrayList();
    private boolean myTopLR;
    private boolean myBottomLR;
    private boolean myIsParsed;
    private Set myFixedTagNames;
    private boolean mySortTagValues;
    private static final char TAB = '\t';
    private static final String LR = "\n";
    private static final String TAG_PREFIX = "@";
    private static final String COMMENT_PREFIX = "/**";
    private static final String COMMENT_POSTFIX = "*/";
    private static final char COMMENT_SPECIAL_CHAR = '*';
    private static final Enumeration EMPTY_ENUM = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private static final Comparator ourTagValueComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String v2;
            ITag t1 = (ITag)o1;
            ITag t2 = (ITag)o2;
            int nc = t1.getName().compareTo(t2.getName());
            if (nc != 0) {
                return nc;
            }
            String v1 = t1.getValue();
            if (v1 == (v2 = t2.getValue())) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareTo(v2);
        }
    };

    JavaCommentsImpl() {
    }

    public String getContent() {
        String changedContent;
        StringBuffer buffer = new StringBuffer(1024);
        String commentBody = this.getComment();
        if (commentBody == null && this.myTags.isEmpty() && this.myUnchangedContent == null) {
            return null;
        }
        if (commentBody != null && commentBody.length() > 0) {
            buffer.append(commentBody);
            buffer.append(LR);
        }
        if (!this.myTags.isEmpty()) {
            Iterator iterator = this.getOrderedTags();
            while (iterator.hasNext()) {
                ITag tag = (ITag)iterator.next();
                if (tag.getValue() == null) continue;
                buffer.append(tag.getName());
                buffer.append(" ");
                buffer.append(tag.getValue() + LR);
            }
        }
        String string = changedContent = buffer.length() > 0 ? this.arrangeBody(buffer.toString()) : null;
        if (this.myUnchangedContent != null && changedContent != null) {
            return this.myUnchangedContent + LR + changedContent;
        }
        if (this.myUnchangedContent != null) {
            return this.myUnchangedContent;
        }
        if (changedContent != null) {
            return changedContent;
        }
        return null;
    }

    protected Iterator getOrderedTags() {
        if (this.myFixedTagNames == null) {
            if (this.mySortTagValues) {
                ArrayList tags = new ArrayList(this.myTags);
                Collections.sort(tags, ourTagValueComparator);
                return tags.iterator();
            }
            return new TreeSet(this.myTags).iterator();
        }
        AbstractCollection groupedTags = this.mySortTagValues ? new ArrayList(this.myTags.size()) : new TreeSet();
        ArrayList<ITag> fixedTags = new ArrayList<ITag>(this.myTags.size());
        int i = 0;
        while (i < this.myTags.size()) {
            ITag tag = (ITag)this.myTags.get(i);
            if (this.myFixedTagNames.contains(tag.getName())) {
                fixedTags.add(tag);
            } else {
                groupedTags.add(tag);
            }
            ++i;
        }
        ArrayList<ITag> tags = new ArrayList<ITag>(groupedTags.size() + fixedTags.size());
        tags.addAll(groupedTags);
        if (this.mySortTagValues) {
            Collections.sort(tags, ourTagValueComparator);
        }
        tags.addAll(fixedTags);
        return tags.iterator();
    }

    public void setContent(String content) {
        this.myIsParsed = false;
        if (content != null && content.length() > 0) {
            this.myContent = content;
            this.myUnchangedContent = null;
            this.myTopLR = false;
            this.myBottomLR = false;
        } else {
            this.myContent = null;
            this.myUnchangedContent = null;
            this.myCommentBody = null;
            this.myTags = new ArrayList();
            this.myTopLR = true;
            this.myBottomLR = true;
            this.myIsParsed = false;
        }
    }

    public String getComment() {
        this.parseContent();
        return this.myCommentBody != null ? this.myCommentBody.trim() : null;
    }

    public void setComment(String newCommentContent) {
        this.parseContent();
        this.myCommentBody = newCommentContent;
    }

    public ITag addTag(String name, String value) {
        this.parseContent();
        if (this.isValidTag(name)) {
            TagImpl tagImpl = new TagImpl(this, name, value);
            this.myTags.add(tagImpl);
            return tagImpl;
        }
        return null;
    }

    public ITag setTag(String tagName, String value) {
        this.parseContent();
        Iterator it = this.myTags.iterator();
        while (it.hasNext()) {
            ITag tag = (ITag)it.next();
            if (tag.getValue() == null || !tagName.equals(tag.getName())) continue;
            tag.setValue(value);
            return tag;
        }
        return this.addTag(tagName, value);
    }

    public ITag[] setAllTags(String tagName, String value) {
        this.parseContent();
        ArrayList<ITag> rv = new ArrayList<ITag>();
        Iterator it = this.myTags.iterator();
        while (it.hasNext()) {
            ITag tag = (ITag)it.next();
            if (tag.getValue() == null || !tagName.equals(tag.getName())) continue;
            tag.setValue(value);
            rv.add(tag);
        }
        return rv.toArray(new ITag[rv.size()]);
    }

    public boolean hasTags(String name) {
        if (this.isValidTag(name)) {
            this.initRawContentIfNecessary();
            return this.myContent != null && this.myContent.indexOf(name) != -1;
        }
        return false;
    }

    public Enumeration getTags() {
        this.parseContent();
        Vector<ITag> tags = new Vector<ITag>();
        Iterator iterator = this.myTags.iterator();
        while (iterator.hasNext()) {
            ITag tag = (ITag)iterator.next();
            if (tag.getValue() == null) continue;
            tags.add(tag);
        }
        return tags.elements();
    }

    public Enumeration getTags(String name) {
        if (this.myTags.isEmpty() && !this.hasTags(name)) {
            return EMPTY_ENUM;
        }
        Vector<ITag> tags = new Vector<ITag>();
        Enumeration allTags = this.getTags();
        while (allTags.hasMoreElements()) {
            ITag tag = (ITag)allTags.nextElement();
            if (!tag.getName().equals(name)) continue;
            tags.add(tag);
        }
        return tags.elements();
    }

    public void synchronize(boolean direction) {
        if (this.mySynchronizer != null) {
            if (direction) {
                this.mySynchronizer.doSynchronizeTo(this.getContent());
            } else {
                this.setContent(this.mySynchronizer.doSynchronizeFrom());
            }
        }
    }

    public void setSynchronizer(ISynchronizer synchronizer) {
        this.mySynchronizer = synchronizer;
    }

    public ISynchronizer getSynchronizer() {
        return this.mySynchronizer;
    }

    private void initRawContentIfNecessary() {
        if (this.myContent == null) {
            this.synchronize(false);
        }
    }

    private void parseContent() {
        if (!this.myIsParsed) {
            this.initRawContentIfNecessary();
            this.myUnchangedContent = this.getUnchangedContent(this.myContent);
            this.parseBody(this.getClearContent(this.myContent));
            this.myIsParsed = true;
        }
    }

    private void parseBody(String content) {
        if (content == null) {
            return;
        }
        content = content.trim();
        content = this.removeCommentPrefix(content);
        content = this.removeCommentPostfix(content);
        StringTokenizer commentsLines = new StringTokenizer(content, LR);
        ArrayList<String> lineList = new ArrayList<String>();
        int i = 0;
        while (commentsLines.hasMoreElements()) {
            String line = commentsLines.nextToken();
            line = this.removeSpecialCharsters(line);
            if ((line = line.trim()).length() > 0) {
                lineList.add(line);
            }
            ++i;
        }
        String[] lineArray = new String[lineList.size()];
        lineArray = lineList.toArray(lineArray);
        StringBuffer commentBody = new StringBuffer(1024);
        int i2 = 0;
        while (i2 < lineArray.length) {
            String line = lineArray[i2];
            if (line.startsWith(TAG_PREFIX)) {
                int j = i2 + 1;
                while (j < lineArray.length) {
                    if (lineArray[j].startsWith(TAG_PREFIX)) {
                        i2 = j - 1;
                        break;
                    }
                    line = line + LR + lineArray[j];
                    i2 = j++;
                }
                ITag tag = this.extractTag(line);
                if (tag != null) {
                    this.myTags.add(tag);
                }
            } else {
                commentBody.append(line);
                commentBody.append(LR);
            }
            ++i2;
        }
        this.myCommentBody = commentBody.toString();
    }

    private ITag extractTag(String content) {
        String name;
        String value = null;
        int index = content.indexOf(" ");
        if (index != -1) {
            name = content.substring(0, index).trim();
            value = content.substring(index).trim();
        } else {
            name = content.trim();
            value = "";
        }
        if (this.isValidTag(name)) {
            return new TagImpl(this, name, value);
        }
        return null;
    }

    private String removeCommentPrefix(String content) {
        if (content.startsWith(COMMENT_PREFIX)) {
            return content.substring(COMMENT_PREFIX.length());
        }
        return content;
    }

    private String removeCommentPostfix(String content) {
        if (content.endsWith(COMMENT_POSTFIX)) {
            return content.substring(0, content.length() - COMMENT_POSTFIX.length());
        }
        return content;
    }

    private String removeSpecialCharsters(String line) {
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch != '*' && !Character.isWhitespace(ch) && ch != '\t') break;
            ++i;
        }
        return line.substring(i, line.length()).trim();
    }

    private String arrangeBody(String content) {
        String blr;
        String tlr;
        StringTokenizer commentsLines = new StringTokenizer(content, LR);
        StringBuffer contentBuf = new StringBuffer(1024);
        while (commentsLines.hasMoreElements()) {
            String line = commentsLines.nextToken();
            contentBuf.append(this.addSpecialCharsters(line));
            contentBuf.append(LR);
        }
        content = contentBuf.toString();
        String string = tlr = this.myTopLR ? LR : "";
        if (!content.startsWith(COMMENT_PREFIX)) {
            content = tlr + COMMENT_PREFIX + LR + content;
        }
        String string2 = blr = this.myBottomLR ? LR : "";
        if (!content.endsWith(COMMENT_POSTFIX)) {
            if (!content.endsWith(LR)) {
                content = content + LR;
            }
            content = content + " */" + blr;
        }
        return content;
    }

    private String addSpecialCharsters(String line) {
        return " * " + line;
    }

    private boolean isValidTag(String name) {
        if (name.startsWith(TAG_PREFIX) && name.length() > 1) {
            char secondChar = name.charAt(1);
            return Character.isLetterOrDigit(secondChar);
        }
        return false;
    }

    private String getUnchangedContent(String content) {
        if (content == null) {
            return null;
        }
        int firstIndex = content.lastIndexOf(COMMENT_PREFIX);
        if (firstIndex > 0) {
            return (content = content.substring(0, firstIndex).trim()).length() > 0 ? content : null;
        }
        return null;
    }

    private String getClearContent(String content) {
        int secondIndex;
        if (content == null) {
            return null;
        }
        int firstIndex = content.indexOf(COMMENT_PREFIX);
        if (firstIndex != (secondIndex = content.lastIndexOf(COMMENT_PREFIX))) {
            return content.substring(secondIndex);
        }
        return content;
    }

    boolean isTagExist(ITag tag) {
        return this.myTags != null && this.myTags.contains(tag);
    }

    public void setSortTagValues(boolean sort) {
        this.mySortTagValues = sort;
    }

    public void addFixedTagName(String name) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        if (this.myFixedTagNames == null) {
            this.myFixedTagNames = new HashSet();
        }
        this.myFixedTagNames.add(name);
    }
}

