/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.java.javacomment.internal;

import com.tssap.selena.java.javacomment.ISynchronizer;
import com.tssap.selena.java.javacomment.internal.JavaCommentsImpl;
import com.tssap.selena.java.javacomment.internal.JavaCommentsPlugin;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.formatter.CodeFormatter;

class JavaCommentsExtImpl
extends JavaCommentsImpl {
    private static final PropertyOperation ourPropertyOperation = new MyPropertyOperation();
    private IMember myMember;

    public JavaCommentsExtImpl(IMember member) {
        this.myMember = member;
        super.setSynchronizer(new ISynchronizer(){

            public String doSynchronizeFrom() {
                return JavaCommentsExtImpl.getContent((IJavaElement)JavaCommentsExtImpl.this.myMember);
            }

            public void doSynchronizeTo(String content) {
                if (JavaCommentsExtImpl.this.myMember.exists()) {
                    try {
                        int nesting = JavaCommentsExtImpl.getNesting(JavaCommentsExtImpl.this.myMember);
                        content = JavaCommentsExtImpl.format(content, nesting, true);
                        JavaCommentsExtImpl.doPropertyOperation((IJavaElement)JavaCommentsExtImpl.this.myMember, null, content, null, ourPropertyOperation);
                    }
                    catch (JavaModelException e) {
                        JavaCommentsPlugin.logWarning("Failed to synchronize comment", e);
                    }
                }
            }
        });
    }

    private static String getContent(IJavaElement javaElement) {
        try {
            if (javaElement instanceof IMember) {
                String source = ((IMember)javaElement).getSource();
                if (source != null) {
                    IDOMType domMember = null;
                    if (javaElement instanceof IType) {
                        domMember = new DOMFactory().createType(source);
                    } else if (javaElement instanceof IMethod) {
                        domMember = new DOMFactory().createMethod(source);
                    } else if (javaElement instanceof IField) {
                        domMember = new DOMFactory().createField(source);
                    }
                    if (domMember != null) {
                        return domMember.getComment();
                    }
                }
                return null;
            }
        }
        catch (JavaModelException e) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private static int getNesting(IMember member) {
        int nesting = 0;
        IMember javaElement = member;
        while (!((javaElement = javaElement.getParent()) instanceof ICompilationUnit) && !(javaElement instanceof IClassFile)) {
            if (javaElement == null) {
                return 0;
            }
            ++nesting;
        }
        return nesting;
    }

    private static String format(String sourceText, int nesting, boolean comment) {
        String oldSourceText = sourceText;
        sourceText = comment ? "\n" + sourceText + "\n int xxx;\n" : sourceText;
        int i = 0;
        while (i < nesting) {
            sourceText = "class XXXX {" + sourceText + "}";
            ++i;
        }
        sourceText = new CodeFormatter((Map)null).format(sourceText);
        IDOMType domType = new DOMFactory().createType(sourceText);
        sourceText = oldSourceText;
        if (domType != null) {
            IDOMNode domNode = null;
            Enumeration enumeration = domType.getChildren();
            int i2 = 0;
            while (enumeration.hasMoreElements()) {
                domNode = (IDOMNode)enumeration.nextElement();
                ++i2;
            }
            if (domNode != null) {
                if (comment) {
                    IDOMMember domMember = (IDOMMember)domNode;
                    sourceText = domMember.getComment() + "\n";
                } else {
                    sourceText = domNode.getContents();
                }
            }
        }
        return sourceText;
    }

    private static boolean doPropertyOperation(IJavaElement javaElement, String propertyName, Object newPropertyValue, Object oldPropertyValue, PropertyOperation propertyOperation) throws JavaModelException {
        if (!(javaElement instanceof IMember)) {
            return false;
        }
        ICompilationUnit compilationUnit = ((IMember)javaElement).getCompilationUnit();
        IBuffer buffer = compilationUnit.getBuffer();
        if (buffer == null) {
            return false;
        }
        char[] sourceCharsters = buffer.getCharacters();
        IDOMCompilationUnit domCompilationUnit = new DOMFactory().createCompilationUnit(sourceCharsters, compilationUnit.getElementName());
        IDOMNode necessaryDOMElement = JavaCommentsExtImpl.findNode((IDOMNode)domCompilationUnit, (IMember)javaElement);
        if (necessaryDOMElement == null) {
            return false;
        }
        if (!propertyOperation.propertyOperation(javaElement, necessaryDOMElement, propertyName, newPropertyValue, oldPropertyValue)) {
            return false;
        }
        char[] newSourceCharsters = domCompilationUnit.getCharacters();
        buffer.setContents(newSourceCharsters);
        buffer.save(null, true);
        compilationUnit.makeConsistent(null);
        compilationUnit.save(null, true);
        return true;
    }

    private static IDOMNode findNode(IDOMNode domNode, IMember jdtMember) {
        String jdtContext = null;
        try {
            jdtContext = jdtMember.getSource();
        }
        catch (JavaModelException e) {
            return null;
        }
        IDOMField domMember = null;
        int elementType = jdtMember.getElementType();
        if (elementType == 8) {
            domMember = new DOMFactory().createField(jdtContext);
        } else if (elementType == 9) {
            domMember = new DOMFactory().createMethod(jdtContext);
        } else if (elementType == 7) {
            domMember = new DOMFactory().createType(jdtContext);
        }
        if (domMember == null) {
            return null;
        }
        if (domNode.isSignatureEqual((IDOMNode)domMember)) {
            return domNode;
        }
        Enumeration domNodeEnum = domNode.getChildren();
        while (domNodeEnum.hasMoreElements()) {
            IDOMNode childDomNode = (IDOMNode)domNodeEnum.nextElement();
            IDOMNode necessaryJavaElement = JavaCommentsExtImpl.findNode(childDomNode, jdtMember);
            if (necessaryJavaElement == null) continue;
            return necessaryJavaElement;
        }
        return null;
    }

    private static class MyPropertyOperation
    implements PropertyOperation {
        private MyPropertyOperation() {
        }

        public boolean propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMMember) {
                ((IDOMMember)domNode).setComment((String)newPropertyValue);
                return true;
            }
            return false;
        }
    }

    private static interface PropertyOperation {
        public boolean propertyOperation(IJavaElement var1, IDOMNode var2, String var3, Object var4, Object var5);
    }
}

