/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.OptionTemplateWizardPage;
import org.eclipse.pde.ui.templates.TemplateOption;

public abstract class OptionTemplateSection
extends BaseOptionTemplateSection {
    private static final String KEY_MUST_BE_SET = "OptionTemplateSection.mustBeSet";
    private ArrayList pages = new ArrayList();

    public abstract String getSectionId();

    protected String getTemplateDirectory() {
        return "templates";
    }

    protected abstract URL getInstallURL();

    public URL getTemplateLocation() {
        URL url = this.getInstallURL();
        try {
            String location = String.valueOf(this.getTemplateDirectory()) + File.separator + this.getSectionId();
            return new URL(url, location);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public WizardPage getPage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            return null;
        }
        TemplatePage tpage = (TemplatePage)this.pages.get(pageIndex);
        return tpage.page;
    }

    public WizardPage createPage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            return null;
        }
        TemplatePage tpage = (TemplatePage)this.pages.get(pageIndex);
        tpage.page = new OptionTemplateWizardPage(this, tpage.options, null);
        return tpage.page;
    }

    public WizardPage createPage(int pageIndex, String helpContextId) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            return null;
        }
        TemplatePage tpage = (TemplatePage)this.pages.get(pageIndex);
        tpage.page = new OptionTemplateWizardPage(this, tpage.options, helpContextId);
        return tpage.page;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public void setPageCount(int count) {
        this.pages.clear();
        int i = 0;
        while (i < count) {
            this.pages.add(new TemplatePage());
            ++i;
        }
    }

    public TemplateOption[] getOptions(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            return new TemplateOption[0];
        }
        TemplatePage page = (TemplatePage)this.pages.get(pageIndex);
        return page.options.toArray(new TemplateOption[page.options.size()]);
    }

    public TemplateOption[] getOptions(WizardPage page) {
        int i = 0;
        while (i < this.pages.size()) {
            TemplatePage tpage = (TemplatePage)this.pages.get(i);
            if (tpage.page.equals(page)) {
                return this.getOptions(i);
            }
            ++i;
        }
        return new TemplateOption[0];
    }

    public int getPageIndex(TemplateOption option) {
        int i = 0;
        while (i < this.pages.size()) {
            TemplatePage tpage = (TemplatePage)this.pages.get(i);
            if (tpage.options.contains(option)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getLabel() {
        String key = "template." + this.getSectionId() + ".name";
        return this.getPluginResourceString(key);
    }

    public String getDescription() {
        String key = "template." + this.getSectionId() + ".desc";
        return this.getPluginResourceString(key);
    }

    protected void flagMissingRequiredOption(TemplateOption option) {
        WizardPage page = null;
        int i = 0;
        while (i < this.pages.size()) {
            TemplatePage tpage = (TemplatePage)this.pages.get(i);
            ArrayList list = tpage.options;
            if (list.contains(option)) {
                page = tpage.page;
                break;
            }
            ++i;
        }
        if (page != null) {
            page.setPageComplete(false);
            String message = PDEPlugin.getFormattedMessage(KEY_MUST_BE_SET, option.getMessageLabel());
            page.setErrorMessage(message);
        }
    }

    protected void resetPageState() {
        if (this.pages.size() == 0) {
            return;
        }
        WizardPage firstPage = ((TemplatePage)this.pages.get((int)0)).page;
        IWizardContainer container = firstPage.getWizard().getContainer();
        WizardPage currentPage = (WizardPage)container.getCurrentPage();
        currentPage.setErrorMessage(null);
        currentPage.setPageComplete(true);
    }

    void registerOption(TemplateOption option, Object value, int pageIndex) {
        super.registerOption(option, value, pageIndex);
        if (pageIndex >= 0 && pageIndex < this.pages.size()) {
            TemplatePage tpage = (TemplatePage)this.pages.get(pageIndex);
            tpage.options.add(option);
        }
    }

    class TemplatePage {
        WizardPage page;
        ArrayList options = new ArrayList();
    }
}

