/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.preferences.BuildpathPreferencePage;
import org.eclipse.pde.internal.ui.wizards.project.ProjectStructurePage;
import org.eclipse.pde.internal.ui.wizards.templates.FieldData;
import org.eclipse.pde.internal.ui.wizards.templates.FirstTemplateWizardPage;
import org.eclipse.pde.internal.ui.wizards.templates.TemplateEditorInput;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.IPluginStructureData;
import org.eclipse.pde.ui.IProjectProvider;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class AbstractNewPluginTemplateWizard
extends Wizard
implements IPluginContentWizard {
    private static final String KEY_WTITLE = "PluginCodeGeneratorWizard.title";
    private static final String KEY_WFTITLE = "PluginCodeGeneratorWizard.ftitle";
    private static final String KEY_MISSING = "PluginCodeGeneratorWizard.missing";
    private static final String KEY_FMISSING = "PluginCoreGeneratorWizard.fmissing";
    private static final String KEY_GENERATING = "PluginCoreGeneratorWizard.generating";
    private IProjectProvider provider;
    private IPluginStructureData structureData;
    private boolean fragment;
    private FirstTemplateWizardPage firstPage;
    private ITemplateSection[] activeSections;
    private IConfigurationElement config;

    public AbstractNewPluginTemplateWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_DEFCON_WIZ);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IProjectProvider provider, IPluginStructureData structureData, boolean fragment, IConfigurationElement config) {
        this.provider = provider;
        this.structureData = structureData;
        this.fragment = fragment;
        this.config = config;
        this.setWindowTitle(PDEPlugin.getResourceString(fragment ? KEY_WFTITLE : KEY_WTITLE));
    }

    protected abstract ITemplateSection[] getTemplateSections();

    protected abstract void addAdditionalPages();

    public final void addPages() {
        this.firstPage = new FirstTemplateWizardPage(this.provider, this.structureData, this.fragment);
        this.addPage((IWizardPage)this.firstPage);
        this.addAdditionalPages();
    }

    public final boolean performFinish() {
        this.activeSections = this.getTemplateSections();
        final FieldData data = this.firstPage.createFieldData();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException {
                try {
                    try {
                        AbstractNewPluginTemplateWizard.this.doFinish(data, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private int computeTotalWork() {
        int totalWork = 5;
        int i = 0;
        while (i < this.activeSections.length) {
            totalWork += this.activeSections[i].getNumberOfWorkUnits();
            ++i;
        }
        return totalWork;
    }

    private void doFinish(FieldData data, IProgressMonitor monitor) throws CoreException, InterruptedException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_GENERATING), this.computeTotalWork());
        ArrayList dependencies = this.getDependencies();
        if (!this.verifyPluginPath(dependencies)) {
            throw new InterruptedException();
        }
        IProject project = this.provider.getProject();
        ProjectStructurePage.createProject(project, this.provider, this.structureData, monitor);
        monitor.worked(1);
        ProjectStructurePage.createBuildProperties(project, this.structureData, data.isFragment(), monitor);
        monitor.worked(1);
        WorkspacePluginModelBase model = this.firstPage.createPluginManifest(project, data, dependencies, monitor);
        monitor.worked(1);
        if (this.structureData.getRuntimeLibraryName() != null) {
            this.setJavaSettings((IPluginModelBase)model, monitor);
            monitor.worked(1);
        }
        this.executeTemplates(project, (IPluginModelBase)model, monitor);
        model.save();
        this.saveTemplateFile(project, monitor);
        monitor.worked(1);
        IFile file = (IFile)model.getUnderlyingResource();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getEditorRegistry().setDefaultEditor(file, "org.eclipse.pde.ui.manifestEditor");
        this.openPluginFile(file);
    }

    private void setJavaSettings(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        boolean useContainers = BuildpathPreferencePage.getUseClasspathContainers();
        ClasspathUtilCore.setClasspath((IPluginModelBase)model, (boolean)useContainers, null, (IProgressMonitor)monitor);
    }

    private ArrayList getDependencies() {
        ArrayList result = new ArrayList();
        IPluginReference[] list = this.firstPage.getDependencies();
        this.addDependencies(list, result);
        int i = 0;
        while (i < this.activeSections.length) {
            this.addDependencies(this.activeSections[i].getDependencies(), result);
            ++i;
        }
        return result;
    }

    private void addDependencies(IPluginReference[] list, ArrayList result) {
        int i = 0;
        while (i < list.length) {
            IPluginReference reference = list[i];
            if (!result.contains(reference)) {
                result.add(reference);
            }
            ++i;
        }
    }

    private boolean verifyPluginPath(ArrayList dependencies) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ArrayList<IPluginModelBase> matches = new ArrayList<IPluginModelBase>();
        boolean workspaceModels = false;
        int i = 0;
        while (i < dependencies.size()) {
            IPluginReference ref = (IPluginReference)dependencies.get(i);
            IPluginModelBase model = manager.findPlugin(ref.getId(), ref.getVersion(), ref.getMatch());
            if (model != null) {
                if (model.getUnderlyingResource() != null) {
                    workspaceModels = true;
                    break;
                }
                if (!model.isEnabled()) {
                    matches.add(model);
                }
            }
            ++i;
        }
        if (!workspaceModels && matches.size() > 0) {
            final boolean[] result = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (AbstractNewPluginTemplateWizard.this.askToEnable()) {
                        ExternalModelManager mng = PDECore.getDefault().getExternalModelManager();
                        mng.enableAll();
                        result[0] = true;
                    } else {
                        result[0] = false;
                    }
                }
            });
            return result[0];
        }
        return true;
    }

    private boolean askToEnable() {
        String title = this.getWindowTitle();
        String message = PDEPlugin.getResourceString(this.fragment ? KEY_FMISSING : KEY_MISSING);
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        return dialog.open() == 0;
    }

    private void executeTemplates(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < this.activeSections.length) {
            ITemplateSection section = this.activeSections[i];
            section.execute(project, model, monitor);
            ++i;
        }
    }

    private void writeTemplateFile(PrintWriter writer) {
        String indent = "   ";
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<form>");
        if (this.activeSections.length > 0) {
            writer.println(String.valueOf(indent) + PDEPlugin.getResourceString("ManifestEditor.TemplatePage.intro"));
            int i = 0;
            while (i < this.activeSections.length) {
                ITemplateSection section = this.activeSections[i];
                String list = "<li style=\"text\" value=\"" + (i + 1) + ".\">";
                writer.println(String.valueOf(indent) + list + "<b>" + section.getLabel() + ".</b>" + section.getDescription() + "</li>");
                ++i;
            }
        }
        writer.println(String.valueOf(indent) + PDEPlugin.getResourceString("ManifestEditor.TemplatePage.common"));
        writer.println("</form>");
    }

    private void saveTemplateFile(IProject project, IProgressMonitor monitor) {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.writeTemplateFile(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {}
        String contents = swriter.toString();
        IFile file = project.getFile(".template");
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, false, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        catch (IOException iOException) {}
    }

    private IEditorInput createEditorInput(IFile file) {
        return new TemplateEditorInput(file, "TemplatePage");
    }

    private void openPluginFile(final IFile file) {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        final IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            return;
        }
        Display d = ww.getShell().getDisplay();
        final IWorkbenchPart focusPart = page.getActivePart();
        d.asyncExec(new Runnable(){

            public void run() {
                try {
                    String editorId;
                    String string = editorId = AbstractNewPluginTemplateWizard.this.fragment ? "org.eclipse.pde.ui.fragmentEditor" : "org.eclipse.pde.ui.manifestEditor";
                    if (focusPart instanceof ISetSelectionTarget) {
                        StructuredSelection selection = new StructuredSelection((Object)file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                    IEditorInput input = AbstractNewPluginTemplateWizard.this.createEditorInput(file);
                    ww.getActivePage().openEditor(input, editorId);
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }
}

