/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.FormBrowser;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.templates.FirstTemplateWizardPage;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class TemplateSelectionPage
extends WizardPage {
    private ArrayList candidates;
    private ArrayList visiblePages;
    private WizardCheckboxTablePart tablePart;
    private FormBrowser descriptionBrowser;
    private static final String NL_TITLE = "TemplateSelectionPage.title";
    private static final String NL_DESC = "TemplateSelectionPage.desc";
    private static final String NL_TABLE = "TemplateSelectionPage.table";
    private static final String NL_CNAME = "TemplateSelectionPage.column.name";
    private static final String NL_CPOINT = "TemplateSelectionPage.column.point";

    public TemplateSelectionPage() {
        super("templateSelection");
        this.setTitle(PDEPlugin.getResourceString(NL_TITLE));
        this.setDescription(PDEPlugin.getResourceString(NL_DESC));
        this.createCandidates();
        this.tablePart = new TablePart(PDEPlugin.getResourceString(NL_TABLE));
        this.descriptionBrowser = new FormBrowser(2560);
        this.descriptionBrowser.setText("");
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.visiblePages = new ArrayList();
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private void createCandidates() {
        this.candidates = new ArrayList();
        IPluginRegistry registry = Platform.getPluginRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PDEPlugin.getPluginId(), "templates");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            this.addTemplate(element, this.candidates);
            ++i;
        }
    }

    private void addTemplate(IConfigurationElement config, ArrayList result) {
        if (!config.getName().equalsIgnoreCase("template")) {
            return;
        }
        try {
            Object template = config.createExecutableExtension("class");
            if (template instanceof ITemplateSection) {
                result.add(template);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.tablePart.createControl(container);
        CheckboxTableViewer viewer = this.tablePart.getTableViewer();
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.initializeTable(viewer.getTable());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                TemplateSelectionPage.this.handleSelectionChanged((ITemplateSection)sel.getFirstElement());
            }
        });
        this.descriptionBrowser.createControl(container);
        Control c = this.descriptionBrowser.getControl();
        GridData gd = new GridData(1296);
        gd.heightHint = 100;
        c.setLayoutData((Object)gd);
        viewer.setInput((Object)PDEPlugin.getDefault());
        this.tablePart.selectAll(true);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.template_selection");
    }

    public ITemplateSection[] getSelectedTemplates() {
        Object[] elements = this.tablePart.getTableViewer().getCheckedElements();
        ITemplateSection[] result = new ITemplateSection[elements.length];
        System.arraycopy(elements, 0, result, 0, elements.length);
        return result;
    }

    private void initializeTable(Table table) {
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(PDEPlugin.getResourceString(NL_CNAME));
        column.setResizable(true);
        column = new TableColumn(table, 0);
        column.setText(PDEPlugin.getResourceString(NL_CPOINT));
        column.setResizable(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        table.setLayout((Layout)layout);
    }

    private void handleSelectionChanged(ITemplateSection section) {
        String text;
        String string = text = section != null ? section.getDescription() : "";
        if (text.length() > 0) {
            text = "<p>" + text + "</p>";
        }
        this.descriptionBrowser.setText(text);
    }

    public boolean canFlipToNextPage() {
        if (this.tablePart.getSelectionCount() == 0) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public IWizardPage getNextPage() {
        ITemplateSection[] sections = this.getSelectedTemplates();
        this.visiblePages.clear();
        int i = 0;
        while (i < sections.length) {
            ITemplateSection section = sections[i];
            if (!section.getPagesAdded()) {
                section.addPages((Wizard)this.getWizard());
            }
            int j = 0;
            while (j < section.getPageCount()) {
                this.visiblePages.add(section.getPage(j));
                ++j;
            }
            ++i;
        }
        if (this.visiblePages.size() > 0) {
            return (IWizardPage)this.visiblePages.get(0);
        }
        return null;
    }

    IWizardPage getNextVisiblePage(IWizardPage page) {
        if (page instanceof FirstTemplateWizardPage) {
            return this;
        }
        if (page == this) {
            return page.getNextPage();
        }
        int index = this.visiblePages.indexOf(page);
        if (index >= 0 && index < this.visiblePages.size() - 1) {
            return (IWizardPage)this.visiblePages.get(index + 1);
        }
        return null;
    }

    IWizardPage getPreviousVisiblePage(IWizardPage page) {
        if (page instanceof FirstTemplateWizardPage) {
            return null;
        }
        if (page == this) {
            return super.getPreviousPage();
        }
        int index = this.visiblePages.indexOf(page);
        if (index > 0 && index < this.visiblePages.size()) {
            return (IWizardPage)this.visiblePages.get(index - 1);
        }
        return null;
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
            return super.createStructuredViewer(parent, style | 0x10000, factory);
        }

        protected void updateCounter(int amount) {
            super.updateCounter(amount);
            if (TemplateSelectionPage.this.getContainer() != null) {
                TemplateSelectionPage.this.getContainer().updateButtons();
            }
        }
    }

    class ListContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TemplateSelectionPage.this.candidates.toArray();
        }
    }

    class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ListLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ITemplateSection section = (ITemplateSection)obj;
            if (index == 0) {
                return section.getLabel();
            }
            return section.getUsedExtensionPoint();
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXTENSION_OBJ);
            }
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINT_OBJ);
        }
    }
}

