/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.ui.IPluginStructureData;
import org.eclipse.pde.ui.templates.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class NewWizardTemplate
extends PDETemplateSection {
    private static final String KEY_TITLE = "NewWizardTemplate.title";
    private static final String KEY_DESC = "NewWizardTemplate.desc";
    private static final String KEY_PACKAGE_LABEL = "NewWizardTemplate.packageName";
    private static final String KEY_CATEGORY_ID_LABEL = "NewWizardTemplate.categoryId";
    private static final String KEY_CATEGORY_NAME_LABEL = "NewWizardTemplate.categoryName";
    private static final String KEY_CLASS_LABEL = "NewWizardTemplate.className";
    private static final String KEY_PAGE_CLASS_LABEL = "NewWizardTemplate.pageClassName";
    private static final String KEY_WIZARD_LABEL = "NewWizardTemplate.wizardName";
    private static final String KEY_DEFAULT_NAME = "NewWizardTemplate.defaultName";
    private static final String KEY_EXTENSION_LABEL = "NewWizardTemplate.extension";
    private static final String KEY_FILE_LABEL = "NewWizardTemplate.fileName";

    public NewWizardTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public String getSectionId() {
        return "newWizard";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(KEY_PACKAGE_LABEL), null, 0);
        this.addOption("categoryId", PDEPlugin.getResourceString(KEY_CATEGORY_ID_LABEL), null, 0);
        this.addOption("categoryName", PDEPlugin.getResourceString(KEY_CATEGORY_NAME_LABEL), "Sample Wizards", 0);
        this.addOption("wizardClassName", PDEPlugin.getResourceString(KEY_CLASS_LABEL), "SampleNewWizard", 0);
        this.addOption("wizardPageClassName", PDEPlugin.getResourceString(KEY_PAGE_CLASS_LABEL), "SampleNewWizardPage", 0);
        this.addOption("wizardName", PDEPlugin.getResourceString(KEY_WIZARD_LABEL), PDEPlugin.getResourceString(KEY_DEFAULT_NAME), 0);
        this.addOption("extension", PDEPlugin.getResourceString(KEY_EXTENSION_LABEL), "mpe", 0);
        this.addOption("initialFileName", PDEPlugin.getResourceString(KEY_FILE_LABEL), "new_file.mpe", 0);
    }

    protected void initializeFields(IPluginStructureData sdata, IFieldData data) {
        String pluginId = sdata.getPluginId();
        this.initializeOption("packageName", String.valueOf(pluginId) + ".wizards");
        this.initializeOption("categoryId", pluginId);
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", String.valueOf(pluginId) + ".wizards");
        this.initializeOption("categoryId", pluginId);
    }

    public boolean isDependentOnFirstPage() {
        return true;
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_new_wizard");
        page.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        page.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        int i = 0;
        while (i < allPageOptions.length) {
            TemplateOption nextOption = allPageOptions[i];
            if (nextOption.isRequired() && nextOption.isEmpty()) {
                this.flagMissingRequiredOption(nextOption);
                return;
            }
            ++i;
        }
        this.resetPageState();
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.newWizards";
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension("org.eclipse.ui.newWizards", true);
        IPluginModelFactory factory = this.model.getFactory();
        String cid = this.getStringOption("categoryId");
        this.createCategory(extension, cid);
        String fullClassName = String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption("wizardClassName");
        IPluginElement viewElement = factory.createElement((IPluginObject)extension);
        viewElement.setName("wizard");
        viewElement.setAttribute("id", fullClassName);
        viewElement.setAttribute("name", this.getStringOption("wizardName"));
        viewElement.setAttribute("icon", "icons/sample.gif");
        viewElement.setAttribute("class", fullClassName);
        viewElement.setAttribute("category", cid);
        extension.add((IPluginObject)viewElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    private void createCategory(IPluginExtension extension, String id) throws CoreException {
        IPluginObject[] elements = extension.getChildren();
        int i = 0;
        while (i < elements.length) {
            String cid;
            IPluginAttribute att;
            IPluginElement element = (IPluginElement)elements[i];
            if (element.getName().equalsIgnoreCase("category") && (att = element.getAttribute("id")) != null && (cid = att.getValue()) != null && cid.equals(id)) {
                return;
            }
            ++i;
        }
        IPluginElement categoryElement = this.model.getFactory().createElement((IPluginObject)extension);
        categoryElement.setName("category");
        categoryElement.setAttribute("name", this.getStringOption("categoryName"));
        categoryElement.setAttribute("id", id);
        extension.add((IPluginObject)categoryElement);
    }
}

