/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.project.PluginClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.project.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.templates.FieldData;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IPluginStructureData;
import org.eclipse.pde.ui.IProjectProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class FirstTemplateWizardPage
extends WizardPage {
    private static final String RUNTIME_ID = "org.eclipse.core.runtime";
    private static final String RESOURCES_ID = "org.eclipse.core.resources";
    private static final String WORKBENCH_ID = "org.eclipse.ui";
    private static final String KEY_TITLE = "DefaultCodeGenerationPage.title";
    private static final String KEY_FTITLE = "DefaultCodeGenerationPage.ftitle";
    private static final String KEY_ID_NOT_SET = "DefaultCodeGenerationPage.idNotSet";
    private static final String KEY_VERSION_FORMAT = "DefaultCodeGenerationPage.versionFormat";
    private static final String KEY_INVALID_ID = "DefaultCodeGenerationPage.invalidId";
    private static final String KEY_DESC = "DefaultCodeGenerationPage.desc";
    private static final String KEY_FDESC = "DefaultCodeGenerationPage.fdesc";
    private static final String KEY_FNAME = "DefaultCodeGenerationPage.fname";
    private static final String KEY_NAME = "DefaultCodeGenerationPage.name";
    private static final String KEY_VERSION = "DefaultCodeGenerationPage.version";
    private static final String KEY_PROVIDER = "DefaultCodeGenerationPage.providerName";
    private static final String KEY_PLUGIN_ID = "DefaultCodeGenerationPage.pluginId";
    private static final String KEY_BROWSE = "DefaultCodeGenerationPage.pluginId.browse";
    private static final String KEY_PLUGIN_VERSION = "DefaultCodeGenerationPage.pluginVersion";
    private static final String KEY_MATCH = "ManifestEditor.PluginSpecSection.versionMatch";
    private static final String KEY_MATCH_PERFECT = "ManifestEditor.MatchSection.perfect";
    private static final String KEY_MATCH_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    private static final String KEY_MATCH_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    private static final String KEY_MATCH_GREATER = "ManifestEditor.MatchSection.greater";
    private static final String KEY_CLASS = "DefaultCodeGenerationPage.class";
    private static final String KEY_GENERATE = "DefaultCodeGenerationPage.generate";
    private static final String KEY_INITIAL_NAME = "DefaultCodeGenerationPage.initialName";
    private static final String KEY_INITIAL_FNAME = "DefaultCodeGenerationPage.initialFName";
    private static final String KEY_CREATING = "DefaultCodeGenerationPage.creating";
    private static final String KEY_CREATING_PLUGIN = "DefaultCodeGenerationPage.creatingPlugin";
    private static final String KEY_CREATING_FRAGMENT = "DefaultCodeGenerationPage.creatingFragment";
    private static final String KEY_OPTIONS = "DefaultCodeGenerationPage.options";
    private static final String KEY_OPTIONS_THIS = "DefaultCodeGenerationPage.options.this";
    private static final String KEY_OPTIONS_BUNDLE = "DefaultCodeGenerationPage.options.bundle";
    private static final String KEY_OPTIONS_WORKSPACE = "DefaultCodeGenerationPage.options.workspace";
    private IProjectProvider projectProvider;
    private IPluginStructureData structureData;
    private boolean fragment;
    private Text nameField;
    private Text requiresField;
    private Text pluginVersionField;
    private Text pluginIdField;
    private Button thisCheck;
    private Button bundleCheck;
    private Button workspaceCheck;
    private Button requiresButton;
    private Text versionField;
    private Combo matchCombo;
    private Text providerField;
    private Text classField;
    private Button generateMainClass;
    private static final String PLUGIN_REQUIRES_EXPORT = "export";
    private static final String MANIFEST_FILE_NAME = "plugin.xml";

    public FirstTemplateWizardPage(IProjectProvider projectProvider, IPluginStructureData structureData, boolean fragment) {
        super("DefaultCodeGenerationPage");
        this.fragment = fragment;
        if (fragment) {
            this.setTitle(PDEPlugin.getResourceString(KEY_FTITLE));
            this.setDescription(PDEPlugin.getResourceString(KEY_FDESC));
        } else {
            this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
            this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        }
        this.projectProvider = projectProvider;
        this.structureData = structureData;
    }

    public void becomesVisible(int event) {
        this.nameField.setFocus();
    }

    private void browsePluginId() {
        BusyIndicator.showWhile((Display)this.pluginIdField.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] result;
                PluginSelectionDialog dialog = new PluginSelectionDialog(FirstTemplateWizardPage.this.pluginIdField.getShell());
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 350, 400);
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                    IPluginModel model = (IPluginModel)result[0];
                    IPlugin plugin = model.getPlugin();
                    FirstTemplateWizardPage.this.pluginIdField.setText(plugin.getId());
                    FirstTemplateWizardPage.this.pluginVersionField.setText(plugin.getVersion());
                }
            }
        });
    }

    private Button createCheck(Composite parent, String label, boolean state) {
        Button check = new Button(parent, 32);
        check.setText(label);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        check.setLayoutData((Object)gd);
        check.setSelection(state);
        return check;
    }

    private void addCommonControls(Composite parent) {
        this.nameField = this.createField(parent, PDEPlugin.getResourceString(this.fragment ? KEY_FNAME : KEY_NAME));
        this.versionField = this.createField(parent, PDEPlugin.getResourceString(KEY_VERSION));
        this.versionField.setText("1.0.0");
        this.versionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!FirstTemplateWizardPage.this.isVersionValid(FirstTemplateWizardPage.this.versionField.getText())) {
                    FirstTemplateWizardPage.this.setPageComplete(false);
                    FirstTemplateWizardPage.this.setErrorMessage(PDEPlugin.getResourceString(FirstTemplateWizardPage.KEY_VERSION_FORMAT));
                } else if (FirstTemplateWizardPage.this.fragment) {
                    FirstTemplateWizardPage.this.verifyPluginFields();
                } else {
                    FirstTemplateWizardPage.this.setPageComplete(true);
                    FirstTemplateWizardPage.this.setErrorMessage(null);
                }
            }
        });
        this.providerField = this.createField(parent, PDEPlugin.getResourceString(KEY_PROVIDER));
    }

    private void addFragmentSpecificControls(Composite parent) {
        this.pluginIdField = this.createField(parent, PDEPlugin.getResourceString(KEY_PLUGIN_ID), false);
        this.pluginIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FirstTemplateWizardPage.this.verifyPluginFields();
            }
        });
        Button browsePluginButton = new Button(parent, 8);
        browsePluginButton.setText(PDEPlugin.getResourceString(KEY_BROWSE));
        browsePluginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FirstTemplateWizardPage.this.browsePluginId();
            }
        });
        this.pluginVersionField = this.createField(parent, PDEPlugin.getResourceString(KEY_PLUGIN_VERSION));
        this.pluginVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FirstTemplateWizardPage.this.verifyPluginFields();
            }
        });
        this.matchCombo = this.createMatchCombo(parent);
    }

    private void addPluginSpecificControls(Composite parent) {
        this.classField = this.createField(parent, PDEPlugin.getResourceString(KEY_CLASS));
        this.classField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                IStatus status = JavaConventions.validateJavaTypeName((String)FirstTemplateWizardPage.this.classField.getText());
                if (status.getSeverity() == 4) {
                    FirstTemplateWizardPage.this.setErrorMessage(status.getMessage());
                    FirstTemplateWizardPage.this.setPageComplete(false);
                } else {
                    FirstTemplateWizardPage.this.setErrorMessage(null);
                    FirstTemplateWizardPage.this.setPageComplete(true);
                }
            }
        });
        new Label(parent, 0);
        this.generateMainClass = new Button(parent, 32);
        this.generateMainClass.setText(PDEPlugin.getResourceString(KEY_GENERATE));
        this.generateMainClass.setSelection(true);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.generateMainClass.setLayoutData((Object)gd);
        this.generateMainClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = FirstTemplateWizardPage.this.generateMainClass.getSelection();
                FirstTemplateWizardPage.this.thisCheck.setEnabled(value);
                FirstTemplateWizardPage.this.bundleCheck.setEnabled(value);
                FirstTemplateWizardPage.this.workspaceCheck.setEnabled(value);
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 3;
        new Label(parent, 0).setLayoutData((Object)gd);
        Group checkGroup = new Group(parent, 0);
        checkGroup.setText(PDEPlugin.getResourceString(KEY_OPTIONS));
        checkGroup.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        checkGroup.setLayoutData((Object)gd);
        this.thisCheck = this.createCheck((Composite)checkGroup, PDEPlugin.getResourceString(KEY_OPTIONS_THIS), true);
        this.bundleCheck = this.createCheck((Composite)checkGroup, PDEPlugin.getResourceString(KEY_OPTIONS_BUNDLE), true);
        this.workspaceCheck = this.createCheck((Composite)checkGroup, PDEPlugin.getResourceString(KEY_OPTIONS_WORKSPACE), true);
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite container = new Composite(parent, 0);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        this.addCommonControls(container);
        if (this.fragment) {
            this.addFragmentSpecificControls(container);
        } else {
            this.addPluginSpecificControls(container);
        }
        this.presetFields();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        if (this.fragment) {
            WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_fragment_required_data");
        } else {
            WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_project_required_data");
        }
    }

    private void verifyPluginFields() {
        if (this.pluginIdField.getText().length() == 0) {
            this.setErrorMessage(PDEPlugin.getResourceString(KEY_ID_NOT_SET));
            this.setPageComplete(false);
        } else {
            String id = this.pluginIdField.getText();
            String version = this.pluginVersionField.getText();
            if (version.length() == 0 || !this.isVersionValid(version)) {
                this.setPageComplete(false);
                this.setErrorMessage(PDEPlugin.getResourceString(KEY_VERSION_FORMAT));
                return;
            }
            int match = this.matchCombo.getSelectionIndex();
            if (this.isPluginValid(id, version, match)) {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            } else {
                this.setPageComplete(false);
                this.setErrorMessage(PDEPlugin.getResourceString(KEY_INVALID_ID));
            }
        }
    }

    private boolean isPluginValid(String pluginId, String pluginVersion, int match) {
        IPlugin plugin = PDECore.getDefault().findPlugin(pluginId, pluginVersion, match);
        return plugin != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameField.setFocus();
        }
    }

    private Text createField(Composite parent, String label) {
        return this.createField(parent, label, true);
    }

    private Text createField(Composite parent, String label, boolean addFiller) {
        Label l = new Label(parent, 0);
        l.setText(label);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        Text text = new Text(parent, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gd);
        if (addFiller) {
            Label filler = new Label(parent, 0);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            filler.setLayoutData((Object)gd);
        }
        return text;
    }

    private Combo createMatchCombo(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(PDEPlugin.getResourceString(KEY_MATCH));
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        Combo combo = new Combo(parent, 2056);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gd);
        String[] items = new String[]{"", PDEPlugin.getResourceString(KEY_MATCH_EQUIVALENT), PDEPlugin.getResourceString(KEY_MATCH_COMPATIBLE), PDEPlugin.getResourceString(KEY_MATCH_PERFECT), PDEPlugin.getResourceString(KEY_MATCH_GREATER)};
        combo.setItems(items);
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FirstTemplateWizardPage.this.verifyPluginFields();
            }
        });
        Label filler = new Label(parent, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        filler.setLayoutData((Object)gd);
        return combo;
    }

    private boolean isVersionValid(String version) {
        try {
            new PluginVersionIdentifier(version);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void presetFields() {
        String name = this.projectProvider.getProjectName();
        String noSpaceName = this.removeSpaces(name);
        int loc = name.lastIndexOf(46);
        String lastSegment = name;
        if (loc != -1) {
            StringBuffer buf = new StringBuffer(name.substring(loc + 1));
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
            lastSegment = buf.toString();
        }
        String noSpaceLastSegment = this.removeSpaces(lastSegment);
        if (!this.fragment) {
            this.classField.setText(String.valueOf(noSpaceName) + "." + noSpaceLastSegment.toString() + "Plugin");
        }
        this.versionField.setText("1.0.0");
        if (this.fragment) {
            this.nameField.setText(PDEPlugin.getFormattedMessage(KEY_INITIAL_FNAME, lastSegment));
        } else {
            this.nameField.setText(PDEPlugin.getFormattedMessage(KEY_INITIAL_NAME, lastSegment));
        }
        loc = name.indexOf(46);
        if (loc == -1) {
            return;
        }
        String firstSegment = name.substring(0, loc);
        if (firstSegment.toLowerCase().equals("com")) {
            String provider = name.substring(loc + 1);
            if ((loc = provider.indexOf(46)) != -1) {
                provider = provider.substring(0, loc);
                this.providerField.setText(provider.toUpperCase());
            } else {
                provider = "";
            }
        }
        this.setErrorMessage(null);
    }

    private String removeSpaces(String name) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c != ' ') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public FieldData createFieldData() {
        FieldData data = new FieldData();
        data.name = this.nameField.getText();
        PluginVersionIdentifier pvi = new PluginVersionIdentifier(this.versionField.getText());
        data.version = pvi.toString();
        data.provider = this.providerField.getText();
        data.fragment = this.fragment;
        if (this.fragment) {
            data.pluginId = this.pluginIdField.getText();
            try {
                PluginVersionIdentifier fvi = new PluginVersionIdentifier(this.pluginVersionField.getText());
                data.pluginVersion = fvi.toString();
            }
            catch (NumberFormatException numberFormatException) {
                data.pluginVersion = this.pluginVersionField.getText();
            }
            data.match = this.matchCombo.getSelectionIndex();
        } else {
            data.doMain = this.generateMainClass.getSelection();
            data.className = this.classField.getText();
            data.thisCheck = this.thisCheck.getSelection();
            data.bundleCheck = this.bundleCheck.getSelection();
            data.workspaceCheck = this.workspaceCheck.getSelection();
        }
        return data;
    }

    public WorkspacePluginModelBase createPluginManifest(IProject project, FieldData data, ArrayList dependencies, IProgressMonitor monitor) throws CoreException {
        IFile file = project.getFile(this.fragment ? "fragment.xml" : MANIFEST_FILE_NAME);
        Object model = this.fragment ? new WorkspaceFragmentModel(file) : new WorkspacePluginModel(file);
        IPluginBase plugin = model.getPluginBase(true);
        plugin.setId(this.structureData.getPluginId());
        plugin.setName(data.name);
        plugin.setProviderName(data.provider);
        plugin.setVersion(data.version);
        if (this.fragment) {
            IFragment fragment = (IFragment)plugin;
            fragment.setPluginId(data.pluginId);
            fragment.setPluginVersion(data.pluginVersion);
            fragment.setRule(data.match);
        } else {
            ((IPlugin)plugin).setClassName(data.className);
        }
        if (this.structureData.getRuntimeLibraryName() != null) {
            IPluginLibrary library = model.getFactory().createLibrary();
            library.setName(this.structureData.getRuntimeLibraryName());
            plugin.add(library);
        }
        int i = 0;
        while (i < dependencies.size()) {
            IPluginReference ref = (IPluginReference)dependencies.get(i);
            IPluginImport iimport = model.getFactory().createImport();
            iimport.setId(ref.getId());
            iimport.setVersion(ref.getVersion());
            iimport.setMatch(ref.getMatch());
            plugin.add(iimport);
            ++i;
        }
        IFile buildFile = project.getFile("build.properties");
        if (buildFile.exists()) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
            model.setBuildModel((IBuildModel)buildModel);
        }
        if (data.doMain) {
            this.generatePluginClass(project, data, monitor);
        }
        return model;
    }

    public void generatePluginClass(IProject project, FieldData data, IProgressMonitor monitor) throws CoreException {
        String fullyQualifiedClassName = data.className;
        if (fullyQualifiedClassName == null || fullyQualifiedClassName.length() == 0) {
            return;
        }
        int flags = 0;
        if (data.thisCheck) {
            flags |= 1;
        }
        if (data.workspaceCheck) {
            flags |= 2;
        }
        if (data.bundleCheck) {
            flags |= 8;
        }
        String sourceFolder = this.structureData.getSourceFolderName();
        IPath folderPath = project.getFullPath().append(sourceFolder);
        IFolder folder = project.getWorkspace().getRoot().getFolder(folderPath);
        PluginClassCodeGenerator generator = new PluginClassCodeGenerator(folder, fullyQualifiedClassName, flags);
        monitor.subTask(PDEPlugin.getFormattedMessage(KEY_CREATING, fullyQualifiedClassName));
        generator.generate(monitor);
        monitor.worked(1);
    }

    public IPluginReference[] getDependencies() {
        IPluginReference[] dependencies = new IPluginReference[]{new PluginReference(RESOURCES_ID, null, 0), new PluginReference(WORKBENCH_ID, null, 0)};
        return dependencies;
    }

    public IPluginStructureData getStructureData() {
        return this.structureData;
    }
}

