/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.util.ArraySorter;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginSelectionDialog
extends SelectionDialog {
    public static final String KEY_TITLE = "PluginSelectionDialog.title";
    public static final String KEY_WORKSPACE_PLUGINS = "PluginSelectionDialog.workspacePlugins";
    public static final String KEY_EXTERNAL_PLUGINS = "PluginSelectionDialog.externalPlugins";
    private TreeViewer treeViewer;
    private NamedElement workspacePlugins;
    private NamedElement externalPlugins;
    private Label messageLabel;

    public PluginSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Control tree = this.createTree(container);
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        this.messageLabel = new Label(container, 0);
        gd = new GridData(768);
        this.messageLabel.setLayoutData((Object)gd);
        this.updateMessageLabel();
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.fragment_add_target");
        return container;
    }

    private Control createTree(Composite container) {
        Tree tree = new Tree(container, 2052);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.treeViewer.setAutoExpandLevel(999);
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IPluginModel) {
                    return ((IPluginModel)object).isEnabled();
                }
                return true;
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object item = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (item instanceof IPluginModel) {
                    PluginSelectionDialog.this.pluginSelected((IPluginModel)item);
                } else {
                    PluginSelectionDialog.this.pluginSelected(null);
                }
            }
        });
        this.treeViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == PluginSelectionDialog.this.workspacePlugins) {
                    return -1;
                }
                if (obj == PluginSelectionDialog.this.externalPlugins) {
                    return 1;
                }
                return 0;
            }
        });
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.workspacePlugins = new NamedElement(PDEPlugin.getResourceString(KEY_WORKSPACE_PLUGINS), pluginsImage);
        this.externalPlugins = new NamedElement(PDEPlugin.getResourceString(KEY_EXTERNAL_PLUGINS), pluginsImage);
        this.treeViewer.setInput((Object)PDEPlugin.getDefault());
        return tree;
    }

    private void pluginSelected(IPluginModel model) {
        if (model != null) {
            Vector<IPluginModel> result = new Vector<IPluginModel>();
            result.add(model);
            this.setResult(result);
            this.setMessage(((LabelProvider)this.treeViewer.getLabelProvider()).getText((Object)model));
        } else {
            this.setResult(null);
            this.setMessage("");
        }
        this.getButton(0).setEnabled(model != null);
    }

    public void setMessage(String message) {
        super.setMessage(message);
        this.updateMessageLabel();
    }

    public void updateMessageLabel() {
        if (this.getMessage() != null) {
            this.messageLabel.setText(this.getMessage());
        } else {
            this.messageLabel.setText("");
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModel);
        }

        public Object[] getChildren(Object parent) {
            if (parent == PluginSelectionDialog.this.externalPlugins) {
                ExternalModelManager manager = PDECore.getDefault().getExternalModelManager();
                Object[] models = manager.getModels();
                ArraySorter.INSTANCE.sortInPlace(models);
                return models;
            }
            if (parent == PluginSelectionDialog.this.workspacePlugins) {
                WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
                Object[] models = manager.getWorkspacePluginModels();
                ArraySorter.INSTANCE.sortInPlace(models);
                return models;
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModel) {
                IPluginModel model = (IPluginModel)child;
                if (model.getUnderlyingResource() != null) {
                    return PluginSelectionDialog.this.workspacePlugins;
                }
                return PluginSelectionDialog.this.externalPlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{PluginSelectionDialog.this.workspacePlugins, PluginSelectionDialog.this.externalPlugins};
        }
    }
}

