/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.preferences.BuildpathPreferencePage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConvertedProjectsPage
extends WizardPage {
    private Button updateBuildPathButton;
    private CheckboxTableViewer projectViewer;
    public static final String KEY_TITLE = "ConvertedProjectWizard.title";
    public static final String KEY_UPDATE_BUILD_PATH = "ConvertedProjectWizard.updateBuildPath";
    public static final String KEY_CONVERTING = "ConvertedProjectWizard.converting";
    public static final String KEY_UPDATING = "ConvertedProjectWizard.updating";
    public static final String KEY_DESC = "ConvertedProjectWizard.desc";
    public static final String KEY_PROJECT_LIST = "ConvertedProjectWizard.projectList";
    private Vector initialSelection;
    private TablePart tablePart;

    public ConvertedProjectsPage(Vector initialSelection) {
        super("convertedProjects");
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.initialSelection = initialSelection;
        this.tablePart = new TablePart(PDEPlugin.getResourceString(KEY_PROJECT_LIST));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.projectViewer = this.tablePart.getTableViewer();
        this.projectViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object object) {
                return ConvertedProjectsPage.this.isCandidate((IProject)object);
            }
        });
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 200;
        this.updateBuildPathButton = new Button(container, 32);
        this.updateBuildPathButton.setText(PDEPlugin.getResourceString(KEY_UPDATE_BUILD_PATH));
        boolean value = BuildpathPreferencePage.isConversionUpdate();
        this.updateBuildPathButton.setSelection(value);
        gd = new GridData(768);
        this.updateBuildPathButton.setLayoutData((Object)gd);
        this.projectViewer.setInput((Object)PDEPlugin.getWorkspace());
        if (this.initialSelection != null) {
            this.tablePart.setSelection(this.initialSelection.toArray());
        } else {
            this.tablePart.updateCounter(0);
        }
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.converted_projects");
    }

    private boolean isCandidate(IProject project) {
        if (project.isOpen()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature") && !PDE.hasPluginNature((IProject)project)) {
                    return true;
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
        return false;
    }

    private static String createInitialName(String id) {
        int loc = id.lastIndexOf(46);
        if (loc == -1) {
            return id;
        }
        String name = id.substring(loc + 1);
        StringBuffer buf = new StringBuffer(name);
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        return buf.toString();
    }

    private static void createManifestFile(IFile file, IProgressMonitor monitor) throws CoreException {
        WorkspacePluginModel model = new WorkspacePluginModel(file);
        model.load();
        IProject project = file.getProject();
        IPlugin plugin = model.getPlugin();
        String id = project.getName();
        plugin.setId(id);
        String name = ConvertedProjectsPage.createInitialName(id);
        plugin.setName(name);
        plugin.setVersion("0.0.1");
        model.save();
    }

    public boolean finish() {
        final boolean updateBuildPath = this.updateBuildPathButton.getSelection();
        final Object[] selected = this.tablePart.getSelection();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        ConvertedProjectsPage.this.convertProjects(selected, updateBuildPath, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private static IClasspathEntry[] mergeEntries(IClasspathEntry[] e1, IClasspathEntry[] e2) {
        int size = e1.length + e2.length;
        IClasspathEntry[] result = new IClasspathEntry[size];
        int cnt = 0;
        int i = 0;
        while (i < e1.length) {
            result[cnt++] = e1[i];
            ++i;
        }
        i = 0;
        while (i < e2.length) {
            result[cnt++] = e2[i];
            ++i;
        }
        return result;
    }

    public static void updateBuildPath(IProject project, IProgressMonitor monitor) throws CoreException {
        IPath manifestPath = project.getFullPath().append("plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(manifestPath);
        if (!file.exists()) {
            return;
        }
        WorkspacePluginModel model = new WorkspacePluginModel(file);
        model.load();
        if (!model.isLoaded()) {
            return;
        }
        ClasspathUtilCore.setClasspath((IPluginModelBase)model, (boolean)false, null, (IProgressMonitor)monitor);
    }

    public static void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        IPath manifestPath = project.getFullPath().append("plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(manifestPath);
        if (file.exists()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getEditorRegistry().setDefaultEditor(file, "org.eclipse.pde.ui.manifestEditor");
        } else {
            ConvertedProjectsPage.createManifestFile(file, monitor);
        }
        IPath buildPath = project.getFullPath().append("build.properties");
        IFile buildFile = project.getWorkspace().getRoot().getFile(buildPath);
        if (buildFile.exists()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getEditorRegistry().setDefaultEditor(buildFile, "org.eclipse.pde.ui.buildEditor");
        }
    }

    private void convertProjects(Object[] selected, boolean updateBuildPath, IProgressMonitor monitor) throws CoreException {
        IProject project;
        int totalCount = updateBuildPath ? selected.length : 2 * selected.length;
        monitor.beginTask(PDEPlugin.getResourceString(KEY_CONVERTING), totalCount);
        int i = 0;
        while (i < selected.length) {
            project = (IProject)selected[i];
            ConvertedProjectsPage.convertProject(project, monitor);
            monitor.worked(1);
            ++i;
        }
        if (updateBuildPath) {
            monitor.subTask(PDEPlugin.getResourceString(KEY_UPDATING));
            i = 0;
            while (i < selected.length) {
                project = (IProject)selected[i];
                ConvertedProjectsPage.updateBuildPath(project, monitor);
                monitor.worked(1);
                ++i;
            }
        }
        monitor.done();
    }

    public class ProjectContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            IWorkspace workspace = PDEPlugin.getWorkspace();
            return workspace.getRoot().getProjects();
        }
    }

    public class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return ((IProject)obj).getName();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            ConvertedProjectsPage.this.setPageComplete(count > 0);
        }
    }
}

