/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.IMissingPluginConfirmation;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.preferences.BuildpathPreferencePage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.imports.UpdateBuildpathWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class UpdateClasspathAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;
    private static final String KEY_TITLE = "Actions.classpath.title";
    private static final String KEY_MESSAGE = "Actions.classpath.message";
    private static final String KEY_UPDATE = "Actions.classpath.update";
    private static final String KEY_SETTING = "Actions.classpath.setting";

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            ArrayList<IPluginModelBase> models = new ArrayList<IPluginModelBase>(elems.length);
            int i = 0;
            while (i < elems.length) {
                IPluginModelBase model;
                Object elem = elems[i];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof IJavaProject) {
                    project = ((IJavaProject)elem).getProject();
                }
                if (project != null && WorkspaceModelManager.isJavaPluginProject((IProject)project) && (model = this.findModelFor(project)) != null) {
                    models.add(model);
                }
                ++i;
            }
            IPluginModelBase[] modelArray = models.toArray(new IPluginModelBase[models.size()]);
            UpdateBuildpathWizard wizard = new UpdateBuildpathWizard(modelArray);
            WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static void run(boolean fork, IRunnableContext context, final IPluginModelBase[] models) {
        try {
            context.run(fork, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(models){
                            private final /* synthetic */ IPluginModelBase[] val$models;
                            {
                                this.val$models = iPluginModelBaseArray;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                UpdateClasspathAction.doUpdateClasspath(monitor, this.val$models);
                            }
                        };
                        PDEPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            String title = PDEPlugin.getResourceString(KEY_TITLE);
            String message = PDEPlugin.getResourceString(KEY_MESSAGE);
            PDEPlugin.logException(e, title, message);
        }
    }

    private IPluginModelBase findModelFor(IProject project) {
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        return (IPluginModelBase)manager.getWorkspaceModel(project);
    }

    public static void doUpdateClasspath(IProgressMonitor monitor, IPluginModelBase[] models) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_UPDATE), models.length);
        boolean useContainers = BuildpathPreferencePage.getUseClasspathContainers();
        MissingPluginConfirmation confirmation = new MissingPluginConfirmation();
        try {
            int i = 0;
            while (i < models.length) {
                IPluginModelBase model = models[i];
                if (model.getPluginBase().getLibraries().length != 0) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                    UpdateClasspathAction.setProjectBuildpath(model, useContainers, confirmation, (IProgressMonitor)subMonitor);
                    if (monitor.isCanceled()) break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        Object var7_9 = null;
        monitor.done();
    }

    private static void setProjectBuildpath(IPluginModelBase model, boolean useContainers, IMissingPluginConfirmation confirmation, IProgressMonitor monitor) throws CoreException {
        IPluginBase pluginBase = model.getPluginBase();
        String message = PDEPlugin.getFormattedMessage(KEY_SETTING, pluginBase.getId());
        monitor.beginTask(message, 1);
        try {
            ClasspathUtilCore.setClasspath((IPluginModelBase)model, (boolean)useContainers, (IMissingPluginConfirmation)confirmation, (IProgressMonitor)monitor);
            monitor.worked(1);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        Object var6_8 = null;
        monitor.done();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    private static class MissingPluginConfirmation
    implements IMissingPluginConfirmation {
        private boolean useProjectReference = false;
        private boolean alreadyAsked = false;

        MissingPluginConfirmation() {
        }

        public boolean getUseProjectReference() {
            if (!this.alreadyAsked) {
                this.useProjectReference = this.syncAsk();
                this.alreadyAsked = true;
            }
            return this.useProjectReference;
        }

        private boolean syncAsk() {
            Display display = SWTUtil.getStandardDisplay();
            Shell shell = PDEPlugin.getActiveWorkbenchShell();
            boolean[] result = new boolean[1];
            display.syncExec(new Runnable(result, shell){
                private final /* synthetic */ boolean[] val$result;
                private final /* synthetic */ Shell val$shell;
                {
                    this.val$result = blArray;
                    this.val$shell = shell;
                }

                public void run() {
                    this.val$result[0] = MessageDialog.openQuestion((Shell)this.val$shell, (String)PDEPlugin.getResourceString("UpdateClasspathAction.missingPlugin.title"), (String)PDEPlugin.getResourceString("UpdateClasspathAction.missingPlugin.message"));
                }
            });
            return result[0];
        }
    }
}

