/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.StatusWizardPage;
import org.eclipse.pde.internal.ui.wizards.imports.TargetEnvironmentPreferenceNode;
import org.eclipse.pde.internal.ui.wizards.imports.TargetPlatformPreferenceNode;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginImportWizardFirstPage
extends StatusWizardPage {
    private static final String SETTINGS_DROPLOCATION = "droplocation";
    private static final String SETTINGS_DOOTHER = "doother";
    private static final String SETTINGS_DOIMPORT = "doimport";
    private static final String SETTINGS_DOEXTRACT = "doextract";
    private static final String KEY_TITLE = "ImportWizard.FirstPage.title";
    private static final String KEY_DESC = "ImportWizard.FirstPage.desc";
    private static final String KEY_RUNTIME_LOCATION = "ImportWizard.FirstPage.runtimeLocation";
    private static final String KEY_OTHER_LOCATION = "ImportWizard.FirstPage.otherLocation";
    private static final String KEY_RUNTIME_DESC = "ImportWizard.FirstPage.runtimeDesc";
    private static final String KEY_OTHER_DESC = "ImportWizard.FirstPage.otherDesc";
    private static final String KEY_OTHER_FOLDER = "ImportWizard.FirstPage.otherFolder";
    private static final String KEY_CHANGE = "ImportWizard.FirstPage.change";
    private static final String KEY_BROWSE = "ImportWizard.FirstPage.browse";
    private static final String KEY_CHANGE_TARGET = "ImportWizard.FirstPage.changeTarget";
    private static final String KEY_IMPORT_CHECK = "ImportWizard.FirstPage.importCheck";
    private static final String KEY_EXTRACT_CHECK = "ImportWizard.FirstPage.extractCheck";
    private static final String KEY_SOURCE_REMINDER = "ImportWizard.FirstPage.sourceReminder";
    private static final String KEY_TARGET_DESC = "ImportWizard.FirstPage.targetDesc";
    private static final String KEY_FOLDER_TITLE = "ImportWizard.messages.folder.title";
    private static final String KEY_FOLDER_MESSAGE = "ImportWizard.messages.folder.message";
    private static final String KEY_LOCATION_MISSING = "ImportWizard.errors.locationMissing";
    private static final String KEY_BUILD_INVALID = "ImportWizard.errors.buildFolderInvalid";
    private static final String KEY_BUILD_MISSING = "ImportWizard.errors.buildFolderMissing";
    private static final String KEY_OS = "ImportWizard.FirstPage.os";
    private static final String KEY_WS = "ImportWizard.FirstPage.ws";
    private static final String KEY_NL = "ImportWizard.FirstPage.nl";
    private static final String KEY_ARCH = "ImportWizard.FirstPage.arch";
    private Label otherLocationLabel;
    private Button runtimeLocationButton;
    private Button changeButton;
    private Button browseButton;
    private Combo dropLocation;
    private Button doImportCheck;
    private Button doExtractCheck;
    private Button changeEnvButton;
    private Label osLabel;
    private Label wsLabel;
    private Label archLabel;
    private Label nlLabel;
    private IStatus dropLocationStatus;

    public PluginImportWizardFirstPage() {
        super("PluginImportWizardPage", true);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.dropLocationStatus = StatusWizardPage.createStatus(0, "");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.runtimeLocationButton = new Button(composite, 32);
        this.fillHorizontal((Control)this.runtimeLocationButton, 2, false);
        this.runtimeLocationButton.setText(PDEPlugin.getResourceString(KEY_RUNTIME_LOCATION));
        this.changeButton = new Button(composite, 8);
        this.changeButton.setText(PDEPlugin.getResourceString(KEY_CHANGE));
        this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.handleChangeTargetPlatform();
            }
        });
        this.changeButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.changeButton);
        int wizardClientWidth = parent.getSize().x - 2 * layout.marginWidth;
        this.otherLocationLabel = new Label(composite, 0);
        this.otherLocationLabel.setText(PDEPlugin.getResourceString(KEY_OTHER_FOLDER));
        this.dropLocation = new Combo(composite, 4);
        this.fillHorizontal((Control)this.dropLocation, 1, true);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(PDEPlugin.getResourceString(KEY_BROWSE));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = PluginImportWizardFirstPage.this.chooseDropLocation();
                if (chosen != null) {
                    PluginImportWizardFirstPage.this.dropLocation.setText(chosen.toOSString());
                }
            }
        });
        this.browseButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.browseButton);
        Label label = new Label(composite, 258);
        GridData gd = this.fillHorizontal((Control)label, 3, false);
        gd.heightHint = 20;
        this.doImportCheck = new Button(composite, 32);
        this.doImportCheck.setText(PDEPlugin.getResourceString(KEY_IMPORT_CHECK));
        this.doImportCheck.setEnabled(false);
        this.fillHorizontal((Control)this.doImportCheck, 3, false);
        this.doExtractCheck = new Button(composite, 32);
        this.doExtractCheck.setText(PDEPlugin.getResourceString(KEY_EXTRACT_CHECK));
        this.fillHorizontal((Control)this.doExtractCheck, 3, false);
        this.createTargetEnvironmentLabels(composite, wizardClientWidth, 3);
        this.changeEnvButton = new Button(composite, 8);
        this.changeEnvButton.setText(PDEPlugin.getResourceString(KEY_CHANGE_TARGET));
        this.changeEnvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.handleEnvChange();
            }
        });
        this.changeEnvButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.changeEnvButton);
        this.initializeFields(this.getDialogSettings());
        this.hookListeners();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.plugin_import_first_page");
    }

    private Label createMultiLineLabel(Composite composite, int parentWidth, String text, int span) {
        Label label = new Label(composite, 64);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.widthHint = parentWidth;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void createTargetEnvironmentLabels(Composite composite, int width, int span) {
        Label label = new Label(composite, 0);
        this.fillHorizontal((Control)label, 3, false);
        Composite container = new Composite(composite, 0);
        this.fillHorizontal((Control)container, 3, false);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.createMultiLineLabel(container, width, PDEPlugin.getResourceString(KEY_TARGET_DESC), 2);
        this.osLabel = this.createTargetLine(container, KEY_OS, TargetPlatform.getOS());
        this.wsLabel = this.createTargetLine(container, KEY_WS, TargetPlatform.getWS());
        this.nlLabel = this.createTargetLine(container, KEY_NL, TargetPlatform.getNL());
        this.archLabel = this.createTargetLine(container, KEY_ARCH, TargetPlatform.getOSArch());
    }

    private void updateTargetLabels() {
        this.osLabel.setText(TargetPlatform.getOS());
        this.wsLabel.setText(TargetPlatform.getWS());
        this.nlLabel.setText(TargetPlatform.getNL());
        this.archLabel.setText(TargetPlatform.getOSArch());
        this.osLabel.getParent().layout(true);
        this.osLabel.getParent().getParent().layout(true);
    }

    private Label createTargetLine(Composite parent, String nameKey, String value) {
        GridData gd = new GridData();
        Label label = new Label(parent, 0);
        label.setText(PDEPlugin.getResourceString(nameKey));
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        label = new Label(parent, 0);
        label.setText(value);
        gd = new GridData(256);
        label.setLayoutData((Object)gd);
        return label;
    }

    private String getTargetHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return preferences.getString("platform_path");
    }

    private void hookListeners() {
        this.runtimeLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.setOtherEnabled(!PluginImportWizardFirstPage.this.runtimeLocationButton.getSelection());
                PluginImportWizardFirstPage.this.updateStatus();
                if (PluginImportWizardFirstPage.this.runtimeLocationButton.getSelection()) {
                    PluginImportWizardFirstPage.this.dropLocation.setText(PluginImportWizardFirstPage.this.getTargetHome());
                }
            }
        });
        this.doImportCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.doExtractCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.updateStatus();
                if (PluginImportWizardFirstPage.this.doExtractCheck.getSelection() && !PluginImportWizardFirstPage.this.doImportCheck.getSelection()) {
                    PluginImportWizardFirstPage.this.doImportCheck.setSelection(true);
                }
                PluginImportWizardFirstPage.this.doImportCheck.setEnabled(!PluginImportWizardFirstPage.this.doExtractCheck.getSelection());
            }
        });
        this.dropLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.updateStatus();
            }
        });
        this.dropLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginImportWizardFirstPage.this.updateStatus();
            }
        });
    }

    private void updateStatus() {
        this.validateDropLocation();
        this.updateStatus(this.dropLocationStatus);
        if (this.dropLocationStatus.getSeverity() == 0 && !this.runtimeLocationButton.getSelection() && this.doExtractCheck.getSelection() && !new Path(this.dropLocation.getText()).equals((Object)new Path(this.getTargetHome()))) {
            this.updateStatus(StatusWizardPage.createStatus(1, PDEPlugin.getResourceString(KEY_SOURCE_REMINDER)));
        }
    }

    private GridData fillHorizontal(Control control, int span, boolean grab) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.grabExcessHorizontalSpace = grab;
        control.setLayoutData((Object)gd);
        return gd;
    }

    private void handleChangeTargetPlatform() {
        TargetPlatformPreferenceNode targetNode = new TargetPlatformPreferenceNode();
        if (this.showPreferencePage(targetNode)) {
            this.dropLocation.setText(ExternalModelManager.getEclipseHome(null).toOSString());
        }
    }

    private void handleEnvChange() {
        TargetEnvironmentPreferenceNode targetNode = new TargetEnvironmentPreferenceNode();
        if (this.showPreferencePage(targetNode)) {
            this.updateTargetLabels();
        }
    }

    private boolean showPreferencePage(final IPreferenceNode targetNode) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    private void initializeFields(IDialogSettings initialSettings) {
        String[] dropItems = new String[]{};
        boolean doExtract = false;
        boolean doOther = false;
        boolean doImport = true;
        if (initialSettings != null) {
            doOther = initialSettings.getBoolean(SETTINGS_DOOTHER);
            doImport = !initialSettings.getBoolean(SETTINGS_DOIMPORT);
            doExtract = initialSettings.getBoolean(SETTINGS_DOEXTRACT);
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (i < 6) {
                String curr = initialSettings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
                if (curr != null && !items.contains(curr)) {
                    items.add(curr);
                }
                ++i;
            }
            dropItems = items.toArray(new String[items.size()]);
        }
        this.dropLocation.setItems(dropItems);
        this.runtimeLocationButton.setSelection(!doOther);
        this.setOtherEnabled(doOther);
        if (doOther) {
            this.dropLocation.select(0);
        } else {
            this.dropLocation.setText(this.getTargetHome());
        }
        this.doImportCheck.setSelection(doImport);
        this.doImportCheck.setEnabled(!doExtract);
        this.doExtractCheck.setSelection(doExtract);
        this.validateDropLocation();
        this.updateStatus(this.dropLocationStatus);
    }

    private void setOtherEnabled(boolean enabled) {
        this.otherLocationLabel.setEnabled(enabled);
        this.dropLocation.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.changeButton.setEnabled(!enabled);
    }

    public void storeSettings(boolean finishPressed) {
        boolean other;
        IDialogSettings settings = this.getDialogSettings();
        boolean bl = other = !this.runtimeLocationButton.getSelection();
        if (finishPressed || this.dropLocation.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.dropLocation.getText());
            String[] items = this.dropLocation.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        if (finishPressed) {
            settings.put(SETTINGS_DOOTHER, other);
            settings.put(SETTINGS_DOIMPORT, !this.doImportCheck.getSelection());
            settings.put(SETTINGS_DOEXTRACT, this.doExtractCheck.getSelection());
        }
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.dropLocation.getText());
        dialog.setText(PDEPlugin.getResourceString(KEY_FOLDER_TITLE));
        dialog.setMessage(PDEPlugin.getResourceString(KEY_FOLDER_MESSAGE));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private void validateDropLocation() {
        if (this.isOtherLocation()) {
            IPath curr = this.getDropLocation();
            if (curr.segmentCount() == 0) {
                this.dropLocationStatus = StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_LOCATION_MISSING));
                return;
            }
            if (!Path.ROOT.isValidPath(this.dropLocation.getText())) {
                this.dropLocationStatus = StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_BUILD_INVALID));
                return;
            }
            File file = curr.toFile();
            if (!file.isDirectory()) {
                this.dropLocationStatus = StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_BUILD_MISSING));
                return;
            }
        }
        this.dropLocationStatus = StatusWizardPage.createStatus(0, "");
    }

    public IPath getDropLocation() {
        return new Path(this.dropLocation.getText());
    }

    public boolean isOtherLocation() {
        return !this.runtimeLocationButton.getSelection();
    }

    public boolean doImportToWorkspace() {
        return this.doImportCheck.getSelection();
    }

    public boolean doExtractPluginSource() {
        return this.doExtractCheck.getSelection();
    }
}

