/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.RegistryLoader;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.StatusWizardPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class PluginImportWizardDetailedPage
extends StatusWizardPage {
    private static final String KEY_TITLE = "ImportWizard.DetailedPage.title";
    private static final String KEY_DESC = "ImportWizard.DetailedPage.desc";
    private PluginImportWizardFirstPage firstPage;
    private IPath dropLocation;
    private CheckboxTableViewer pluginListViewer;
    private TablePart tablePart;
    private static final String SETTINGS_SHOW_IDS = "showIds";
    private static final String KEY_SHOW_NAMES = "ImportWizard.DetailedPage.showNames";
    private static final String KEY_PLUGIN_LIST = "ImportWizard.DetailedPage.pluginList";
    private static final String KEY_INVERT_SELECTION = "ImportWizard.DetailedPage.invertSelection";
    private static final String KEY_EXISTING = "ImportWizard.DetailedPage.existing";
    private static final String KEY_EXISTING_BINARY = "ImportWizard.DetailedPage.existingBinary";
    private static final String KEY_EXISTING_EXTERNAL = "ImportWizard.DetailedPage.existingExternal";
    private static final String KEY_ADD_REQUIRED = "ImportWizard.DetailedPage.addRequired";
    private static final String KEY_LOADING_RUNTIME = "ImportWizard.messages.loadingRuntime";
    private static final String KEY_UPDATING = "ImportWizard.messages.updating";
    private static final String KEY_LOADING_FILE = "ImportWizard.messages.loadingFile";
    private static final String KEY_NO_PLUGINS = "ImportWizard.messages.noPlugins";
    private static final String KEY_NO_SELECTED = "ImportWizard.errors.noPluginSelected";
    private IPluginModelBase[] models;
    private boolean block;
    private HashSet preSelectedModels;

    public PluginImportWizardDetailedPage(PluginImportWizardFirstPage firstPage, HashSet preSelectedModels) {
        super("PluginImportWizardDetailedPage", false);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.firstPage = firstPage;
        this.preSelectedModels = preSelectedModels;
        this.dropLocation = null;
        this.updateStatus(StatusWizardPage.createStatus(4, ""));
        String[] stringArray = new String[8];
        stringArray[0] = PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll");
        stringArray[1] = PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll");
        stringArray[2] = PDEPlugin.getResourceString(KEY_INVERT_SELECTION);
        stringArray[4] = PDEPlugin.getResourceString(KEY_EXISTING);
        stringArray[5] = PDEPlugin.getResourceString(KEY_EXISTING_BINARY);
        stringArray[7] = PDEPlugin.getResourceString(KEY_ADD_REQUIRED);
        String[] buttonLabels = stringArray;
        this.tablePart = new TablePart(PDEPlugin.getResourceString(KEY_PLUGIN_LIST), buttonLabels);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    private void initializeFields(IPath dropLocation) {
        if (!dropLocation.equals((Object)this.dropLocation)) {
            this.updateStatus(StatusWizardPage.createStatus(0, ""));
            this.dropLocation = dropLocation;
            this.models = null;
        }
        if (this.models == null) {
            this.getModels();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(PDEPlugin.getResourceString(PluginImportWizardDetailedPage.KEY_UPDATING), -1);
                    PluginImportWizardDetailedPage.this.pluginListViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            PluginImportWizardDetailedPage.access$2(1.access$0(this.this$1)).setInput((Object)PDEPlugin.getDefault());
                        }
                    });
                    monitor.done();
                }

                static /* synthetic */ PluginImportWizardDetailedPage access$0(1 var0) {
                    return var0.PluginImportWizardDetailedPage.this;
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            if (this.models != null) {
                int i = 0;
                while (i < this.models.length) {
                    String id = this.models[i].getPluginBase().getId();
                    if (id != null && this.preSelectedModels.contains(id)) {
                        this.tablePart.getTableViewer().setChecked((Object)this.models[i], true);
                    }
                    ++i;
                }
                this.tablePart.updateCounter(this.tablePart.getTableViewer().getCheckedElements().length);
            }
        }
    }

    public void storeSettings(boolean finishPressed) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeFields(this.firstPage.getDropLocation());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.pluginListViewer = this.tablePart.getTableViewer();
        this.pluginListViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginListViewer.setLabelProvider((IBaseLabelProvider)new PluginLabelProvider());
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.plugin_import_second_page");
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public IPluginModelBase[] getModels() {
        if (this.models != null) {
            return this.models;
        }
        if (this.dropLocation == null) {
            return null;
        }
        if (this.dropLocation.equals((Object)ExternalModelManager.getEclipseHome(null))) {
            final ExternalModelManager registry = PDECore.getDefault().getExternalModelManager();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(PDEPlugin.getResourceString(PluginImportWizardDetailedPage.KEY_LOADING_RUNTIME), -1);
                    PluginImportWizardDetailedPage.this.models = registry.getAllModels();
                    monitor.done();
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (Throwable e) {
                PDEPlugin.logException(e);
            }
        } else {
            final Vector result = new Vector();
            final Vector fresult = new Vector();
            if (this.dropLocation != null) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(PDEPlugin.getResourceString(PluginImportWizardDetailedPage.KEY_LOADING_FILE), -1);
                        MultiStatus errors = RegistryLoader.loadFromDirectories((Vector)result, (Vector)fresult, (String[])PluginImportWizardDetailedPage.this.createPaths(PluginImportWizardDetailedPage.this.dropLocation), (boolean)false, (boolean)false, (IProgressMonitor)monitor);
                        if (errors != null && errors.getChildren().length > 0) {
                            PDEPlugin.log((IStatus)errors);
                        }
                        PluginImportWizardDetailedPage.this.models = new IPluginModelBase[result.size() + fresult.size()];
                        System.arraycopy(result.toArray(new IPluginModel[result.size()]), 0, PluginImportWizardDetailedPage.this.models, 0, result.size());
                        System.arraycopy(fresult.toArray(new IFragmentModel[fresult.size()]), 0, PluginImportWizardDetailedPage.this.models, result.size(), fresult.size());
                        monitor.done();
                    }
                };
                try {
                    this.getContainer().run(true, false, op);
                }
                catch (Throwable e) {
                    PDEPlugin.logException(e);
                }
            }
        }
        return this.models;
    }

    private String[] createPaths(IPath dropLocation) {
        ArrayList<String> paths = new ArrayList<String>();
        File pluginsDir = new File(dropLocation.toFile(), "plugins");
        if (pluginsDir.exists()) {
            paths.add(pluginsDir.getAbsolutePath());
        }
        if (dropLocation.toFile().exists()) {
            paths.add(dropLocation.toFile().getAbsolutePath());
        }
        return paths.toArray(new String[paths.size()]);
    }

    public IPluginModelBase[] getSelectedModels() {
        Object[] selected = this.tablePart.getSelection();
        IPluginModelBase[] result = new IPluginModelBase[selected.length];
        System.arraycopy(selected, 0, result, 0, selected.length);
        return result;
    }

    private IStatus validatePlugins() {
        IPluginModelBase[] allModels = this.getModels();
        if (allModels == null || allModels.length == 0) {
            return StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_NO_PLUGINS));
        }
        if (this.tablePart.getSelectionCount() == 0) {
            return StatusWizardPage.createStatus(1, PDEPlugin.getResourceString(KEY_NO_SELECTED));
        }
        return StatusWizardPage.createStatus(0, "");
    }

    private void dialogChanged() {
        IStatus genStatus = this.validatePlugins();
        this.updateStatus(genStatus);
        if (this.tablePart.getSelectionCount() == 0) {
            this.setPageComplete(false);
        }
    }

    private void buttonSelected(int index) {
        if (index == 2) {
            this.invertSelection();
            return;
        }
        ArrayList checked = null;
        switch (index) {
            case 4: {
                checked = this.selectExistingProjects();
                break;
            }
            case 5: {
                checked = this.selectLibraryProjects();
                break;
            }
            case 7: {
                checked = this.selectDependentPlugins();
                break;
            }
            default: {
                return;
            }
        }
        this.tablePart.setSelection(checked.toArray());
    }

    private void invertSelection() {
        IPluginModelBase[] models = this.getModels();
        Vector<IPluginModelBase> selected = new Vector<IPluginModelBase>();
        int i = 0;
        while (i < models.length) {
            IPluginModelBase model = models[i];
            if (!this.pluginListViewer.getChecked((Object)model)) {
                selected.add(model);
            }
            ++i;
        }
        this.tablePart.setSelection(selected.toArray());
    }

    private ArrayList selectExistingProjects() {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        ArrayList<IPluginModelBase> selected = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] models = this.getModels();
        int i = 0;
        while (i < models.length) {
            IPluginModelBase curr = models[i];
            String id = curr.getPluginBase().getId();
            IProject proj = (IProject)root.findMember(id);
            if (proj != null && proj.isOpen()) {
                selected.add(curr);
            }
            ++i;
        }
        return selected;
    }

    private ArrayList selectLibraryProjects() {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        ArrayList<IPluginModelBase> selected = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] models = this.getModels();
        int i = 0;
        while (i < models.length) {
            IPluginModelBase curr = models[i];
            String id = curr.getPluginBase().getId();
            IProject proj = (IProject)root.findMember(id);
            if (proj != null && WorkspaceModelManager.isBinaryPluginProject((IProject)proj)) {
                selected.add(curr);
            }
            ++i;
        }
        return selected;
    }

    private ArrayList selectDependentPlugins() {
        IPluginModelBase model;
        HashSet<IPluginModelBase> checked = new HashSet<IPluginModelBase>();
        Object[] selected = this.tablePart.getSelection();
        if (selected.length == 1 && (model = (IPluginModelBase)selected[0]).getPluginBase().getId().equals("org.eclipse.core.boot")) {
            checked.add(model);
            return new ArrayList(checked);
        }
        if (selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                IPluginModelBase model2 = (IPluginModelBase)selected[i];
                this.addPluginAndDependent(model2, checked);
                ++i;
            }
        }
        return new ArrayList(checked);
    }

    private IPluginModelBase findModel(String id) {
        IPluginModelBase[] models = this.getModels();
        int i = 0;
        while (i < models.length) {
            IPluginModelBase model = models[i];
            if (model.getPluginBase().getId().equals(id)) {
                return model;
            }
            ++i;
        }
        return null;
    }

    private IFragmentModel[] findFragments(IPlugin plugin) {
        String pluginId = plugin.getId();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.models.length) {
            IFragment fragment;
            String refId;
            IPluginModelBase model = this.models[i];
            if (model instanceof IFragmentModel && pluginId.equalsIgnoreCase(refId = (fragment = ((IFragmentModel)model).getFragment()).getPluginId())) {
                result.add(model);
            }
            ++i;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    private void addPluginAndDependent(IPluginModelBase model, HashSet checked) {
        this.addPluginAndDependent(model, checked, true);
    }

    private void addPluginAndDependent(IPluginModelBase model, HashSet checked, boolean addFragmentPlugin) {
        IFragment fragment;
        String id;
        IPluginModelBase found;
        if (!checked.add(model)) {
            return;
        }
        if (model instanceof IPluginModel) {
            IPlugin plugin = ((IPluginModel)model).getPlugin();
            IPluginImport[] required = plugin.getImports();
            if (required.length > 0) {
                int k = 0;
                while (k < required.length) {
                    String id2 = required[k].getId();
                    IPluginModelBase found2 = this.findModel(id2);
                    if (found2 != null) {
                        this.addPluginAndDependent(found2, checked);
                    }
                    ++k;
                }
            }
            IFragmentModel[] fragments = this.findFragments(plugin);
            int i = 0;
            while (i < fragments.length) {
                this.addPluginAndDependent((IPluginModelBase)fragments[i], checked, false);
                ++i;
            }
        }
        if (addFragmentPlugin && model instanceof IFragmentModel && (found = this.findModel(id = (fragment = ((IFragmentModel)model).getFragment()).getPluginId())) != null) {
            this.addPluginAndDependent(found, checked);
        }
    }

    public class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return PluginImportWizardDetailedPage.this.getModels();
        }
    }

    class PluginLabelProvider
    extends LabelProvider {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();

        public String getText(Object obj) {
            return this.provider.getText(obj);
        }

        public Image getImage(Object obj) {
            Image image = this.provider.getImage(obj);
            IPluginModelBase model = (IPluginModelBase)obj;
            String id = model.getPluginBase().getId();
            if (!PDEPlugin.getWorkspace().getRoot().exists((IPath)new Path(id))) {
                return image;
            }
            int flags = 256;
            return this.provider.get(image, flags);
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel, String[] buttonLabels) {
            super(mainLabel, buttonLabels);
            this.setSelectAllIndex(0);
            this.setDeselectAllIndex(1);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            PluginImportWizardDetailedPage.this.dialogChanged();
        }

        public void buttonSelected(Button button, int index) {
            if (index == 0 || index == 1) {
                super.buttonSelected(button, index);
            } else {
                PluginImportWizardDetailedPage.this.buttonSelected(index);
            }
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, factory);
            viewer.setSorter(ListUtil.PLUGIN_SORTER);
            return viewer;
        }
    }
}

