/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.pde.internal.ui.wizards.imports.UpdateClasspathAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class PluginImportWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "PluginImportWizard";
    private static final String KEY_WTITLE = "ImportWizard.title";
    private static final String KEY_NO_TO_ALL_LABEL = "ImportWizard.noToAll";
    private static final String KEY_MESSAGES_TITLE = "ImportWizard.messages.title";
    private static final String KEY_MESSAGES_NO_PLUGINS = "ImportWizard.messages.noPlugins";
    private static final String KEY_MESSAGES_DO_NOT_ASK = "ImportWizard.messages.doNotAsk";
    private static final String KEY_MESSAGES_EXISTS = "ImportWizard.messages.exists";
    private PluginImportWizardFirstPage page1;
    private PluginImportWizardDetailedPage page2;
    private HashSet preSelectedModels = new HashSet();

    public PluginImportWizard() {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_IMPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object[] items = selection.toArray();
        WorkspaceModelManager wManager = PDECore.getDefault().getWorkspaceModelManager();
        int i = 0;
        while (i < items.length) {
            IModel model;
            IFile file;
            IProject project = null;
            if (items[i] instanceof IProject) {
                project = (IProject)items[i];
            } else if (items[i] instanceof IJavaProject) {
                project = ((IJavaProject)items[i]).getProject();
            } else if (items[i] instanceof IFile && ((file = (IFile)items[i]).getName().equals("plugin.xml") || file.getName().equals("fragment.xml"))) {
                project = file.getProject();
            }
            if (project != null && (model = wManager.getWorkspaceModel(project)) != null && model instanceof WorkspacePluginModelBase) {
                this.preSelectedModels.add(((WorkspacePluginModelBase)model).getPluginBase().getId());
            }
            ++i;
        }
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.page1 = new PluginImportWizardFirstPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new PluginImportWizardDetailedPage(this.page1, this.preSelectedModels);
        this.addPage((IWizardPage)this.page2);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        ArrayList modelIds = new ArrayList();
        try {
            IPluginModelBase[] models = this.page2.getSelectedModels();
            if (models.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)PDEPlugin.getResourceString(KEY_MESSAGES_TITLE), (String)PDEPlugin.getResourceString(KEY_MESSAGES_NO_PLUGINS));
                return false;
            }
            this.page1.storeSettings(true);
            this.page2.storeSettings(true);
            IRunnableWithProgress op = PluginImportWizard.getImportOperation(this.getShell(), this.page1.doImportToWorkspace(), this.page1.doExtractPluginSource(), models, modelIds);
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return true;
        }
        return true;
    }

    public static IRunnableWithProgress getImportOperation(final Shell shell, final boolean doImport, final boolean doExtract, final IPluginModelBase[] models, final ArrayList modelIds) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean isAutoBuilding = PDEPlugin.getWorkspace().isAutoBuilding();
                try {
                    try {
                        int numUnits = 2;
                        if (isAutoBuilding) {
                            IWorkspace workspace = PDEPlugin.getWorkspace();
                            IWorkspaceDescription description = workspace.getDescription();
                            description.setAutoBuilding(false);
                            workspace.setDescription(description);
                            ++numUnits;
                        }
                        monitor.beginTask("", numUnits);
                        ReplaceQuery query = new ReplaceQuery(shell);
                        PluginImportOperation op = new PluginImportOperation(models, modelIds, doImport, doExtract, query);
                        PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    try {
                        PDEPlugin.getWorkspace().run(PluginImportWizard.getUpdateClasspathOperation(modelIds), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (isAutoBuilding) {
                            IWorkspace workspace = PDEPlugin.getWorkspace();
                            IWorkspaceDescription description = workspace.getDescription();
                            description.setAutoBuilding(true);
                            workspace.setDescription(description);
                            PDEPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (CoreException coreException) {}
                    monitor.done();
                    throw throwable;
                }
                Object var6_10 = null;
                try {
                    PDEPlugin.getWorkspace().run(PluginImportWizard.getUpdateClasspathOperation(modelIds), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (isAutoBuilding) {
                        IWorkspace workspace = PDEPlugin.getWorkspace();
                        IWorkspaceDescription description = workspace.getDescription();
                        description.setAutoBuilding(true);
                        workspace.setDescription(description);
                        PDEPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                catch (CoreException coreException) {}
                monitor.done();
            }
        };
    }

    private static IWorkspaceRunnable getUpdateClasspathOperation(final ArrayList modelIds) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                UpdateClasspathAction.doUpdateClasspath(monitor, PluginImportWizard.getWorkspaceCounterparts(modelIds));
            }
        };
    }

    public boolean performCancel() {
        this.page1.storeSettings(false);
        this.page2.storeSettings(false);
        return super.performCancel();
    }

    private static IPluginModelBase[] getWorkspaceCounterparts(ArrayList modelIds) {
        IPluginModelBase[] allModels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
        ArrayList<IPluginModelBase> desiredModels = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < allModels.length) {
            if (modelIds.contains(allModels[i].getPluginBase().getId())) {
                desiredModels.add(allModels[i]);
            }
            ++i;
        }
        return desiredModels.toArray(new IPluginModelBase[desiredModels.size()]);
    }

    private static class ReplaceDialog
    extends MessageDialog {
        public ReplaceDialog(Shell parentShell, String dialogMessage) {
            super(parentShell, PDEPlugin.getResourceString(PluginImportWizard.KEY_MESSAGES_TITLE), null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, PDEPlugin.getResourceString(PluginImportWizard.KEY_NO_TO_ALL_LABEL), IDialogConstants.CANCEL_LABEL}, 0);
        }
    }

    private static class ReplaceQuery
    implements PluginImportOperation.IReplaceQuery {
        private Shell shell;
        private int yesToAll = 0;
        private int[] RETURNCODES;

        public ReplaceQuery(Shell shell) {
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[1] = 2;
            nArray[2] = 1;
            nArray[3] = 1;
            this.RETURNCODES = nArray;
            this.shell = shell;
        }

        public int doQuery(IProject project) {
            if (this.yesToAll != 0) {
                return this.yesToAll > 0 ? 2 : 1;
            }
            String message = PDEPlugin.getFormattedMessage(PluginImportWizard.KEY_MESSAGES_EXISTS, project.getName());
            int[] result = new int[1];
            this.shell.getDisplay().syncExec(new Runnable(this, message, result){
                private final /* synthetic */ ReplaceQuery this$1;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = replaceQuery;
                    this.val$message = string;
                    this.val$result = nArray;
                }

                public void run() {
                    ReplaceDialog dialog = new ReplaceDialog(ReplaceQuery.access$0(this.this$1), this.val$message);
                    int retVal = dialog.open();
                    if (retVal >= 0) {
                        this.val$result[0] = ReplaceQuery.access$1(this.this$1)[retVal];
                        if (retVal == 1) {
                            ReplaceQuery.access$2(this.this$1, 1);
                        } else if (retVal == 3) {
                            ReplaceQuery.access$2(this.this$1, -1);
                        }
                    }
                }
            });
            return result[0];
        }

        static /* synthetic */ Shell access$0(ReplaceQuery replaceQuery) {
            return replaceQuery.shell;
        }

        static /* synthetic */ int[] access$1(ReplaceQuery replaceQuery) {
            return replaceQuery.RETURNCODES;
        }

        static /* synthetic */ void access$2(ReplaceQuery replaceQuery, int n) {
            replaceQuery.yesToAll = n;
        }
    }
}

