/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.Assert;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.imports.UpdateClasspathOperation;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class PluginImportOperation
implements IWorkspaceRunnable {
    private static final String KEY_TITLE = "ImportWizard.messages.title";
    private static final String KEY_CREATING = "ImportWizard.operation.creating";
    private static final String KEY_MULTI_PROBLEM = "ImportWizard.operation.multiProblem";
    private static final String KEY_PROBLEM = "ImportWizard.operation.problem";
    private static final String KEY_CREATING2 = "ImportWizard.operation.creating2";
    private static final String KEY_EXTRACTING = "ImportWizard.operation.extracting";
    private static final String KEY_COPYING_SOURCE = "ImportWizard.operation.copyingSource";
    private IPluginModelBase[] models;
    private ArrayList modelIds;
    private boolean doImport;
    private boolean extractSource;
    private IWorkspaceRoot root;
    private IReplaceQuery replaceQuery;

    public PluginImportOperation(IPluginModelBase[] models, ArrayList modelIds, boolean doImport, boolean doExtractSource, IReplaceQuery replaceQuery) {
        Assert.isNotNull((Object)models);
        Assert.isNotNull((Object)replaceQuery);
        this.models = models;
        this.modelIds = modelIds;
        this.extractSource = doExtractSource;
        this.doImport = doExtractSource ? true : doImport;
        this.root = ResourcesPlugin.getWorkspace().getRoot();
        this.replaceQuery = replaceQuery;
    }

    private IFragment[] findFragmentsFor(IPlugin plugin) {
        ArrayList<IFragment> result = new ArrayList<IFragment>();
        int i = 0;
        while (i < this.models.length) {
            IFragment fragment;
            IPluginModelBase model = this.models[i];
            if (model.isFragmentModel() && PDECore.compare((String)(fragment = (IFragment)model.getPluginBase()).getPluginId(), (String)fragment.getPluginVersion(), (String)plugin.getId(), (String)plugin.getVersion(), (int)fragment.getRule())) {
                result.add(fragment);
            }
            ++i;
        }
        return result.toArray(new IFragment[result.size()]);
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(PDEPlugin.getResourceString(KEY_CREATING), this.models.length);
        try {
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEPlugin.getResourceString(KEY_MULTI_PROBLEM), null);
            int i = 0;
            while (i < this.models.length) {
                try {
                    this.createProject(this.models[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    multiStatus.merge(e.getStatus());
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            if (!multiStatus.isOK()) {
                throw new CoreException((IStatus)multiStatus);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        Object var5_7 = null;
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProject(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        block17: {
            block16: {
                String name = model.getPluginBase().getId();
                String task = PDEPlugin.getFormattedMessage(KEY_CREATING2, name);
                monitor.beginTask(task, 8);
                try {
                    IProject project;
                    block19: {
                        block18: {
                            project = this.root.getProject(name);
                            if (!project.exists()) break block18;
                            if (this.queryReplace(project)) {
                                project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                try {
                                    RepositoryProvider.unmap((IProject)project);
                                }
                                catch (TeamException teamException) {}
                                break block19;
                            } else {
                                Object var11_6 = null;
                                break block16;
                            }
                        }
                        monitor.worked(1);
                    }
                    project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!project.isOpen()) {
                        project.open(null);
                    }
                    File pluginDir = new File(model.getInstallLocation());
                    IFile buildFile = project.getFile("build.properties");
                    WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
                    if (this.doImport) {
                        this.importContent(pluginDir, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (this.extractSource) {
                            this.configureBinIncludes(pluginDir, buildModel);
                        }
                        this.importSource(project, model.getPluginBase(), (IPath)new Path(pluginDir.getPath()), this.doImport, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        this.linkContent(pluginDir, project, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                    boolean isJavaProject = model.getPluginBase().getLibraries().length > 0;
                    this.setProjectDescription(project, isJavaProject, monitor);
                    if (!this.doImport) {
                        try {
                            RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
                        }
                        catch (TeamException teamException) {}
                    }
                    boolean sourceFound = false;
                    if (isJavaProject & this.extractSource) {
                        sourceFound = this.doExtractSource(project, model, buildModel, monitor);
                    }
                    if (!(!this.doImport || isJavaProject && sourceFound)) {
                        project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
                    }
                    if (isJavaProject) {
                        this.modelIds.add(model.getPluginBase().getId());
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var11_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var11_8 = null;
        monitor.done();
    }

    private void configureBinIncludes(File pluginDir, WorkspaceBuildModel buildModel) {
        IBuild build = buildModel.getBuild(true);
        IBuildEntry entry = buildModel.getFactory().createEntry("bin.includes");
        File[] files = pluginDir.listFiles();
        try {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                String token = file.getName();
                if (file.isDirectory()) {
                    token = String.valueOf(token) + "/";
                }
                entry.addToken(token);
                ++i;
            }
            build.add(entry);
            buildModel.save();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void importContent(Object source, IPath destPath, IImportStructureProvider provider, List filesToImport, IProgressMonitor monitor) throws CoreException {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        ImportOperation op = new ImportOperation(destPath, source, provider, query);
        op.setCreateContainerStructure(false);
        if (filesToImport != null) {
            op.setFilesToImport(filesToImport);
        }
        try {
            op.run(monitor);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof CoreException) {
                throw (CoreException)th;
            }
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private void importSource(IProject project, IPluginBase plugin, IPath pluginPath, boolean doImport, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void importSourceFile(IProject project, File srcFile, IPath srcPath, boolean doImport) throws CoreException {
        try {
            if (doImport) {
                IFile file = project.getFile(srcPath);
                FileInputStream fstream = new FileInputStream(srcFile);
                if (file.exists()) {
                    file.setContents((InputStream)fstream, true, false, null);
                } else {
                    file.create((InputStream)fstream, true, null);
                }
                fstream.close();
            } else {
                IFile file = project.getFile(srcPath);
                if (!(file.getParent() instanceof IProject)) {
                    file = project.getFile(this.getFlatPath(srcPath));
                }
                file.createLink((IPath)new Path(srcFile.getPath()), 0, null);
            }
        }
        catch (IOException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private String getFlatPath(IPath path) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < path.segmentCount()) {
            if (i > 0) {
                buf.append("_");
            }
            buf.append(path.segment(i));
            ++i;
        }
        return buf.toString();
    }

    private boolean importCrossFragmentSource(IProject project, SourceLocationManager manager, IPlugin plugin, IPath srcPath, IFragment fragment, boolean doImport) {
        String id = fragment.getId();
        IProject fragmentProject = PDEPlugin.getWorkspace().getRoot().getProject(id);
        if (!fragmentProject.exists()) {
            return false;
        }
        IFile fragmentFile = fragmentProject.getFile(srcPath);
        if (fragmentFile.exists()) {
            return true;
        }
        File srcFile = manager.findSourceFile((IPluginBase)fragment, srcPath);
        if (srcFile == null) {
            return false;
        }
        try {
            this.importSourceFile(fragmentProject, srcFile, srcPath, doImport);
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void linkContent(File sourceDir, IProject project, IProgressMonitor monitor) throws CoreException {
        File[] items = sourceDir.listFiles();
        monitor.beginTask("Linking content...", items.length);
        int i = 0;
        while (i < items.length) {
            File sourceFile = items[i];
            if (sourceFile.isDirectory()) {
                IFolder folder = project.getFolder(sourceFile.getName());
                folder.createLink((IPath)new Path(sourceFile.getPath()), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                String fileName = sourceFile.getName();
                if (!fileName.equals(".classpath") && !fileName.equals(".project")) {
                    IFile file = project.getFile(fileName);
                    file.createLink((IPath)new Path(sourceFile.getPath()), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            monitor.worked(1);
            ++i;
        }
    }

    private boolean doExtractSource(IProject project, IPluginModelBase model, WorkspaceBuildModel buildModel, IProgressMonitor monitor) throws CoreException {
        boolean sourceFound = false;
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        IClasspathEntry[] entries = new IClasspathEntry[libraries.length];
        int i = 0;
        while (i < libraries.length) {
            entries[i] = UpdateClasspathOperation.getLibraryEntry(project, libraries[i], true);
            ++i;
        }
        monitor.beginTask(PDEPlugin.getResourceString(KEY_EXTRACTING), entries.length * 2);
        try {
            IBuild build = buildModel.getBuild(true);
            int i2 = 0;
            while (i2 < entries.length) {
                IClasspathEntry entry = entries[i2];
                IPath curr = entry.getPath();
                IPath entryPath = curr.removeFirstSegments(1).makeRelative();
                String entryName = "source." + entryPath.toString();
                IBuildEntry buildEntry = null;
                IPath sourceAttach = entry.getSourceAttachmentPath();
                if (sourceAttach != null) {
                    IResource res = this.root.findMember(sourceAttach);
                    if (res instanceof IFile) {
                        String name = curr.removeFileExtension().lastSegment();
                        IFolder dest = project.getFolder("src-" + name);
                        if (buildEntry == null) {
                            buildEntry = buildModel.getFactory().createEntry(entryName);
                            build.add(buildEntry);
                        }
                        buildEntry.addToken(String.valueOf(dest.getName()) + "/");
                        if (!dest.exists()) {
                            dest.create(true, true, null);
                        }
                        this.extractZipFile(res, dest, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        sourceFound = true;
                        res = this.root.findMember(curr);
                        if (res instanceof IFile) {
                            this.extractResources(res, dest, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            this.createJarPackagerFiles(dest, (IFile)res);
                            res.delete(true, monitor);
                            if (dest.getFolder("META-INF").exists()) {
                                dest.getFolder("META-INF").delete(true, monitor);
                            }
                        } else {
                            monitor.worked(1);
                        }
                    } else {
                        monitor.worked(2);
                    }
                } else {
                    monitor.worked(2);
                }
                ++i2;
            }
            buildModel.save();
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            monitor.done();
            throw throwable;
        }
        Object var19_22 = null;
        monitor.done();
        return sourceFound;
    }

    private void extractZipFile(IResource res, IFolder dest, IProgressMonitor monitor) throws CoreException {
        block10: {
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(res.getLocation().toFile());
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                    this.importContent(provider.getRoot(), dest.getFullPath(), (IImportStructureProvider)provider, null, monitor);
                }
                catch (IOException e) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var7_10 = null;
            if (zipFile == null) break block10;
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void extractResources(IResource res, IFolder dest, IProgressMonitor monitor) throws CoreException {
        block10: {
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(res.getLocation().toFile());
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                    ArrayList collected = new ArrayList();
                    this.collectResources(provider, provider.getRoot(), collected);
                    this.importContent(provider.getRoot(), dest.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
                }
                catch (IOException e) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var7_11 = null;
            if (zipFile == null) break block10;
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void collectResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    this.collectResources(provider, curr, collected);
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    private void createJarPackagerFiles(IFolder sourceFolder, IFile jarFile) throws CoreException {
        IProject project = sourceFolder.getProject();
        IFolder scriptsFolder = project.getFolder("scripts");
        if (!scriptsFolder.exists()) {
            scriptsFolder.create(true, true, null);
        }
        IFile descriptorFile = scriptsFolder.getFile(String.valueOf(sourceFolder.getName()) + ".jardesc");
        String string = this.constructJarPackagerFileContent(sourceFolder, jarFile, descriptorFile.getFullPath());
        if (!descriptorFile.exists()) {
            descriptorFile.create((InputStream)new ByteArrayInputStream(string.getBytes()), true, null);
        } else {
            descriptorFile.setContents((InputStream)new ByteArrayInputStream(string.getBytes()), true, true, null);
        }
    }

    private String constructJarPackagerFileContent(IFolder folder, IFile jarFile, IPath descriptorPath) {
        IPath folderPath = folder.getFullPath();
        IPath manifestPath = folderPath.append("META-INF").append("MANIFEST.MF");
        IPackageFragmentRoot root = JavaCore.create((IProject)folder.getProject()).getPackageFragmentRoot((IResource)folder);
        StringBuffer buf = new StringBuffer();
        String lineDelim = System.getProperty("line.separator", "\n");
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append(lineDelim);
        buf.append("<jardesc>");
        buf.append(lineDelim);
        buf.append("\t<jar path=\"");
        buf.append(jarFile.getLocation().toString());
        buf.append("\"/>");
        buf.append(lineDelim);
        buf.append("\t<options compress=\"true\"");
        buf.append(lineDelim);
        buf.append("\t\tdescriptionLocation=\"");
        buf.append(descriptorPath.toString());
        buf.append('\"');
        buf.append(lineDelim);
        buf.append("\t\texportErrors=\"true\" exportWarnings=\"true\" logErrors=\"true\"");
        buf.append(lineDelim);
        buf.append("\t\tlogWarnings=\"true\" overwrite=\"false\" saveDescription=\"true\" useSourceFolders=\"false\"/>");
        buf.append(lineDelim);
        buf.append("\t<manifest generateManifest=\"false\"");
        buf.append(lineDelim);
        buf.append("\t\tmanifestLocation=\"");
        buf.append(manifestPath.toString());
        buf.append('\"');
        buf.append(lineDelim);
        buf.append("\t\tmanifestVersion=\"1.0\" reuseManifest=\"false\" saveManifest=\"false\" usesManifest=\"false\">");
        buf.append(lineDelim);
        buf.append("\t\t<sealing sealJar=\"false\"><packagesToSeal/><packagesToUnSeal/></sealing>");
        buf.append(lineDelim);
        buf.append("\t</manifest>");
        buf.append(lineDelim);
        buf.append("\t<selectedElements exportClassFiles=\"true\" exportJavaFiles=\"false\">");
        buf.append(lineDelim);
        buf.append("\t\t<javaElement handleIdentifier=\"");
        buf.append(root.getHandleIdentifier());
        buf.append("\"/>");
        buf.append(lineDelim);
        buf.append("\t</selectedElements>");
        buf.append(lineDelim);
        buf.append("</jardesc>");
        buf.append(lineDelim);
        return buf.toString();
    }

    private boolean queryReplace(IProject project) throws OperationCanceledException {
        switch (this.replaceQuery.doQuery(project)) {
            case 0: {
                throw new OperationCanceledException();
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    private void setProjectDescription(IProject project, boolean needsJavaNature, IProgressMonitor monitor) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (needsJavaNature) {
            desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
        } else {
            desc.setNatureIds(new String[]{"org.eclipse.pde.PluginNature"});
        }
        project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    public interface IReplaceQuery {
        public static final int CANCEL = 0;
        public static final int NO = 1;
        public static final int YES = 2;

        public int doQuery(IProject var1);
    }
}

