/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.StatusWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class FeatureImportWizardFirstPage
extends StatusWizardPage {
    private static final String SETTINGS_DROPLOCATION = "droplocation";
    private static final String SETTINGS_DOOTHER = "doother";
    private static final String KEY_TITLE = "FeatureImportWizard.FirstPage.title";
    private static final String KEY_DESC = "FeatureImportWizard.FirstPage.desc";
    private static final String KEY_RUNTIME_LOCATION = "FeatureImportWizard.FirstPage.runtimeLocation";
    private static final String KEY_OTHER_LOCATION = "FeatureImportWizard.FirstPage.otherLocation";
    private static final String KEY_RUNTIME_DESC = "FeatureImportWizard.FirstPage.runtimeDesc";
    private static final String KEY_OTHER_DESC = "ImportWizard.FirstPage.otherDesc";
    private static final String KEY_OTHER_FOLDER = "FeatureImportWizard.FirstPage.otherFolder";
    private static final String KEY_SOURCE_REMINDER = "FeatureImportWizard.FirstPage.sourceReminder";
    private static final String KEY_BROWSE = "FeatureImportWizard.FirstPage.browse";
    private static final String KEY_FOLDER_TITLE = "FeatureImportWizard.messages.folder.title";
    private static final String KEY_FOLDER_MESSAGE = "FeatureImportWizard.messages.folder.message";
    private static final String KEY_LOCATION_MISSING = "FeatureImportWizard.errors.locationMissing";
    private static final String KEY_BUILD_INVALID = "FeatureImportWizard.errors.buildFolderInvalid";
    private static final String KEY_BUILD_MISSING = "FeatureImportWizard.errors.buildFolderMissing";
    private Label otherLocationLabel;
    private Button runtimeLocationButton;
    private Button browseButton;
    private Combo dropLocation;
    private IStatus dropLocationStatus;

    public FeatureImportWizardFirstPage() {
        super("FeatureImportWizardPage", true);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.dropLocationStatus = StatusWizardPage.createStatus(0, "");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.runtimeLocationButton = new Button(composite, 32);
        this.fillHorizontal((Control)this.runtimeLocationButton, 3, false);
        this.runtimeLocationButton.setText(PDEPlugin.getResourceString(KEY_RUNTIME_LOCATION));
        int cfr_ignored_0 = parent.getSize().x - 2 * layout.marginWidth;
        this.otherLocationLabel = new Label(composite, 0);
        this.otherLocationLabel.setText(PDEPlugin.getResourceString(KEY_OTHER_FOLDER));
        this.dropLocation = new Combo(composite, 4);
        this.fillHorizontal((Control)this.dropLocation, 1, true);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(PDEPlugin.getResourceString(KEY_BROWSE));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = FeatureImportWizardFirstPage.this.chooseDropLocation();
                if (chosen != null) {
                    FeatureImportWizardFirstPage.this.dropLocation.setText(chosen.toOSString());
                }
            }
        });
        this.browseButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.browseButton);
        this.initializeFields(this.getDialogSettings());
        this.hookListeners();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.feature_import_first_page");
    }

    private Label createMultiLineLabel(Composite composite, int parentWidth, String text, int span) {
        Label label = new Label(composite, 64);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.widthHint = parentWidth;
        label.setLayoutData((Object)gd);
        return label;
    }

    private String getTargetHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return preferences.getString("platform_path");
    }

    private void hookListeners() {
        this.runtimeLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardFirstPage.this.setOtherEnabled(!FeatureImportWizardFirstPage.this.runtimeLocationButton.getSelection());
                FeatureImportWizardFirstPage.this.updateStatus();
                if (FeatureImportWizardFirstPage.this.runtimeLocationButton.getSelection()) {
                    FeatureImportWizardFirstPage.this.dropLocation.setText(FeatureImportWizardFirstPage.this.getTargetHome());
                }
            }
        });
        this.dropLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardFirstPage.this.updateStatus();
            }
        });
        this.dropLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeatureImportWizardFirstPage.this.updateStatus();
            }
        });
    }

    private void updateStatus() {
        this.validateDropLocation();
        this.updateStatus(this.dropLocationStatus);
    }

    private GridData fillHorizontal(Control control, int span, boolean grab) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.grabExcessHorizontalSpace = grab;
        control.setLayoutData((Object)gd);
        return gd;
    }

    private boolean showPreferencePage(final IPreferenceNode targetNode) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    private void initializeFields(IDialogSettings initialSettings) {
        String[] dropItems = new String[]{};
        boolean doOther = false;
        if (initialSettings != null) {
            doOther = initialSettings.getBoolean(SETTINGS_DOOTHER);
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (i < 6) {
                String curr = initialSettings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
                if (curr != null && !items.contains(curr)) {
                    items.add(curr);
                }
                ++i;
            }
            dropItems = items.toArray(new String[items.size()]);
        }
        this.dropLocation.setItems(dropItems);
        this.runtimeLocationButton.setSelection(!doOther);
        this.setOtherEnabled(doOther);
        if (doOther) {
            this.dropLocation.select(0);
        } else {
            this.dropLocation.setText(this.getTargetHome());
        }
        this.validateDropLocation();
        this.updateStatus(this.dropLocationStatus);
    }

    private void setOtherEnabled(boolean enabled) {
        this.otherLocationLabel.setEnabled(enabled);
        this.dropLocation.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public void storeSettings(boolean finishPressed) {
        boolean other;
        IDialogSettings settings = this.getDialogSettings();
        boolean bl = other = !this.runtimeLocationButton.getSelection();
        if (finishPressed || this.dropLocation.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.dropLocation.getText());
            String[] items = this.dropLocation.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        if (finishPressed) {
            settings.put(SETTINGS_DOOTHER, other);
        }
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.dropLocation.getText());
        dialog.setText(PDEPlugin.getResourceString(KEY_FOLDER_TITLE));
        dialog.setMessage(PDEPlugin.getResourceString(KEY_FOLDER_MESSAGE));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private void validateDropLocation() {
        if (this.isOtherLocation()) {
            IPath curr = this.getDropLocation();
            if (curr.segmentCount() == 0) {
                this.dropLocationStatus = StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_LOCATION_MISSING));
                return;
            }
            if (!Path.ROOT.isValidPath(this.dropLocation.getText())) {
                this.dropLocationStatus = StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_BUILD_INVALID));
                return;
            }
            File file = curr.toFile();
            if (!file.exists() || !file.isDirectory()) {
                this.dropLocationStatus = StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_BUILD_MISSING));
                return;
            }
        }
        this.dropLocationStatus = StatusWizardPage.createStatus(0, "");
    }

    public IPath getDropLocation() {
        return new Path(this.dropLocation.getText());
    }

    public boolean isOtherLocation() {
        return !this.runtimeLocationButton.getSelection();
    }
}

