/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.StatusWizardPage;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class FeatureImportWizardDetailedPage
extends StatusWizardPage {
    private static final String KEY_TITLE = "FeatureImportWizard.DetailedPage.title";
    private static final String KEY_DESC = "FeatureImportWizard.DetailedPage.desc";
    private FeatureImportWizardFirstPage firstPage;
    private IPath dropLocation;
    private CheckboxTreeViewer featureTreeViewer;
    private TreePart treePart;
    private static final String KEY_SHOW_NAMES = "FeatureImportWizard.DetailedPage.showNames";
    private static final String KEY_FEATURE_LIST = "FeatureImportWizard.DetailedPage.featureList";
    private static final String KEY_LOADING_RUNTIME = "FeatureImportWizard.messages.loadingRuntime";
    private static final String KEY_UPDATING = "FeatureImportWizard.messages.updating";
    private static final String KEY_LOADING_FILE = "FeatureImportWizard.messages.loadingFile";
    private static final String KEY_NO_FEATURES = "FeatureImportWizard.messages.noFeatures";
    private static final String KEY_NO_SELECTED = "FeatureImportWizard.errors.noFeatureSelected";
    private IFeatureModel[] models;
    private boolean block;

    public FeatureImportWizardDetailedPage(FeatureImportWizardFirstPage firstPage) {
        super("FeatureImportWizardDetailedPage", false);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.firstPage = firstPage;
        this.dropLocation = null;
        this.updateStatus(StatusWizardPage.createStatus(4, ""));
        String[] buttonLabels = new String[]{PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll"), PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll")};
        this.treePart = new FeatureTreePart(buttonLabels);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    private void initializeFields(IPath dropLocation) {
        block6: {
            if (!dropLocation.equals((Object)this.dropLocation)) {
                this.updateStatus(StatusWizardPage.createStatus(0, ""));
                this.dropLocation = dropLocation;
                this.models = null;
            }
            if (this.models != null) break block6;
            this.getModels();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(PDEPlugin.getResourceString(FeatureImportWizardDetailedPage.KEY_UPDATING), -1);
                    FeatureImportWizardDetailedPage.this.featureTreeViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            FeatureImportWizardDetailedPage.access$3(4.access$0(this.this$1)).setInput((Object)PDEPlugin.getDefault());
                            if (4.access$0(this.this$1).getModels() != null) {
                                FeatureImportWizardDetailedPage.access$3(4.access$0(this.this$1)).setCheckedElements((Object[])4.access$0(this.this$1).getModels());
                            }
                        }
                    });
                    monitor.done();
                }

                static /* synthetic */ FeatureImportWizardDetailedPage access$0(4 var0) {
                    return var0.FeatureImportWizardDetailedPage.this;
                }
            };
            try {
                try {
                    this.getContainer().run(true, false, op);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    PDEPlugin.logException(e);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.dialogChanged();
                throw throwable;
            }
            Object var4_6 = null;
            this.dialogChanged();
        }
    }

    public void storeSettings(boolean finishPressed) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeFields(this.firstPage.getDropLocation());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.treePart.createControl(container, 0, 2, null);
        this.featureTreeViewer = (CheckboxTreeViewer)this.treePart.getTreeViewer();
        this.featureTreeViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.featureTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData gd = (GridData)this.treePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.feature_import_second_page");
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public IFeatureModel[] getModels() {
        if (this.models != null) {
            return this.models;
        }
        final ArrayList result = new ArrayList();
        final IPath home = this.dropLocation;
        if (home != null) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask(PDEPlugin.getResourceString(FeatureImportWizardDetailedPage.KEY_LOADING_FILE), -1);
                    try {
                        try {
                            MultiStatus errors = FeatureImportWizardDetailedPage.this.doLoadFeatures(result, FeatureImportWizardDetailedPage.this.createPath(home), monitor);
                            if (errors != null && errors.getChildren().length > 0) {
                                PDEPlugin.log((IStatus)errors);
                            }
                            FeatureImportWizardDetailedPage.this.models = result.toArray(new IFeatureModel[result.size()]);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var3_6 = null;
                    monitor.done();
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
        }
        return this.models;
    }

    private Object[] getRoots() {
        return this.getModels();
    }

    private File createPath(IPath dropLocation) {
        File featuresDir = new File(dropLocation.toFile(), "features");
        if (featuresDir.exists()) {
            return featuresDir;
        }
        return null;
    }

    private MultiStatus doLoadFeatures(ArrayList result, File path, IProgressMonitor monitor) throws CoreException {
        if (path == null) {
            return null;
        }
        File[] dirs = path.listFiles();
        monitor.beginTask(PDEPlugin.getResourceString("FeatureImportWizard.DetailedPage.loading"), dirs.length);
        ArrayList<IStatus> resultStatus = new ArrayList<IStatus>();
        int i = 0;
        while (i < dirs.length) {
            File dir = dirs[i];
            if (dir.isDirectory()) {
                IStatus status;
                File manifest = new File(dir, "feature.xml");
                if (manifest.exists() && (status = this.doLoadFeature(dir, manifest, result)) != null) {
                    resultStatus.add(status);
                }
                monitor.worked(1);
            }
            ++i;
        }
        if (resultStatus != null) {
            IStatus[] children = resultStatus.toArray(new IStatus[resultStatus.size()]);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.pde.ui", 0, children, PDEPlugin.getResourceString("FeatureImportWizard.DetailedPage.problemsLoading"), null);
            return multiStatus;
        }
        return null;
    }

    private IStatus doLoadFeature(File dir, File manifest, ArrayList result) {
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(dir.getAbsolutePath());
        Status status = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(manifest);
            model.load((InputStream)stream, false);
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.pde.ui", 0, e.getMessage(), (Throwable)e);
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (status == null) {
            result.add(model);
        }
        return status;
    }

    public IFeatureModel[] getSelectedModels() {
        Object[] selected = this.featureTreeViewer.getCheckedElements();
        IFeatureModel[] result = new IFeatureModel[selected.length];
        System.arraycopy(selected, 0, result, 0, selected.length);
        return result;
    }

    private void dialogChanged() {
        IStatus genStatus = this.validateFeatures();
        this.updateStatus(genStatus);
    }

    private IStatus validateFeatures() {
        IFeatureModel[] allModels = this.getModels();
        if (allModels == null || allModels.length == 0) {
            return StatusWizardPage.createStatus(4, PDEPlugin.getResourceString(KEY_NO_FEATURES));
        }
        if (this.featureTreeViewer.getCheckedElements().length == 0) {
            return StatusWizardPage.createStatus(1, PDEPlugin.getResourceString(KEY_NO_SELECTED));
        }
        return StatusWizardPage.createStatus(0, "");
    }

    private void featureChecked(IFeatureModel model, boolean checked) {
        this.dialogChanged();
    }

    private void buttonSelected(int index) {
        if (index == 0) {
            this.doSelectAll(true);
        } else {
            this.doSelectAll(false);
        }
    }

    private void doSelectAll(boolean select) {
        if (select) {
            this.featureTreeViewer.setCheckedElements((Object[])this.getModels());
        } else {
            this.featureTreeViewer.setCheckedElements(new Object[0]);
        }
        this.dialogChanged();
    }

    static /* synthetic */ void access$1(FeatureImportWizardDetailedPage featureImportWizardDetailedPage, IFeatureModel iFeatureModel, boolean bl) {
        featureImportWizardDetailedPage.featureChecked(iFeatureModel, bl);
    }

    public class FeatureContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object parent) {
            Object[] result = FeatureImportWizardDetailedPage.this.getRoots();
            return result != null ? result : new Object[]{};
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    class FeatureTreePart
    extends TreePart {
        public FeatureTreePart(String[] buttonLabels) {
            super(buttonLabels);
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
            style |= 0x300;
            style = factory == null ? (style |= 0x800) : (style |= 0);
            CheckboxTreeViewer treeViewer = new CheckboxTreeViewer(parent, style);
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                private final /* synthetic */ FeatureTreePart this$1;
                {
                    this.this$1 = featureTreePart;
                }

                public void selectionChanged(SelectionChangedEvent e) {
                    FeatureTreePart.access$0(this.this$1, (IStructuredSelection)e.getSelection());
                }
            });
            treeViewer.addDoubleClickListener(new IDoubleClickListener(this){
                private final /* synthetic */ FeatureTreePart this$1;
                {
                    this.this$1 = featureTreePart;
                }

                public void doubleClick(DoubleClickEvent e) {
                    FeatureTreePart.access$1(this.this$1, (IStructuredSelection)e.getSelection());
                }
            });
            treeViewer.addCheckStateListener(new ICheckStateListener(this){
                private final /* synthetic */ FeatureTreePart this$1;
                {
                    this.this$1 = featureTreePart;
                }

                public void checkStateChanged(CheckStateChangedEvent e) {
                    FeatureImportWizardDetailedPage.access$1(FeatureTreePart.access$2(this.this$1), (IFeatureModel)e.getElement(), e.getChecked());
                }
            });
            return treeViewer;
        }

        protected void createMainLabel(Composite parent, int span, FormWidgetFactory factory) {
            Label label = new Label(parent, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            label.setText(PDEPlugin.getResourceString(FeatureImportWizardDetailedPage.KEY_FEATURE_LIST));
            label.setLayoutData((Object)gd);
        }

        protected Button createButton(Composite parent, String label, int index, FormWidgetFactory factory) {
            Button button = super.createButton(parent, label, index, factory);
            SWTUtil.setButtonDimensionHint(button);
            return button;
        }

        public void buttonSelected(Button button, int index) {
            FeatureImportWizardDetailedPage.this.buttonSelected(index);
        }

        static /* synthetic */ void access$0(FeatureTreePart featureTreePart, IStructuredSelection iStructuredSelection) {
            featureTreePart.selectionChanged(iStructuredSelection);
        }

        static /* synthetic */ void access$1(FeatureTreePart featureTreePart, IStructuredSelection iStructuredSelection) {
            featureTreePart.handleDoubleClick(iStructuredSelection);
        }

        static /* synthetic */ FeatureImportWizardDetailedPage access$2(FeatureTreePart featureTreePart) {
            return featureTreePart.FeatureImportWizardDetailedPage.this;
        }
    }
}

