/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.Assert;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class FeatureImportOperation
implements IWorkspaceRunnable {
    private static final String KEY_TITLE = "FeatureImportWizard.messages.title";
    private static final String KEY_CREATING = "FeatureImportWizard.operation.creating";
    private static final String KEY_CREATING2 = "FeatureImportWizard.operation.creating2";
    private static final String KEY_MULTI_PROBLEM = "FeatureImportWizard.operation.multiProblem";
    private static final String KEY_PROBLEM = "FeatureImportWizard.operation.problem";
    private IFeatureModel[] models;
    private IPath targetPath;
    private IWorkspaceRoot root;
    private IReplaceQuery replaceQuery;

    public FeatureImportOperation(IFeatureModel[] models, IPath targetPath, IReplaceQuery replaceQuery) {
        Assert.isNotNull((Object)models);
        Assert.isNotNull((Object)replaceQuery);
        this.models = models;
        this.targetPath = targetPath;
        this.root = ResourcesPlugin.getWorkspace().getRoot();
        this.replaceQuery = replaceQuery;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(PDEPlugin.getResourceString(KEY_CREATING), this.models.length);
        try {
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEPlugin.getResourceString(KEY_MULTI_PROBLEM), null);
            int i = 0;
            while (i < this.models.length) {
                try {
                    this.createProject(this.models[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    multiStatus.merge(e.getStatus());
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            if (!multiStatus.isOK()) {
                throw new CoreException((IStatus)multiStatus);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        Object var5_7 = null;
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProject(IFeatureModel model, IProgressMonitor monitor) throws CoreException {
        block8: {
            block7: {
                String name = String.valueOf(model.getFeature().getId()) + "-feature";
                String task = PDEPlugin.getFormattedMessage(KEY_CREATING2, name);
                monitor.beginTask(task, 8);
                try {
                    IProject project;
                    block10: {
                        block9: {
                            project = this.root.getProject(name);
                            if (!project.exists()) break block9;
                            if (this.queryReplace(project)) {
                                project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                try {
                                    RepositoryProvider.unmap((IProject)project);
                                }
                                catch (TeamException teamException) {}
                                break block10;
                            } else {
                                Object var9_6 = null;
                                break block7;
                            }
                        }
                        monitor.worked(1);
                    }
                    IProjectDescription description = PDEPlugin.getWorkspace().newProjectDescription(name);
                    description.setLocation(this.targetPath.append(name));
                    project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!project.isOpen()) {
                        project.open(null);
                    }
                    File featureDir = new File(model.getInstallLocation());
                    this.importContent(featureDir, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.setProjectNatures(project, monitor);
                    project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
                    IJavaProject jProject = JavaCore.create((IProject)project);
                    jProject.setRawClasspath(this.computeClasspath(), monitor);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var9_8 = null;
        monitor.done();
    }

    private IClasspathEntry[] computeClasspath() {
        IClasspathEntry[] entries = new IClasspathEntry[1];
        Path jrePath = new Path("JRE_LIB");
        IPath[] annot = new IPath[]{new Path("JRE_SRC"), new Path("JRE_SRCROOT")};
        entries[0] = JavaCore.newVariableEntry((IPath)jrePath, (IPath)annot[0], (IPath)annot[1]);
        return entries;
    }

    private void importContent(Object source, IPath destPath, IImportStructureProvider provider, List filesToImport, IProgressMonitor monitor) throws CoreException {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        ImportOperation op = new ImportOperation(destPath, source, provider, query);
        op.setCreateContainerStructure(false);
        if (filesToImport != null) {
            op.setFilesToImport(filesToImport);
        }
        try {
            op.run(monitor);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof CoreException) {
                throw (CoreException)th;
            }
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    private String getFlatPath(IPath path) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < path.segmentCount()) {
            if (i > 0) {
                buf.append("_");
            }
            buf.append(path.segment(i));
            ++i;
        }
        return buf.toString();
    }

    private boolean queryReplace(IProject project) throws OperationCanceledException {
        switch (this.replaceQuery.doQuery(project)) {
            case 0: {
                throw new OperationCanceledException();
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    private void setProjectNatures(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.FeatureNature"});
        project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    public interface IReplaceQuery {
        public static final int CANCEL = 0;
        public static final int NO = 1;
        public static final int YES = 2;

        public int doQuery(IProject var1);
    }
}

